/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.maven.MojoUtils;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.ValueFactoryFactory;

@Mojo(name="package", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageRascalMojo
extends AbstractMojo {
    private static final String MAIN_PACKAGER_MODULE = "lang::rascalcore::package::Packager";
    private static final ISourceLocation[] MAIN_PACKAGER_SEARCH_PATH = new ISourceLocation[]{URIUtil.correctLocation((String)"lib", (String)"typepal", (String)""), URIUtil.correctLocation((String)"lib", (String)"rascal-core", (String)"")};
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="bin", required=true)
    private String bin;
    @Parameter(property="srcs", required=true)
    private List<String> srcs;
    @Parameter(defaultValue="|lib://${project.name}/|", property="sourceLookup", required=true)
    private String sourceLookup;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;

    private Evaluator makeEvaluator() throws URISyntaxException, FactTypeUseException, IOException {
        return MojoUtils.makeEvaluator(this.getLog(), this.session, MAIN_PACKAGER_SEARCH_PATH, MAIN_PACKAGER_MODULE);
    }

    public void execute() throws MojoExecutionException {
        try {
            Evaluator eval = this.makeEvaluator();
            ISourceLocation binLoc = MojoUtils.location(this.bin);
            ISourceLocation sourceLookupLoc = MojoUtils.location(this.sourceLookup);
            IList srcLocs = this.locations(this.srcs);
            eval.call("package", new IValue[]{srcLocs, binLoc, sourceLookupLoc});
            this.getLog().info((CharSequence)"packager is done.");
        }
        catch (IOException | URISyntaxException e) {
            throw new MojoExecutionException("unexpected error during Rascal compiler run", e);
        }
    }

    private IList locations(List<String> files) {
        IListWriter result = ValueFactoryFactory.getValueFactory().listWriter();
        result.appendAll(MojoUtils.locations(files));
        return (IList)result.done();
    }
}

