/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="console", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RascalConsoleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        LinkedList<String> command = new LinkedList<String>();
        command.add(javaBin);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> command.add("-D" + key + "=" + value)));
        command.add("-cp");
        command.add(this.collectClasspath());
        command.add("org.rascalmpl.shell.RascalShell");
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.inheritIO().start();
            process.waitFor();
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        catch (InterruptedException e) {
            this.getLog().warn((Throwable)e);
        }
    }

    private String collectClasspath() {
        StringBuilder builder = new StringBuilder();
        boolean dependsOnRascal = false;
        if ("org.rascalmpl".equals(this.project.getGroupId()) && "rascal".equals(this.project.getArtifactId())) {
            File r = new File(this.project.getBuild().getOutputDirectory());
            builder.append(File.pathSeparator + r.getAbsolutePath());
            dependsOnRascal = true;
        }
        for (Object o : this.project.getArtifacts()) {
            Artifact a = (Artifact)o;
            File file = a.getFile().getAbsoluteFile();
            builder.append(File.pathSeparator + file.getAbsolutePath());
            if (!"org.rascalmpl".equals(a.getGroupId()) || !"rascal".equals(a.getArtifactId())) continue;
            dependsOnRascal = true;
        }
        if (!dependsOnRascal) {
            String msg = "Current project does not have a dependency on org.rascalmpl:rascal";
            this.getLog().error((CharSequence)msg);
            throw new RuntimeException(msg);
        }
        return builder.toString().substring(1);
    }
}

