/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import oshi.SystemInfo;

public abstract class AbstractRascalMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="bin", required=true)
    protected File bin;
    @Parameter(defaultValue="${project.build.directory}/generatedSources", property="generatedSources", required=true)
    protected File generatedSources;
    @Parameter(property="srcs", required=true)
    protected List<File> srcs;
    @Parameter(property="srcIgnores", required=false)
    protected List<File> srcIgnores;
    @Parameter(property="libs", required=false)
    protected List<File> libs;
    @Parameter(defaultValue="false", property="verbose", required=true)
    protected boolean verbose;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="0.41.0-RC24", required=false, readonly=false)
    protected String bootstrapRascalVersion;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="")
    protected String mainModule;
    protected final String skipTag;
    protected final String mainClass;
    protected Map<String, String> extraParameters = new HashMap<String, String>();
    protected Path cachedRascalRuntime = null;
    protected SystemInfo systemInformation = new SystemInfo();

    public AbstractRascalMojo(String mainClass, String skipTag) {
        this.mainClass = mainClass;
        this.skipTag = skipTag;
    }

    protected Path getRascalRuntime() {
        if (this.cachedRascalRuntime == null) {
            this.cachedRascalRuntime = this.detectedDependentRascalArtifact(this.getLog(), this.project, this.session);
            this.getLog().info((CharSequence)("The Rascal runtime was resolved at " + this.cachedRascalRuntime));
        }
        return this.cachedRascalRuntime;
    }

    protected String files(List<File> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining(File.pathSeparator));
    }

    protected void setExtraParameters() {
    }

    public void execute() throws MojoExecutionException {
        try {
            if (System.getProperty("rascal." + this.skipTag + ".skip") != null) {
                this.getLog().info((CharSequence)("Skipping " + ((Object)((Object)this)).getClass().getName() + " completely"));
                return;
            }
            this.getLog().info((CharSequence)"configuring paths");
            for (File src : this.srcs) {
                this.getLog().info((CharSequence)("\tregistered source location: " + src));
            }
            for (File ignore : this.srcIgnores) {
                this.getLog().warn((CharSequence)("\tignoring sources in: " + ignore));
            }
            this.getLog().info((CharSequence)"Checking if any files need compilation...");
            this.libs.addAll(this.collectDependentArtifactLibraries(this.project));
            for (File lib : this.libs) {
                this.getLog().info((CharSequence)("\tregistered library location: " + lib));
            }
            this.getLog().info((CharSequence)"Paths have been configured.");
            this.setExtraParameters();
            this.runMain(this.verbose, this.srcs, this.srcIgnores, this.libs, this.generatedSources, this.bin, this.extraParameters, true).waitFor();
            return;
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("nested " + this.mainClass + " was killed", (Exception)e);
        }
        catch (Throwable e) {
            throw new MojoExecutionException("error launching " + this.mainClass, e);
        }
    }

    protected Path detectedDependentRascalArtifact(Log log, MavenProject project, MavenSession session) {
        try {
            if (project.getGroupId().equals("org.rascalmpl") && project.getArtifactId().equals("rascal")) {
                log.info((CharSequence)("Maven Rascal Mojo detected rascal project self-application. Downloading the configured bootstrap rascal-" + this.bootstrapRascalVersion + ".jar"));
                log.info((CharSequence)("Find <rascalBootstrapVersion>" + this.bootstrapRascalVersion + "</rascalBootstrapVersion> in rascal/pom.xml"));
                if (this.bootstrapRascalVersion.endsWith("SNAPSHOT")) {
                    throw new IllegalArgumentException("The rascalBootstrapVersion configuration parameter must not be a SNAPSHOT release, because of the required reproducibility of any Rascal release. The Maven build will bail out now.");
                }
                return this.installBootstrapRascalVersion(project, session);
            }
            for (Object o : project.getArtifacts()) {
                Artifact a = (Artifact)o;
                if (!a.getGroupId().equals("org.rascalmpl") || !a.getArtifactId().equals("rascal")) continue;
                File file = a.getFile().getAbsoluteFile();
                if (a.getSelectedVersion().compareTo((Object)this.getReferenceRascalVersion()) >= 0) {
                    return file.toPath();
                }
                log.warn((CharSequence)("Rascal version in pom.xml dependency is too old for this Rascal maven plugin. " + this.getReferenceRascalVersion() + " or later expected."));
                log.warn((CharSequence)("Downloading and using a newer version org.rascalmpl:rascal:" + this.bootstrapRascalVersion + "; please add it to the pom.xml"));
                return this.installBootstrapRascalVersion(project, session);
            }
            throw new MojoExecutionException("Pom.xml is missig a dependency on org.rascalmpl:rascal:" + this.getReferenceRascalVersion() + " (or later).");
        }
        catch (OverConstrainedVersionException e) {
            log.error((CharSequence)("Rascal version is over-constrained (impossible to resolve). Expected " + this.getReferenceRascalVersion() + " or later. Have to abort."));
            throw new RuntimeException(e);
        }
        catch (MojoExecutionException e) {
            log.error((CharSequence)"Unable to just-in-time-install the required (bootstrap) version of Rascal. Have to abort.");
            throw new RuntimeException(e);
        }
    }

    protected List<File> collectDependentArtifactLibraries(MavenProject project) throws URISyntaxException, IOException {
        LinkedList<File> libs = new LinkedList<File>();
        for (Object o : project.getArtifacts()) {
            Artifact a = (Artifact)o;
            File file = a.getFile().getAbsoluteFile();
            libs.add(file);
        }
        return libs;
    }

    protected final ArtifactVersion getReferenceRascalVersion() {
        return new DefaultArtifactVersion("0.41.0-RC26");
    }

    protected Path installBootstrapRascalVersion(MavenProject project, MavenSession session) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)"org.apache.maven.plugins", (String)"maven-dependency-plugin", (String)"3.1.1"), (String)MojoExecutor.goal((String)"get"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"artifact", (String)("org.rascalmpl:rascal:" + this.bootstrapRascalVersion))}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)session, (BuildPluginManager)this.pluginManager));
        return Path.of(session.getSettings().getLocalRepository(), "org", "rascalmpl", "rascal", this.bootstrapRascalVersion, "rascal-" + this.bootstrapRascalVersion + ".jar");
    }

    protected Process runMain(boolean verbose, List<File> srcs, List<File> ignores, List<File> libs, File generated, File bin, Map<String, String> extraParameters, boolean inheritIO) throws IOException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        LinkedList<String> command = new LinkedList<String>();
        command.add(javaBin);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> command.add("-D" + key + "=" + value)));
        long totalMemoryKilobytes = this.systemInformation.getHardware().getMemory().getTotal() / 1000L;
        long requiredMemoryKilobytes = 2000000000L;
        command.add("-Xmx" + Math.min(totalMemoryKilobytes, requiredMemoryKilobytes) + "k");
        command.add("--illegal-access=deny");
        command.add("-cp");
        command.add(this.getRascalRuntime().toString());
        assert (this.mainClass != null) : "mainClass is null";
        command.add(this.mainClass);
        if (this.mainClass.endsWith("RascalShell") && this.mainModule != null && !this.mainModule.isEmpty()) {
            command.add(this.mainModule);
        }
        if (!srcs.isEmpty()) {
            command.add("-srcs");
            command.add(this.files(srcs));
        }
        if (!this.srcIgnores.isEmpty()) {
            command.add("-ignores");
            command.add(this.files(this.srcIgnores));
        }
        if (!libs.isEmpty()) {
            command.add("-libs");
            command.add(this.files(libs));
        }
        command.add("-bin");
        assert (bin != null) : "bin is null";
        command.add(bin.toString());
        command.add("-generatedSources");
        assert (this.generatedSources != null) : "generatedSourced is null";
        command.add(generated.toString());
        for (Map.Entry<String, String> e : extraParameters.entrySet()) {
            command.add("-" + e.getKey());
            assert (e.getValue() != null) : "value with " + e.getKey() + " is null in extraParameters";
            command.add(e.getValue());
        }
        if (verbose) {
            command.add("-verbose");
        }
        this.getLog().debug((CharSequence)("Starting process: " + (String)command.get(0) + command.stream().collect(Collectors.joining("\n\t"))));
        assert (command.stream().map(Objects::nonNull).allMatch(b -> b)) : "command had a null parameter";
        ProcessBuilder p = new ProcessBuilder(command);
        if (inheritIO) {
            p.inheritIO();
        } else {
            p.redirectErrorStream(true);
        }
        return p.start();
    }

    protected List<File> getTodoList(File binLoc, List<File> srcLocs, List<File> ignoredLocs, final String dirtyExtension, final String binaryExtension) throws InclusionScanException, URISyntaxException {
        StaleSourceScanner scanner = new StaleSourceScanner(100L);
        scanner.addSourceMapping(new SourceMapping(){

            public Set<File> getTargetFiles(File targetDir, String source) throws InclusionScanException {
                File file = new File(source);
                String name = file.getName();
                if (name.endsWith("." + dirtyExtension)) {
                    return Set.of(new File(targetDir, new File(file.getParentFile(), "$" + name.substring(0, name.length() - ("." + dirtyExtension).length()) + "." + binaryExtension).getPath()));
                }
                return Set.of();
            }
        });
        binLoc = new File(binLoc, "rascal");
        HashSet staleSources = new HashSet();
        for (File src : this.srcs) {
            staleSources.addAll(scanner.getIncludedSources(src, binLoc));
        }
        LinkedList<File> filteredStaleSources = new LinkedList<File>();
        for (File file : staleSources) {
            if (!ignoredLocs.stream().noneMatch(l -> this.isIgnoredBy((File)l, file))) continue;
            filteredStaleSources.add(file);
        }
        return filteredStaleSources;
    }

    protected boolean isIgnoredBy(File prefix, File loc) {
        String prefixPath = prefix.toString();
        String locPath = loc.toString();
        return locPath.startsWith(prefixPath);
    }

    protected <T, R, E extends Exception> Function<T, R> handleExceptions(FunctionWithException<T, R, E> fe) {
        return arg -> {
            try {
                return fe.apply(arg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @FunctionalInterface
    protected static interface FunctionWithException<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

