/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.rascalmpl.maven.AbstractRascalMojo;

@Mojo(name="tutor", inheritByDefault=false, defaultPhase=LifecyclePhase.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CompileRascalDocumentation
extends AbstractRascalMojo {
    @Parameter(property="license", required=false, defaultValue="${project.basedir}/LICENSE.md")
    private String license;
    @Parameter(property="citation", required=false, defaultValue="${project.basedir}/CITATION.md")
    private String citation;
    @Parameter(property="sources", required=false, defaultValue="http://github.com/usethesource/${project.name}/blob/main")
    private String sources;
    @Parameter(property="funding", required=false, defaultValue="${project.basedir}/FUNDING.md")
    private String funding;
    @Parameter(property="issues", required=false, defaultValue="http://github.com/usethesource/${project.name}/issues")
    private String issues;
    @Parameter(property="isPackageCourse", required=false, defaultValue="true")
    private boolean isPackageCourse;
    @Parameter(property="releaseNotes", required=false, defaultValue="${project.basedir}/RELEASE-NOTES.md")
    private String releaseNotes;
    @Parameter(property="errorsAsWarnings", required=false, defaultValue="false")
    private boolean errorsAsWarnings;
    @Parameter(property="warningsAsErrors", required=false, defaultValue="false")
    private boolean warningsAsErrors;

    public CompileRascalDocumentation() {
        super("org.rascalmpl.shell.RascalTutorCompile", "tutor");
    }

    @Override
    public void execute() throws MojoExecutionException {
        try {
            if (System.getProperty("rascal." + this.skipTag + ".skip") != null) {
                this.getLog().info((CharSequence)("Skipping " + ((Object)((Object)this)).getClass().getName() + " completely"));
                return;
            }
            this.getLog().info((CharSequence)"configuring paths");
            for (File src : this.srcs) {
                this.getLog().info((CharSequence)("\tregistered source location: " + src));
            }
            for (File ignore : this.srcIgnores) {
                this.getLog().warn((CharSequence)("\tignoring sources in: " + ignore));
            }
            this.libs.addAll(this.collectDependentArtifactLibraries(this.project));
            for (File lib : this.libs) {
                this.getLog().info((CharSequence)("\tregistered library location: " + lib));
            }
            this.getLog().info((CharSequence)"Paths have been configured.");
            this.extraParameters.putAll(Map.of("license", this.license, "citation", this.citation, "funding", this.funding, "releaseNotes", this.releaseNotes, "isPackageCourse", Boolean.toString(this.isPackageCourse), "errorsAsWarnings", Boolean.toString(this.errorsAsWarnings), "warningsAsErrors", Boolean.toString(this.warningsAsErrors)));
            if (this.isPackageCourse) {
                this.extraParameters.put("packageName", this.project.getId());
            }
            this.runMain(this.verbose, this.srcs, this.srcIgnores, this.libs, this.generatedSources, this.bin, this.extraParameters, true).waitFor();
            return;
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("nested " + this.mainClass + " was killed", (Exception)e);
        }
        catch (Throwable e) {
            throw new MojoExecutionException("error launching " + this.mainClass, e);
        }
    }
}

