/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.io.file.SimplePathVisitor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.utils.cli.ShutdownHookUtils;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.rascalmpl.maven.AbstractRascalMojo;

@Mojo(name="compile", inheritByDefault=false, defaultPhase=LifecyclePhase.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CompileRascalMojo
extends AbstractRascalMojo {
    @Parameter(property="parallel", required=false, defaultValue="false")
    private boolean parallel;
    @Parameter(property="parallelMax", required=false, defaultValue="4")
    private int parallelMax;
    @Parameter(property="parallelPreChecks", required=false)
    private List<File> parallelPreChecks;
    @Parameter(required=false, defaultValue="false")
    private boolean logPathConfig;
    @Parameter(required=false, defaultValue="false")
    private boolean logImports;
    @Parameter(required=false, defaultValue="false")
    private boolean logWrittenFiles;
    @Parameter(required=false, defaultValue="true")
    private boolean warnUnused;
    @Parameter(required=false, defaultValue="true")
    private boolean warnUnusedFormals;
    @Parameter(required=false, defaultValue="true")
    private boolean warnUnusedVariables;
    @Parameter(required=false, defaultValue="true")
    private boolean warnUnusedPatternFormals;
    @Parameter(property="errorsAsWarnings", required=false, defaultValue="false")
    private boolean errorsAsWarnings;
    @Parameter(property="warningsAsErrors", required=false, defaultValue="false")
    private boolean warningsAsErrors;
    private long processorEstimate = 0L;

    public CompileRascalMojo() {
        super("org.rascalmpl.shell.RascalCompile", "compile");
    }

    @Override
    public void execute() throws MojoExecutionException {
        try {
            if (System.getProperty("rascal.compile.skip") != null) {
                this.getLog().info((CharSequence)"Skipping Rascal compiler completely");
                return;
            }
            this.getLog().info((CharSequence)"configuring paths");
            for (File src : this.srcs) {
                this.getLog().info((CharSequence)("\tregistered source location: " + src));
            }
            for (Iterator ignore : this.srcIgnores) {
                this.getLog().warn((CharSequence)("\tignoring sources in: " + (File)((Object)ignore)));
            }
            this.getLog().info((CharSequence)"Checking if any files need compilation...");
            List<File> todoList = this.getTodoList(this.bin, this.srcs, this.srcIgnores, "rsc", "tpl", "rascal");
            todoList.removeAll(this.parallelPreChecks);
            if (!todoList.isEmpty()) {
                this.getLog().info((CharSequence)"Stale source files have been found:");
                for (File todo : todoList) {
                    this.getLog().info((CharSequence)("\t" + todo));
                }
            } else {
                this.getLog().info((CharSequence)"No stale source files have been found, skipping compilation.");
                return;
            }
            this.libs.addAll(this.collectDependentArtifactLibraries(this.project));
            for (File lib : this.libs) {
                this.getLog().info((CharSequence)("\tregistered library location: " + lib));
            }
            this.getLog().info((CharSequence)"Files have been configured.");
            int result = this.runChecker(this.verbose, todoList, this.parallelPreChecks, this.srcs, this.srcIgnores, this.libs, this.bin, this.generatedSources);
            if (result > 0) {
                throw new MojoExecutionException("Errors found while checking.");
            }
            return;
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e);
        }
    }

    private int estimateBestNumberOfParallelProcesses() {
        if (this.processorEstimate == 0L) {
            long result = this.systemInformation.getHardware().getProcessor().getLogicalProcessorCount();
            if (result < 2L) {
                return 1;
            }
            this.getLog().info((CharSequence)("Logical processor count: " + result));
            long maxMemory = this.systemInformation.getHardware().getMemory().getTotal();
            this.getLog().info((CharSequence)("Available memory: " + maxMemory / 1000L + " kilobytes"));
            long max2GmemoryDivisions = maxMemory / 1000L / 2000000L;
            this.getLog().info((CharSequence)("Number of 2G processors for this amount of memory:" + max2GmemoryDivisions));
            result = Math.min(result, max2GmemoryDivisions);
            this.getLog().info((CharSequence)("Estimated max number of processors: " + result));
            this.getLog().info((CharSequence)("Max number of processors requested: " + this.parallelMax));
            if (result < 2L) {
                return 1;
            }
            this.processorEstimate = result < 2L ? 1L : Math.min((long)this.parallelMax, result);
            this.getLog().info((CharSequence)("Final estimate number of processores: " + this.processorEstimate));
        }
        return (int)this.processorEstimate;
    }

    private int runChecker(boolean verbose, List<File> todoList, List<File> prechecks, List<File> srcLocs, List<File> srcIgnores, List<File> libLocs, File binLoc, File generatedSourcesLoc) throws IOException, URISyntaxException, Exception {
        if (!this.parallel || todoList.size() <= 10 || this.estimateBestNumberOfParallelProcesses() <= 1) {
            return this.runCheckerSingleThreaded(verbose, todoList, srcLocs, srcIgnores, libLocs, binLoc, generatedSourcesLoc);
        }
        return this.runCheckerMultithreaded(verbose, todoList, prechecks, srcLocs, srcIgnores, libLocs, binLoc, generatedSourcesLoc);
    }

    private int runCheckerMultithreaded(boolean verbose, List<File> todoList, List<File> prechecks, List<File> srcs, List<File> srcIgnores, List<File> libs, File bin, File generatedSourcesLoc) throws Exception {
        List<List<File>> chunks = this.splitTodoList(todoList);
        chunks.add(0, prechecks);
        List<File> tmpBins = chunks.stream().map(this.handleExceptions(l -> Files.createTempDirectory("rascal-checker", new FileAttribute[0]).toFile())).collect(Collectors.toList());
        List<File> tmpGeneratedSources = chunks.stream().map(this.handleExceptions(l -> Files.createTempDirectory("rascal-sources", new FileAttribute[0]).toFile())).collect(Collectors.toList());
        int result = 0;
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        try {
            int i;
            LinkedList<Process> processes = new LinkedList<Process>();
            ShutdownHookUtils.addShutDownHook((Thread)new Thread(() -> {
                for (Process p : processes) {
                    try {
                        p.destroy();
                    }
                    catch (Exception exception) {}
                }
            }));
            List<File> todoChunk = chunks.get(0);
            if (!todoChunk.isEmpty()) {
                CompileRascalMojo.copyOverTpls(bin, tmpBins.subList(0, 1));
                this.setExtraCompilerParameters(verbose, todoChunk, extraParameters);
                this.getLog().info((CharSequence)("Pre-compiling common modules " + prechecks.stream().map(f -> f.getName()).collect(Collectors.joining(", "))));
                Process prechecker = this.runMain(verbose, "", srcs, srcIgnores, libs, tmpGeneratedSources.get(0), tmpBins.get(0), extraParameters, true, 1);
                processes.add(prechecker);
                int exitCode = prechecker.waitFor();
                this.getLog().info((CharSequence)("Pre-compilation finished (" + exitCode + ")"));
                result += exitCode;
                if (exitCode == 137) {
                    this.getLog().error((CharSequence)"JVM 0was killed by the OS; possibly for taking to much memory");
                }
                if (tmpBins.size() > 1) {
                    CompileRascalMojo.copyOverTpls(tmpBins.get(0), tmpBins.subList(1, tmpBins.size()));
                }
            }
            for (int i2 = 1; i2 < chunks.size(); ++i2) {
                List<File> chunk = chunks.get(i2);
                if (chunk.isEmpty()) continue;
                this.setExtraCompilerParameters(verbose, chunks.get(i2), extraParameters);
                this.getLog().info((CharSequence)("Compiler " + i2 + " started on a parallel job of " + chunks.get(i2).size() + " modules."));
                processes.add(this.runMain(verbose, "", srcs, srcIgnores, libs, tmpGeneratedSources.get(i2), tmpBins.get(i2), extraParameters, i2 == 1, chunks.size()));
            }
            ArrayList otherOutput = new ArrayList();
            for (i = 2; i < processes.size(); ++i) {
                Process p = (Process)processes.get(i);
                ArrayList ourQueue = new ArrayList();
                otherOutput.add(ourQueue);
                CompletableFuture.runAsync(() -> {
                    try (InputStreamReader reader = new InputStreamReader(p.getInputStream());){
                        int read;
                        char[] buffer = new char[8192];
                        int filled = 0;
                        while ((read = reader.read(buffer, filled, buffer.length - filled)) != -1) {
                            if ((filled += read) == buffer.length) {
                                ourQueue.add(new String(buffer));
                            }
                            filled = 0;
                        }
                        if (filled > 0) {
                            ourQueue.add(new String(buffer, 0, filled));
                        }
                    }
                    catch (Exception e) {
                        return;
                    }
                });
            }
            for (i = 1; i < processes.size(); ++i) {
                int exitCode = ((Process)processes.get(i)).waitFor();
                if (i >= 2) {
                    ((List)otherOutput.get(i - 2)).forEach(System.out::print);
                }
                if (exitCode == 137) {
                    this.getLog().error((CharSequence)("JVM " + i + "was killed by the OS; possibly for taking too much memory"));
                }
                result += exitCode;
                this.getLog().info((CharSequence)("Compiler " + i + " finished (" + exitCode + ") on a job of " + chunks.get(i).size() + " modules."));
            }
            this.mergeOutputFolders(bin, tmpBins);
            this.mergeOutputFolders(generatedSourcesLoc, tmpGeneratedSources);
            if (result > 0) {
                throw new MojoExecutionException("Checker found errors");
            }
            return result;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to prepare temporary directories for the checker.");
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Checker was interrupted");
        }
    }

    private int runCheckerSingleThreaded(boolean verbose, List<File> todoList, List<File> srcLocs, List<File> srcIgnores, List<File> libLocs, File binLoc, File generated) throws URISyntaxException, IOException, MojoExecutionException {
        this.getLog().info((CharSequence)"Running single checker process");
        try {
            this.setExtraCompilerParameters(verbose, todoList, this.extraParameters);
            return this.runMain(verbose, "", srcLocs, srcIgnores, libLocs, generated, binLoc, this.extraParameters, true, 1).waitFor();
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)"Checker was interrupted");
            throw new MojoExecutionException((Throwable)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private void setExtraCompilerParameters(boolean verbose, List<File> todoList, Map<String, String> extraParameters) {
        extraParameters.put("modules", this.files(todoList));
        extraParameters.put("logPathConfig", Boolean.toString(this.logPathConfig));
        extraParameters.put("logImports", Boolean.toString(this.logImports));
        extraParameters.put("verbose", Boolean.toString(verbose));
        extraParameters.put("logWrittenFiles", Boolean.toString(this.logWrittenFiles));
        extraParameters.put("warnUnused", Boolean.toString(this.warnUnused));
        extraParameters.put("warnUnusedVariables", Boolean.toString(this.warnUnusedVariables));
        extraParameters.put("warnUnusedFormals", Boolean.toString(this.warnUnusedFormals));
        extraParameters.put("warnUnusedPatternFormals", Boolean.toString(this.warnUnusedPatternFormals));
        extraParameters.put("warningsAsErrors", Boolean.toString(this.warningsAsErrors));
        extraParameters.put("errorsAsWarnings", Boolean.toString(this.errorsAsWarnings));
    }

    private void mergeOutputFolders(File bin, List<File> binFolders) throws IOException {
        for (File tmp : binFolders) {
            this.getLog().debug((CharSequence)("Copying files from " + tmp + " to " + bin));
            CompileRascalMojo.mergeOutputFolders(bin, tmp);
        }
    }

    private static void copyOverTpls(File from, List<File> target) throws IOException {
        final Path srcPath = from.toPath();
        final List targetPaths = target.stream().map(File::toPath).collect(Collectors.toList());
        Files.walkFileTree(srcPath, (FileVisitor<? super Path>)new SimplePathVisitor(){

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path child = srcPath.relativize(dir);
                for (Path t : targetPaths) {
                    Files.createDirectories(t.resolve(child), new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".tpl")) {
                    Path child = srcPath.relativize(file);
                    for (Path t : targetPaths) {
                        Path targetFile = t.resolve(child);
                        Files.copy(file, targetFile, new CopyOption[0]);
                        Files.setLastModifiedTime(targetFile, attrs.lastModifiedTime());
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void mergeOutputFolders(File dst, File src) throws IOException {
        final Path dstPath = dst.toPath();
        final Path srcPath = src.toPath();
        Files.walkFileTree(srcPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(dstPath.resolve(srcPath.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile = dstPath.resolve(srcPath.relativize(file));
                Files.move(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                Files.setLastModifiedTime(targetFile, attrs.lastModifiedTime());
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private List<List<File>> splitTodoList(List<File> todoList) {
        todoList.sort(File::compareTo);
        int procs = this.estimateBestNumberOfParallelProcesses();
        int chunkSize = todoList.size() / procs;
        int remainder = todoList.size() % procs;
        ArrayList<List<File>> result = new ArrayList<List<File>>(todoList.size() / chunkSize + 1);
        for (int from = 0; from < todoList.size(); from += chunkSize + (remainder-- > 0 ? 1 : 0)) {
            int to = from + chunkSize + (remainder > 0 ? 1 : 0);
            result.add(Collections.unmodifiableList(todoList.subList(from, to)));
        }
        return result;
    }
}

