/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.rascalmpl.maven.AbstractRascalMojo;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="tutor", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class TutorRascalMojo
extends AbstractRascalMojo {
    @Parameter(property="license", required=false, defaultValue="${project.basedir}/LICENSE.md")
    private String license;
    @Parameter(property="citation", required=false, defaultValue="${project.basedir}/CITATION.md")
    private String citation;
    @Parameter(property="sources", required=false, defaultValue="http://github.com/usethesource/${project.name}/blob/main")
    private String sources;
    @Parameter(property="funding", required=false, defaultValue="${project.basedir}/FUNDING.md")
    private String funding;
    @Parameter(property="issues", required=false, defaultValue="http://github.com/usethesource/${project.name}/issues")
    private String issues;
    @Parameter(property="isPackageCourse", required=false, defaultValue="true")
    private boolean isPackageCourse;
    @Parameter(property="releaseNotes", required=false, defaultValue="${project.basedir}/RELEASE-NOTES.md")
    private String releaseNotes;
    @Parameter(property="errorsAsWarnings", required=false, defaultValue="false")
    private boolean errorsAsWarnings;
    @Parameter(property="warningsAsErrors", required=false, defaultValue="false")
    private boolean warningsAsErrors;
    @Parameter(defaultValue="0.2.0", required=false, readonly=false)
    private String screenShotFeatureVersion;

    public TutorRascalMojo() {
        super("org.rascalmpl.shell.RascalTutorCompile", "tutor");
    }

    @Override
    public void execute() throws MojoExecutionException {
        try {
            if (System.getProperty("rascal." + this.skipTag + ".skip") != null) {
                this.getLog().info((CharSequence)("Skipping " + ((Object)((Object)this)).getClass().getName() + " completely"));
                return;
            }
            this.getLog().info((CharSequence)"configuring paths");
            for (File src : this.srcs) {
                this.getLog().info((CharSequence)("\tregistered source location: " + src));
            }
            for (File ignore : this.srcIgnores) {
                this.getLog().warn((CharSequence)("\tignoring sources in: " + ignore));
            }
            this.libs.addAll(this.collectDependentArtifactLibraries(this.project));
            for (File lib : this.libs) {
                this.getLog().info((CharSequence)("\tregistered library location: " + lib));
            }
            this.getLog().info((CharSequence)"Paths have been configured.");
            this.extraParameters.putAll(Map.of("license", this.license, "citation", this.citation, "funding", this.funding, "releaseNotes", this.releaseNotes, "isPackageCourse", Boolean.toString(this.isPackageCourse), "errorsAsWarnings", Boolean.toString(this.errorsAsWarnings), "warningsAsErrors", Boolean.toString(this.warningsAsErrors)));
            if (this.isPackageCourse) {
                this.extraParameters.put("packageName", this.project.getId());
            }
            String screenshotter = null;
            try {
                screenshotter = this.installScreenshotFeature(this.project, this.session).toString();
            }
            catch (MojoExecutionException e) {
                this.getLog().warn((CharSequence)"Could not install rascal-tutor-screenshot feature. Ignoring.", (Throwable)e);
                screenshotter = "";
            }
            int exitCode = this.runMain(this.verbose, screenshotter, this.srcs, this.srcIgnores, this.libs, this.generatedSources, this.bin, this.extraParameters, true, 1).waitFor();
            if (exitCode != 0) {
                throw new MojoExecutionException("tutor returned non-zero exit status");
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("nested " + this.mainClass + " was killed", (Exception)e);
        }
        catch (Throwable e) {
            throw new MojoExecutionException("error launching " + this.mainClass, e);
        }
    }

    protected Path installScreenshotFeature(MavenProject project, MavenSession session) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)"org.apache.maven.plugins", (String)"maven-dependency-plugin", (String)"3.1.1"), (String)MojoExecutor.goal((String)"get"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"artifact", (String)("org.rascalmpl:rascal-tutor-screenshot:" + this.screenShotFeatureVersion))}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)session, (BuildPluginManager)this.pluginManager));
        return Path.of(session.getSettings().getLocalRepository(), "org", "rascalmpl", "rascal-tutor-screenshot", this.screenShotFeatureVersion, "rascal-tutor-screenshot-" + this.screenShotFeatureVersion + ".jar");
    }
}

