/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.rascalmpl.maven.AbstractRascalMojo;

@Mojo(name="compile", inheritByDefault=false, defaultPhase=LifecyclePhase.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CompileRascalMojo
extends AbstractRascalMojo {
    @Parameter(property="parallel", required=false, defaultValue="false")
    private boolean parallel;
    @Parameter(property="parallelMax", required=false, defaultValue="4")
    private int parallelMax;
    @Parameter(property="parallelPreChecks", required=false)
    private List<File> parallelPreChecks;

    public CompileRascalMojo() {
        super("org.rascalmpl.shell.RascalCompile", "compile");
    }

    @Override
    public void execute() throws MojoExecutionException {
        try {
            if (System.getProperty("rascal.compile.skip") != null) {
                this.getLog().info((CharSequence)"Skipping Rascal compiler completely");
                return;
            }
            this.getLog().info((CharSequence)"configuring paths");
            for (File src : this.srcs) {
                this.getLog().info((CharSequence)("\tregistered source location: " + src));
            }
            for (Iterator ignore : this.srcIgnores) {
                this.getLog().warn((CharSequence)("\tignoring sources in: " + (File)((Object)ignore)));
            }
            this.getLog().info((CharSequence)"Checking if any files need compilation...");
            List<File> todoList = this.getTodoList(this.bin, this.srcs, this.srcIgnores, "rsc", "tpl");
            todoList.removeAll(this.parallelPreChecks);
            if (!todoList.isEmpty()) {
                this.getLog().info((CharSequence)"Stale source files have been found:");
                for (File todo : todoList) {
                    this.getLog().info((CharSequence)("\t" + todo));
                }
            } else {
                this.getLog().info((CharSequence)"No stale source files have been found, skipping compilation.");
                return;
            }
            this.libs.addAll(this.collectDependentArtifactLibraries(this.project));
            for (File lib : this.libs) {
                this.getLog().info((CharSequence)("\tregistered library location: " + lib));
            }
            this.getLog().info((CharSequence)"Files have been configured.");
            int result = this.runChecker(this.verbose, todoList, this.parallelPreChecks, this.srcs, this.libs, this.bin, this.generatedSources);
            if (result > 0) {
                throw new MojoExecutionException("Errors found while checking.");
            }
            return;
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e);
        }
    }

    private int estimateBestNumberOfParallelProcesses() {
        long result = this.systemInformation.getHardware().getProcessor().getLogicalProcessorCount();
        if (result < 2L) {
            return 1;
        }
        this.getLog().info((CharSequence)("Logical processor count: " + result));
        long maxMemory = this.systemInformation.getHardware().getMemory().getTotal();
        this.getLog().info((CharSequence)("Available memory: " + maxMemory / 1000L + " kilobytes"));
        long max2GmemoryDivisions = maxMemory / 1000L / 2000000L;
        this.getLog().info((CharSequence)("Number of 2G processors for this amount of memory:" + max2GmemoryDivisions));
        result = Math.min(result, max2GmemoryDivisions);
        this.getLog().info((CharSequence)("Estimated max number of processors: " + result));
        this.getLog().info((CharSequence)("Max number of processors requested: " + this.parallelMax));
        if (result < 2L) {
            return 1;
        }
        long finalEstimate = result < 2L ? 1L : Math.min((long)this.parallelMax, result);
        this.getLog().info((CharSequence)("Final estimate number of processores: " + finalEstimate));
        return (int)finalEstimate;
    }

    private int runChecker(boolean verbose, List<File> todoList, List<File> prechecks, List<File> srcLocs, List<File> libLocs, File binLoc, File generatedSourcesLoc) throws IOException, URISyntaxException, Exception {
        if (!this.parallel || todoList.size() <= 10 || this.estimateBestNumberOfParallelProcesses() <= 1) {
            return this.runCheckerSingleThreaded(verbose, todoList, srcLocs, libLocs, binLoc, generatedSourcesLoc);
        }
        return this.runCheckerMultithreaded(verbose, todoList, prechecks, srcLocs, libLocs, binLoc, generatedSourcesLoc);
    }

    private int runCheckerMultithreaded(boolean verbose, List<File> todoList, List<File> prechecks, List<File> srcs, List<File> libs, File bin, File generatedSourcesLoc) throws Exception {
        todoList.removeAll(prechecks);
        List<List<File>> chunks = this.splitTodoList(todoList);
        chunks.add(0, prechecks);
        List<File> tmpBins = chunks.stream().map(this.handleExceptions(l -> Files.createTempDirectory("rascal-checker", new FileAttribute[0]).toFile())).collect(Collectors.toList());
        List<File> tmpGeneratedSources = chunks.stream().map(this.handleExceptions(l -> Files.createTempDirectory("rascal-sources", new FileAttribute[0]).toFile())).collect(Collectors.toList());
        int result = 0;
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        try {
            int i;
            LinkedList<Process> processes = new LinkedList<Process>();
            extraParameters.put("modules", this.files(todoList));
            Process prechecker = this.runMain(verbose, srcs, libs, (File)tmpGeneratedSources.get(0), (File)tmpBins.get(0), extraParameters, true);
            result += prechecker.waitFor();
            libs.add((File)tmpBins.get(0));
            for (i = 1; i < chunks.size(); ++i) {
                extraParameters.put("modules", this.files(chunks.get(i)));
                processes.add(this.runMain(verbose, srcs, libs, tmpGeneratedSources.get(i), tmpBins.get(i), extraParameters, i <= 1));
            }
            for (i = 0; i < processes.size(); ++i) {
                if (i <= 1) {
                    result += ((Process)processes.get(i)).waitFor();
                    continue;
                }
                result += this.readStandardOutputAndWait((Process)processes.get(i));
            }
            this.mergeOutputFolders(bin, tmpBins);
            this.mergeOutputFolders(generatedSourcesLoc, tmpGeneratedSources);
            if (result > 0) {
                throw new MojoExecutionException("Checker found errors");
            }
            return result;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to prepare temporary directories for the checker.");
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Checker was interrupted");
        }
    }

    private int readStandardOutputAndWait(Process p) {
        int n;
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            n = p.waitFor();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return n;
    }

    private int runCheckerSingleThreaded(boolean verbose, List<File> todoList, List<File> srcLocs, List<File> libLocs, File binLoc, File generated) throws URISyntaxException, IOException, MojoExecutionException {
        this.getLog().info((CharSequence)"Running single checker process");
        try {
            this.extraParameters.put("modules", this.files(todoList));
            return this.runMain(verbose, srcLocs, libLocs, generated, binLoc, this.extraParameters, true).waitFor();
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)"Checker was interrupted");
            throw new MojoExecutionException((Throwable)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private void mergeOutputFolders(File bin, List<File> binFolders) throws IOException {
        for (File tmp : binFolders) {
            this.getLog().info((CharSequence)("Copying files from " + tmp + " to " + bin));
            CompileRascalMojo.mergeOutputFolders(bin, tmp);
        }
    }

    private static void mergeOutputFolders(File dst, File src) throws IOException {
        final Path dstPath = dst.toPath();
        final Path srcPath = src.toPath();
        Files.walkFileTree(srcPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(dstPath.resolve(srcPath.relativize(dir).toString()), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.move(file, dstPath.resolve(srcPath.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private List<List<File>> splitTodoList(List<File> todoList) {
        todoList.sort(File::compareTo);
        int chunkSize = todoList.size() / this.estimateBestNumberOfParallelProcesses();
        ArrayList<List<File>> result = new ArrayList<List<File>>();
        for (int from = 0; from <= todoList.size(); from += chunkSize) {
            result.add(Collections.unmodifiableList(todoList.subList(from, Math.min(from + chunkSize, todoList.size()))));
        }
        return result;
    }
}

