/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractRascalMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="memory", defaultValue="2G", readonly=true, required=false)
    protected String memory;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="bin", required=true)
    protected File bin;
    @Parameter(property="srcs", required=true)
    protected List<File> srcs;
    @Parameter(property="ignores", required=false)
    protected List<File> ignores;
    @Parameter(property="libs", required=false)
    protected List<File> libs;
    @Parameter(property="resources", required=false)
    protected List<File> resources;
    @Parameter(defaultValue="false", property="verbose", required=true)
    protected boolean verbose;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="0.41.0", required=false, readonly=false)
    protected String bootstrapRascalVersion;
    @Component
    protected BuildPluginManager pluginManager;
    @Parameter(defaultValue="")
    protected String mainModule;
    protected final String skipTag;
    protected final String mainClass;
    protected Map<String, String> extraParameters = new HashMap<String, String>();
    protected Path cachedRascalRuntime = null;

    public AbstractRascalMojo(String mainClass, String skipTag) {
        this.mainClass = mainClass;
        this.skipTag = skipTag;
    }

    protected Path getRascalRuntime() {
        if (this.cachedRascalRuntime == null) {
            this.cachedRascalRuntime = this.detectedDependentRascalArtifact(this.getLog(), this.project, this.session);
            this.getLog().info((CharSequence)("The Rascal runtime was resolved at " + this.cachedRascalRuntime));
        }
        return this.cachedRascalRuntime;
    }

    protected boolean isRascalProject() {
        return this.project.getGroupId().equals("org.rascalmpl") && this.project.getArtifactId().equals("rascal");
    }

    protected String files(List<File> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining(File.pathSeparator));
    }

    protected void setExtraParameters() {
    }

    public void execute() throws MojoExecutionException {
        try {
            if (System.getProperty("rascal." + this.skipTag + ".skip") != null) {
                this.getLog().info((CharSequence)("Skipping " + ((Object)((Object)this)).getClass().getName() + " completely"));
                return;
            }
            this.getLog().debug((CharSequence)"configuring paths");
            for (File src : this.srcs) {
                this.getLog().debug((CharSequence)("\tregistered source location: " + src));
            }
            for (File ignore : this.ignores) {
                this.getLog().debug((CharSequence)("\tignoring sources in: " + ignore));
            }
            for (File resource : this.resources) {
                this.getLog().debug((CharSequence)("\tcopying resources: " + resource));
            }
            this.getLog().info((CharSequence)"Checking if any files need compilation...");
            this.libs.addAll(this.collectDependentArtifactLibraries(this.project));
            for (File lib : this.libs) {
                this.getLog().debug((CharSequence)("\tregistered library location: " + lib));
            }
            this.getLog().debug((CharSequence)"Paths have been configured.");
            this.setExtraParameters();
            int exitVal = this.runMain(this.verbose, "", this.srcs, this.ignores, this.libs, this.resources, this.bin, this.extraParameters, true).waitFor();
            if (exitVal != 0) {
                throw new MojoExecutionException(this.mainClass + " exited with error code " + exitVal);
            }
            return;
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("nested " + this.mainClass + " was killed", (Exception)e);
        }
        catch (Throwable e) {
            throw new MojoExecutionException("error launching " + this.mainClass, e);
        }
    }

    protected Path detectedDependentRascalArtifact(Log log, MavenProject project, MavenSession session) {
        try {
            if (project.getGroupId().equals("org.rascalmpl") && project.getArtifactId().equals("rascal")) {
                log.info((CharSequence)("Maven Rascal Mojo detected rascal project self-application. Downloading the configured bootstrap rascal-" + this.bootstrapRascalVersion + ".jar"));
                log.info((CharSequence)("Find <rascalBootstrapVersion>" + this.bootstrapRascalVersion + "</rascalBootstrapVersion> in rascal/pom.xml"));
                if (this.bootstrapRascalVersion.endsWith("SNAPSHOT")) {
                    throw new IllegalArgumentException("The rascalBootstrapVersion configuration parameter must not be a SNAPSHOT release, because of the required reproducibility of any Rascal release. The Maven build will bail out now.");
                }
                return this.installBootstrapRascalVersion(project, session);
            }
            for (Object o : project.getArtifacts()) {
                Artifact a = (Artifact)o;
                if (!a.getGroupId().equals("org.rascalmpl") || !a.getArtifactId().equals("rascal")) continue;
                File file = a.getFile().getAbsoluteFile();
                if (a.getSelectedVersion().compareTo((Object)this.getReferenceRascalVersion()) >= 0) {
                    return file.toPath();
                }
                log.warn((CharSequence)("Rascal version in pom.xml dependency is too old for this Rascal maven plugin. " + this.getReferenceRascalVersion() + " or later expected."));
                log.warn((CharSequence)("Downloading and using a newer version org.rascalmpl:rascal:" + this.bootstrapRascalVersion + "; please add it to the pom.xml"));
                return this.installBootstrapRascalVersion(project, session);
            }
            throw new MojoExecutionException("Pom.xml is missig a dependency on org.rascalmpl:rascal:" + this.getReferenceRascalVersion() + " (or later).");
        }
        catch (OverConstrainedVersionException e) {
            log.error((CharSequence)("Rascal version is over-constrained (impossible to resolve). Expected " + this.getReferenceRascalVersion() + " or later. Have to abort."));
            throw new RuntimeException(e);
        }
        catch (MojoExecutionException e) {
            log.error((CharSequence)"Unable to just-in-time-install the required (bootstrap) version of Rascal. Have to abort.");
            throw new RuntimeException(e);
        }
    }

    protected List<File> collectDependentArtifactLibraries(MavenProject project) throws URISyntaxException, IOException {
        LinkedList<File> libs = new LinkedList<File>();
        for (Object o : project.getArtifacts()) {
            Artifact a = (Artifact)o;
            File file = a.getFile().getAbsoluteFile();
            libs.add(file);
        }
        return libs;
    }

    protected final ArtifactVersion getReferenceRascalVersion() {
        return new DefaultArtifactVersion("0.41.0");
    }

    protected Path installBootstrapRascalVersion(MavenProject project, MavenSession session) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)"org.apache.maven.plugins", (String)"maven-dependency-plugin", (String)"3.9.0"), (String)MojoExecutor.goal((String)"get"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"artifact", (String)("org.rascalmpl:rascal:" + this.bootstrapRascalVersion))}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)session, (BuildPluginManager)this.pluginManager));
        return Path.of(session.getSettings().getLocalRepository(), "org", "rascalmpl", "rascal", this.bootstrapRascalVersion, "rascal-" + this.bootstrapRascalVersion + ".jar");
    }

    protected Process runMain(boolean verbose, String moreClasspath, List<File> srcs, List<File> ignores, List<File> libs, List<File> resources, File bin, Map<String, String> extraParameters, boolean inheritIO) throws IOException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        LinkedList<String> command = new LinkedList<String>();
        command.add(javaBin);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!key.equals("user.dir")) {
                command.add("-D" + key + "=" + value);
            }
        }));
        command.add("-Xmx" + this.memory);
        command.add("-cp");
        command.add(this.getRascalRuntime().toString() + (String)(moreClasspath.isEmpty() ? "" : File.pathSeparator + moreClasspath));
        assert (this.mainClass != null) : "mainClass is null";
        command.add(this.mainClass);
        if (this.mainClass.endsWith("RascalShell") && this.mainModule != null && !this.mainModule.isEmpty()) {
            command.add(this.mainModule);
        }
        if (!this.mainClass.endsWith("RascalShell")) {
            if (!srcs.isEmpty()) {
                command.add("-srcs");
                command.add(this.files(srcs));
            }
            if (!resources.isEmpty()) {
                command.add("-resources");
                command.add(this.files(resources));
            }
            if (!ignores.isEmpty()) {
                command.add("-ignores");
                command.add(this.files(ignores));
            }
            if (!libs.isEmpty()) {
                command.add("-libs");
                command.add(this.files(libs));
            }
            command.add("-bin");
            assert (bin != null) : "bin is null";
            command.add(bin.toString());
            for (Map.Entry<String, String> e : extraParameters.entrySet()) {
                command.add("-" + e.getKey());
                assert (e.getValue() != null) : "value with " + e.getKey() + " is null in extraParameters";
                command.add(e.getValue());
            }
            if (verbose) {
                command.add("-verbose");
            }
        }
        assert (command.stream().map(Objects::nonNull).allMatch(b -> b)) : "command had a null parameter";
        this.getLog().debug((CharSequence)("Java exec: " + (String)command.get(0)));
        this.getLog().debug((CharSequence)("Starting process:\n\t java " + command.stream().skip(1L).map(s -> s.replace("\n", "\\\\n")).map(s -> "'" + s + "'").collect(Collectors.joining(" "))));
        ProcessBuilder p = new ProcessBuilder(command);
        if (inheritIO) {
            p.inheritIO();
        } else {
            p.redirectErrorStream(true);
        }
        return p.start();
    }

    protected List<File> getTodoList(File binLoc, List<File> srcLocs, List<File> ignoredLocs, final String dirtyExtension, final String binaryExtension, String binaryPrefix) throws InclusionScanException, URISyntaxException {
        StaleSourceScanner scanner = new StaleSourceScanner(100L);
        scanner.addSourceMapping(new SourceMapping(){

            public Set<File> getTargetFiles(File targetDir, String source) throws InclusionScanException {
                File file = new File(source);
                String name = file.getName();
                if (name.endsWith("." + dirtyExtension)) {
                    return Set.of(new File(targetDir, new File(file.getParentFile(), "$" + name.substring(0, name.length() - ("." + dirtyExtension).length()) + "." + binaryExtension).getPath()));
                }
                return Set.of();
            }
        });
        binLoc = new File(binLoc, binaryPrefix);
        HashSet staleSources = new HashSet();
        for (File src : this.srcs) {
            staleSources.addAll(scanner.getIncludedSources(src, binLoc));
        }
        LinkedList<File> filteredStaleSources = new LinkedList<File>();
        for (File file : staleSources) {
            if (!ignoredLocs.stream().noneMatch(l -> this.isIgnoredBy((File)l, file))) continue;
            filteredStaleSources.add(file);
        }
        return filteredStaleSources;
    }

    protected boolean isIgnoredBy(File prefix, File loc) {
        String prefixPath = prefix.toString();
        String locPath = loc.toString();
        return locPath.startsWith(prefixPath);
    }

    protected <T, R, E extends Exception> Function<T, R> handleExceptions(FunctionWithException<T, R, E> fe) {
        return arg -> {
            try {
                return fe.apply(arg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @FunctionalInterface
    protected static interface FunctionWithException<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

