/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.base;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Byte;
import org.rascalmpl.java.lang.Character;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Float;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Short;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class Defaults
extends Object {
    private static final Double DOUBLE_DEFAULT = Double.valueOf((double)0.0);
    private static final Float FLOAT_DEFAULT = Float.valueOf((float)0.0f);

    private Defaults() {
    }

    @CheckForNull
    public static <T extends Object> T defaultValue(Class<T> type) {
        Preconditions.checkNotNull(type);
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            if (type == Character.TYPE) {
                return (T)Character.valueOf((char)'\u0000');
            }
            if (type == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (type == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (type == Integer.TYPE) {
                return (T)Integer.valueOf((int)0);
            }
            if (type == Long.TYPE) {
                return (T)Long.valueOf((long)0L);
            }
            if (type == Float.TYPE) {
                return (T)FLOAT_DEFAULT;
            }
            if (type == Double.TYPE) {
                return (T)DOUBLE_DEFAULT;
            }
        }
        return null;
    }
}

