/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.base;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.com.google.common.base.NullnessCasts;
import org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.com.google.common.base.ParametricNullness;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Predicate;
import org.rascalmpl.com.google.common.base.Supplier;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Functions
extends org.rascalmpl.java.lang.Object {
    private Functions() {
    }

    public static Function<org.rascalmpl.java.lang.Object, String> toStringFunction() {
        return ToStringFunction.INSTANCE;
    }

    public static <E extends org.rascalmpl.java.lang.Object> Function<E, E> identity() {
        return IdentityFunction.INSTANCE;
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Function<K, V> forMap(Map<K, V> map) {
        return new FunctionForMapNoDefault<K, V>(map);
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Function<K, V> forMap(Map<K, ? extends V> map, @ParametricNullness V defaultValue) {
        return new ForMapWithDefault<K, V>(map, defaultValue);
    }

    public static <A extends org.rascalmpl.java.lang.Object, B extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object> Function<A, C> compose(Function<B, C> g2, Function<A, ? extends B> f) {
        return new FunctionComposition<A, B, C>(g2, f);
    }

    public static <T extends org.rascalmpl.java.lang.Object> Function<T, Boolean> forPredicate(Predicate<T> predicate) {
        return new PredicateFunction(predicate);
    }

    public static <E extends org.rascalmpl.java.lang.Object> Function<@Nullable org.rascalmpl.java.lang.Object, E> constant(@ParametricNullness E value) {
        return new ConstantFunction<E>(value);
    }

    public static <F extends org.rascalmpl.java.lang.Object, T extends org.rascalmpl.java.lang.Object> Function<F, T> forSupplier(Supplier<T> supplier) {
        return new SupplierFunction(supplier);
    }

    private static class SupplierFunction<F extends @Nullable org.rascalmpl.java.lang.Object, T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Function<F, T>,
    Serializable {
        private final Supplier<T> supplier;
        private static final long serialVersionUID = 0L;

        private SupplierFunction(Supplier<T> supplier) {
            this.supplier = Preconditions.checkNotNull(supplier);
        }

        @Override
        @ParametricNullness
        public T apply(@ParametricNullness F input) {
            return this.supplier.get();
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof SupplierFunction) {
                SupplierFunction that = (SupplierFunction)obj;
                return this.supplier.equals(that.supplier);
            }
            return false;
        }

        public int hashCode() {
            return this.supplier.hashCode();
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Functions.forSupplier(").append(this.supplier).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static class ConstantFunction<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Function<org.rascalmpl.java.lang.Object, E>,
    Serializable {
        @ParametricNullness
        private final E value;
        private static final long serialVersionUID = 0L;

        public ConstantFunction(@ParametricNullness E value) {
            this.value = value;
        }

        @Override
        @ParametricNullness
        public E apply(@CheckForNull org.rascalmpl.java.lang.Object from) {
            return this.value;
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof ConstantFunction) {
                ConstantFunction that = (ConstantFunction)obj;
                return Objects.equal(this.value, that.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Functions.constant(").append(this.value).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static class PredicateFunction<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Function<T, Boolean>,
    Serializable {
        private final Predicate<T> predicate;
        private static final long serialVersionUID = 0L;

        private PredicateFunction(Predicate<T> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public Boolean apply(@ParametricNullness T t2) {
            return Boolean.valueOf((boolean)this.predicate.apply(t2));
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof PredicateFunction) {
                PredicateFunction that = (PredicateFunction)obj;
                return this.predicate.equals(that.predicate);
            }
            return false;
        }

        public int hashCode() {
            return this.predicate.hashCode();
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Functions.forPredicate(").append(this.predicate).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static class FunctionComposition<A extends @Nullable org.rascalmpl.java.lang.Object, B extends @Nullable org.rascalmpl.java.lang.Object, C extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Function<A, C>,
    Serializable {
        private final Function<B, C> g;
        private final Function<A, ? extends B> f;
        private static final long serialVersionUID = 0L;

        public FunctionComposition(Function<B, C> g2, Function<A, ? extends B> f) {
            this.g = Preconditions.checkNotNull(g2);
            this.f = Preconditions.checkNotNull(f);
        }

        @Override
        @ParametricNullness
        public C apply(@ParametricNullness A a) {
            return this.g.apply(this.f.apply(a));
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof FunctionComposition) {
                FunctionComposition that = (FunctionComposition)obj;
                return this.f.equals(that.f) && this.g.equals(that.g);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.g.hashCode();
        }

        public String toString() {
            return new StringBuilder().append(this.g).append((String)"org.rascalmpl.(").append(this.f).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static class ForMapWithDefault<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Function<K, V>,
    Serializable {
        final Map<K, ? extends V> map;
        @ParametricNullness
        final V defaultValue;
        private static final long serialVersionUID = 0L;

        ForMapWithDefault(Map<K, ? extends V> map, @ParametricNullness V defaultValue) {
            this.map = Preconditions.checkNotNull(map);
            this.defaultValue = defaultValue;
        }

        @Override
        @ParametricNullness
        public V apply(@ParametricNullness K key) {
            org.rascalmpl.java.lang.Object result = this.map.get(key);
            return (V)(result != null || this.map.containsKey(key) ? NullnessCasts.uncheckedCastNullableTToT(result) : this.defaultValue);
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
            if (o instanceof ForMapWithDefault) {
                ForMapWithDefault that = (ForMapWithDefault)o;
                return this.map.equals(that.map) && Objects.equal(this.defaultValue, that.defaultValue);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(new org.rascalmpl.java.lang.Object[]{this.map, this.defaultValue});
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Functions.forMap(").append(this.map).append((String)"org.rascalmpl., defaultValue=").append(this.defaultValue).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static class FunctionForMapNoDefault<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Function<K, V>,
    Serializable {
        final Map<K, V> map;
        private static final long serialVersionUID = 0L;

        FunctionForMapNoDefault(Map<K, V> map) {
            this.map = Preconditions.checkNotNull(map);
        }

        @Override
        @ParametricNullness
        public V apply(@ParametricNullness K key) {
            org.rascalmpl.java.lang.Object result = this.map.get(key);
            Preconditions.checkArgument(result != null || this.map.containsKey(key), (String)"org.rascalmpl.Key '%s' not present in map", key);
            return (V)NullnessCasts.uncheckedCastNullableTToT(result);
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
            if (o instanceof FunctionForMapNoDefault) {
                FunctionForMapNoDefault that = (FunctionForMapNoDefault)o;
                return this.map.equals(that.map);
            }
            return false;
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Functions.forMap(").append(this.map).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static final class IdentityFunction
    extends Enum<IdentityFunction>
    implements Function<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object> {
        public static final /* enum */ IdentityFunction INSTANCE = new IdentityFunction((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ IdentityFunction[] $VALUES;

        public static IdentityFunction[] values() {
            return (IdentityFunction[])$VALUES.clone();
        }

        public static IdentityFunction valueOf(String name) {
            return (IdentityFunction)Enum.valueOf(IdentityFunction.class, (String)name);
        }

        private IdentityFunction() {
            super((String)string, n);
        }

        @Override
        @CheckForNull
        public org.rascalmpl.java.lang.Object apply(@CheckForNull org.rascalmpl.java.lang.Object o) {
            return o;
        }

        public String toString() {
            return "org.rascalmpl.Functions.identity()";
        }

        static {
            $VALUES = new IdentityFunction[]{INSTANCE};
        }
    }

    private static final class ToStringFunction
    extends Enum<ToStringFunction>
    implements Function<org.rascalmpl.java.lang.Object, String> {
        public static final /* enum */ ToStringFunction INSTANCE = new ToStringFunction((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ ToStringFunction[] $VALUES;

        public static ToStringFunction[] values() {
            return (ToStringFunction[])$VALUES.clone();
        }

        public static ToStringFunction valueOf(String name) {
            return (ToStringFunction)Enum.valueOf(ToStringFunction.class, (String)name);
        }

        private ToStringFunction() {
            super((String)string, n);
        }

        @Override
        public String apply(org.rascalmpl.java.lang.Object o) {
            Preconditions.checkNotNull(o);
            return o.toString();
        }

        public String toString() {
            return "org.rascalmpl.Functions.toStringFunction()";
        }

        static {
            $VALUES = new ToStringFunction[]{INSTANCE};
        }
    }
}

