/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.base;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.lang.Appendable;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.AbstractList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public class Joiner
extends org.rascalmpl.java.lang.Object {
    private final String separator;

    public static Joiner on(String separator) {
        return new Joiner(separator);
    }

    public static Joiner on(char separator) {
        return new Joiner(String.valueOf((char)separator));
    }

    private Joiner(String separator) {
        this.separator = Preconditions.checkNotNull(separator);
    }

    private Joiner(Joiner prototype) {
        this.separator = prototype.separator;
    }

    @CanIgnoreReturnValue
    public <A extends Appendable> A appendTo(A appendable, Iterable<? extends @Nullable org.rascalmpl.java.lang.Object> parts) throws IOException {
        return this.appendTo(appendable, (Iterator<? extends org.rascalmpl.java.lang.Object>)parts.iterator());
    }

    @CanIgnoreReturnValue
    public <A extends Appendable> A appendTo(A appendable, Iterator<? extends @Nullable org.rascalmpl.java.lang.Object> parts) throws IOException {
        Preconditions.checkNotNull(appendable);
        if (parts.hasNext()) {
            appendable.append(this.toString(parts.next()));
            while (parts.hasNext()) {
                appendable.append((CharSequence)this.separator);
                appendable.append(this.toString(parts.next()));
            }
        }
        return appendable;
    }

    @CanIgnoreReturnValue
    public final <A extends Appendable> A appendTo(A appendable, @Nullable org.rascalmpl.java.lang.Object[] parts) throws IOException {
        List partsList = Arrays.asList((org.rascalmpl.java.lang.Object[])parts);
        return this.appendTo(appendable, (Iterable<? extends org.rascalmpl.java.lang.Object>)partsList);
    }

    @CanIgnoreReturnValue
    public final <A extends Appendable> A appendTo(A appendable, @CheckForNull org.rascalmpl.java.lang.Object first, @CheckForNull org.rascalmpl.java.lang.Object second, org.rascalmpl.java.lang.Object ... rest) throws IOException {
        return this.appendTo(appendable, Joiner.iterable(first, second, rest));
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder builder, Iterable<? extends @Nullable org.rascalmpl.java.lang.Object> parts) {
        return this.appendTo(builder, (Iterator<? extends org.rascalmpl.java.lang.Object>)parts.iterator());
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder builder, Iterator<? extends @Nullable org.rascalmpl.java.lang.Object> parts) {
        try {
            this.appendTo((Appendable)builder, parts);
        }
        catch (IOException impossible) {
            throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
        }
        return builder;
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder builder, @Nullable org.rascalmpl.java.lang.Object[] parts) {
        List partsList = Arrays.asList((org.rascalmpl.java.lang.Object[])parts);
        return this.appendTo(builder, (Iterable<? extends org.rascalmpl.java.lang.Object>)partsList);
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder builder, @CheckForNull org.rascalmpl.java.lang.Object first, @CheckForNull org.rascalmpl.java.lang.Object second, org.rascalmpl.java.lang.Object ... rest) {
        return this.appendTo(builder, Joiner.iterable(first, second, rest));
    }

    public final String join(Iterable<? extends @Nullable org.rascalmpl.java.lang.Object> parts) {
        return this.join((Iterator<? extends org.rascalmpl.java.lang.Object>)parts.iterator());
    }

    public final String join(Iterator<? extends @Nullable org.rascalmpl.java.lang.Object> parts) {
        return this.appendTo(new StringBuilder(), parts).toString();
    }

    public final String join(@Nullable org.rascalmpl.java.lang.Object[] parts) {
        List partsList = Arrays.asList((org.rascalmpl.java.lang.Object[])parts);
        return this.join((Iterable<? extends org.rascalmpl.java.lang.Object>)partsList);
    }

    public final String join(@CheckForNull org.rascalmpl.java.lang.Object first, @CheckForNull org.rascalmpl.java.lang.Object second, org.rascalmpl.java.lang.Object ... rest) {
        return this.join(Joiner.iterable(first, second, rest));
    }

    public Joiner useForNull(final String nullText) {
        Preconditions.checkNotNull(nullText);
        return new Joiner(this){

            @Override
            CharSequence toString(@CheckForNull org.rascalmpl.java.lang.Object part) {
                return part == null ? nullText : Joiner.this.toString(part);
            }

            @Override
            public Joiner useForNull(String nullText2) {
                throw new UnsupportedOperationException((String)"org.rascalmpl.already specified useForNull");
            }

            @Override
            public Joiner skipNulls() {
                throw new UnsupportedOperationException((String)"org.rascalmpl.already specified useForNull");
            }
        };
    }

    public Joiner skipNulls() {
        return new Joiner(this){

            @Override
            public <A extends Appendable> A appendTo(A appendable, Iterator<? extends @Nullable org.rascalmpl.java.lang.Object> parts) throws IOException {
                org.rascalmpl.java.lang.Object part;
                Preconditions.checkNotNull(appendable, (org.rascalmpl.java.lang.Object)"org.rascalmpl.appendable");
                Preconditions.checkNotNull(parts, (org.rascalmpl.java.lang.Object)"org.rascalmpl.parts");
                while (parts.hasNext()) {
                    part = parts.next();
                    if (part == null) continue;
                    appendable.append(Joiner.this.toString(part));
                    break;
                }
                while (parts.hasNext()) {
                    part = parts.next();
                    if (part == null) continue;
                    appendable.append((CharSequence)Joiner.this.separator);
                    appendable.append(Joiner.this.toString(part));
                }
                return appendable;
            }

            @Override
            public Joiner useForNull(String nullText) {
                throw new UnsupportedOperationException((String)"org.rascalmpl.already specified skipNulls");
            }

            @Override
            public MapJoiner withKeyValueSeparator(String kvs) {
                throw new UnsupportedOperationException((String)"org.rascalmpl.can't use .skipNulls() with maps");
            }
        };
    }

    public MapJoiner withKeyValueSeparator(char keyValueSeparator) {
        return this.withKeyValueSeparator(String.valueOf((char)keyValueSeparator));
    }

    public MapJoiner withKeyValueSeparator(String keyValueSeparator) {
        return new MapJoiner(this, keyValueSeparator);
    }

    CharSequence toString(@CheckForNull org.rascalmpl.java.lang.Object part) {
        Objects.requireNonNull((org.rascalmpl.java.lang.Object)part);
        return part instanceof CharSequence ? (CharSequence)part : part.toString();
    }

    private static Iterable<@Nullable org.rascalmpl.java.lang.Object> iterable(final @CheckForNull org.rascalmpl.java.lang.Object first, final @CheckForNull org.rascalmpl.java.lang.Object second, final @Nullable org.rascalmpl.java.lang.Object[] rest) {
        Preconditions.checkNotNull(rest);
        return new AbstractList<org.rascalmpl.java.lang.Object>(){

            public int size() {
                return rest.length + 2;
            }

            @CheckForNull
            public org.rascalmpl.java.lang.Object get(int index) {
                switch (index) {
                    case 0: {
                        return first;
                    }
                    case 1: {
                        return second;
                    }
                }
                return rest[index - 2];
            }
        };
    }

    public static final class MapJoiner
    extends org.rascalmpl.java.lang.Object {
        private final Joiner joiner;
        private final String keyValueSeparator;

        private MapJoiner(Joiner joiner, String keyValueSeparator) {
            this.joiner = joiner;
            this.keyValueSeparator = Preconditions.checkNotNull(keyValueSeparator);
        }

        @CanIgnoreReturnValue
        public <A extends Appendable> A appendTo(A appendable, Map<?, ?> map) throws IOException {
            return this.appendTo(appendable, (Iterable<? extends Map.Entry<?, ?>>)map.entrySet());
        }

        @CanIgnoreReturnValue
        public StringBuilder appendTo(StringBuilder builder, Map<?, ?> map) {
            return this.appendTo(builder, (Iterable<? extends Map.Entry<?, ?>>)map.entrySet());
        }

        @CanIgnoreReturnValue
        public <A extends Appendable> A appendTo(A appendable, Iterable<? extends Map.Entry<?, ?>> entries) throws IOException {
            return this.appendTo(appendable, entries.iterator());
        }

        @CanIgnoreReturnValue
        public <A extends Appendable> A appendTo(A appendable, Iterator<? extends Map.Entry<?, ?>> parts) throws IOException {
            Preconditions.checkNotNull(appendable);
            if (parts.hasNext()) {
                Map.Entry entry = (Map.Entry)parts.next();
                appendable.append(this.joiner.toString(entry.getKey()));
                appendable.append((CharSequence)this.keyValueSeparator);
                appendable.append(this.joiner.toString(entry.getValue()));
                while (parts.hasNext()) {
                    appendable.append((CharSequence)this.joiner.separator);
                    Map.Entry e = (Map.Entry)parts.next();
                    appendable.append(this.joiner.toString(e.getKey()));
                    appendable.append((CharSequence)this.keyValueSeparator);
                    appendable.append(this.joiner.toString(e.getValue()));
                }
            }
            return appendable;
        }

        @CanIgnoreReturnValue
        public StringBuilder appendTo(StringBuilder builder, Iterable<? extends Map.Entry<?, ?>> entries) {
            return this.appendTo(builder, entries.iterator());
        }

        @CanIgnoreReturnValue
        public StringBuilder appendTo(StringBuilder builder, Iterator<? extends Map.Entry<?, ?>> entries) {
            try {
                this.appendTo((Appendable)builder, entries);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
            return builder;
        }

        public String join(Map<?, ?> map) {
            return this.join((Iterable<? extends Map.Entry<?, ?>>)map.entrySet());
        }

        public String join(Iterable<? extends Map.Entry<?, ?>> entries) {
            return this.join(entries.iterator());
        }

        public String join(Iterator<? extends Map.Entry<?, ?>> entries) {
            return this.appendTo(new StringBuilder(), entries).toString();
        }

        public MapJoiner useForNull(String nullText) {
            return new MapJoiner(this.joiner.useForNull(nullText), this.keyValueSeparator);
        }
    }
}

