/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.base;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Absent;
import org.rascalmpl.com.google.common.base.AbstractIterator;
import org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Present;
import org.rascalmpl.com.google.common.base.Supplier;
import org.rascalmpl.com.google.errorprone.annotations.DoNotMock;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.javax.annotation.CheckForNull;

@DoNotMock(value="org.rascalmpl.Use Optional.of(value) or Optional.absent()")
@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
public abstract class Optional<T extends Object>
extends Object
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T extends Object> Optional<T> absent() {
        return Absent.withType();
    }

    public static <T extends Object> Optional<T> of(T reference) {
        return new Present<T>(Preconditions.checkNotNull(reference));
    }

    public static <T extends Object> Optional<T> fromNullable(@CheckForNull T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    @CheckForNull
    public static <T extends Object> Optional<T> fromJavaUtil(@CheckForNull org.rascalmpl.java.util.Optional<T> javaUtilOptional) {
        return javaUtilOptional == null ? null : Optional.fromNullable(javaUtilOptional.orElse(null));
    }

    @CheckForNull
    public static <T extends Object> org.rascalmpl.java.util.Optional<T> toJavaUtil(@CheckForNull Optional<T> googleOptional) {
        return googleOptional == null ? null : googleOptional.toJavaUtil();
    }

    public org.rascalmpl.java.util.Optional<T> toJavaUtil() {
        return org.rascalmpl.java.util.Optional.ofNullable(this.orNull());
    }

    Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    public abstract T or(Supplier<? extends T> var1);

    @CheckForNull
    public abstract T orNull();

    public abstract Set<T> asSet();

    public abstract <V extends Object> Optional<V> transform(Function<? super T, V> var1);

    public abstract boolean equals(@CheckForNull Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public static <T extends Object> Iterable<T> presentInstances(final Iterable<? extends Optional<? extends T>> optionals) {
        Preconditions.checkNotNull(optionals);
        return new Iterable<T>(){

            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    private final Iterator<? extends Optional<? extends T>> iterator;
                    {
                        this.iterator = Preconditions.checkNotNull(optionals.iterator());
                    }

                    @Override
                    @CheckForNull
                    protected T computeNext() {
                        while (this.iterator.hasNext()) {
                            Optional optional = (Optional)this.iterator.next();
                            if (!optional.isPresent()) continue;
                            return optional.get();
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }
}

