/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.base;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.CommonPattern;
import org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.com.google.common.base.JdkPattern;
import org.rascalmpl.com.google.common.base.MoreObjects;
import org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.com.google.common.base.ParametricNullness;
import org.rascalmpl.com.google.common.base.Platform;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Predicate;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassCastException;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.NullPointerException;
import org.rascalmpl.java.lang.SafeVarargs;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.regex.Pattern;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Predicates
extends org.rascalmpl.java.lang.Object {
    private Predicates() {
    }

    @GwtCompatible(serializable=true)
    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> alwaysTrue() {
        return ObjectPredicate.ALWAYS_TRUE.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> alwaysFalse() {
        return ObjectPredicate.ALWAYS_FALSE.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> isNull() {
        return ObjectPredicate.IS_NULL.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> notNull() {
        return ObjectPredicate.NOT_NULL.withNarrowedType();
    }

    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> not(Predicate<T> predicate) {
        return new NotPredicate<T>(predicate);
    }

    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> and(Iterable<? extends Predicate<? super T>> components) {
        return new AndPredicate(Predicates.defensiveCopy(components));
    }

    @SafeVarargs
    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> and(Predicate<? super T> ... components) {
        return new AndPredicate(Predicates.defensiveCopy((org.rascalmpl.java.lang.Object[])components));
    }

    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> second) {
        return new AndPredicate(Predicates.asList(Preconditions.checkNotNull(first), Preconditions.checkNotNull(second)));
    }

    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        return new OrPredicate(Predicates.defensiveCopy(components));
    }

    @SafeVarargs
    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> or(Predicate<? super T> ... components) {
        return new OrPredicate(Predicates.defensiveCopy((org.rascalmpl.java.lang.Object[])components));
    }

    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> or(Predicate<? super T> first, Predicate<? super T> second) {
        return new OrPredicate(Predicates.asList(Preconditions.checkNotNull(first), Preconditions.checkNotNull(second)));
    }

    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> equalTo(@ParametricNullness T target) {
        return target == null ? Predicates.isNull() : new IsEqualToPredicate(target).withNarrowedType();
    }

    @GwtIncompatible
    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> instanceOf(Class<?> clazz) {
        return new InstanceOfPredicate(clazz);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Predicate<Class<?>> subtypeOf(Class<?> clazz) {
        return new SubtypeOfPredicate(clazz);
    }

    public static <T extends org.rascalmpl.java.lang.Object> Predicate<T> in(Collection<? extends T> target) {
        return new InPredicate(target);
    }

    public static <A extends org.rascalmpl.java.lang.Object, B extends org.rascalmpl.java.lang.Object> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return new CompositionPredicate(predicate, function);
    }

    @GwtIncompatible
    public static Predicate<CharSequence> containsPattern(String pattern) {
        return new ContainsPatternFromStringPredicate(pattern);
    }

    @GwtIncompatible(value="org.rascalmpl.java.util.regex.Pattern")
    public static Predicate<CharSequence> contains(Pattern pattern) {
        return new ContainsPatternPredicate(new JdkPattern(pattern));
    }

    private static String toStringHelper(String methodName, Iterable<?> components) {
        StringBuilder builder = new StringBuilder((String)"org.rascalmpl.Predicates.").append(methodName).append('(');
        boolean first = true;
        for (org.rascalmpl.java.lang.Object o : components) {
            if (!first) {
                builder.append(',');
            }
            builder.append(o);
            first = false;
        }
        return builder.append(')').toString();
    }

    private static <T extends org.rascalmpl.java.lang.Object> List<Predicate<? super T>> asList(Predicate<? super T> first, Predicate<? super T> second) {
        return Arrays.asList((org.rascalmpl.java.lang.Object[])new Predicate[]{first, second});
    }

    private static <T extends org.rascalmpl.java.lang.Object> List<T> defensiveCopy(T ... array) {
        return Predicates.defensiveCopy(Arrays.asList(array));
    }

    static <T extends org.rascalmpl.java.lang.Object> List<T> defensiveCopy(Iterable<T> iterable) {
        ArrayList list = new ArrayList();
        for (org.rascalmpl.java.lang.Object element : iterable) {
            list.add(Preconditions.checkNotNull(element));
        }
        return list;
    }

    @GwtIncompatible
    private static class ContainsPatternFromStringPredicate
    extends ContainsPatternPredicate {
        private static final long serialVersionUID = 0L;

        ContainsPatternFromStringPredicate(String string) {
            super(Platform.compilePattern(string));
        }

        @Override
        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Predicates.containsPattern(").append(this.pattern.pattern()).append((String)"org.rascalmpl.)").toString();
        }
    }

    @GwtIncompatible
    private static class ContainsPatternPredicate
    extends org.rascalmpl.java.lang.Object
    implements Predicate<CharSequence>,
    Serializable {
        final CommonPattern pattern;
        private static final long serialVersionUID = 0L;

        ContainsPatternPredicate(CommonPattern pattern) {
            this.pattern = Preconditions.checkNotNull(pattern);
        }

        @Override
        public boolean apply(CharSequence t2) {
            return this.pattern.matcher(t2).find();
        }

        public int hashCode() {
            return Objects.hashCode(new org.rascalmpl.java.lang.Object[]{this.pattern.pattern(), Integer.valueOf((int)this.pattern.flags())});
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof ContainsPatternPredicate) {
                ContainsPatternPredicate that = (ContainsPatternPredicate)obj;
                return Objects.equal((org.rascalmpl.java.lang.Object)this.pattern.pattern(), (org.rascalmpl.java.lang.Object)that.pattern.pattern()) && this.pattern.flags() == that.pattern.flags();
            }
            return false;
        }

        public String toString() {
            String patternString = MoreObjects.toStringHelper(this.pattern).add((String)"org.rascalmpl.pattern", (org.rascalmpl.java.lang.Object)this.pattern.pattern()).add((String)"org.rascalmpl.pattern.flags", this.pattern.flags()).toString();
            return new StringBuilder().append((String)"org.rascalmpl.Predicates.contains(").append(patternString).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static class CompositionPredicate<A extends @Nullable org.rascalmpl.java.lang.Object, B extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Predicate<A>,
    Serializable {
        final Predicate<B> p;
        final Function<A, ? extends B> f;
        private static final long serialVersionUID = 0L;

        private CompositionPredicate(Predicate<B> p, Function<A, ? extends B> f) {
            this.p = Preconditions.checkNotNull(p);
            this.f = Preconditions.checkNotNull(f);
        }

        @Override
        public boolean apply(@ParametricNullness A a) {
            return this.p.apply(this.f.apply(a));
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof CompositionPredicate) {
                CompositionPredicate that = (CompositionPredicate)obj;
                return this.f.equals(that.f) && this.p.equals(that.p);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.p.hashCode();
        }

        public String toString() {
            return new StringBuilder().append(this.p).append((String)"org.rascalmpl.(").append(this.f).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static class InPredicate<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Predicate<T>,
    Serializable {
        private final Collection<?> target;
        private static final long serialVersionUID = 0L;

        private InPredicate(Collection<?> target) {
            this.target = Preconditions.checkNotNull(target);
        }

        @Override
        public boolean apply(@ParametricNullness T t2) {
            try {
                return this.target.contains(t2);
            }
            catch (ClassCastException | NullPointerException e) {
                return false;
            }
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof InPredicate) {
                InPredicate that = (InPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Predicates.in(").append(this.target).append((String)"org.rascalmpl.)").toString();
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static class SubtypeOfPredicate
    extends org.rascalmpl.java.lang.Object
    implements Predicate<Class<?>>,
    Serializable {
        private final Class<?> clazz;
        private static final long serialVersionUID = 0L;

        private SubtypeOfPredicate(Class<?> clazz) {
            this.clazz = Preconditions.checkNotNull(clazz);
        }

        @Override
        public boolean apply(Class<?> input) {
            return this.clazz.isAssignableFrom(input);
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof SubtypeOfPredicate) {
                SubtypeOfPredicate that = (SubtypeOfPredicate)obj;
                return this.clazz == that.clazz;
            }
            return false;
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Predicates.subtypeOf(").append(this.clazz.getName()).append((String)"org.rascalmpl.)").toString();
        }
    }

    @GwtIncompatible
    private static class InstanceOfPredicate<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Predicate<T>,
    Serializable {
        private final Class<?> clazz;
        @J2ktIncompatible
        private static final long serialVersionUID = 0L;

        private InstanceOfPredicate(Class<?> clazz) {
            this.clazz = Preconditions.checkNotNull(clazz);
        }

        @Override
        public boolean apply(@ParametricNullness T o) {
            return this.clazz.isInstance(o);
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof InstanceOfPredicate) {
                InstanceOfPredicate that = (InstanceOfPredicate)obj;
                return this.clazz == that.clazz;
            }
            return false;
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Predicates.instanceOf(").append(this.clazz.getName()).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static class IsEqualToPredicate
    extends org.rascalmpl.java.lang.Object
    implements Predicate<org.rascalmpl.java.lang.Object>,
    Serializable {
        private final org.rascalmpl.java.lang.Object target;
        private static final long serialVersionUID = 0L;

        private IsEqualToPredicate(org.rascalmpl.java.lang.Object target) {
            this.target = target;
        }

        @Override
        public boolean apply(@CheckForNull org.rascalmpl.java.lang.Object o) {
            return this.target.equals(o);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof IsEqualToPredicate) {
                IsEqualToPredicate that = (IsEqualToPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Predicates.equalTo(").append(this.target).append((String)"org.rascalmpl.)").toString();
        }

        <T extends org.rascalmpl.java.lang.Object> Predicate<T> withNarrowedType() {
            return this;
        }
    }

    private static class OrPredicate<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        private OrPredicate(List<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(@ParametricNullness T t2) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (!((Predicate)this.components.get(i)).apply(t2)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.components.hashCode() + 87855567;
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof OrPredicate) {
                OrPredicate that = (OrPredicate)obj;
                return this.components.equals(that.components);
            }
            return false;
        }

        public String toString() {
            return Predicates.toStringHelper((String)"org.rascalmpl.or", this.components);
        }
    }

    private static class AndPredicate<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        private AndPredicate(List<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(@ParametricNullness T t2) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (((Predicate)this.components.get(i)).apply(t2)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.components.hashCode() + 306654252;
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof AndPredicate) {
                AndPredicate that = (AndPredicate)obj;
                return this.components.equals(that.components);
            }
            return false;
        }

        public String toString() {
            return Predicates.toStringHelper((String)"org.rascalmpl.and", this.components);
        }
    }

    private static class NotPredicate<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Predicate<T>,
    Serializable {
        final Predicate<T> predicate;
        private static final long serialVersionUID = 0L;

        NotPredicate(Predicate<T> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(@ParametricNullness T t2) {
            return !this.predicate.apply(t2);
        }

        public int hashCode() {
            return ~this.predicate.hashCode();
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof NotPredicate) {
                NotPredicate that = (NotPredicate)obj;
                return this.predicate.equals(that.predicate);
            }
            return false;
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Predicates.not(").append(this.predicate).append((String)"org.rascalmpl.)").toString();
        }
    }

    static abstract class ObjectPredicate
    extends Enum<ObjectPredicate>
    implements Predicate<org.rascalmpl.java.lang.Object> {
        public static final /* enum */ ObjectPredicate ALWAYS_TRUE = new ObjectPredicate(){

            @Override
            public boolean apply(@CheckForNull org.rascalmpl.java.lang.Object o) {
                return true;
            }

            public String toString() {
                return "org.rascalmpl.Predicates.alwaysTrue()";
            }
        };
        public static final /* enum */ ObjectPredicate ALWAYS_FALSE = new ObjectPredicate(){

            @Override
            public boolean apply(@CheckForNull org.rascalmpl.java.lang.Object o) {
                return false;
            }

            public String toString() {
                return "org.rascalmpl.Predicates.alwaysFalse()";
            }
        };
        public static final /* enum */ ObjectPredicate IS_NULL = new ObjectPredicate(){

            @Override
            public boolean apply(@CheckForNull org.rascalmpl.java.lang.Object o) {
                return o == null;
            }

            public String toString() {
                return "org.rascalmpl.Predicates.isNull()";
            }
        };
        public static final /* enum */ ObjectPredicate NOT_NULL = new ObjectPredicate(){

            @Override
            public boolean apply(@CheckForNull org.rascalmpl.java.lang.Object o) {
                return o != null;
            }

            public String toString() {
                return "org.rascalmpl.Predicates.notNull()";
            }
        };
        private static final /* synthetic */ ObjectPredicate[] $VALUES;

        public static ObjectPredicate[] values() {
            return (ObjectPredicate[])$VALUES.clone();
        }

        public static ObjectPredicate valueOf(String name) {
            return (ObjectPredicate)Enum.valueOf(ObjectPredicate.class, (String)name);
        }

        private ObjectPredicate() {
            super((String)string, n);
        }

        <T extends org.rascalmpl.java.lang.Object> Predicate<T> withNarrowedType() {
            return this;
        }

        static {
            $VALUES = new ObjectPredicate[]{ALWAYS_TRUE, ALWAYS_FALSE, IS_NULL, NOT_NULL};
        }
    }
}

