/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.base;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.base.Platform;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.errorprone.annotations.InlineMe;
import org.rascalmpl.com.google.errorprone.annotations.InlineMeValidationDisabled;
import org.rascalmpl.java.lang.ArrayIndexOutOfBoundsException;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Character;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Strings
extends Object {
    private Strings() {
    }

    public static String nullToEmpty(@CheckForNull String string) {
        return Platform.nullToEmpty(string);
    }

    @CheckForNull
    public static String emptyToNull(@CheckForNull String string) {
        return Platform.emptyToNull(string);
    }

    public static boolean isNullOrEmpty(@CheckForNull String string) {
        return Platform.stringIsNullOrEmpty(string);
    }

    public static String padStart(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }

    public static String padEnd(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    @InlineMe(replacement="org.rascalmpl.string.repeat(count)")
    @InlineMeValidationDisabled(value="org.rascalmpl.Java 11+ API only")
    public static String repeat(String string, int count) {
        int n;
        Preconditions.checkNotNull(string);
        if (count <= 1) {
            Preconditions.checkArgument(count >= 0, (String)"org.rascalmpl.invalid count: %s", count);
            return count == 0 ? "org.rascalmpl." : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder().append((String)"org.rascalmpl.Required array size too large: ").append(longSize).toString());
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy((Object)array, (int)0, (Object)array, (int)n, (int)n);
        }
        System.arraycopy((Object)array, (int)0, (Object)array, (int)n, (int)(size - n));
        return new String(array);
    }

    public static String commonPrefix(CharSequence a, CharSequence b) {
        int p;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        int maxPrefixLength = Math.min((int)a.length(), (int)b.length());
        for (p = 0; p < maxPrefixLength && a.charAt(p) == b.charAt(p); ++p) {
        }
        if (Strings.validSurrogatePairAt(a, p - 1) || Strings.validSurrogatePairAt(b, p - 1)) {
            --p;
        }
        return a.subSequence(0, p).toString();
    }

    public static String commonSuffix(CharSequence a, CharSequence b) {
        int s2;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        int maxSuffixLength = Math.min((int)a.length(), (int)b.length());
        for (s2 = 0; s2 < maxSuffixLength && a.charAt(a.length() - s2 - 1) == b.charAt(b.length() - s2 - 1); ++s2) {
        }
        if (Strings.validSurrogatePairAt(a, a.length() - s2 - 1) || Strings.validSurrogatePairAt(b, b.length() - s2 - 1)) {
            --s2;
        }
        return a.subSequence(a.length() - s2, a.length()).toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate((char)string.charAt(index)) && Character.isLowSurrogate((char)string.charAt(index + 1));
    }

    public static String lenientFormat(@CheckForNull String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf((Object)template);
        if (args == null) {
            args = new Object[]{"org.rascalmpl.(Object[])null"};
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = Strings.lenientToString(args[i]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf((String)"org.rascalmpl.%s", templateStart)) != -1) {
            builder.append((CharSequence)template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append((CharSequence)template, templateStart, template.length());
        if (i < args.length) {
            builder.append((String)"org.rascalmpl. [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append((String)"org.rascalmpl., ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(@CheckForNull Object o) {
        if (o == null) {
            return "org.rascalmpl.null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            String objectToString = new StringBuilder().append(o.getClass().getName()).append('@').append(Integer.toHexString((int)System.identityHashCode((Object)o))).toString();
            Logger.getLogger((String)"org.rascalmpl.com.google.common.base.Strings").log(Level.WARNING, new StringBuilder().append((String)"org.rascalmpl.Exception during lenientFormat for ").append(objectToString).toString(), (Throwable)((java.lang.Object)e));
            return new StringBuilder().append((String)"org.rascalmpl.<").append(objectToString).append((String)"org.rascalmpl. threw ").append(e.getClass().getName()).append((String)"org.rascalmpl.>").toString();
        }
    }
}

