/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.base;

import org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.com.google.common.base.IgnoreJRERequirement;
import org.rascalmpl.com.google.common.base.Internal;
import org.rascalmpl.com.google.common.base.NullnessCasts;
import org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.com.google.common.base.ParametricNullness;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Supplier;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Void;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Suppliers
extends org.rascalmpl.java.lang.Object {
    private Suppliers() {
    }

    public static <F extends org.rascalmpl.java.lang.Object, T extends org.rascalmpl.java.lang.Object> Supplier<T> compose(Function<? super F, T> function, Supplier<F> supplier) {
        return new SupplierComposition<F, T>(function, supplier);
    }

    public static <T extends org.rascalmpl.java.lang.Object> Supplier<T> memoize(Supplier<T> delegate) {
        if (delegate instanceof NonSerializableMemoizingSupplier || delegate instanceof MemoizingSupplier) {
            return delegate;
        }
        return delegate instanceof Serializable ? new MemoizingSupplier<T>(delegate) : new NonSerializableMemoizingSupplier<T>(delegate);
    }

    public static <T extends org.rascalmpl.java.lang.Object> Supplier<T> memoizeWithExpiration(Supplier<T> delegate, long duration, TimeUnit unit) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkArgument(duration > 0L, (String)"org.rascalmpl.duration (%s %s) must be > 0", duration, (org.rascalmpl.java.lang.Object)unit);
        return new ExpiringMemoizingSupplier<T>(delegate, unit.toNanos(duration));
    }

    @Beta
    @J2ktIncompatible
    @GwtIncompatible
    @IgnoreJRERequirement
    public static <T extends org.rascalmpl.java.lang.Object> Supplier<T> memoizeWithExpiration(Supplier<T> delegate, Duration duration) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkArgument(!duration.isNegative() && !duration.isZero(), (String)"org.rascalmpl.duration (%s) must be > 0", (org.rascalmpl.java.lang.Object)duration);
        return new ExpiringMemoizingSupplier<T>(delegate, Internal.toNanosSaturated(duration));
    }

    public static <T extends org.rascalmpl.java.lang.Object> Supplier<T> ofInstance(@ParametricNullness T instance) {
        return new SupplierOfInstance<T>(instance);
    }

    public static <T extends org.rascalmpl.java.lang.Object> Supplier<T> synchronizedSupplier(Supplier<T> delegate) {
        return new ThreadSafeSupplier<T>(delegate);
    }

    public static <T extends org.rascalmpl.java.lang.Object> Function<Supplier<T>, T> supplierFunction() {
        SupplierFunctionImpl sf = SupplierFunctionImpl.INSTANCE;
        return sf;
    }

    private static final class SupplierFunctionImpl
    extends Enum<SupplierFunctionImpl>
    implements SupplierFunction<org.rascalmpl.java.lang.Object> {
        public static final /* enum */ SupplierFunctionImpl INSTANCE = new SupplierFunctionImpl((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ SupplierFunctionImpl[] $VALUES;

        public static SupplierFunctionImpl[] values() {
            return (SupplierFunctionImpl[])$VALUES.clone();
        }

        public static SupplierFunctionImpl valueOf(String name) {
            return (SupplierFunctionImpl)Enum.valueOf(SupplierFunctionImpl.class, (String)name);
        }

        private SupplierFunctionImpl() {
            super((String)string, n);
        }

        @Override
        @CheckForNull
        public org.rascalmpl.java.lang.Object apply(Supplier<@Nullable org.rascalmpl.java.lang.Object> input) {
            return input.get();
        }

        public String toString() {
            return "org.rascalmpl.Suppliers.supplierFunction()";
        }

        static {
            $VALUES = new SupplierFunctionImpl[]{INSTANCE};
        }
    }

    private static interface SupplierFunction<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends Function<Supplier<T>, T> {
    }

    private static class ThreadSafeSupplier<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        private static final long serialVersionUID = 0L;

        ThreadSafeSupplier(Supplier<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ParametricNullness
        public T get() {
            Supplier<T> supplier = this.delegate;
            synchronized (supplier) {
                return this.delegate.get();
            }
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Suppliers.synchronizedSupplier(").append(this.delegate).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static class SupplierOfInstance<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<T>,
    Serializable {
        @ParametricNullness
        final T instance;
        private static final long serialVersionUID = 0L;

        SupplierOfInstance(@ParametricNullness T instance) {
            this.instance = instance;
        }

        @Override
        @ParametricNullness
        public T get() {
            return this.instance;
        }

        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof SupplierOfInstance) {
                SupplierOfInstance that = (SupplierOfInstance)obj;
                return Objects.equal(this.instance, that.instance);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(new org.rascalmpl.java.lang.Object[]{this.instance});
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Suppliers.ofInstance(").append(this.instance).append((String)"org.rascalmpl.)").toString();
        }
    }

    @VisibleForTesting
    static class ExpiringMemoizingSupplier<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        final long durationNanos;
        @CheckForNull
        volatile transient T value;
        volatile transient long expirationNanos;
        private static final long serialVersionUID = 0L;

        ExpiringMemoizingSupplier(Supplier<T> delegate, long durationNanos) {
            this.delegate = delegate;
            this.durationNanos = durationNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ParametricNullness
        public T get() {
            long nanos = this.expirationNanos;
            long now = System.nanoTime();
            if (nanos == 0L || now - nanos >= 0L) {
                ExpiringMemoizingSupplier expiringMemoizingSupplier = this;
                synchronized (expiringMemoizingSupplier) {
                    if (nanos == this.expirationNanos) {
                        T t2 = this.delegate.get();
                        this.value = t2;
                        nanos = now + this.durationNanos;
                        this.expirationNanos = nanos == 0L ? 1L : nanos;
                        return t2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Suppliers.memoizeWithExpiration(").append(this.delegate).append((String)"org.rascalmpl., ").append(this.durationNanos).append((String)"org.rascalmpl., NANOS)").toString();
        }
    }

    @VisibleForTesting
    static class NonSerializableMemoizingSupplier<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<T> {
        private static final Supplier<Void> SUCCESSFULLY_COMPUTED;
        private volatile Supplier<T> delegate;
        @CheckForNull
        private T value;

        NonSerializableMemoizingSupplier(Supplier<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ParametricNullness
        public T get() {
            if (this.delegate != SUCCESSFULLY_COMPUTED) {
                NonSerializableMemoizingSupplier nonSerializableMemoizingSupplier = this;
                synchronized (nonSerializableMemoizingSupplier) {
                    if (this.delegate != SUCCESSFULLY_COMPUTED) {
                        T t2 = this.delegate.get();
                        this.value = t2;
                        this.delegate = SUCCESSFULLY_COMPUTED;
                        return t2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            String delegate = this.delegate;
            return new StringBuilder().append((String)"org.rascalmpl.Suppliers.memoize(").append(delegate == SUCCESSFULLY_COMPUTED ? new StringBuilder().append((String)"org.rascalmpl.<supplier that returned ").append(this.value).append((String)"org.rascalmpl.>").toString() : delegate).append((String)"org.rascalmpl.)").toString();
        }

        private static /* synthetic */ Void lambda$static$0() {
            throw new IllegalStateException();
        }

        /*
         * Exception decompiling
         */
        static {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()Lorg/rascalmpl/java/lang/Object;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @VisibleForTesting
    static class MemoizingSupplier<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        @CheckForNull
        transient T value;
        private static final long serialVersionUID = 0L;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ParametricNullness
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        T t2 = this.delegate.get();
                        this.value = t2;
                        this.initialized = true;
                        return t2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Suppliers.memoize(").append(this.initialized ? new StringBuilder().append((String)"org.rascalmpl.<supplier that returned ").append(this.value).append((String)"org.rascalmpl.>").toString() : this.delegate).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static class SupplierComposition<F extends @Nullable org.rascalmpl.java.lang.Object, T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<T>,
    Serializable {
        final Function<? super F, T> function;
        final Supplier<F> supplier;
        private static final long serialVersionUID = 0L;

        SupplierComposition(Function<? super F, T> function, Supplier<F> supplier) {
            this.function = Preconditions.checkNotNull(function);
            this.supplier = Preconditions.checkNotNull(supplier);
        }

        @Override
        @ParametricNullness
        public T get() {
            return this.function.apply(this.supplier.get());
        }

        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof SupplierComposition) {
                SupplierComposition that = (SupplierComposition)obj;
                return this.function.equals(that.function) && this.supplier.equals(that.supplier);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.function, this.supplier);
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Suppliers.compose(").append(this.function).append((String)"org.rascalmpl., ").append(this.supplier).append((String)"org.rascalmpl.)").toString();
        }
    }
}

