/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.base;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.io.PrintWriter;
import org.rascalmpl.java.io.StringWriter;
import org.rascalmpl.java.io.Writer;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassCastException;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Error;
import org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.StackTraceElement;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.ThreadDeath;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.lang.reflect.InvocationTargetException;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.util.AbstractList;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Throwables
extends org.rascalmpl.java.lang.Object {
    @J2ktIncompatible
    @GwtIncompatible
    private static final String JAVA_LANG_ACCESS_CLASSNAME = "org.rascalmpl.sun.misc.JavaLangAccess";
    @J2ktIncompatible
    @GwtIncompatible
    @VisibleForTesting
    static final String SHARED_SECRETS_CLASSNAME = "org.rascalmpl.sun.misc.SharedSecrets";
    @CheckForNull
    @J2ktIncompatible
    @GwtIncompatible
    private static final org.rascalmpl.java.lang.Object jla = Throwables.getJLA();
    @CheckForNull
    @J2ktIncompatible
    @GwtIncompatible
    private static final Method getStackTraceElementMethod = jla == null ? null : Throwables.getGetMethod();
    @CheckForNull
    @J2ktIncompatible
    @GwtIncompatible
    private static final Method getStackTraceDepthMethod = jla == null ? null : Throwables.getSizeMethod(jla);

    private Throwables() {
    }

    @GwtIncompatible
    public static <X extends Throwable> void throwIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        Preconditions.checkNotNull(throwable);
        if (declaredType.isInstance((org.rascalmpl.java.lang.Object)throwable)) {
            throw (Throwable)declaredType.cast((org.rascalmpl.java.lang.Object)throwable);
        }
    }

    @Deprecated
    @J2ktIncompatible
    @GwtIncompatible
    public static <X extends Throwable> void propagateIfInstanceOf(@CheckForNull Throwable throwable, Class<X> declaredType) throws X {
        if (throwable != null) {
            Throwables.throwIfInstanceOf(throwable, declaredType);
        }
    }

    public static void throwIfUnchecked(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)((Object)throwable);
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    @Deprecated
    @J2ktIncompatible
    @GwtIncompatible
    public static void propagateIfPossible(@CheckForNull Throwable throwable) {
        if (throwable != null) {
            Throwables.throwIfUnchecked(throwable);
        }
    }

    @Deprecated
    @J2ktIncompatible
    @GwtIncompatible
    public static <X extends Throwable> void propagateIfPossible(@CheckForNull Throwable throwable, Class<X> declaredType) throws X {
        Throwables.propagateIfInstanceOf(throwable, declaredType);
        Throwables.propagateIfPossible(throwable);
    }

    @Deprecated
    @J2ktIncompatible
    @GwtIncompatible
    public static <X1 extends Throwable, X2 extends Throwable> void propagateIfPossible(@CheckForNull Throwable throwable, Class<X1> declaredType1, Class<X2> declaredType2) throws X1, X2 {
        Preconditions.checkNotNull(declaredType2);
        Throwables.propagateIfInstanceOf(throwable, declaredType1);
        Throwables.propagateIfPossible(throwable, declaredType2);
    }

    @Deprecated
    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static RuntimeException propagate(Throwable throwable) {
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            if (throwable == slowPointer) {
                throw new IllegalArgumentException((String)"org.rascalmpl.Loop in causal chain detected.", throwable);
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            advanceSlowPointer = !advanceSlowPointer;
        }
        return throwable;
    }

    public static List<Throwable> getCausalChain(Throwable throwable) {
        Throwable cause;
        Preconditions.checkNotNull(throwable);
        ArrayList causes = new ArrayList(4);
        causes.add((org.rascalmpl.java.lang.Object)throwable);
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            causes.add((org.rascalmpl.java.lang.Object)throwable);
            if (throwable == slowPointer) {
                throw new IllegalArgumentException((String)"org.rascalmpl.Loop in causal chain detected.", throwable);
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            advanceSlowPointer = !advanceSlowPointer;
        }
        return Collections.unmodifiableList((List)causes);
    }

    @CheckForNull
    @GwtIncompatible
    public static <X extends Throwable> X getCauseAs(Throwable throwable, Class<X> expectedCauseType) {
        try {
            return (X)((Object)((Throwable)expectedCauseType.cast((org.rascalmpl.java.lang.Object)throwable.getCause())));
        }
        catch (ClassCastException e) {
            e.initCause(throwable);
            throw e;
        }
    }

    @GwtIncompatible
    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter));
        return stringWriter.toString();
    }

    @Deprecated
    @J2ktIncompatible
    @GwtIncompatible
    public static List<StackTraceElement> lazyStackTrace(Throwable throwable) {
        return Throwables.lazyStackTraceIsLazy() ? Throwables.jlaStackTrace(throwable) : Collections.unmodifiableList((List)Arrays.asList((org.rascalmpl.java.lang.Object[])throwable.getStackTrace()));
    }

    @Deprecated
    @J2ktIncompatible
    @GwtIncompatible
    public static boolean lazyStackTraceIsLazy() {
        return getStackTraceElementMethod != null && getStackTraceDepthMethod != null;
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static List<StackTraceElement> jlaStackTrace(final Throwable t2) {
        Preconditions.checkNotNull(t2);
        return new AbstractList<StackTraceElement>(){

            public StackTraceElement get(int n) {
                return (StackTraceElement)Throwables.invokeAccessibleNonThrowingMethod((Method)Objects.requireNonNull((org.rascalmpl.java.lang.Object)getStackTraceElementMethod), Objects.requireNonNull((org.rascalmpl.java.lang.Object)jla), new org.rascalmpl.java.lang.Object[]{t2, Integer.valueOf((int)n)});
            }

            public int size() {
                return ((Integer)Throwables.invokeAccessibleNonThrowingMethod((Method)Objects.requireNonNull((org.rascalmpl.java.lang.Object)getStackTraceDepthMethod), Objects.requireNonNull((org.rascalmpl.java.lang.Object)jla), new org.rascalmpl.java.lang.Object[]{t2})).intValue();
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static org.rascalmpl.java.lang.Object invokeAccessibleNonThrowingMethod(Method method, org.rascalmpl.java.lang.Object receiver, org.rascalmpl.java.lang.Object ... params) {
        try {
            return method.invoke(receiver, params);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    @CheckForNull
    @J2ktIncompatible
    @GwtIncompatible
    private static org.rascalmpl.java.lang.Object getJLA() {
        try {
            Class sharedSecrets = Class.forName((String)"org.rascalmpl.sun.misc.SharedSecrets", (boolean)false, null);
            Method langAccess = sharedSecrets.getMethod((String)"org.rascalmpl.getJavaLangAccess", new Class[0]);
            return langAccess.invoke(null, new org.rascalmpl.java.lang.Object[0]);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable t2) {
            return null;
        }
    }

    @CheckForNull
    @J2ktIncompatible
    @GwtIncompatible
    private static Method getGetMethod() {
        return Throwables.getJlaMethod((String)"org.rascalmpl.getStackTraceElement", new Class[]{Throwable.class, Integer.TYPE});
    }

    @CheckForNull
    @J2ktIncompatible
    @GwtIncompatible
    private static Method getSizeMethod(org.rascalmpl.java.lang.Object jla) {
        try {
            Method getStackTraceDepth = Throwables.getJlaMethod((String)"org.rascalmpl.getStackTraceDepth", new Class[]{Throwable.class});
            if (getStackTraceDepth == null) {
                return null;
            }
            getStackTraceDepth.invoke(jla, new org.rascalmpl.java.lang.Object[]{new Throwable()});
            return getStackTraceDepth;
        }
        catch (IllegalAccessException | UnsupportedOperationException | InvocationTargetException e) {
            return null;
        }
    }

    @CheckForNull
    @J2ktIncompatible
    @GwtIncompatible
    private static Method getJlaMethod(String name, Class<?> ... parameterTypes) throws ThreadDeath {
        try {
            return Class.forName((String)"org.rascalmpl.sun.misc.JavaLangAccess", (boolean)false, null).getMethod(name, parameterTypes);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable t2) {
            return null;
        }
    }
}

