/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.cache;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.cache.AbstractCache;
import org.rascalmpl.com.google.common.cache.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.cache.LoadingCache;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.util.concurrent.UncheckedExecutionException;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.LinkedHashMap;
import org.rascalmpl.java.util.concurrent.ExecutionException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractLoadingCache<K extends Object, V extends Object>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    @CanIgnoreReturnValue
    public V getUnchecked(K key) {
        try {
            return (V)this.get((Object)key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object key : keys) {
            if (result.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

