/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.cache;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.cache.CacheStats;
import org.rascalmpl.com.google.common.cache.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.CompatibleWith;
import org.rascalmpl.com.google.errorprone.annotations.DoNotMock;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.java.util.concurrent.ConcurrentMap;
import org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.javax.annotation.CheckForNull;

@DoNotMock(value="org.rascalmpl.Use CacheBuilder.newBuilder().build()")
@ElementTypesAreNonnullByDefault
@GwtCompatible
public interface Cache<K extends Object, V extends Object> {
    @CheckForNull
    @CanIgnoreReturnValue
    public V getIfPresent(@CompatibleWith(value="org.rascalmpl.K") Object var1);

    @CanIgnoreReturnValue
    public V get(K var1, Callable<? extends V> var2) throws ExecutionException;

    public ImmutableMap<K, V> getAllPresent(Iterable<? extends Object> var1);

    public void put(K var1, V var2);

    public void putAll(Map<? extends K, ? extends V> var1);

    public void invalidate(@CompatibleWith(value="org.rascalmpl.K") Object var1);

    public void invalidateAll(Iterable<? extends Object> var1);

    public void invalidateAll();

    public long size();

    public CacheStats stats();

    public ConcurrentMap<K, V> asMap();

    public void cleanUp();
}

