/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.cache;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.MoreObjects;
import org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Splitter;
import org.rascalmpl.com.google.common.base.Strings;
import org.rascalmpl.com.google.common.cache.CacheBuilder;
import org.rascalmpl.com.google.common.cache.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.cache.LocalCache;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.NumberFormatException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.Locale;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class CacheBuilderSpec
extends org.rascalmpl.java.lang.Object {
    private static final Splitter KEYS_SPLITTER = Splitter.on(',').trimResults();
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    private static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder().put("org.rascalmpl.initialCapacity", new InitialCapacityParser()).put("org.rascalmpl.maximumSize", (InitialCapacityParser)((Object)new MaximumSizeParser())).put("org.rascalmpl.maximumWeight", (InitialCapacityParser)((Object)new MaximumWeightParser())).put("org.rascalmpl.concurrencyLevel", (InitialCapacityParser)((Object)new ConcurrencyLevelParser())).put("org.rascalmpl.weakKeys", (InitialCapacityParser)((Object)new KeyStrengthParser(LocalCache.Strength.WEAK))).put("org.rascalmpl.softValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.SOFT))).put("org.rascalmpl.weakValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.WEAK))).put("org.rascalmpl.recordStats", (InitialCapacityParser)((Object)new RecordStatsParser())).put("org.rascalmpl.expireAfterAccess", (InitialCapacityParser)((Object)new AccessDurationParser())).put("org.rascalmpl.expireAfterWrite", (InitialCapacityParser)((Object)new WriteDurationParser())).put("org.rascalmpl.refreshAfterWrite", (InitialCapacityParser)((Object)new RefreshDurationParser())).put("org.rascalmpl.refreshInterval", (InitialCapacityParser)((Object)new RefreshDurationParser())).buildOrThrow();
    @CheckForNull
    @VisibleForTesting
    Integer initialCapacity;
    @CheckForNull
    @VisibleForTesting
    Long maximumSize;
    @CheckForNull
    @VisibleForTesting
    Long maximumWeight;
    @CheckForNull
    @VisibleForTesting
    Integer concurrencyLevel;
    @CheckForNull
    @VisibleForTesting
    LocalCache.Strength keyStrength;
    @CheckForNull
    @VisibleForTesting
    LocalCache.Strength valueStrength;
    @CheckForNull
    @VisibleForTesting
    Boolean recordStats;
    @VisibleForTesting
    long writeExpirationDuration;
    @CheckForNull
    @VisibleForTesting
    TimeUnit writeExpirationTimeUnit;
    @VisibleForTesting
    long accessExpirationDuration;
    @CheckForNull
    @VisibleForTesting
    TimeUnit accessExpirationTimeUnit;
    @VisibleForTesting
    long refreshDuration;
    @CheckForNull
    @VisibleForTesting
    TimeUnit refreshTimeUnit;
    private final String specification;

    private CacheBuilderSpec(String specification) {
        this.specification = specification;
    }

    public static CacheBuilderSpec parse(String cacheBuilderSpecification) {
        CacheBuilderSpec spec = new CacheBuilderSpec(cacheBuilderSpecification);
        if (!cacheBuilderSpecification.isEmpty()) {
            for (String keyValuePair : KEYS_SPLITTER.split((CharSequence)cacheBuilderSpecification)) {
                ImmutableList<String> keyAndValue = ImmutableList.copyOf(KEY_VALUE_SPLITTER.split((CharSequence)keyValuePair));
                Preconditions.checkArgument(!keyAndValue.isEmpty(), (org.rascalmpl.java.lang.Object)"org.rascalmpl.blank key-value pair");
                Preconditions.checkArgument(keyAndValue.size() <= 2, (String)"org.rascalmpl.key-value pair %s with more than one equals sign", (org.rascalmpl.java.lang.Object)keyValuePair);
                String key = (String)keyAndValue.get(0);
                ValueParser valueParser = VALUE_PARSERS.get((org.rascalmpl.java.lang.Object)key);
                Preconditions.checkArgument(valueParser != null, (String)"org.rascalmpl.unknown key %s", (org.rascalmpl.java.lang.Object)key);
                String value = keyAndValue.size() == 1 ? null : (String)keyAndValue.get(1);
                valueParser.parse(spec, key, value);
            }
        }
        return spec;
    }

    public static CacheBuilderSpec disableCaching() {
        return CacheBuilderSpec.parse((String)"org.rascalmpl.maximumSize=0");
    }

    CacheBuilder<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object> toCacheBuilder() {
        CacheBuilder<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object> builder = CacheBuilder.newBuilder();
        if (this.initialCapacity != null) {
            builder.initialCapacity(this.initialCapacity.intValue());
        }
        if (this.maximumSize != null) {
            builder.maximumSize(this.maximumSize.longValue());
        }
        if (this.maximumWeight != null) {
            builder.maximumWeight(this.maximumWeight.longValue());
        }
        if (this.concurrencyLevel != null) {
            builder.concurrencyLevel(this.concurrencyLevel.intValue());
        }
        if (this.keyStrength != null) {
            switch (this.keyStrength) {
                case WEAK: {
                    builder.weakKeys();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.valueStrength != null) {
            switch (this.valueStrength) {
                case SOFT: {
                    builder.softValues();
                    break;
                }
                case WEAK: {
                    builder.weakValues();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.recordStats != null && this.recordStats.booleanValue()) {
            builder.recordStats();
        }
        if (this.writeExpirationTimeUnit != null) {
            builder.expireAfterWrite(this.writeExpirationDuration, this.writeExpirationTimeUnit);
        }
        if (this.accessExpirationTimeUnit != null) {
            builder.expireAfterAccess(this.accessExpirationDuration, this.accessExpirationTimeUnit);
        }
        if (this.refreshTimeUnit != null) {
            builder.refreshAfterWrite(this.refreshDuration, this.refreshTimeUnit);
        }
        return builder;
    }

    public String toParsableString() {
        return this.specification;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue((org.rascalmpl.java.lang.Object)this.toParsableString()).toString();
    }

    public int hashCode() {
        return Objects.hashCode(new org.rascalmpl.java.lang.Object[]{this.initialCapacity, this.maximumSize, this.maximumWeight, this.concurrencyLevel, this.keyStrength, this.valueStrength, this.recordStats, CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit)});
    }

    public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheBuilderSpec)) {
            return false;
        }
        CacheBuilderSpec that = (CacheBuilderSpec)obj;
        return Objects.equal((org.rascalmpl.java.lang.Object)this.initialCapacity, (org.rascalmpl.java.lang.Object)that.initialCapacity) && Objects.equal((org.rascalmpl.java.lang.Object)this.maximumSize, (org.rascalmpl.java.lang.Object)that.maximumSize) && Objects.equal((org.rascalmpl.java.lang.Object)this.maximumWeight, (org.rascalmpl.java.lang.Object)that.maximumWeight) && Objects.equal((org.rascalmpl.java.lang.Object)this.concurrencyLevel, (org.rascalmpl.java.lang.Object)that.concurrencyLevel) && Objects.equal((org.rascalmpl.java.lang.Object)this.keyStrength, (org.rascalmpl.java.lang.Object)that.keyStrength) && Objects.equal((org.rascalmpl.java.lang.Object)this.valueStrength, (org.rascalmpl.java.lang.Object)that.valueStrength) && Objects.equal((org.rascalmpl.java.lang.Object)this.recordStats, (org.rascalmpl.java.lang.Object)that.recordStats) && Objects.equal((org.rascalmpl.java.lang.Object)CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), (org.rascalmpl.java.lang.Object)CacheBuilderSpec.durationInNanos(that.writeExpirationDuration, that.writeExpirationTimeUnit)) && Objects.equal((org.rascalmpl.java.lang.Object)CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), (org.rascalmpl.java.lang.Object)CacheBuilderSpec.durationInNanos(that.accessExpirationDuration, that.accessExpirationTimeUnit)) && Objects.equal((org.rascalmpl.java.lang.Object)CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit), (org.rascalmpl.java.lang.Object)CacheBuilderSpec.durationInNanos(that.refreshDuration, that.refreshTimeUnit));
    }

    @CheckForNull
    private static Long durationInNanos(long duration, @CheckForNull TimeUnit unit) {
        return unit == null ? null : Long.valueOf((long)unit.toNanos(duration));
    }

    private static String format(String format, org.rascalmpl.java.lang.Object ... args) {
        return String.format((Locale)Locale.ROOT, (String)format, (org.rascalmpl.java.lang.Object[])args);
    }

    static class RefreshDurationParser
    extends DurationParser {
        RefreshDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            Preconditions.checkArgument(spec.refreshTimeUnit == null, (org.rascalmpl.java.lang.Object)"org.rascalmpl.refreshAfterWrite already set");
            spec.refreshDuration = duration;
            spec.refreshTimeUnit = unit;
        }
    }

    static class WriteDurationParser
    extends DurationParser {
        WriteDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            Preconditions.checkArgument(spec.writeExpirationTimeUnit == null, (org.rascalmpl.java.lang.Object)"org.rascalmpl.expireAfterWrite already set");
            spec.writeExpirationDuration = duration;
            spec.writeExpirationTimeUnit = unit;
        }
    }

    static class AccessDurationParser
    extends DurationParser {
        AccessDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            Preconditions.checkArgument(spec.accessExpirationTimeUnit == null, (org.rascalmpl.java.lang.Object)"org.rascalmpl.expireAfterAccess already set");
            spec.accessExpirationDuration = duration;
            spec.accessExpirationTimeUnit = unit;
        }
    }

    static abstract class DurationParser
    extends org.rascalmpl.java.lang.Object
    implements ValueParser {
        DurationParser() {
        }

        protected abstract void parseDuration(CacheBuilderSpec var1, long var2, TimeUnit var4);

        @Override
        public void parse(CacheBuilderSpec spec, String key, @CheckForNull String value) {
            if (Strings.isNullOrEmpty(value)) {
                throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.value of key ").append(key).append((String)"org.rascalmpl. omitted").toString());
            }
            try {
                TimeUnit timeUnit;
                char lastChar = value.charAt(value.length() - 1);
                switch (lastChar) {
                    case 'd': {
                        timeUnit = TimeUnit.DAYS;
                        break;
                    }
                    case 'h': {
                        timeUnit = TimeUnit.HOURS;
                        break;
                    }
                    case 'm': {
                        timeUnit = TimeUnit.MINUTES;
                        break;
                    }
                    case 's': {
                        timeUnit = TimeUnit.SECONDS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(CacheBuilderSpec.format((String)"org.rascalmpl.key %s invalid unit: was %s, must end with one of [dhms]", new org.rascalmpl.java.lang.Object[]{key, value}));
                    }
                }
                long duration = Long.parseLong((String)value.substring(0, value.length() - 1));
                this.parseDuration(spec, duration, timeUnit);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(CacheBuilderSpec.format((String)"org.rascalmpl.key %s value set to %s, must be integer", new org.rascalmpl.java.lang.Object[]{key, value}));
            }
        }
    }

    static class RecordStatsParser
    extends org.rascalmpl.java.lang.Object
    implements ValueParser {
        RecordStatsParser() {
        }

        @Override
        public void parse(CacheBuilderSpec spec, String key, @CheckForNull String value) {
            Preconditions.checkArgument(value == null, (org.rascalmpl.java.lang.Object)"org.rascalmpl.recordStats does not take values");
            Preconditions.checkArgument(spec.recordStats == null, (org.rascalmpl.java.lang.Object)"org.rascalmpl.recordStats already set");
            spec.recordStats = Boolean.valueOf((boolean)true);
        }
    }

    static class ValueStrengthParser
    extends org.rascalmpl.java.lang.Object
    implements ValueParser {
        private final LocalCache.Strength strength;

        public ValueStrengthParser(LocalCache.Strength strength) {
            this.strength = strength;
        }

        @Override
        public void parse(CacheBuilderSpec spec, String key, @CheckForNull String value) {
            Preconditions.checkArgument(value == null, (String)"org.rascalmpl.key %s does not take values", (org.rascalmpl.java.lang.Object)key);
            Preconditions.checkArgument(spec.valueStrength == null, (String)"org.rascalmpl.%s was already set to %s", (org.rascalmpl.java.lang.Object)key, (org.rascalmpl.java.lang.Object)spec.valueStrength);
            spec.valueStrength = this.strength;
        }
    }

    static class KeyStrengthParser
    extends org.rascalmpl.java.lang.Object
    implements ValueParser {
        private final LocalCache.Strength strength;

        public KeyStrengthParser(LocalCache.Strength strength) {
            this.strength = strength;
        }

        @Override
        public void parse(CacheBuilderSpec spec, String key, @CheckForNull String value) {
            Preconditions.checkArgument(value == null, (String)"org.rascalmpl.key %s does not take values", (org.rascalmpl.java.lang.Object)key);
            Preconditions.checkArgument(spec.keyStrength == null, (String)"org.rascalmpl.%s was already set to %s", (org.rascalmpl.java.lang.Object)key, (org.rascalmpl.java.lang.Object)spec.keyStrength);
            spec.keyStrength = this.strength;
        }
    }

    static class ConcurrencyLevelParser
    extends IntegerParser {
        ConcurrencyLevelParser() {
        }

        @Override
        protected void parseInteger(CacheBuilderSpec spec, int value) {
            Preconditions.checkArgument(spec.concurrencyLevel == null, (String)"org.rascalmpl.concurrency level was already set to %s", (org.rascalmpl.java.lang.Object)spec.concurrencyLevel);
            spec.concurrencyLevel = Integer.valueOf((int)value);
        }
    }

    static class MaximumWeightParser
    extends LongParser {
        MaximumWeightParser() {
        }

        @Override
        protected void parseLong(CacheBuilderSpec spec, long value) {
            Preconditions.checkArgument(spec.maximumWeight == null, (String)"org.rascalmpl.maximum weight was already set to %s", (org.rascalmpl.java.lang.Object)spec.maximumWeight);
            Preconditions.checkArgument(spec.maximumSize == null, (String)"org.rascalmpl.maximum size was already set to %s", (org.rascalmpl.java.lang.Object)spec.maximumSize);
            spec.maximumWeight = Long.valueOf((long)value);
        }
    }

    static class MaximumSizeParser
    extends LongParser {
        MaximumSizeParser() {
        }

        @Override
        protected void parseLong(CacheBuilderSpec spec, long value) {
            Preconditions.checkArgument(spec.maximumSize == null, (String)"org.rascalmpl.maximum size was already set to %s", (org.rascalmpl.java.lang.Object)spec.maximumSize);
            Preconditions.checkArgument(spec.maximumWeight == null, (String)"org.rascalmpl.maximum weight was already set to %s", (org.rascalmpl.java.lang.Object)spec.maximumWeight);
            spec.maximumSize = Long.valueOf((long)value);
        }
    }

    static class InitialCapacityParser
    extends IntegerParser {
        InitialCapacityParser() {
        }

        @Override
        protected void parseInteger(CacheBuilderSpec spec, int value) {
            Preconditions.checkArgument(spec.initialCapacity == null, (String)"org.rascalmpl.initial capacity was already set to %s", (org.rascalmpl.java.lang.Object)spec.initialCapacity);
            spec.initialCapacity = Integer.valueOf((int)value);
        }
    }

    static abstract class LongParser
    extends org.rascalmpl.java.lang.Object
    implements ValueParser {
        LongParser() {
        }

        protected abstract void parseLong(CacheBuilderSpec var1, long var2);

        @Override
        public void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            if (Strings.isNullOrEmpty(value)) {
                throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.value of key ").append(key).append((String)"org.rascalmpl. omitted").toString());
            }
            try {
                this.parseLong(spec, Long.parseLong((String)value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(CacheBuilderSpec.format((String)"org.rascalmpl.key %s value set to %s, must be integer", new org.rascalmpl.java.lang.Object[]{key, value}), (Throwable)((Object)e));
            }
        }
    }

    static abstract class IntegerParser
    extends org.rascalmpl.java.lang.Object
    implements ValueParser {
        IntegerParser() {
        }

        protected abstract void parseInteger(CacheBuilderSpec var1, int var2);

        @Override
        public void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            if (Strings.isNullOrEmpty(value)) {
                throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.value of key ").append(key).append((String)"org.rascalmpl. omitted").toString());
            }
            try {
                this.parseInteger(spec, Integer.parseInt((String)value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(CacheBuilderSpec.format((String)"org.rascalmpl.key %s value set to %s, must be integer", new org.rascalmpl.java.lang.Object[]{key, value}), (Throwable)((Object)e));
            }
        }
    }

    private static interface ValueParser {
        public void parse(CacheBuilderSpec var1, String var2, @CheckForNull String var3);
    }
}

