/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.NavigableMap;
import org.rascalmpl.java.util.NavigableSet;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.SortedMap;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
abstract class AbstractNavigableMap<K extends @Nullable Object, V extends @Nullable Object>
extends Maps.IteratorBasedAbstractMap<K, V>
implements NavigableMap<K, V> {
    AbstractNavigableMap() {
    }

    @CheckForNull
    public abstract V get(@CheckForNull Object var1);

    @CheckForNull
    public Map.Entry<K, V> firstEntry() {
        return Iterators.getNext(this.entryIterator(), null);
    }

    @CheckForNull
    public Map.Entry<K, V> lastEntry() {
        return Iterators.getNext(this.descendingEntryIterator(), null);
    }

    @CheckForNull
    public Map.Entry<K, V> pollFirstEntry() {
        return Iterators.pollNext(this.entryIterator());
    }

    @CheckForNull
    public Map.Entry<K, V> pollLastEntry() {
        return Iterators.pollNext(this.descendingEntryIterator());
    }

    @ParametricNullness
    public K firstKey() {
        Map.Entry<K, V> entry = this.firstEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return (K)entry.getKey();
    }

    @ParametricNullness
    public K lastKey() {
        Map.Entry<K, V> entry = this.lastEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return (K)entry.getKey();
    }

    @CheckForNull
    public Map.Entry<K, V> lowerEntry(@ParametricNullness K key) {
        return this.headMap((Object)key, false).lastEntry();
    }

    @CheckForNull
    public Map.Entry<K, V> floorEntry(@ParametricNullness K key) {
        return this.headMap((Object)key, true).lastEntry();
    }

    @CheckForNull
    public Map.Entry<K, V> ceilingEntry(@ParametricNullness K key) {
        return this.tailMap((Object)key, true).firstEntry();
    }

    @CheckForNull
    public Map.Entry<K, V> higherEntry(@ParametricNullness K key) {
        return this.tailMap((Object)key, false).firstEntry();
    }

    @CheckForNull
    public K lowerKey(@ParametricNullness K key) {
        return Maps.keyOrNull(this.lowerEntry(key));
    }

    @CheckForNull
    public K floorKey(@ParametricNullness K key) {
        return Maps.keyOrNull(this.floorEntry(key));
    }

    @CheckForNull
    public K ceilingKey(@ParametricNullness K key) {
        return Maps.keyOrNull(this.ceilingEntry(key));
    }

    @CheckForNull
    public K higherKey(@ParametricNullness K key) {
        return Maps.keyOrNull(this.higherEntry(key));
    }

    abstract Iterator<Map.Entry<K, V>> descendingEntryIterator();

    public SortedMap<K, V> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    public SortedMap<K, V> headMap(@ParametricNullness K toKey) {
        return this.headMap((Object)toKey, false);
    }

    public SortedMap<K, V> tailMap(@ParametricNullness K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    public NavigableSet<K> navigableKeySet() {
        return new Maps.NavigableKeySet(this);
    }

    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    public NavigableMap<K, V> descendingMap() {
        return new DescendingMap();
    }

    private final class DescendingMap
    extends Maps.DescendingMap<K, V> {
        private DescendingMap() {
        }

        @Override
        NavigableMap<K, V> forward() {
            return AbstractNavigableMap.this;
        }

        @Override
        Iterator<Map.Entry<K, V>> entryIterator() {
            return AbstractNavigableMap.this.descendingEntryIterator();
        }
    }
}

