/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.collect.ArrayListMultimapGwtSerializationDependencies;
import org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.Multimap;
import org.rascalmpl.com.google.common.collect.Platform;
import org.rascalmpl.com.google.common.collect.Serialization;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.java.io.ObjectOutputStream;
import org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.List;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class ArrayListMultimap<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
extends ArrayListMultimapGwtSerializationDependencies<K, V> {
    private static final int DEFAULT_VALUES_PER_KEY = 3;
    @VisibleForTesting
    transient int expectedValuesPerKey;
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ArrayListMultimap<K, V> create() {
        return new ArrayListMultimap<K, V>();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ArrayListMultimap<K, V> create(int expectedKeys, int expectedValuesPerKey) {
        return new ArrayListMultimap<K, V>(expectedKeys, expectedValuesPerKey);
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ArrayListMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        return new ArrayListMultimap<K, V>(multimap);
    }

    private ArrayListMultimap() {
        this(12, 3);
    }

    private ArrayListMultimap(int expectedKeys, int expectedValuesPerKey) {
        super(Platform.newHashMapWithExpectedSize(expectedKeys));
        CollectPreconditions.checkNonnegative(expectedValuesPerKey, (String)"org.rascalmpl.expectedValuesPerKey");
        this.expectedValuesPerKey = expectedValuesPerKey;
    }

    private ArrayListMultimap(Multimap<? extends K, ? extends V> multimap) {
        this(multimap.keySet().size(), multimap instanceof ArrayListMultimap ? ((ArrayListMultimap)multimap).expectedValuesPerKey : 3);
        this.putAll((Multimap)multimap);
    }

    @Override
    List<V> createCollection() {
        return new ArrayList(this.expectedValuesPerKey);
    }

    @Deprecated
    public void trimToSize() {
        for (Collection collection : this.backingMap().values()) {
            ArrayList arrayList = (ArrayList)collection;
            arrayList.trimToSize();
        }
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultimap(this, stream);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.expectedValuesPerKey = 3;
        int distinctKeys = Serialization.readCount(stream);
        HashMap map = Maps.newHashMap();
        this.setMap(map);
        Serialization.populateMultimap(this, stream, distinctKeys);
    }
}

