/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.NullPointerException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class CollectPreconditions
extends Object {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException(new StringBuilder().append((String)"org.rascalmpl.null key in entry: null=").append(value).toString());
        }
        if (value == null) {
            throw new NullPointerException(new StringBuilder().append((String)"org.rascalmpl.null value in entry: ").append(key).append((String)"org.rascalmpl.=null").toString());
        }
    }

    @CanIgnoreReturnValue
    static int checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(new StringBuilder().append(name).append((String)"org.rascalmpl. cannot be negative but was: ").append(value).toString());
        }
        return value;
    }

    @CanIgnoreReturnValue
    static long checkNonnegative(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(new StringBuilder().append(name).append((String)"org.rascalmpl. cannot be negative but was: ").append(value).toString());
        }
        return value;
    }

    static void checkPositive(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException(new StringBuilder().append(name).append((String)"org.rascalmpl. must be positive but was: ").append(value).toString());
        }
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, (Object)"org.rascalmpl.no calls to next() since the last call to remove()");
    }
}

