/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.collect.CompactHashSet;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ObjectArrays;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.SafeVarargs;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.java.util.Spliterators;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class CompactLinkedHashSet<E extends @Nullable Object>
extends CompactHashSet<E> {
    private static final int ENDPOINT = -2;
    @CheckForNull
    private transient int[] predecessor;
    @CheckForNull
    private transient int[] successor;
    private transient int firstEntry;
    private transient int lastEntry;

    public static <E extends Object> CompactLinkedHashSet<E> create() {
        return new CompactLinkedHashSet<E>();
    }

    public static <E extends Object> CompactLinkedHashSet<E> create(Collection<? extends E> collection) {
        CompactLinkedHashSet<E> set = CompactLinkedHashSet.createWithExpectedSize(collection.size());
        set.addAll(collection);
        return set;
    }

    @SafeVarargs
    public static <E extends Object> CompactLinkedHashSet<E> create(E ... elements) {
        CompactLinkedHashSet<E> set = CompactLinkedHashSet.createWithExpectedSize(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E extends Object> CompactLinkedHashSet<E> createWithExpectedSize(int expectedSize) {
        return new CompactLinkedHashSet<E>(expectedSize);
    }

    CompactLinkedHashSet() {
    }

    CompactLinkedHashSet(int expectedSize) {
        super(expectedSize);
    }

    @Override
    void init(int expectedSize) {
        super.init(expectedSize);
        this.firstEntry = -2;
        this.lastEntry = -2;
    }

    @Override
    int allocArrays() {
        int expectedSize = super.allocArrays();
        this.predecessor = new int[expectedSize];
        this.successor = new int[expectedSize];
        return expectedSize;
    }

    @Override
    @CanIgnoreReturnValue
    Set<E> convertToHashFloodingResistantImplementation() {
        Set result = super.convertToHashFloodingResistantImplementation();
        this.predecessor = null;
        this.successor = null;
        return result;
    }

    private int getPredecessor(int entry) {
        return this.requirePredecessors()[entry] - 1;
    }

    @Override
    int getSuccessor(int entry) {
        return this.requireSuccessors()[entry] - 1;
    }

    private void setSuccessor(int entry, int succ) {
        this.requireSuccessors()[entry] = succ + 1;
    }

    private void setPredecessor(int entry, int pred) {
        this.requirePredecessors()[entry] = pred + 1;
    }

    private void setSucceeds(int pred, int succ) {
        if (pred == -2) {
            this.firstEntry = succ;
        } else {
            this.setSuccessor(pred, succ);
        }
        if (succ == -2) {
            this.lastEntry = pred;
        } else {
            this.setPredecessor(succ, pred);
        }
    }

    @Override
    void insertEntry(int entryIndex, @ParametricNullness E object, int hash, int mask) {
        super.insertEntry(entryIndex, object, hash, mask);
        this.setSucceeds(this.lastEntry, entryIndex);
        this.setSucceeds(entryIndex, -2);
    }

    @Override
    void moveLastEntry(int dstIndex, int mask) {
        int srcIndex = this.size() - 1;
        super.moveLastEntry(dstIndex, mask);
        this.setSucceeds(this.getPredecessor(dstIndex), this.getSuccessor(dstIndex));
        if (dstIndex < srcIndex) {
            this.setSucceeds(this.getPredecessor(srcIndex), dstIndex);
            this.setSucceeds(dstIndex, this.getSuccessor(srcIndex));
        }
        this.requirePredecessors()[srcIndex] = 0;
        this.requireSuccessors()[srcIndex] = 0;
    }

    @Override
    void resizeEntries(int newCapacity) {
        super.resizeEntries(newCapacity);
        this.predecessor = Arrays.copyOf((int[])this.requirePredecessors(), (int)newCapacity);
        this.successor = Arrays.copyOf((int[])this.requireSuccessors(), (int)newCapacity);
    }

    @Override
    int firstEntryIndex() {
        return this.firstEntry;
    }

    @Override
    int adjustAfterRemove(int indexBeforeRemove, int indexRemoved) {
        return indexBeforeRemove >= this.size() ? indexRemoved : indexBeforeRemove;
    }

    @Override
    public @Nullable Object[] toArray() {
        return ObjectArrays.toArrayImpl(this);
    }

    @Override
    public <T extends Object> T[] toArray(T[] a) {
        return ObjectArrays.toArrayImpl((Collection)this, a);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator((Collection)this, (int)17);
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.firstEntry = -2;
        this.lastEntry = -2;
        if (this.predecessor != null && this.successor != null) {
            Arrays.fill((int[])this.predecessor, (int)0, (int)this.size(), (int)0);
            Arrays.fill((int[])this.successor, (int)0, (int)this.size(), (int)0);
        }
        super.clear();
    }

    private int[] requirePredecessors() {
        return (int[])Objects.requireNonNull((Object)this.predecessor);
    }

    private int[] requireSuccessors() {
        return (int[])Objects.requireNonNull((Object)this.successor);
    }
}

