/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.primitives.Ints;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.math.BigInteger;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class DiscreteDomain<C extends Comparable>
extends org.rascalmpl.java.lang.Object {
    final boolean supportsFastOffset;

    public static DiscreteDomain<org.rascalmpl.java.lang.Integer> integers() {
        return IntegerDomain.INSTANCE;
    }

    public static DiscreteDomain<Long> longs() {
        return LongDomain.INSTANCE;
    }

    public static DiscreteDomain<BigInteger> bigIntegers() {
        return BigIntegerDomain.INSTANCE;
    }

    protected DiscreteDomain() {
        this(false);
    }

    private DiscreteDomain(boolean supportsFastOffset) {
        this.supportsFastOffset = supportsFastOffset;
    }

    C offset(C origin, long distance) {
        C current = origin;
        CollectPreconditions.checkNonnegative(distance, (String)"org.rascalmpl.distance");
        for (long i = 0L; i < distance; ++i) {
            if ((current = this.next(current)) != null) continue;
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.overflowed computing offset(").append(origin).append((String)"org.rascalmpl., ").append(distance).append((String)"org.rascalmpl.)").toString());
        }
        return current;
    }

    @CheckForNull
    public abstract C next(C var1);

    @CheckForNull
    public abstract C previous(C var1);

    public abstract long distance(C var1, C var2);

    @CanIgnoreReturnValue
    public C minValue() {
        throw new NoSuchElementException();
    }

    @CanIgnoreReturnValue
    public C maxValue() {
        throw new NoSuchElementException();
    }

    private static final class BigIntegerDomain
    extends DiscreteDomain<BigInteger>
    implements Serializable {
        private static final BigIntegerDomain INSTANCE = new BigIntegerDomain();
        private static final BigInteger MIN_LONG = BigInteger.valueOf((long)java.lang.Long.MIN_VALUE);
        private static final BigInteger MAX_LONG = BigInteger.valueOf((long)java.lang.Long.MAX_VALUE);
        private static final long serialVersionUID = 0L;

        BigIntegerDomain() {
            super(true);
        }

        @Override
        public BigInteger next(BigInteger value) {
            return value.add(BigInteger.ONE);
        }

        @Override
        public BigInteger previous(BigInteger value) {
            return value.subtract(BigInteger.ONE);
        }

        @Override
        BigInteger offset(BigInteger origin, long distance) {
            CollectPreconditions.checkNonnegative(distance, (String)"org.rascalmpl.distance");
            return origin.add(BigInteger.valueOf((long)distance));
        }

        @Override
        public long distance(BigInteger start, BigInteger end) {
            return end.subtract(start).max(MIN_LONG).min(MAX_LONG).longValue();
        }

        private org.rascalmpl.java.lang.Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "org.rascalmpl.DiscreteDomain.bigIntegers()";
        }
    }

    private static final class LongDomain
    extends DiscreteDomain<Long>
    implements Serializable {
        private static final LongDomain INSTANCE = new LongDomain();
        private static final long serialVersionUID = 0L;

        LongDomain() {
            super(true);
        }

        @Override
        @CheckForNull
        public Long next(Long value) {
            long l = value.longValue();
            return l == java.lang.Long.MAX_VALUE ? null : Long.valueOf((long)(l + 1L));
        }

        @Override
        @CheckForNull
        public Long previous(Long value) {
            long l = value.longValue();
            return l == java.lang.Long.MIN_VALUE ? null : Long.valueOf((long)(l - 1L));
        }

        @Override
        Long offset(Long origin, long distance) {
            CollectPreconditions.checkNonnegative(distance, (String)"org.rascalmpl.distance");
            long result = origin.longValue() + distance;
            if (result < 0L) {
                Preconditions.checkArgument(origin.longValue() < 0L, (org.rascalmpl.java.lang.Object)"org.rascalmpl.overflow");
            }
            return Long.valueOf((long)result);
        }

        @Override
        public long distance(Long start, Long end) {
            long result = end.longValue() - start.longValue();
            if (end.longValue() > start.longValue() && result < 0L) {
                return java.lang.Long.MAX_VALUE;
            }
            if (end.longValue() < start.longValue() && result > 0L) {
                return java.lang.Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public Long minValue() {
            return Long.valueOf((long)java.lang.Long.MIN_VALUE);
        }

        @Override
        public Long maxValue() {
            return Long.valueOf((long)java.lang.Long.MAX_VALUE);
        }

        private org.rascalmpl.java.lang.Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "org.rascalmpl.DiscreteDomain.longs()";
        }
    }

    private static final class IntegerDomain
    extends DiscreteDomain<org.rascalmpl.java.lang.Integer>
    implements Serializable {
        private static final IntegerDomain INSTANCE = new IntegerDomain();
        private static final long serialVersionUID = 0L;

        IntegerDomain() {
            super(true);
        }

        @Override
        @CheckForNull
        public org.rascalmpl.java.lang.Integer next(org.rascalmpl.java.lang.Integer value) {
            int i = value.intValue();
            return i == Integer.MAX_VALUE ? null : org.rascalmpl.java.lang.Integer.valueOf((int)(i + 1));
        }

        @Override
        @CheckForNull
        public org.rascalmpl.java.lang.Integer previous(org.rascalmpl.java.lang.Integer value) {
            int i = value.intValue();
            return i == Integer.MIN_VALUE ? null : org.rascalmpl.java.lang.Integer.valueOf((int)(i - 1));
        }

        @Override
        org.rascalmpl.java.lang.Integer offset(org.rascalmpl.java.lang.Integer origin, long distance) {
            CollectPreconditions.checkNonnegative(distance, (String)"org.rascalmpl.distance");
            return org.rascalmpl.java.lang.Integer.valueOf((int)Ints.checkedCast(origin.longValue() + distance));
        }

        @Override
        public long distance(org.rascalmpl.java.lang.Integer start, org.rascalmpl.java.lang.Integer end) {
            return (long)end.intValue() - (long)start.intValue();
        }

        @Override
        public org.rascalmpl.java.lang.Integer minValue() {
            return org.rascalmpl.java.lang.Integer.valueOf((int)Integer.MIN_VALUE);
        }

        @Override
        public org.rascalmpl.java.lang.Integer maxValue() {
            return org.rascalmpl.java.lang.Integer.valueOf((int)Integer.MAX_VALUE);
        }

        private org.rascalmpl.java.lang.Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "org.rascalmpl.DiscreteDomain.integers()";
        }
    }
}

