/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ForwardingQueue;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.Deque;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public abstract class ForwardingDeque<E extends @Nullable Object>
extends ForwardingQueue<E>
implements Deque<E> {
    protected ForwardingDeque() {
    }

    @Override
    protected abstract Deque<E> delegate();

    public void addFirst(@ParametricNullness E e) {
        this.delegate().addFirst(e);
    }

    public void addLast(@ParametricNullness E e) {
        this.delegate().addLast(e);
    }

    public Iterator<E> descendingIterator() {
        return this.delegate().descendingIterator();
    }

    @ParametricNullness
    public E getFirst() {
        return (E)this.delegate().getFirst();
    }

    @ParametricNullness
    public E getLast() {
        return (E)this.delegate().getLast();
    }

    @CanIgnoreReturnValue
    public boolean offerFirst(@ParametricNullness E e) {
        return this.delegate().offerFirst(e);
    }

    @CanIgnoreReturnValue
    public boolean offerLast(@ParametricNullness E e) {
        return this.delegate().offerLast(e);
    }

    @CheckForNull
    public E peekFirst() {
        return (E)this.delegate().peekFirst();
    }

    @CheckForNull
    public E peekLast() {
        return (E)this.delegate().peekLast();
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public E pollFirst() {
        return (E)this.delegate().pollFirst();
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public E pollLast() {
        return (E)this.delegate().pollLast();
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public E pop() {
        return (E)this.delegate().pop();
    }

    public void push(@ParametricNullness E e) {
        this.delegate().push(e);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public E removeFirst() {
        return (E)this.delegate().removeFirst();
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public E removeLast() {
        return (E)this.delegate().removeLast();
    }

    @CanIgnoreReturnValue
    public boolean removeFirstOccurrence(@CheckForNull Object o) {
        return this.delegate().removeFirstOccurrence(o);
    }

    @CanIgnoreReturnValue
    public boolean removeLastOccurrence(@CheckForNull Object o) {
        return this.delegate().removeLastOccurrence(o);
    }
}

