/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ForwardingCollection;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.java.util.Queue;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingQueue<E extends @Nullable Object>
extends ForwardingCollection<E>
implements Queue<E> {
    protected ForwardingQueue() {
    }

    @Override
    protected abstract Queue<E> delegate();

    @CanIgnoreReturnValue
    public boolean offer(@ParametricNullness E o) {
        return this.delegate().offer(o);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public E poll() {
        return (E)this.delegate().poll();
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public E remove() {
        return (E)this.delegate().remove();
    }

    @CheckForNull
    public E peek() {
        return (E)this.delegate().peek();
    }

    @ParametricNullness
    public E element() {
        return (E)this.delegate().element();
    }

    protected boolean standardOffer(@ParametricNullness E e) {
        try {
            return this.add(e);
        }
        catch (IllegalStateException caught) {
            return false;
        }
    }

    @CheckForNull
    protected E standardPeek() {
        try {
            return this.element();
        }
        catch (NoSuchElementException caught) {
            return null;
        }
    }

    @CheckForNull
    protected E standardPoll() {
        try {
            return this.remove();
        }
        catch (NoSuchElementException caught) {
            return null;
        }
    }
}

