/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ForwardingMap;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.java.lang.ClassCastException;
import org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.java.lang.NullPointerException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.java.util.SortedMap;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingSortedMap<K extends @Nullable Object, V extends @Nullable Object>
extends ForwardingMap<K, V>
implements SortedMap<K, V> {
    protected ForwardingSortedMap() {
    }

    @Override
    protected abstract SortedMap<K, V> delegate();

    @CheckForNull
    public Comparator<? super K> comparator() {
        return this.delegate().comparator();
    }

    @ParametricNullness
    public K firstKey() {
        return (K)this.delegate().firstKey();
    }

    public SortedMap<K, V> headMap(@ParametricNullness K toKey) {
        return this.delegate().headMap(toKey);
    }

    @ParametricNullness
    public K lastKey() {
        return (K)this.delegate().lastKey();
    }

    public SortedMap<K, V> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
        return this.delegate().subMap(fromKey, toKey);
    }

    public SortedMap<K, V> tailMap(@ParametricNullness K fromKey) {
        return this.delegate().tailMap(fromKey);
    }

    static int unsafeCompare(@CheckForNull Comparator<?> comparator, @CheckForNull Object o1, @CheckForNull Object o2) {
        if (comparator == null) {
            return ((Comparable)o1).compareTo(o2);
        }
        return comparator.compare(o1, o2);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected boolean standardContainsKey(@CheckForNull Object key) {
        try {
            @Nullable ForwardingSortedMap self = this;
            Object ceilingKey = self.tailMap(key).firstKey();
            return ForwardingSortedMap.unsafeCompare(this.comparator(), ceilingKey, key) == 0;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException e) {
            return false;
        }
    }

    protected SortedMap<K, V> standardSubMap(K fromKey, K toKey) {
        Preconditions.checkArgument(ForwardingSortedMap.unsafeCompare(this.comparator(), fromKey, toKey) <= 0, (Object)"org.rascalmpl.fromKey must be <= toKey");
        return this.tailMap(fromKey).headMap(toKey);
    }

    protected class StandardKeySet
    extends Maps.SortedKeySet<K, V> {
        public StandardKeySet() {
            super(ForwardingSortedMap.this);
        }
    }
}

