/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.collect.CollectCollectors;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.EmptyImmutableListMultimap;
import org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.com.google.common.collect.ImmutableMultimap;
import org.rascalmpl.com.google.common.collect.ListMultimap;
import org.rascalmpl.com.google.common.collect.Multimap;
import org.rascalmpl.com.google.common.collect.Serialization;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.DoNotCall;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.com.google.j2objc.annotations.RetainedWith;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.java.io.ObjectOutputStream;
import org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.function.Function;
import org.rascalmpl.java.util.stream.Collector;
import org.rascalmpl.java.util.stream.Stream;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public class ImmutableListMultimap<K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object>
extends ImmutableMultimap<K, V>
implements ListMultimap<K, V> {
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableListMultimap<V, K> inverse;
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    public static <T extends org.rascalmpl.java.lang.Object, K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Collector<T, ?, ImmutableListMultimap<K, V>> toImmutableListMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return CollectCollectors.toImmutableListMultimap(keyFunction, valueFunction);
    }

    public static <T extends org.rascalmpl.java.lang.Object, K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Collector<T, ?, ImmutableListMultimap<K, V>> flatteningToImmutableListMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends Stream<? extends V>> valuesFunction) {
        return CollectCollectors.flatteningToImmutableListMultimap(keyFunction, valuesFunction);
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableListMultimap<K, V> of() {
        return EmptyImmutableListMultimap.INSTANCE;
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableListMultimap<K, V> of(K k1, V v1) {
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put(k1, v1);
        return builder.build();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableListMultimap<K, V> of(K k1, V v1, K k2, V v2) {
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put(k1, v1);
        builder.put(k2, v2);
        return builder.build();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableListMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put(k1, v1);
        builder.put(k2, v2);
        builder.put(k3, v3);
        return builder.build();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableListMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put(k1, v1);
        builder.put(k2, v2);
        builder.put(k3, v3);
        builder.put(k4, v4);
        return builder.build();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableListMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put(k1, v1);
        builder.put(k2, v2);
        builder.put(k3, v3);
        builder.put(k4, v4);
        builder.put(k5, v5);
        return builder.build();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableListMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap) {
        ImmutableListMultimap kvMultimap;
        if (multimap.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        if (multimap instanceof ImmutableListMultimap && !(kvMultimap = (ImmutableListMultimap)multimap).isPartialView()) {
            return kvMultimap;
        }
        return ImmutableListMultimap.fromMapEntries(multimap.asMap().entrySet(), null);
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableListMultimap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        return ((Builder)new Builder().putAll((Iterable)entries)).build();
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableListMultimap<K, V> fromMapEntries(Collection<? extends Map.Entry<? extends K, ? extends Collection<? extends V>>> mapEntries, @CheckForNull Comparator<? super V> valueComparator) {
        if (mapEntries.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder(mapEntries.size());
        int size = 0;
        for (Map.Entry entry : mapEntries) {
            org.rascalmpl.java.lang.Object key = entry.getKey();
            Collection values = (Collection)entry.getValue();
            ImmutableList<Object> list = valueComparator == null ? ImmutableList.copyOf(values) : ImmutableList.sortedCopyOf(valueComparator, values);
            if (list.isEmpty()) continue;
            builder.put(key, list);
            size += list.size();
        }
        return new ImmutableListMultimap(builder.buildOrThrow(), size);
    }

    ImmutableListMultimap(ImmutableMap<K, ImmutableList<V>> map, int size) {
        super(map, size);
    }

    @Override
    public ImmutableList<V> get(K key) {
        ImmutableList list = (ImmutableList)((Object)this.map.get((org.rascalmpl.java.lang.Object)key));
        return list == null ? ImmutableList.of() : list;
    }

    @Override
    public ImmutableListMultimap<V, K> inverse() {
        ImmutableListMultimap<K, V> result = this.inverse;
        return result == null ? (this.inverse = this.invert()) : result;
    }

    private ImmutableListMultimap<V, K> invert() {
        Builder<K, V> builder = ImmutableListMultimap.builder();
        Iterator iterator = this.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            builder.put(entry.getValue(), entry.getKey());
        }
        ImmutableMultimap invertedMultimap = builder.build();
        ((ImmutableListMultimap)invertedMultimap).inverse = this;
        return invertedMultimap;
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final ImmutableList<V> removeAll(@CheckForNull org.rascalmpl.java.lang.Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final ImmutableList<V> replaceValues(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultimap(this, stream);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ImmutableMap tmpMap;
        stream.defaultReadObject();
        int keyCount = stream.readInt();
        if (keyCount < 0) {
            throw new InvalidObjectException(new StringBuilder().append((String)"org.rascalmpl.Invalid key count ").append(keyCount).toString());
        }
        ImmutableMap.Builder<org.rascalmpl.java.lang.Object, ImmutableCollection> builder = ImmutableMap.builder();
        int tmpSize = 0;
        for (int i = 0; i < keyCount; ++i) {
            org.rascalmpl.java.lang.Object key = Objects.requireNonNull((org.rascalmpl.java.lang.Object)stream.readObject());
            int valueCount = stream.readInt();
            if (valueCount <= 0) {
                throw new InvalidObjectException(new StringBuilder().append((String)"org.rascalmpl.Invalid value count ").append(valueCount).toString());
            }
            ImmutableList.Builder valuesBuilder = ImmutableList.builder();
            for (int j = 0; j < valueCount; ++j) {
                valuesBuilder.add(Objects.requireNonNull((org.rascalmpl.java.lang.Object)stream.readObject()));
            }
            builder.put(key, valuesBuilder.build());
            tmpSize += valueCount;
        }
        try {
            tmpMap = builder.buildOrThrow();
        }
        catch (IllegalArgumentException e) {
            throw (InvalidObjectException)new InvalidObjectException(e.getMessage()).initCause((Throwable)((Object)e));
        }
        ImmutableMultimap.FieldSettersHolder.MAP_FIELD_SETTER.set(this, tmpMap);
        ImmutableMultimap.FieldSettersHolder.SIZE_FIELD_SETTER.set(this, tmpSize);
    }

    public static final class Builder<K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object>
    extends ImmutableMultimap.Builder<K, V> {
        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> put(K key, V value) {
            super.put(key, value);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            super.put(entry);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            super.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(K key, Iterable<? extends V> values) {
            super.putAll(key, values);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(K key, V ... values) {
            super.putAll(key, values);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Multimap<? extends K, ? extends V> multimap) {
            super.putAll(multimap);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        Builder<K, V> combine(ImmutableMultimap.Builder<K, V> other) {
            super.combine(other);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> orderKeysBy(Comparator<? super K> keyComparator) {
            super.orderKeysBy(keyComparator);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> orderValuesBy(Comparator<? super V> valueComparator) {
            super.orderValuesBy(valueComparator);
            return this;
        }

        @Override
        public ImmutableListMultimap<K, V> build() {
            return (ImmutableListMultimap)super.build();
        }
    }
}

