/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.CollectCollectors;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.com.google.common.collect.ImmutableSortedMap;
import org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.Range;
import org.rascalmpl.com.google.common.collect.RangeMap;
import org.rascalmpl.com.google.common.collect.RegularImmutableSortedSet;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.DoNotCall;
import org.rascalmpl.com.google.errorprone.annotations.DoNotMock;
import org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.java.util.function.BiFunction;
import org.rascalmpl.java.util.function.Function;
import org.rascalmpl.java.util.stream.Collector;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public class ImmutableRangeMap<K extends Comparable<?>, V extends org.rascalmpl.java.lang.Object>
extends org.rascalmpl.java.lang.Object
implements RangeMap<K, V>,
Serializable {
    private static final ImmutableRangeMap<Comparable<?>, org.rascalmpl.java.lang.Object> EMPTY = new ImmutableRangeMap(ImmutableList.of(), ImmutableList.of());
    private final transient ImmutableList<Range<K>> ranges;
    private final transient ImmutableList<V> values;
    private static final long serialVersionUID = 0L;

    public static <T extends org.rascalmpl.java.lang.Object, K extends Comparable<? super K>, V extends org.rascalmpl.java.lang.Object> Collector<T, ?, ImmutableRangeMap<K, V>> toImmutableRangeMap(Function<? super T, Range<K>> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return CollectCollectors.toImmutableRangeMap(keyFunction, valueFunction);
    }

    public static <K extends Comparable<?>, V extends org.rascalmpl.java.lang.Object> ImmutableRangeMap<K, V> of() {
        return EMPTY;
    }

    public static <K extends Comparable<?>, V extends org.rascalmpl.java.lang.Object> ImmutableRangeMap<K, V> of(Range<K> range, V value) {
        return new ImmutableRangeMap<K, V>(ImmutableList.of(range), ImmutableList.of(value));
    }

    public static <K extends Comparable<?>, V extends org.rascalmpl.java.lang.Object> ImmutableRangeMap<K, V> copyOf(RangeMap<K, ? extends V> rangeMap) {
        if (rangeMap instanceof ImmutableRangeMap) {
            return (ImmutableRangeMap)rangeMap;
        }
        Map<Range<K>, ? extends V> map = rangeMap.asMapOfRanges();
        ImmutableList.Builder rangesBuilder = new ImmutableList.Builder(map.size());
        ImmutableList.Builder valuesBuilder = new ImmutableList.Builder(map.size());
        for (Map.Entry entry : map.entrySet()) {
            rangesBuilder.add((Range)entry.getKey());
            valuesBuilder.add(entry.getValue());
        }
        return new ImmutableRangeMap<K, V>(rangesBuilder.build(), valuesBuilder.build());
    }

    public static <K extends Comparable<?>, V extends org.rascalmpl.java.lang.Object> Builder<K, V> builder() {
        return new Builder();
    }

    ImmutableRangeMap(ImmutableList<Range<K>> ranges, ImmutableList<V> values) {
        this.ranges = ranges;
        this.values = values;
    }

    /*
     * Exception decompiling
     */
    @Override
    @CheckForNull
    public V get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @CheckForNull
    public Map.Entry<Range<K>, V> getEntry(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Range<K> span() {
        if (this.ranges.isEmpty()) {
            throw new NoSuchElementException();
        }
        Range firstRange = (Range)this.ranges.get(0);
        Range lastRange = (Range)this.ranges.get(this.ranges.size() - 1);
        return Range.create(firstRange.lowerBound, lastRange.upperBound);
    }

    @Override
    @Deprecated
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final void put(Range<K> range, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final void putCoalescing(Range<K> range, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final void putAll(RangeMap<K, ? extends V> rangeMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final void remove(Range<K> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final void merge(Range<K> range, @CheckForNull V value, BiFunction<? super V, ? super @Nullable V, ? extends @Nullable V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableMap<Range<K>, V> asMapOfRanges() {
        if (this.ranges.isEmpty()) {
            return ImmutableMap.of();
        }
        RegularImmutableSortedSet rangeSet = new RegularImmutableSortedSet(this.ranges, Range.rangeLexOrdering());
        return new ImmutableSortedMap(rangeSet, this.values);
    }

    @Override
    public ImmutableMap<Range<K>, V> asDescendingMapOfRanges() {
        if (this.ranges.isEmpty()) {
            return ImmutableMap.of();
        }
        RegularImmutableSortedSet<Range<K>> rangeSet = new RegularImmutableSortedSet<Range<K>>(this.ranges.reverse(), Range.rangeLexOrdering().reverse());
        return new ImmutableSortedMap<Range<K>, V>(rangeSet, this.values.reverse());
    }

    /*
     * Exception decompiling
     */
    @Override
    public ImmutableRangeMap<K, V> subRangeMap(Range<K> range) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int hashCode() {
        return this.asMapOfRanges().hashCode();
    }

    @Override
    public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
        if (o instanceof RangeMap) {
            RangeMap rangeMap = (RangeMap)o;
            return this.asMapOfRanges().equals((org.rascalmpl.java.lang.Object)rangeMap.asMapOfRanges());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.asMapOfRanges().toString();
    }

    org.rascalmpl.java.lang.Object writeReplace() {
        return new SerializedForm(this.asMapOfRanges());
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException((String)"org.rascalmpl.Use SerializedForm");
    }

    private static class SerializedForm<K extends Comparable<?>, V extends org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Serializable {
        private final ImmutableMap<Range<K>, V> mapOfRanges;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<Range<K>, V> mapOfRanges) {
            this.mapOfRanges = mapOfRanges;
        }

        org.rascalmpl.java.lang.Object readResolve() {
            if (this.mapOfRanges.isEmpty()) {
                return ImmutableRangeMap.of();
            }
            return this.createRangeMap();
        }

        org.rascalmpl.java.lang.Object createRangeMap() {
            Builder builder = new Builder();
            for (Map.Entry entry : this.mapOfRanges.entrySet()) {
                builder.put((Range)entry.getKey(), entry.getValue());
            }
            return builder.build();
        }
    }

    @DoNotMock
    public static final class Builder<K extends Comparable<?>, V extends org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object {
        private final List<Map.Entry<Range<K>, V>> entries = Lists.newArrayList();

        @CanIgnoreReturnValue
        public Builder<K, V> put(Range<K> range, V value) {
            Preconditions.checkNotNull(range);
            Preconditions.checkNotNull(value);
            Preconditions.checkArgument(!range.isEmpty(), (String)"org.rascalmpl.Range must not be empty, but was %s", range);
            this.entries.add(Maps.immutableEntry(range, value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<K, V> putAll(RangeMap<K, ? extends V> rangeMap) {
            for (Map.Entry entry : rangeMap.asMapOfRanges().entrySet()) {
                this.put((Range)entry.getKey(), entry.getValue());
            }
            return this;
        }

        @CanIgnoreReturnValue
        Builder<K, V> combine(Builder<K, V> builder) {
            this.entries.addAll(builder.entries);
            return this;
        }

        public ImmutableRangeMap<K, V> build() {
            Collections.sort(this.entries, Range.rangeLexOrdering().onKeys());
            ImmutableList.Builder rangesBuilder = new ImmutableList.Builder(this.entries.size());
            ImmutableList.Builder valuesBuilder = new ImmutableList.Builder(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                Range prevRange;
                Range range = (Range)((Map.Entry)this.entries.get(i)).getKey();
                if (i > 0 && range.isConnected(prevRange = (Range)((Map.Entry)this.entries.get(i - 1)).getKey()) && !range.intersection(prevRange).isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Overlapping ranges: range ").append((org.rascalmpl.java.lang.Object)prevRange).append((String)"org.rascalmpl. overlaps with entry ").append((org.rascalmpl.java.lang.Object)range).toString());
                }
                rangesBuilder.add(range);
                valuesBuilder.add(((Map.Entry)this.entries.get(i)).getValue());
            }
            return new ImmutableRangeMap(rangesBuilder.build(), valuesBuilder.build());
        }
    }
}

