/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.CollectCollectors;
import org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.Hashing;
import org.rascalmpl.com.google.common.collect.ImmutableAsList;
import org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.com.google.common.collect.ImmutableEnumSet;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.JdkBackedImmutableSet;
import org.rascalmpl.com.google.common.collect.RegularImmutableAsList;
import org.rascalmpl.com.google.common.collect.RegularImmutableSet;
import org.rascalmpl.com.google.common.collect.Sets;
import org.rascalmpl.com.google.common.collect.SingletonImmutableSet;
import org.rascalmpl.com.google.common.collect.UnmodifiableIterator;
import org.rascalmpl.com.google.common.math.IntMath;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.com.google.j2objc.annotations.RetainedWith;
import org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.SafeVarargs;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.math.RoundingMode;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.EnumSet;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.SortedSet;
import org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.java.util.stream.Collector;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSet<E extends org.rascalmpl.java.lang.Object>
extends ImmutableCollection<E>
implements Set<E> {
    static final int SPLITERATOR_CHARACTERISTICS = 1297;
    static final int MAX_TABLE_SIZE = 0x40000000;
    private static final double DESIRED_LOAD_FACTOR = 0.7;
    private static final int CUTOFF = 0x2CCCCCCC;
    private static final long serialVersionUID = -889275714L;

    public static <E extends org.rascalmpl.java.lang.Object> Collector<E, ?, ImmutableSet<E>> toImmutableSet() {
        return CollectCollectors.toImmutableSet();
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> of(E e1) {
        return new SingletonImmutableSet<E>(e1);
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> of(E e1, E e2) {
        return new RegularSetBuilderImpl<E>(2).add(e1).add(e2).review().build();
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> of(E e1, E e2, E e3) {
        return new RegularSetBuilderImpl<E>(3).add(e1).add(e2).add(e3).review().build();
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> of(E e1, E e2, E e3, E e4) {
        return new RegularSetBuilderImpl<E>(4).add(e1).add(e2).add(e3).add(e4).review().build();
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        return new RegularSetBuilderImpl<E>(5).add(e1).add(e2).add(e3).add(e4).add(e5).review().build();
    }

    @SafeVarargs
    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... others) {
        Preconditions.checkArgument(others.length <= 0x7FFFFFF9, (org.rascalmpl.java.lang.Object)"org.rascalmpl.the total number of elements must fit in an int");
        SetBuilderImpl builder = new RegularSetBuilderImpl<E>(6 + others.length);
        builder = builder.add(e1).add(e2).add(e3).add(e4).add(e5).add(e6);
        for (int i = 0; i < others.length; ++i) {
            builder = builder.add(others[i]);
        }
        return builder.review().build();
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> copyOf(Collection<? extends E> elements) {
        if (elements instanceof ImmutableSet && !(elements instanceof SortedSet)) {
            ImmutableSet set = (ImmutableSet)elements;
            if (!set.isPartialView()) {
                return set;
            }
        } else if (elements instanceof EnumSet) {
            return ImmutableSet.copyOfEnumSet((EnumSet)elements);
        }
        if (elements.isEmpty()) {
            return ImmutableSet.of();
        }
        org.rascalmpl.java.lang.Object[] array = elements.toArray();
        int expectedSize = elements instanceof Set ? array.length : ImmutableSet.estimatedSizeForUnknownDuplication(array.length);
        return ImmutableSet.fromArrayWithExpectedSize((org.rascalmpl.java.lang.Object[])array, (int)expectedSize);
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> copyOf(Iterable<? extends E> elements) {
        return elements instanceof Collection ? ImmutableSet.copyOf((Collection)elements) : ImmutableSet.copyOf(elements.iterator());
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> copyOf(Iterator<? extends E> elements) {
        if (!elements.hasNext()) {
            return ImmutableSet.of();
        }
        org.rascalmpl.java.lang.Object first = elements.next();
        if (!elements.hasNext()) {
            return ImmutableSet.of(first);
        }
        return ((Builder)((Builder)new Builder().add(first)).addAll((Iterator)elements)).build();
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> copyOf(E[] elements) {
        return ImmutableSet.fromArrayWithExpectedSize(elements, (int)ImmutableSet.estimatedSizeForUnknownDuplication(elements.length));
    }

    private static <E extends org.rascalmpl.java.lang.Object> ImmutableSet<E> fromArrayWithExpectedSize(E[] elements, int expectedSize) {
        switch (elements.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(elements[0]);
            }
        }
        SetBuilderImpl builder = new RegularSetBuilderImpl<E>(expectedSize);
        for (int i = 0; i < elements.length; ++i) {
            builder = ((SetBuilderImpl)builder).add(elements[i]);
        }
        return ((SetBuilderImpl)builder).review().build();
    }

    private static ImmutableSet copyOfEnumSet(EnumSet<?> enumSet) {
        return ImmutableEnumSet.asImmutable(EnumSet.copyOf(enumSet));
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    @J2ktIncompatible
    org.rascalmpl.java.lang.Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException((String)"org.rascalmpl.Use SerializedForm");
    }

    public static <E extends org.rascalmpl.java.lang.Object> Builder<E> builder() {
        return new Builder();
    }

    public static <E extends org.rascalmpl.java.lang.Object> Builder<E> builderWithExpectedSize(int expectedSize) {
        CollectPreconditions.checkNonnegative(expectedSize, (String)"org.rascalmpl.expectedSize");
        return new Builder(expectedSize);
    }

    static int chooseTableSize(int setSize) {
        if ((setSize = Math.max((int)setSize, (int)2)) < 0x2CCCCCCC) {
            int tableSize = Integer.highestOneBit((int)(setSize - 1)) << 1;
            while ((double)tableSize * 0.7 < (double)setSize) {
                tableSize <<= 1;
            }
            return tableSize;
        }
        Preconditions.checkArgument(setSize < 0x40000000, (org.rascalmpl.java.lang.Object)"org.rascalmpl.collection too large");
        return 0x40000000;
    }

    private static int estimatedSizeForUnknownDuplication(int inputElementsIncludingAnyDuplicates) {
        if (inputElementsIncludingAnyDuplicates < 4) {
            return inputElementsIncludingAnyDuplicates;
        }
        return Math.max((int)4, (int)IntMath.sqrt(inputElementsIncludingAnyDuplicates, RoundingMode.CEILING));
    }

    private static final class JdkBackedSetBuilderImpl<E extends org.rascalmpl.java.lang.Object>
    extends SetBuilderImpl<E> {
        private final Set<org.rascalmpl.java.lang.Object> delegate;

        JdkBackedSetBuilderImpl(SetBuilderImpl<E> toCopy) {
            super(toCopy);
            this.delegate = Sets.newHashSetWithExpectedSize(this.distinct);
            for (int i = 0; i < this.distinct; ++i) {
                this.delegate.add(Objects.requireNonNull((org.rascalmpl.java.lang.Object)this.dedupedElements[i]));
            }
        }

        @Override
        SetBuilderImpl<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.delegate.add(e)) {
                this.addDedupedElement(e);
            }
            return this;
        }

        @Override
        SetBuilderImpl<E> copy() {
            return new JdkBackedSetBuilderImpl<E>(this);
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(Objects.requireNonNull((org.rascalmpl.java.lang.Object)this.dedupedElements[0]));
                }
            }
            return new JdkBackedImmutableSet(this.delegate, ImmutableList.asImmutableList(this.dedupedElements, this.distinct));
        }
    }

    private static final class RegularSetBuilderImpl<E extends org.rascalmpl.java.lang.Object>
    extends SetBuilderImpl<E> {
        @CheckForNull
        private @Nullable org.rascalmpl.java.lang.Object[] hashTable;
        private int maxRunBeforeFallback;
        private int expandTableThreshold;
        private int hashCode;
        static final int MAX_RUN_MULTIPLIER = 13;

        RegularSetBuilderImpl(int expectedCapacity) {
            super(expectedCapacity);
            this.hashTable = null;
            this.maxRunBeforeFallback = 0;
            this.expandTableThreshold = 0;
        }

        RegularSetBuilderImpl(RegularSetBuilderImpl<E> toCopy) {
            super(toCopy);
            this.hashTable = toCopy.hashTable == null ? null : (org.rascalmpl.java.lang.Object[])toCopy.hashTable.clone();
            this.maxRunBeforeFallback = toCopy.maxRunBeforeFallback;
            this.expandTableThreshold = toCopy.expandTableThreshold;
            this.hashCode = toCopy.hashCode;
        }

        @Override
        SetBuilderImpl<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.hashTable == null) {
                if (this.distinct == 0) {
                    this.addDedupedElement(e);
                    return this;
                }
                this.ensureTableCapacity(this.dedupedElements.length);
                org.rascalmpl.java.lang.Object elem = this.dedupedElements[0];
                --this.distinct;
                return this.insertInHashTable(elem).add((org.rascalmpl.java.lang.Object)e);
            }
            return this.insertInHashTable(e);
        }

        private SetBuilderImpl<E> insertInHashTable(E e) {
            Objects.requireNonNull((org.rascalmpl.java.lang.Object)this.hashTable);
            int eHash = e.hashCode();
            int i0 = Hashing.smear(eHash);
            int mask = this.hashTable.length - 1;
            int i = i0;
            while (i - i0 < this.maxRunBeforeFallback) {
                int index = i & mask;
                org.rascalmpl.java.lang.Object tableEntry = this.hashTable[index];
                if (tableEntry == null) {
                    this.addDedupedElement(e);
                    this.hashTable[index] = e;
                    this.hashCode += eHash;
                    this.ensureTableCapacity(this.distinct);
                    return this;
                }
                if (tableEntry.equals(e)) {
                    return this;
                }
                ++i;
            }
            return new JdkBackedSetBuilderImpl<E>(this).add(e);
        }

        @Override
        SetBuilderImpl<E> copy() {
            return new RegularSetBuilderImpl<E>(this);
        }

        @Override
        SetBuilderImpl<E> review() {
            if (this.hashTable == null) {
                return this;
            }
            int targetTableSize = ImmutableSet.chooseTableSize(this.distinct);
            if (targetTableSize * 2 < this.hashTable.length) {
                this.hashTable = RegularSetBuilderImpl.rebuildHashTable(targetTableSize, this.dedupedElements, this.distinct);
                this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(targetTableSize);
                this.expandTableThreshold = (int)(0.7 * (double)targetTableSize);
            }
            return RegularSetBuilderImpl.hashFloodingDetected(this.hashTable) ? new JdkBackedSetBuilderImpl(this) : this;
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(Objects.requireNonNull((org.rascalmpl.java.lang.Object)this.dedupedElements[0]));
                }
            }
            org.rascalmpl.java.lang.Object[] elements = this.distinct == this.dedupedElements.length ? this.dedupedElements : Arrays.copyOf((org.rascalmpl.java.lang.Object[])this.dedupedElements, (int)this.distinct);
            return new RegularImmutableSet(elements, this.hashCode, (org.rascalmpl.java.lang.Object[])Objects.requireNonNull((org.rascalmpl.java.lang.Object)this.hashTable), this.hashTable.length - 1);
        }

        static @Nullable org.rascalmpl.java.lang.Object[] rebuildHashTable(int newTableSize, org.rascalmpl.java.lang.Object[] elements, int n) {
            @Nullable org.rascalmpl.java.lang.Object[] hashTable = new org.rascalmpl.java.lang.Object[newTableSize];
            int mask = hashTable.length - 1;
            for (int i = 0; i < n; ++i) {
                int j0;
                org.rascalmpl.java.lang.Object e = Objects.requireNonNull((org.rascalmpl.java.lang.Object)elements[i]);
                int j = j0 = Hashing.smear(e.hashCode());
                while (true) {
                    int index;
                    if (hashTable[index = j & mask] == null) break;
                    ++j;
                }
                hashTable[index] = e;
            }
            return hashTable;
        }

        void ensureTableCapacity(int minCapacity) {
            int newTableSize;
            if (this.hashTable == null) {
                newTableSize = ImmutableSet.chooseTableSize(minCapacity);
                this.hashTable = new org.rascalmpl.java.lang.Object[newTableSize];
            } else if (minCapacity > this.expandTableThreshold && this.hashTable.length < 0x40000000) {
                newTableSize = this.hashTable.length * 2;
                this.hashTable = RegularSetBuilderImpl.rebuildHashTable(newTableSize, this.dedupedElements, this.distinct);
            } else {
                return;
            }
            this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(newTableSize);
            this.expandTableThreshold = (int)(0.7 * (double)newTableSize);
        }

        static boolean hashFloodingDetected(@Nullable org.rascalmpl.java.lang.Object[] hashTable) {
            int maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(hashTable.length);
            int mask = hashTable.length - 1;
            int knownRunStart = 0;
            int knownRunEnd = 0;
            block0: while (knownRunStart < hashTable.length) {
                if (knownRunStart == knownRunEnd && hashTable[knownRunStart] == null) {
                    if (hashTable[knownRunStart + maxRunBeforeFallback - 1 & mask] == null) {
                        knownRunStart += maxRunBeforeFallback;
                    }
                    knownRunEnd = ++knownRunStart;
                    continue;
                }
                for (int j = knownRunStart + maxRunBeforeFallback - 1; j >= knownRunEnd; --j) {
                    if (hashTable[j & mask] != null) continue;
                    knownRunEnd = knownRunStart + maxRunBeforeFallback;
                    knownRunStart = j + 1;
                    continue block0;
                }
                return true;
            }
            return false;
        }

        static int maxRunBeforeFallback(int tableSize) {
            return 13 * IntMath.log2(tableSize, RoundingMode.UNNECESSARY);
        }
    }

    private static final class EmptySetBuilderImpl<E extends org.rascalmpl.java.lang.Object>
    extends SetBuilderImpl<E> {
        private static final EmptySetBuilderImpl<org.rascalmpl.java.lang.Object> INSTANCE = new EmptySetBuilderImpl();

        static <E extends org.rascalmpl.java.lang.Object> SetBuilderImpl<E> instance() {
            return INSTANCE;
        }

        private EmptySetBuilderImpl() {
            super(0);
        }

        @Override
        SetBuilderImpl<E> add(E e) {
            return new RegularSetBuilderImpl<E>(4).add(e);
        }

        @Override
        SetBuilderImpl<E> copy() {
            return this;
        }

        @Override
        ImmutableSet<E> build() {
            return ImmutableSet.of();
        }
    }

    private static abstract class SetBuilderImpl<E extends org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object {
        E[] dedupedElements;
        int distinct;

        SetBuilderImpl(int expectedCapacity) {
            this.dedupedElements = new org.rascalmpl.java.lang.Object[expectedCapacity];
            this.distinct = 0;
        }

        SetBuilderImpl(SetBuilderImpl<E> toCopy) {
            this.dedupedElements = Arrays.copyOf(toCopy.dedupedElements, (int)toCopy.dedupedElements.length);
            this.distinct = toCopy.distinct;
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity > this.dedupedElements.length) {
                int newCapacity = ImmutableCollection.Builder.expandedCapacity(this.dedupedElements.length, minCapacity);
                this.dedupedElements = Arrays.copyOf(this.dedupedElements, (int)newCapacity);
            }
        }

        final void addDedupedElement(E e) {
            this.ensureCapacity(this.distinct + 1);
            this.dedupedElements[this.distinct++] = e;
        }

        abstract SetBuilderImpl<E> add(E var1);

        final SetBuilderImpl<E> combine(SetBuilderImpl<E> other) {
            SetBuilderImpl<org.rascalmpl.java.lang.Object> result = this;
            for (int i = 0; i < other.distinct; ++i) {
                result = result.add(Objects.requireNonNull(other.dedupedElements[i]));
            }
            return result;
        }

        abstract SetBuilderImpl<E> copy();

        SetBuilderImpl<E> review() {
            return this;
        }

        abstract ImmutableSet<E> build();
    }

    public static class Builder<E extends org.rascalmpl.java.lang.Object>
    extends ImmutableCollection.Builder<E> {
        @CheckForNull
        private SetBuilderImpl<E> impl;
        boolean forceCopy;

        public Builder() {
            this(0);
        }

        Builder(int capacity) {
            this.impl = capacity > 0 ? new RegularSetBuilderImpl(capacity) : EmptySetBuilderImpl.instance();
        }

        Builder(boolean subclass) {
            this.impl = null;
        }

        @VisibleForTesting
        void forceJdk() {
            Objects.requireNonNull(this.impl);
            this.impl = new JdkBackedSetBuilderImpl<E>(this.impl);
        }

        final void copyIfNecessary() {
            if (this.forceCopy) {
                this.copy();
                this.forceCopy = false;
            }
        }

        void copy() {
            Objects.requireNonNull(this.impl);
            this.impl = this.impl.copy();
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E element) {
            Objects.requireNonNull(this.impl);
            Preconditions.checkNotNull(element);
            this.copyIfNecessary();
            this.impl = this.impl.add(element);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E ... elements) {
            super.add(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> elements) {
            super.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterator<? extends E> elements) {
            super.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        Builder<E> combine(Builder<E> other) {
            Objects.requireNonNull(this.impl);
            Objects.requireNonNull(other.impl);
            this.copyIfNecessary();
            this.impl = this.impl.combine(other.impl);
            return this;
        }

        @Override
        public ImmutableSet<E> build() {
            Objects.requireNonNull(this.impl);
            this.forceCopy = true;
            this.impl = this.impl.review();
            return this.impl.build();
        }
    }

    @J2ktIncompatible
    private static class SerializedForm
    extends org.rascalmpl.java.lang.Object
    implements Serializable {
        final org.rascalmpl.java.lang.Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(org.rascalmpl.java.lang.Object[] elements) {
            this.elements = elements;
        }

        org.rascalmpl.java.lang.Object readResolve() {
            return ImmutableSet.copyOf((org.rascalmpl.java.lang.Object[])this.elements);
        }
    }

    static abstract class Indexed<E extends org.rascalmpl.java.lang.Object>
    extends CachingAsList<E> {
        Indexed() {
        }

        abstract E get(int var1);

        @Override
        public UnmodifiableIterator<E> iterator() {
            return this.asList().iterator();
        }

        /*
         * Exception decompiling
         */
        @Override
        public Spliterator<E> spliterator() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (I)Lorg/rascalmpl/java/lang/Object;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void forEach(Consumer<? super E> consumer) {
            Preconditions.checkNotNull(consumer);
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                consumer.accept(this.get(i));
            }
        }

        @Override
        int copyIntoArray(@Nullable org.rascalmpl.java.lang.Object[] dst, int offset) {
            return this.asList().copyIntoArray(dst, offset);
        }

        @Override
        ImmutableList<E> createAsList() {
            return new ImmutableAsList<E>(){

                public E get(int index) {
                    return this.get(index);
                }

                @Override
                Indexed<E> delegateCollection() {
                    return this;
                }

                @Override
                @J2ktIncompatible
                @GwtIncompatible
                org.rascalmpl.java.lang.Object writeReplace() {
                    return super.writeReplace();
                }
            };
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        org.rascalmpl.java.lang.Object writeReplace() {
            return super.writeReplace();
        }
    }

    @GwtCompatible
    static abstract class CachingAsList<E extends org.rascalmpl.java.lang.Object>
    extends ImmutableSet<E> {
        @LazyInit
        @CheckForNull
        @RetainedWith
        private transient ImmutableList<E> asList;

        CachingAsList() {
        }

        @Override
        public ImmutableList<E> asList() {
            ImmutableList<E> result = this.asList;
            if (result == null) {
                this.asList = this.createAsList();
                return this.asList;
            }
            return result;
        }

        ImmutableList<E> createAsList() {
            return new RegularImmutableAsList(this, this.toArray());
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        org.rascalmpl.java.lang.Object writeReplace() {
            return super.writeReplace();
        }
    }
}

