/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.MoreObjects;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.CollectCollectors;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.EmptyImmutableSetMultimap;
import org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.com.google.common.collect.ImmutableMultimap;
import org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.com.google.common.collect.ImmutableSortedSet;
import org.rascalmpl.com.google.common.collect.Multimap;
import org.rascalmpl.com.google.common.collect.Ordering;
import org.rascalmpl.com.google.common.collect.Platform;
import org.rascalmpl.com.google.common.collect.Serialization;
import org.rascalmpl.com.google.common.collect.SetMultimap;
import org.rascalmpl.com.google.common.collect.UnmodifiableIterator;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.DoNotCall;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.com.google.j2objc.annotations.RetainedWith;
import org.rascalmpl.com.google.j2objc.annotations.Weak;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.java.io.ObjectOutputStream;
import org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.function.Function;
import org.rascalmpl.java.util.stream.Collector;
import org.rascalmpl.java.util.stream.Stream;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public class ImmutableSetMultimap<K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object>
extends ImmutableMultimap<K, V>
implements SetMultimap<K, V> {
    private final transient ImmutableSet<V> emptySet;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableSetMultimap<V, K> inverse;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableSet<Map.Entry<K, V>> entries;
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    public static <T extends org.rascalmpl.java.lang.Object, K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Collector<T, ?, ImmutableSetMultimap<K, V>> toImmutableSetMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return CollectCollectors.toImmutableSetMultimap(keyFunction, valueFunction);
    }

    public static <T extends org.rascalmpl.java.lang.Object, K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Collector<T, ?, ImmutableSetMultimap<K, V>> flatteningToImmutableSetMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends Stream<? extends V>> valuesFunction) {
        return CollectCollectors.flatteningToImmutableSetMultimap(keyFunction, valuesFunction);
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableSetMultimap<K, V> of() {
        return EmptyImmutableSetMultimap.INSTANCE;
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableSetMultimap<K, V> of(K k1, V v1) {
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put(k1, v1);
        return builder.build();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableSetMultimap<K, V> of(K k1, V v1, K k2, V v2) {
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put(k1, v1);
        builder.put(k2, v2);
        return builder.build();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableSetMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put(k1, v1);
        builder.put(k2, v2);
        builder.put(k3, v3);
        return builder.build();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableSetMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put(k1, v1);
        builder.put(k2, v2);
        builder.put(k3, v3);
        builder.put(k4, v4);
        return builder.build();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableSetMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put(k1, v1);
        builder.put(k2, v2);
        builder.put(k3, v3);
        builder.put(k4, v4);
        builder.put(k5, v5);
        return builder.build();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableSetMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap) {
        return ImmutableSetMultimap.copyOf(multimap, null);
    }

    private static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableSetMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap, @CheckForNull Comparator<? super V> valueComparator) {
        ImmutableSetMultimap kvMultimap;
        Preconditions.checkNotNull(multimap);
        if (multimap.isEmpty() && valueComparator == null) {
            return ImmutableSetMultimap.of();
        }
        if (multimap instanceof ImmutableSetMultimap && !(kvMultimap = (ImmutableSetMultimap)multimap).isPartialView()) {
            return kvMultimap;
        }
        return ImmutableSetMultimap.fromMapEntries(multimap.asMap().entrySet(), valueComparator);
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableSetMultimap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        return ((Builder)new Builder().putAll((Iterable)entries)).build();
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableSetMultimap<K, V> fromMapEntries(Collection<? extends Map.Entry<? extends K, ? extends Collection<? extends V>>> mapEntries, @CheckForNull Comparator<? super V> valueComparator) {
        if (mapEntries.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableMap.Builder<org.rascalmpl.java.lang.Object, ImmutableSet<? super V>> builder = new ImmutableMap.Builder<org.rascalmpl.java.lang.Object, ImmutableSet<? super V>>(mapEntries.size());
        int size = 0;
        for (Map.Entry entry : mapEntries) {
            org.rascalmpl.java.lang.Object key = entry.getKey();
            Collection values = (Collection)entry.getValue();
            ImmutableSet<? super V> set = ImmutableSetMultimap.valueSet(valueComparator, values);
            if (set.isEmpty()) continue;
            builder.put(key, set);
            size += set.size();
        }
        return new ImmutableSetMultimap(builder.buildOrThrow(), size, valueComparator);
    }

    ImmutableSetMultimap(ImmutableMap<K, ImmutableSet<V>> map, int size, @CheckForNull Comparator<? super V> valueComparator) {
        super(map, size);
        this.emptySet = ImmutableSetMultimap.emptySet(valueComparator);
    }

    @Override
    public ImmutableSet<V> get(K key) {
        ImmutableSet set = (ImmutableSet)((Object)this.map.get((org.rascalmpl.java.lang.Object)key));
        return MoreObjects.firstNonNull(set, this.emptySet);
    }

    @Override
    public ImmutableSetMultimap<V, K> inverse() {
        ImmutableSetMultimap<K, V> result = this.inverse;
        return result == null ? (this.inverse = this.invert()) : result;
    }

    private ImmutableSetMultimap<V, K> invert() {
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        Iterator iterator = ((ImmutableSet)this.entries()).iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            builder.put(entry.getValue(), entry.getKey());
        }
        ImmutableMultimap invertedMultimap = builder.build();
        ((ImmutableSetMultimap)invertedMultimap).inverse = this;
        return invertedMultimap;
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final ImmutableSet<V> removeAll(@CheckForNull org.rascalmpl.java.lang.Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final ImmutableSet<V> replaceValues(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entries() {
        ImmutableSet<Map.Entry<K, V>> result = this.entries;
        return result == null ? (this.entries = new EntrySet(this)) : result;
    }

    private static <V extends org.rascalmpl.java.lang.Object> ImmutableSet<V> valueSet(@CheckForNull Comparator<? super V> valueComparator, Collection<? extends V> values) {
        return valueComparator == null ? ImmutableSet.copyOf(values) : ImmutableSortedSet.copyOf(valueComparator, values);
    }

    private static <V extends org.rascalmpl.java.lang.Object> ImmutableSet<V> emptySet(@CheckForNull Comparator<? super V> valueComparator) {
        return valueComparator == null ? ImmutableSet.of() : ImmutableSortedSet.emptySet(valueComparator);
    }

    private static <V extends org.rascalmpl.java.lang.Object> ImmutableSet.Builder<V> valuesBuilder(@CheckForNull Comparator<? super V> valueComparator) {
        return valueComparator == null ? new ImmutableSet.Builder() : new ImmutableSortedSet.Builder<V>(valueComparator);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.valueComparator());
        Serialization.writeMultimap(this, stream);
    }

    @CheckForNull
    Comparator<? super V> valueComparator() {
        return this.emptySet instanceof ImmutableSortedSet ? ((ImmutableSortedSet)this.emptySet).comparator() : null;
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ImmutableMap tmpMap;
        stream.defaultReadObject();
        Comparator valueComparator = (Comparator)stream.readObject();
        int keyCount = stream.readInt();
        if (keyCount < 0) {
            throw new InvalidObjectException(new StringBuilder().append((String)"org.rascalmpl.Invalid key count ").append(keyCount).toString());
        }
        ImmutableMap.Builder<org.rascalmpl.java.lang.Object, ImmutableCollection> builder = ImmutableMap.builder();
        int tmpSize = 0;
        for (int i = 0; i < keyCount; ++i) {
            org.rascalmpl.java.lang.Object key = Objects.requireNonNull((org.rascalmpl.java.lang.Object)stream.readObject());
            int valueCount = stream.readInt();
            if (valueCount <= 0) {
                throw new InvalidObjectException(new StringBuilder().append((String)"org.rascalmpl.Invalid value count ").append(valueCount).toString());
            }
            ImmutableSet.Builder<V> valuesBuilder = ImmutableSetMultimap.valuesBuilder(valueComparator);
            for (int j = 0; j < valueCount; ++j) {
                valuesBuilder.add(Objects.requireNonNull((org.rascalmpl.java.lang.Object)stream.readObject()));
            }
            ImmutableCollection valueSet = valuesBuilder.build();
            if (valueSet.size() != valueCount) {
                throw new InvalidObjectException(new StringBuilder().append((String)"org.rascalmpl.Duplicate key-value pairs exist for key ").append(key).toString());
            }
            builder.put(key, valueSet);
            tmpSize += valueCount;
        }
        try {
            tmpMap = builder.buildOrThrow();
        }
        catch (IllegalArgumentException e) {
            throw (InvalidObjectException)new InvalidObjectException(e.getMessage()).initCause((Throwable)((Object)e));
        }
        ImmutableMultimap.FieldSettersHolder.MAP_FIELD_SETTER.set(this, tmpMap);
        ImmutableMultimap.FieldSettersHolder.SIZE_FIELD_SETTER.set(this, tmpSize);
        SetFieldSettersHolder.EMPTY_SET_FIELD_SETTER.set((ImmutableSetMultimap<?, ?>)this, (org.rascalmpl.java.lang.Object)ImmutableSetMultimap.emptySet(valueComparator));
    }

    @GwtIncompatible
    @J2ktIncompatible
    private static final class SetFieldSettersHolder
    extends org.rascalmpl.java.lang.Object {
        static final Serialization.FieldSetter<? super ImmutableSetMultimap<?, ?>> EMPTY_SET_FIELD_SETTER = Serialization.getFieldSetter(ImmutableSetMultimap.class, (String)"org.rascalmpl.emptySet");

        private SetFieldSettersHolder() {
        }
    }

    private static final class EntrySet<K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object>
    extends ImmutableSet<Map.Entry<K, V>> {
        @Weak
        private final transient ImmutableSetMultimap<K, V> multimap;

        EntrySet(ImmutableSetMultimap<K, V> multimap) {
            this.multimap = multimap;
        }

        @Override
        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.multimap.containsEntry(entry.getKey(), entry.getValue());
            }
            return false;
        }

        public int size() {
            return this.multimap.size();
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.multimap.entryIterator();
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        org.rascalmpl.java.lang.Object writeReplace() {
            return super.writeReplace();
        }
    }

    public static final class Builder<K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object>
    extends ImmutableMultimap.Builder<K, V> {
        @Override
        Collection<V> newMutableValueCollection() {
            return Platform.preservesInsertionOrderOnAddsSet();
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> put(K key, V value) {
            super.put(key, value);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            super.put(entry);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            super.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(K key, Iterable<? extends V> values) {
            super.putAll(key, values);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(K key, V ... values) {
            return this.putAll((org.rascalmpl.java.lang.Object)key, (Iterable)Arrays.asList(values));
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Multimap<? extends K, ? extends V> multimap) {
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                this.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        Builder<K, V> combine(ImmutableMultimap.Builder<K, V> other) {
            super.combine(other);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> orderKeysBy(Comparator<? super K> keyComparator) {
            super.orderKeysBy(keyComparator);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> orderValuesBy(Comparator<? super V> valueComparator) {
            super.orderValuesBy(valueComparator);
            return this;
        }

        @Override
        public ImmutableSetMultimap<K, V> build() {
            Object mapEntries = this.builderMap.entrySet();
            if (this.keyComparator != null) {
                mapEntries = Ordering.from(this.keyComparator).onKeys().immutableSortedCopy(mapEntries);
            }
            return ImmutableSetMultimap.fromMapEntries(mapEntries, this.valueComparator);
        }
    }
}

