/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.CollectCollectors;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.com.google.common.collect.ObjectArrays;
import org.rascalmpl.com.google.common.collect.Ordering;
import org.rascalmpl.com.google.common.collect.RegularImmutableSortedSet;
import org.rascalmpl.com.google.common.collect.SortedIterable;
import org.rascalmpl.com.google.common.collect.SortedIterables;
import org.rascalmpl.com.google.common.collect.UnmodifiableIterator;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.DoNotCall;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.NavigableSet;
import org.rascalmpl.java.util.SortedSet;
import org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.java.util.Spliterators;
import org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.java.util.stream.Collector;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSortedSet<E extends org.rascalmpl.java.lang.Object>
extends ImmutableSet.CachingAsList<E>
implements NavigableSet<E>,
SortedIterable<E> {
    static final int SPLITERATOR_CHARACTERISTICS = 1301;
    final transient Comparator<? super E> comparator;
    @LazyInit
    @CheckForNull
    @GwtIncompatible
    transient ImmutableSortedSet<E> descendingSet;
    private static final long serialVersionUID = -889275714L;

    public static <E extends org.rascalmpl.java.lang.Object> Collector<E, ?, ImmutableSortedSet<E>> toImmutableSortedSet(Comparator<? super E> comparator) {
        return CollectCollectors.toImmutableSortedSet(comparator);
    }

    static <E extends org.rascalmpl.java.lang.Object> RegularImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (Ordering.natural().equals((org.rascalmpl.java.lang.Object)comparator)) {
            RegularImmutableSortedSet<Comparable> result = RegularImmutableSortedSet.NATURAL_EMPTY_SET;
            return result;
        }
        return new RegularImmutableSortedSet<E>(ImmutableList.of(), comparator);
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> of() {
        return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1) {
        return new RegularImmutableSortedSet<E>(ImmutableList.of(e1), Ordering.natural());
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2) {
        return ImmutableSortedSet.construct(Ordering.natural(), (int)2, (org.rascalmpl.java.lang.Object[])new Comparable[]{e1, e2});
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3) {
        return ImmutableSortedSet.construct(Ordering.natural(), (int)3, (org.rascalmpl.java.lang.Object[])new Comparable[]{e1, e2, e3});
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableSortedSet.construct(Ordering.natural(), (int)4, (org.rascalmpl.java.lang.Object[])new Comparable[]{e1, e2, e3, e4});
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableSortedSet.construct(Ordering.natural(), (int)5, (org.rascalmpl.java.lang.Object[])new Comparable[]{e1, e2, e3, e4, e5});
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... remaining) {
        Comparable[] contents = new Comparable[6 + remaining.length];
        contents[0] = e1;
        contents[1] = e2;
        contents[2] = e3;
        contents[3] = e4;
        contents[4] = e5;
        contents[5] = e6;
        System.arraycopy(remaining, (int)0, (org.rascalmpl.java.lang.Object)contents, (int)6, (int)remaining.length);
        return ImmutableSortedSet.construct(Ordering.natural(), (int)contents.length, (org.rascalmpl.java.lang.Object[])contents);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> copyOf(E[] elements) {
        return ImmutableSortedSet.construct(Ordering.natural(), (int)elements.length, (org.rascalmpl.java.lang.Object[])((Comparable[])elements.clone()));
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> copyOf(Iterable<? extends E> elements) {
        Ordering naturalOrder = Ordering.natural();
        return ImmutableSortedSet.copyOf(naturalOrder, elements);
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> copyOf(Collection<? extends E> elements) {
        Ordering naturalOrder = Ordering.natural();
        return ImmutableSortedSet.copyOf(naturalOrder, elements);
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> copyOf(Iterator<? extends E> elements) {
        Ordering naturalOrder = Ordering.natural();
        return ImmutableSortedSet.copyOf(naturalOrder, elements);
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> elements) {
        return ((Builder)new Builder<E>(comparator).addAll((Iterator)elements)).build();
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> elements) {
        ImmutableSortedSet original;
        Preconditions.checkNotNull(comparator);
        boolean hasSameComparator = SortedIterables.hasSameComparator(comparator, elements);
        if (hasSameComparator && elements instanceof ImmutableSortedSet && !(original = (ImmutableSortedSet)elements).isPartialView()) {
            return original;
        }
        org.rascalmpl.java.lang.Object[] array = Iterables.toArray(elements);
        return ImmutableSortedSet.construct(comparator, (int)array.length, (org.rascalmpl.java.lang.Object[])array);
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Collection<? extends E> elements) {
        return ImmutableSortedSet.copyOf(comparator, elements);
    }

    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> copyOfSorted(SortedSet<E> sortedSet) {
        Comparator<E> comparator = SortedIterables.comparator(sortedSet);
        ImmutableList<E> list = ImmutableList.copyOf(sortedSet);
        if (list.isEmpty()) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        return new RegularImmutableSortedSet<E>(list, comparator);
    }

    static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> construct(Comparator<? super E> comparator, int n, E ... contents) {
        if (n == 0) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        ObjectArrays.checkElementsNotNull(contents, n);
        Arrays.sort(contents, (int)0, (int)n, comparator);
        int uniques = 1;
        for (int i = 1; i < n; ++i) {
            E cur = contents[i];
            E prev = contents[uniques - 1];
            if (comparator.compare(cur, prev) == 0) continue;
            contents[uniques++] = cur;
        }
        Arrays.fill(contents, (int)uniques, (int)n, null);
        return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(contents, uniques), comparator);
    }

    public static <E extends org.rascalmpl.java.lang.Object> Builder<E> orderedBy(Comparator<E> comparator) {
        return new Builder<E>(comparator);
    }

    public static <E extends Comparable<?>> Builder<E> reverseOrder() {
        return new Builder(Collections.reverseOrder());
    }

    public static <E extends Comparable<?>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    int unsafeCompare(org.rascalmpl.java.lang.Object a, @CheckForNull org.rascalmpl.java.lang.Object b) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, a, b);
    }

    static int unsafeCompare(Comparator<?> comparator, org.rascalmpl.java.lang.Object a, @CheckForNull org.rascalmpl.java.lang.Object b) {
        Comparator<@Nullable ?> unsafeComparator = comparator;
        return unsafeComparator.compare(a, b);
    }

    ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    public ImmutableSortedSet<E> headSet(E toElement) {
        return this.headSet((org.rascalmpl.java.lang.Object)toElement, false);
    }

    public ImmutableSortedSet<E> headSet(E toElement, boolean inclusive) {
        return this.headSetImpl(Preconditions.checkNotNull(toElement), inclusive);
    }

    public ImmutableSortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet((org.rascalmpl.java.lang.Object)fromElement, true, (org.rascalmpl.java.lang.Object)toElement, false);
    }

    @GwtIncompatible
    public ImmutableSortedSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator.compare(fromElement, toElement) <= 0);
        return this.subSetImpl(fromElement, fromInclusive, toElement, toInclusive);
    }

    public ImmutableSortedSet<E> tailSet(E fromElement) {
        return this.tailSet((org.rascalmpl.java.lang.Object)fromElement, true);
    }

    public ImmutableSortedSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.tailSetImpl(Preconditions.checkNotNull(fromElement), inclusive);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    @CheckForNull
    @GwtIncompatible
    public E lower(E e) {
        return Iterators.getNext(this.headSet((org.rascalmpl.java.lang.Object)e, false).descendingIterator(), null);
    }

    @CheckForNull
    public E floor(E e) {
        return Iterators.getNext(this.headSet((org.rascalmpl.java.lang.Object)e, true).descendingIterator(), null);
    }

    @CheckForNull
    public E ceiling(E e) {
        return Iterables.getFirst(this.tailSet((org.rascalmpl.java.lang.Object)e, true), null);
    }

    @CheckForNull
    @GwtIncompatible
    public E higher(E e) {
        return Iterables.getFirst(this.tailSet((org.rascalmpl.java.lang.Object)e, false), null);
    }

    public E first() {
        return (E)this.iterator().next();
    }

    public E last() {
        return (E)this.descendingIterator().next();
    }

    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @GwtIncompatible
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @GwtIncompatible
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    @GwtIncompatible
    public ImmutableSortedSet<E> descendingSet() {
        ImmutableSortedSet<E> result = this.descendingSet;
        if (result == null) {
            result = this.descendingSet = this.createDescendingSet();
            result.descendingSet = this;
        }
        return result;
    }

    @GwtIncompatible
    abstract ImmutableSortedSet<E> createDescendingSet();

    @Override
    public Spliterator<E> spliterator() {
        return new Spliterators.AbstractSpliterator<E>(this.size(), 1365){
            final UnmodifiableIterator<E> iterator;
            {
                this.iterator = ImmutableSortedSet.this.iterator();
            }

            public boolean tryAdvance(Consumer<? super E> action) {
                if (this.iterator.hasNext()) {
                    action.accept(this.iterator.next());
                    return true;
                }
                return false;
            }

            public Comparator<? super E> getComparator() {
                return ImmutableSortedSet.this.comparator;
            }
        };
    }

    @GwtIncompatible
    public abstract UnmodifiableIterator<E> descendingIterator();

    abstract int indexOf(@CheckForNull org.rascalmpl.java.lang.Object var1);

    @J2ktIncompatible
    private void readObject(ObjectInputStream unused) throws InvalidObjectException {
        throw new InvalidObjectException((String)"org.rascalmpl.Use SerializedForm");
    }

    @Override
    @J2ktIncompatible
    org.rascalmpl.java.lang.Object writeReplace() {
        return new SerializedForm<E>(this.comparator, this.toArray());
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.Use toImmutableSortedSet")
    public static <E extends org.rascalmpl.java.lang.Object> Collector<E, ?, ImmutableSet<E>> toImmutableSet() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.Use naturalOrder")
    public static <E extends org.rascalmpl.java.lang.Object> Builder<E> builder() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.Use naturalOrder (which does not accept an expected size)")
    public static <E extends org.rascalmpl.java.lang.Object> Builder<E> builderWithExpectedSize(int expectedSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.Pass a parameter of type Comparable")
    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> of(E e1) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.Pass parameters of type Comparable")
    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> of(E e1, E e2) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.Pass parameters of type Comparable")
    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> of(E e1, E e2, E e3) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.Pass parameters of type Comparable")
    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.Pass parameters of type Comparable")
    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.Pass parameters of type Comparable")
    public static <E extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... remaining) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="org.rascalmpl.Pass parameters of type Comparable")
    public static <Z extends org.rascalmpl.java.lang.Object> ImmutableSortedSet<Z> copyOf(Z[] elements) {
        throw new UnsupportedOperationException();
    }

    @J2ktIncompatible
    private static class SerializedForm<E extends org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Serializable {
        final Comparator<? super E> comparator;
        final org.rascalmpl.java.lang.Object[] elements;
        private static final long serialVersionUID = 0L;

        public SerializedForm(Comparator<? super E> comparator, org.rascalmpl.java.lang.Object[] elements) {
            this.comparator = comparator;
            this.elements = elements;
        }

        org.rascalmpl.java.lang.Object readResolve() {
            return ((Builder)new Builder<E>(this.comparator).add(this.elements)).build();
        }
    }

    public static final class Builder<E extends org.rascalmpl.java.lang.Object>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;
        private E[] elements;
        private int n;

        public Builder(Comparator<? super E> comparator) {
            super(true);
            this.comparator = Preconditions.checkNotNull(comparator);
            this.elements = new org.rascalmpl.java.lang.Object[4];
            this.n = 0;
        }

        @Override
        void copy() {
            this.elements = Arrays.copyOf(this.elements, (int)this.elements.length);
        }

        private void sortAndDedup() {
            if (this.n == 0) {
                return;
            }
            Arrays.sort(this.elements, (int)0, (int)this.n, this.comparator);
            int unique = 1;
            for (int i = 1; i < this.n; ++i) {
                int cmp = this.comparator.compare(this.elements[unique - 1], this.elements[i]);
                if (cmp < 0) {
                    this.elements[unique++] = this.elements[i];
                    continue;
                }
                if (cmp <= 0) continue;
                throw new AssertionError((org.rascalmpl.java.lang.Object)new StringBuilder().append((String)"org.rascalmpl.Comparator ").append(this.comparator).append((String)"org.rascalmpl. compare method violates its contract").toString());
            }
            Arrays.fill(this.elements, (int)unique, (int)this.n, null);
            this.n = unique;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E element) {
            Preconditions.checkNotNull(element);
            this.copyIfNecessary();
            if (this.n == this.elements.length) {
                this.sortAndDedup();
                int newLength = ImmutableCollection.Builder.expandedCapacity(this.n, this.n + 1);
                if (newLength > this.elements.length) {
                    this.elements = Arrays.copyOf(this.elements, (int)newLength);
                }
            }
            this.elements[this.n++] = element;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E ... elements) {
            ObjectArrays.checkElementsNotNull(elements);
            for (E e : elements) {
                this.add((org.rascalmpl.java.lang.Object)e);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> elements) {
            super.addAll((Iterable)elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterator<? extends E> elements) {
            super.addAll((Iterator)elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        Builder<E> combine(ImmutableSet.Builder<E> builder) {
            this.copyIfNecessary();
            Builder other = (Builder)builder;
            for (int i = 0; i < other.n; ++i) {
                this.add((org.rascalmpl.java.lang.Object)other.elements[i]);
            }
            return this;
        }

        @Override
        public ImmutableSortedSet<E> build() {
            this.sortAndDedup();
            if (this.n == 0) {
                return ImmutableSortedSet.emptySet(this.comparator);
            }
            this.forceCopy = true;
            return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(this.elements, this.n), this.comparator);
        }
    }
}

