/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.com.google.common.base.Optional;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Predicate;
import org.rascalmpl.com.google.common.base.Predicates;
import org.rascalmpl.com.google.common.collect.AbstractIndexedListIterator;
import org.rascalmpl.com.google.common.collect.AbstractIterator;
import org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.com.google.common.collect.NullnessCasts;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.com.google.common.collect.PeekingIterator;
import org.rascalmpl.com.google.common.collect.TransformedIterator;
import org.rascalmpl.com.google.common.collect.UnmodifiableIterator;
import org.rascalmpl.com.google.common.collect.UnmodifiableListIterator;
import org.rascalmpl.com.google.common.primitives.Ints;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.IndexOutOfBoundsException;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.SafeVarargs;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.ArrayDeque;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.Deque;
import org.rascalmpl.java.util.Enumeration;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Queue;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.NonNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Iterators
extends org.rascalmpl.java.lang.Object {
    private Iterators() {
    }

    static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<T> emptyIterator() {
        return Iterators.emptyListIterator();
    }

    static <T extends org.rascalmpl.java.lang.Object> UnmodifiableListIterator<T> emptyListIterator() {
        return ArrayItr.EMPTY;
    }

    static <T extends org.rascalmpl.java.lang.Object> Iterator<T> emptyModifiableIterator() {
        return EmptyModifiableIterator.INSTANCE;
    }

    public static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<T> unmodifiableIterator(final Iterator<? extends T> iterator) {
        Preconditions.checkNotNull(iterator);
        if (iterator instanceof UnmodifiableIterator) {
            UnmodifiableIterator result = (UnmodifiableIterator)iterator;
            return result;
        }
        return new UnmodifiableIterator<T>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            @ParametricNullness
            public T next() {
                return iterator.next();
            }
        };
    }

    @Deprecated
    public static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<T> unmodifiableIterator(UnmodifiableIterator<T> iterator) {
        return Preconditions.checkNotNull(iterator);
    }

    public static int size(Iterator<?> iterator) {
        long count = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return Ints.saturatedCast(count);
    }

    public static boolean contains(Iterator<?> iterator, @CheckForNull org.rascalmpl.java.lang.Object element) {
        if (element == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!element.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    @CanIgnoreReturnValue
    public static boolean removeAll(Iterator<?> removeFrom, Collection<?> elementsToRemove) {
        Preconditions.checkNotNull(elementsToRemove);
        boolean result = false;
        while (removeFrom.hasNext()) {
            if (!elementsToRemove.contains(removeFrom.next())) continue;
            removeFrom.remove();
            result = true;
        }
        return result;
    }

    @CanIgnoreReturnValue
    public static <T extends org.rascalmpl.java.lang.Object> boolean removeIf(Iterator<T> removeFrom, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        boolean modified = false;
        while (removeFrom.hasNext()) {
            if (!predicate.apply(removeFrom.next())) continue;
            removeFrom.remove();
            modified = true;
        }
        return modified;
    }

    @CanIgnoreReturnValue
    public static boolean retainAll(Iterator<?> removeFrom, Collection<?> elementsToRetain) {
        Preconditions.checkNotNull(elementsToRetain);
        boolean result = false;
        while (removeFrom.hasNext()) {
            if (elementsToRetain.contains(removeFrom.next())) continue;
            removeFrom.remove();
            result = true;
        }
        return result;
    }

    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext()) {
            org.rascalmpl.java.lang.Object o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            org.rascalmpl.java.lang.Object o1 = iterator1.next();
            if (org.rascalmpl.com.google.common.base.Objects.equal(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterator<?> iterator) {
        StringBuilder sb = new StringBuilder().append('[');
        boolean first = true;
        while (iterator.hasNext()) {
            if (!first) {
                sb.append((String)"org.rascalmpl., ");
            }
            first = false;
            sb.append(iterator.next());
        }
        return sb.append(']').toString();
    }

    @ParametricNullness
    public static <T extends org.rascalmpl.java.lang.Object> T getOnlyElement(Iterator<T> iterator) {
        org.rascalmpl.java.lang.Object first = iterator.next();
        if (!iterator.hasNext()) {
            return (T)first;
        }
        StringBuilder sb = new StringBuilder().append((String)"org.rascalmpl.expected one element but was: <").append(first);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            sb.append((String)"org.rascalmpl., ").append(iterator.next());
        }
        if (iterator.hasNext()) {
            sb.append((String)"org.rascalmpl., ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(sb.toString());
    }

    @ParametricNullness
    public static <T extends org.rascalmpl.java.lang.Object> T getOnlyElement(Iterator<? extends T> iterator, @ParametricNullness T defaultValue) {
        return iterator.hasNext() ? Iterators.getOnlyElement(iterator) : defaultValue;
    }

    @GwtIncompatible
    public static <T extends org.rascalmpl.java.lang.Object> T[] toArray(Iterator<? extends T> iterator, Class<@NonNull T> type) {
        ArrayList<? extends T> list = Lists.newArrayList(iterator);
        return Iterables.toArray(list, type);
    }

    @CanIgnoreReturnValue
    public static <T extends org.rascalmpl.java.lang.Object> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
        Preconditions.checkNotNull(addTo);
        Preconditions.checkNotNull(iterator);
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return wasModified;
    }

    public static int frequency(Iterator<?> iterator, @CheckForNull org.rascalmpl.java.lang.Object element) {
        int count = 0;
        while (Iterators.contains(iterator, element)) {
            ++count;
        }
        return count;
    }

    public static <T extends org.rascalmpl.java.lang.Object> Iterator<T> cycle(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Iterator<T>(){
            Iterator<T> iterator = Iterators.emptyModifiableIterator();

            public boolean hasNext() {
                return this.iterator.hasNext() || iterable.iterator().hasNext();
            }

            @ParametricNullness
            public T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                    if (!this.iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                return this.iterator.next();
            }

            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @SafeVarargs
    public static <T extends org.rascalmpl.java.lang.Object> Iterator<T> cycle(T ... elements) {
        return Iterators.cycle(Lists.newArrayList(elements));
    }

    private static <I extends Iterator<?>> Iterator<I> consumingForArray(I ... elements) {
        return new UnmodifiableIterator<I>((Iterator[])elements){
            int index = 0;
            final /* synthetic */ Iterator[] val$elements;
            {
                this.val$elements = iteratorArray;
            }

            public boolean hasNext() {
                return this.index < this.val$elements.length;
            }

            public I next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Iterator result = (Iterator)Objects.requireNonNull((org.rascalmpl.java.lang.Object)this.val$elements[this.index]);
                this.val$elements[this.index] = null;
                ++this.index;
                return result;
            }
        };
    }

    public static <T extends org.rascalmpl.java.lang.Object> Iterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b) {
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        return Iterators.concat(Iterators.consumingForArray((Iterator[])new Iterator[]{a, b}));
    }

    public static <T extends org.rascalmpl.java.lang.Object> Iterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b, Iterator<? extends T> c) {
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        Preconditions.checkNotNull(c);
        return Iterators.concat(Iterators.consumingForArray((Iterator[])new Iterator[]{a, b, c}));
    }

    public static <T extends org.rascalmpl.java.lang.Object> Iterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b, Iterator<? extends T> c, Iterator<? extends T> d) {
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(d);
        return Iterators.concat(Iterators.consumingForArray((Iterator[])new Iterator[]{a, b, c, d}));
    }

    @SafeVarargs
    public static <T extends org.rascalmpl.java.lang.Object> Iterator<T> concat(Iterator<? extends T> ... inputs) {
        return Iterators.concatNoDefensiveCopy((Iterator[])Arrays.copyOf(inputs, (int)inputs.length));
    }

    public static <T extends org.rascalmpl.java.lang.Object> Iterator<T> concat(Iterator<? extends Iterator<? extends T>> inputs) {
        return new ConcatenatedIterator(inputs);
    }

    static <T extends org.rascalmpl.java.lang.Object> Iterator<T> concatNoDefensiveCopy(Iterator<? extends T> ... inputs) {
        for (Iterator<? extends T> input : Preconditions.checkNotNull(inputs)) {
            Preconditions.checkNotNull(input);
        }
        return Iterators.concat(Iterators.consumingForArray(inputs));
    }

    public static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<List<T>> partition(Iterator<T> iterator, int size) {
        return Iterators.partitionImpl(iterator, size, false);
    }

    public static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<List<@Nullable T>> paddedPartition(Iterator<T> iterator, int size) {
        return Iterators.partitionImpl(iterator, size, true);
    }

    private static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<List<@Nullable T>> partitionImpl(final Iterator<T> iterator, final int size, final boolean pad) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(size > 0);
        return new UnmodifiableIterator<List<T>>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public List<@Nullable T> next() {
                int count;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                @Nullable org.rascalmpl.java.lang.Object[] array = new org.rascalmpl.java.lang.Object[size];
                for (count = 0; count < size && iterator.hasNext(); ++count) {
                    array[count] = iterator.next();
                }
                for (int i = count; i < size; ++i) {
                    array[i] = null;
                }
                @Nullable List list = Collections.unmodifiableList((List)Arrays.asList((org.rascalmpl.java.lang.Object[])array));
                if (pad || count == size) {
                    return list;
                }
                return list.subList(0, count);
            }
        };
    }

    public static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<T> filter(final Iterator<T> unfiltered, final Predicate<? super T> retainIfTrue) {
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(retainIfTrue);
        return new AbstractIterator<T>(){

            @Override
            @CheckForNull
            protected T computeNext() {
                while (unfiltered.hasNext()) {
                    org.rascalmpl.java.lang.Object element = unfiltered.next();
                    if (!retainIfTrue.apply(element)) continue;
                    return element;
                }
                return this.endOfData();
            }
        };
    }

    @GwtIncompatible
    public static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<T> filter(Iterator<?> unfiltered, Class<T> desiredType) {
        return Iterators.filter(unfiltered, Predicates.instanceOf(desiredType));
    }

    public static <T extends org.rascalmpl.java.lang.Object> boolean any(Iterator<T> iterator, Predicate<? super T> predicate) {
        return Iterators.indexOf(iterator, predicate) != -1;
    }

    public static <T extends org.rascalmpl.java.lang.Object> boolean all(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            org.rascalmpl.java.lang.Object element = iterator.next();
            if (predicate.apply(element)) continue;
            return false;
        }
        return true;
    }

    @ParametricNullness
    public static <T extends org.rascalmpl.java.lang.Object> T find(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            org.rascalmpl.java.lang.Object t2 = iterator.next();
            if (!predicate.apply(t2)) continue;
            return (T)t2;
        }
        throw new NoSuchElementException();
    }

    @CheckForNull
    public static <T extends org.rascalmpl.java.lang.Object> T find(Iterator<? extends T> iterator, Predicate<? super T> predicate, @CheckForNull T defaultValue) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            org.rascalmpl.java.lang.Object t2 = iterator.next();
            if (!predicate.apply(t2)) continue;
            return (T)t2;
        }
        return defaultValue;
    }

    public static <T extends org.rascalmpl.java.lang.Object> Optional<T> tryFind(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            org.rascalmpl.java.lang.Object t2 = iterator.next();
            if (!predicate.apply(t2)) continue;
            return Optional.of(t2);
        }
        return Optional.absent();
    }

    public static <T extends org.rascalmpl.java.lang.Object> int indexOf(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate, (org.rascalmpl.java.lang.Object)"org.rascalmpl.predicate");
        int i = 0;
        while (iterator.hasNext()) {
            org.rascalmpl.java.lang.Object current = iterator.next();
            if (predicate.apply(current)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <F extends org.rascalmpl.java.lang.Object, T extends org.rascalmpl.java.lang.Object> Iterator<T> transform(Iterator<F> fromIterator, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(function);
        return new TransformedIterator<F, T>(fromIterator){

            @Override
            @ParametricNullness
            T transform(@ParametricNullness F from) {
                return function.apply(from);
            }
        };
    }

    @ParametricNullness
    public static <T extends org.rascalmpl.java.lang.Object> T get(Iterator<T> iterator, int position) {
        Iterators.checkNonnegative(position);
        int skipped = Iterators.advance(iterator, position);
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException(new StringBuilder().append((String)"org.rascalmpl.position (").append(position).append((String)"org.rascalmpl.) must be less than the number of elements that remained (").append(skipped).append((String)"org.rascalmpl.)").toString());
        }
        return (T)iterator.next();
    }

    @ParametricNullness
    public static <T extends org.rascalmpl.java.lang.Object> T get(Iterator<? extends T> iterator, int position, @ParametricNullness T defaultValue) {
        Iterators.checkNonnegative(position);
        Iterators.advance(iterator, position);
        return Iterators.getNext(iterator, defaultValue);
    }

    static void checkNonnegative(int position) {
        if (position < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder().append((String)"org.rascalmpl.position (").append(position).append((String)"org.rascalmpl.) must not be negative").toString());
        }
    }

    @ParametricNullness
    public static <T extends org.rascalmpl.java.lang.Object> T getNext(Iterator<? extends T> iterator, @ParametricNullness T defaultValue) {
        return (T)(iterator.hasNext() ? iterator.next() : defaultValue);
    }

    @ParametricNullness
    public static <T extends org.rascalmpl.java.lang.Object> T getLast(Iterator<T> iterator) {
        org.rascalmpl.java.lang.Object current;
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return (T)current;
    }

    @ParametricNullness
    public static <T extends org.rascalmpl.java.lang.Object> T getLast(Iterator<? extends T> iterator, @ParametricNullness T defaultValue) {
        return iterator.hasNext() ? Iterators.getLast(iterator) : defaultValue;
    }

    @CanIgnoreReturnValue
    public static int advance(Iterator<?> iterator, int numberToAdvance) {
        int i;
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(numberToAdvance >= 0, (org.rascalmpl.java.lang.Object)"org.rascalmpl.numberToAdvance must be nonnegative");
        for (i = 0; i < numberToAdvance && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return i;
    }

    public static <T extends org.rascalmpl.java.lang.Object> Iterator<T> limit(final Iterator<T> iterator, final int limitSize) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(limitSize >= 0, (org.rascalmpl.java.lang.Object)"org.rascalmpl.limit is negative");
        return new Iterator<T>(){
            private int count;

            public boolean hasNext() {
                return this.count < limitSize && iterator.hasNext();
            }

            @ParametricNullness
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return iterator.next();
            }

            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T extends org.rascalmpl.java.lang.Object> Iterator<T> consumingIterator(final Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator);
        return new UnmodifiableIterator<T>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            @ParametricNullness
            public T next() {
                org.rascalmpl.java.lang.Object next = iterator.next();
                iterator.remove();
                return next;
            }

            public String toString() {
                return "org.rascalmpl.Iterators.consumingIterator(...)";
            }
        };
    }

    @CheckForNull
    static <T extends org.rascalmpl.java.lang.Object> T pollNext(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            org.rascalmpl.java.lang.Object result = iterator.next();
            iterator.remove();
            return (T)result;
        }
        return null;
    }

    static void clear(Iterator<?> iterator) {
        Preconditions.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @SafeVarargs
    public static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<T> forArray(T ... array) {
        return Iterators.forArrayWithPosition(array, (int)0);
    }

    static <T extends org.rascalmpl.java.lang.Object> UnmodifiableListIterator<T> forArrayWithPosition(T[] array, int position) {
        if (array.length == 0) {
            Preconditions.checkPositionIndex(position, array.length);
            return Iterators.emptyListIterator();
        }
        return new ArrayItr(array, position);
    }

    public static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<T> singletonIterator(@ParametricNullness T value) {
        return new SingletonIterator<T>(value);
    }

    public static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<T> forEnumeration(final Enumeration<T> enumeration) {
        Preconditions.checkNotNull(enumeration);
        return new UnmodifiableIterator<T>(){

            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @ParametricNullness
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T extends org.rascalmpl.java.lang.Object> Enumeration<T> asEnumeration(final Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator);
        return new Enumeration<T>(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @ParametricNullness
            public T nextElement() {
                return iterator.next();
            }
        };
    }

    public static <T extends org.rascalmpl.java.lang.Object> PeekingIterator<T> peekingIterator(Iterator<? extends T> iterator) {
        if (iterator instanceof PeekingImpl) {
            PeekingImpl peeking = (PeekingImpl)iterator;
            return peeking;
        }
        return new PeekingImpl<T>(iterator);
    }

    @Deprecated
    public static <T extends org.rascalmpl.java.lang.Object> PeekingIterator<T> peekingIterator(PeekingIterator<T> iterator) {
        return Preconditions.checkNotNull(iterator);
    }

    public static <T extends org.rascalmpl.java.lang.Object> UnmodifiableIterator<T> mergeSorted(Iterable<? extends Iterator<? extends T>> iterators, Comparator<? super T> comparator) {
        Preconditions.checkNotNull(iterators, (org.rascalmpl.java.lang.Object)"org.rascalmpl.iterators");
        Preconditions.checkNotNull(comparator, (org.rascalmpl.java.lang.Object)"org.rascalmpl.comparator");
        return new MergingIterator<T>(iterators, comparator);
    }

    private static class ConcatenatedIterator<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Iterator<T> {
        @CheckForNull
        private Iterator<? extends T> toRemove;
        private Iterator<? extends T> iterator = Iterators.emptyIterator();
        @CheckForNull
        private Iterator<? extends Iterator<? extends T>> topMetaIterator;
        @CheckForNull
        private Deque<Iterator<? extends Iterator<? extends T>>> metaIterators;

        ConcatenatedIterator(Iterator<? extends Iterator<? extends T>> metaIterator) {
            this.topMetaIterator = Preconditions.checkNotNull(metaIterator);
        }

        @CheckForNull
        private Iterator<? extends Iterator<? extends T>> getTopMetaIterator() {
            while (this.topMetaIterator == null || !this.topMetaIterator.hasNext()) {
                if (this.metaIterators != null && !this.metaIterators.isEmpty()) {
                    this.topMetaIterator = (Iterator)this.metaIterators.removeFirst();
                    continue;
                }
                return null;
            }
            return this.topMetaIterator;
        }

        public boolean hasNext() {
            while (!Preconditions.checkNotNull(this.iterator).hasNext()) {
                this.topMetaIterator = this.getTopMetaIterator();
                if (this.topMetaIterator == null) {
                    return false;
                }
                this.iterator = (Iterator)this.topMetaIterator.next();
                if (!(this.iterator instanceof ConcatenatedIterator)) continue;
                ConcatenatedIterator topConcat = (ConcatenatedIterator)this.iterator;
                this.iterator = topConcat.iterator;
                if (this.metaIterators == null) {
                    this.metaIterators = new ArrayDeque();
                }
                this.metaIterators.addFirst(this.topMetaIterator);
                if (topConcat.metaIterators != null) {
                    while (!topConcat.metaIterators.isEmpty()) {
                        this.metaIterators.addFirst((org.rascalmpl.java.lang.Object)((Iterator)topConcat.metaIterators.removeLast()));
                    }
                }
                this.topMetaIterator = topConcat.topMetaIterator;
            }
            return true;
        }

        @ParametricNullness
        public T next() {
            if (this.hasNext()) {
                this.toRemove = this.iterator;
                return (T)this.iterator.next();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.toRemove == null) {
                throw new IllegalStateException((String)"org.rascalmpl.no calls to next() since the last call to remove()");
            }
            this.toRemove.remove();
            this.toRemove = null;
        }
    }

    private static class MergingIterator<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends UnmodifiableIterator<T> {
        final Queue<PeekingIterator<T>> queue;

        /*
         * Exception decompiling
         */
        public MergingIterator(Iterable<? extends Iterator<? extends T>> iterators, Comparator<? super T> itemComparator) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;Lorg/rascalmpl/java/lang/Object;)I
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @ParametricNullness
        public T next() {
            PeekingIterator nextIter = (PeekingIterator)this.queue.remove();
            Object next = nextIter.next();
            if (nextIter.hasNext()) {
                this.queue.add((org.rascalmpl.java.lang.Object)nextIter);
            }
            return (T)next;
        }

        private static /* synthetic */ int lambda$new$0(Comparator itemComparator, PeekingIterator o1, PeekingIterator o2) {
            return itemComparator.compare(o1.peek(), o2.peek());
        }
    }

    private static class PeekingImpl<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements PeekingIterator<E> {
        private final Iterator<? extends E> iterator;
        private boolean hasPeeked;
        @CheckForNull
        private E peekedElement;

        public PeekingImpl(Iterator<? extends E> iterator) {
            this.iterator = Preconditions.checkNotNull(iterator);
        }

        public boolean hasNext() {
            return this.hasPeeked || this.iterator.hasNext();
        }

        @Override
        @ParametricNullness
        public E next() {
            if (!this.hasPeeked) {
                return (E)this.iterator.next();
            }
            E result = NullnessCasts.uncheckedCastNullableTToT(this.peekedElement);
            this.hasPeeked = false;
            this.peekedElement = null;
            return result;
        }

        @Override
        public void remove() {
            Preconditions.checkState(!this.hasPeeked, (org.rascalmpl.java.lang.Object)"org.rascalmpl.Can't remove after you've peeked at next");
            this.iterator.remove();
        }

        @Override
        @ParametricNullness
        public E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.iterator.next();
                this.hasPeeked = true;
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.peekedElement);
        }
    }

    private static final class SingletonIterator<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends UnmodifiableIterator<T> {
        private final T value;
        private boolean done;

        SingletonIterator(T value) {
            this.value = value;
        }

        public boolean hasNext() {
            return !this.done;
        }

        @ParametricNullness
        public T next() {
            if (this.done) {
                throw new NoSuchElementException();
            }
            this.done = true;
            return this.value;
        }
    }

    private static final class ArrayItr<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends AbstractIndexedListIterator<T> {
        static final UnmodifiableListIterator<org.rascalmpl.java.lang.Object> EMPTY = new ArrayItr(new org.rascalmpl.java.lang.Object[0], 0);
        private final T[] array;

        ArrayItr(T[] array, int position) {
            super(array.length, position);
            this.array = array;
        }

        @Override
        @ParametricNullness
        protected T get(int index) {
            return this.array[index];
        }
    }

    private static final class EmptyModifiableIterator
    extends Enum<EmptyModifiableIterator>
    implements Iterator<org.rascalmpl.java.lang.Object> {
        public static final /* enum */ EmptyModifiableIterator INSTANCE = new EmptyModifiableIterator((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ EmptyModifiableIterator[] $VALUES;

        public static EmptyModifiableIterator[] values() {
            return (EmptyModifiableIterator[])$VALUES.clone();
        }

        public static EmptyModifiableIterator valueOf(String name) {
            return (EmptyModifiableIterator)Enum.valueOf(EmptyModifiableIterator.class, (String)name);
        }

        private EmptyModifiableIterator() {
            super((String)string, n);
        }

        public boolean hasNext() {
            return false;
        }

        public org.rascalmpl.java.lang.Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            CollectPreconditions.checkRemove(false);
        }

        static {
            $VALUES = new EmptyModifiableIterator[]{INSTANCE};
        }
    }
}

