/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.ImmutableMultiset;
import org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.Multiset;
import org.rascalmpl.com.google.common.collect.Multisets;
import org.rascalmpl.com.google.common.primitives.Ints;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class JdkBackedImmutableMultiset<E extends Object>
extends ImmutableMultiset<E> {
    private final Map<E, Integer> delegateMap;
    private final ImmutableList<Multiset.Entry<E>> entries;
    private final long size;
    @LazyInit
    @CheckForNull
    private transient ImmutableSet<E> elementSet;

    static <E extends Object> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> entries) {
        Object[] entriesArray = (Multiset.Entry[])entries.toArray((Object[])new Multiset.Entry[0]);
        HashMap delegateMap = Maps.newHashMapWithExpectedSize(entriesArray.length);
        long size = 0L;
        for (int i = 0; i < entriesArray.length; ++i) {
            Multiset.Entry entry = entriesArray[i];
            int count = entry.getCount();
            size += (long)count;
            java.lang.Object element = Preconditions.checkNotNull(entry.getElement());
            delegateMap.put(element, (Object)Integer.valueOf((int)count));
            if (entry instanceof Multisets.ImmutableEntry) continue;
            entriesArray[i] = Multisets.immutableEntry(element, count);
        }
        return new JdkBackedImmutableMultiset(delegateMap, ImmutableList.asImmutableList(entriesArray), size);
    }

    private JdkBackedImmutableMultiset(Map<E, Integer> delegateMap, ImmutableList<Multiset.Entry<E>> entries, long size) {
        this.delegateMap = delegateMap;
        this.entries = entries;
        this.size = size;
    }

    @Override
    public int count(@CheckForNull Object element) {
        return ((Integer)this.delegateMap.getOrDefault(element, (Object)Integer.valueOf((int)0))).intValue();
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ImmutableSet<E> result = this.elementSet;
        return result == null ? (this.elementSet = new ImmutableMultiset.ElementSet<E>(this.entries, this)) : result;
    }

    @Override
    Multiset.Entry<E> getEntry(int index) {
        return (Multiset.Entry)this.entries.get(index);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

