/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.AbstractMapEntry;
import org.rascalmpl.com.google.common.collect.AbstractMultimap;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.com.google.common.collect.ListMultimap;
import org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.Multimap;
import org.rascalmpl.com.google.common.collect.Multimaps;
import org.rascalmpl.com.google.common.collect.Multiset;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.com.google.common.collect.Platform;
import org.rascalmpl.com.google.common.collect.Sets;
import org.rascalmpl.com.google.common.collect.TransformedListIterator;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.java.io.ObjectOutputStream;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.AbstractSequentialList;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.ConcurrentModificationException;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.ListIterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public class LinkedListMultimap<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
extends AbstractMultimap<K, V>
implements ListMultimap<K, V>,
Serializable {
    @CheckForNull
    private transient Node<K, V> head;
    @CheckForNull
    private transient Node<K, V> tail;
    private transient Map<K, KeyList<K, V>> keyToKeyList;
    private transient int size;
    private transient int modCount;
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> LinkedListMultimap<K, V> create() {
        return new LinkedListMultimap<K, V>();
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> LinkedListMultimap<K, V> create(int expectedKeys) {
        return new LinkedListMultimap<K, V>(expectedKeys);
    }

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> LinkedListMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        return new LinkedListMultimap<K, V>(multimap);
    }

    LinkedListMultimap() {
        this(12);
    }

    private LinkedListMultimap(int expectedKeys) {
        this.keyToKeyList = Platform.newHashMapWithExpectedSize(expectedKeys);
    }

    private LinkedListMultimap(Multimap<? extends K, ? extends V> multimap) {
        this(multimap.keySet().size());
        this.putAll((Multimap)multimap);
    }

    @CanIgnoreReturnValue
    private Node<K, V> addNode(@ParametricNullness K key, @ParametricNullness V value, @CheckForNull Node<K, V> nextSibling) {
        Node<K, V> node = new Node<K, V>(key, value);
        if (this.head == null) {
            this.tail = node;
            this.head = this.tail;
            this.keyToKeyList.put(key, new KeyList<K, V>(node));
            ++this.modCount;
        } else if (nextSibling == null) {
            ((Node)Objects.requireNonNull(this.tail)).next = node;
            node.previous = this.tail;
            this.tail = node;
            KeyList<K, V> keyList = (KeyList<K, V>)this.keyToKeyList.get(key);
            if (keyList == null) {
                keyList = new KeyList<K, V>(node);
                this.keyToKeyList.put(key, keyList);
                ++this.modCount;
            } else {
                ++keyList.count;
                Node keyTail = keyList.tail;
                keyTail.nextSibling = node;
                node.previousSibling = keyTail;
                keyList.tail = node;
            }
        } else {
            KeyList keyList = (KeyList)Objects.requireNonNull((org.rascalmpl.java.lang.Object)((KeyList)this.keyToKeyList.get(key)));
            ++keyList.count;
            node.previous = nextSibling.previous;
            node.previousSibling = nextSibling.previousSibling;
            node.next = nextSibling;
            node.nextSibling = nextSibling;
            if (nextSibling.previousSibling == null) {
                keyList.head = node;
            } else {
                nextSibling.previousSibling.nextSibling = node;
            }
            if (nextSibling.previous == null) {
                this.head = node;
            } else {
                nextSibling.previous.next = node;
            }
            nextSibling.previous = node;
            nextSibling.previousSibling = node;
        }
        ++this.size;
        return node;
    }

    private void removeNode(Node<K, V> node) {
        if (node.previous != null) {
            node.previous.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.previous = node.previous;
        } else {
            this.tail = node.previous;
        }
        if (node.previousSibling == null && node.nextSibling == null) {
            KeyList keyList = (KeyList)Objects.requireNonNull((org.rascalmpl.java.lang.Object)((KeyList)this.keyToKeyList.remove(node.key)));
            keyList.count = 0;
            ++this.modCount;
        } else {
            KeyList keyList = (KeyList)Objects.requireNonNull((org.rascalmpl.java.lang.Object)((KeyList)this.keyToKeyList.get(node.key)));
            --keyList.count;
            if (node.previousSibling == null) {
                keyList.head = (Node)Objects.requireNonNull(node.nextSibling);
            } else {
                node.previousSibling.nextSibling = node.nextSibling;
            }
            if (node.nextSibling == null) {
                keyList.tail = (Node)Objects.requireNonNull(node.previousSibling);
            } else {
                node.nextSibling.previousSibling = node.previousSibling;
            }
        }
        --this.size;
    }

    private void removeAllNodes(@ParametricNullness K key) {
        Iterators.clear(new ValueForKeyIterator(this, key));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public boolean containsKey(@CheckForNull org.rascalmpl.java.lang.Object key) {
        return this.keyToKeyList.containsKey(key);
    }

    @Override
    public boolean containsValue(@CheckForNull org.rascalmpl.java.lang.Object value) {
        return this.values().contains(value);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean put(@ParametricNullness K key, @ParametricNullness V value) {
        this.addNode(key, value, null);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public List<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        List<V> oldValues = this.getCopy(key);
        ValueForKeyIterator keyValues = new ValueForKeyIterator(this, key);
        Iterator newValues = values.iterator();
        while (keyValues.hasNext() && newValues.hasNext()) {
            keyValues.next();
            keyValues.set(newValues.next());
        }
        while (keyValues.hasNext()) {
            keyValues.next();
            keyValues.remove();
        }
        while (newValues.hasNext()) {
            keyValues.add(newValues.next());
        }
        return oldValues;
    }

    private List<V> getCopy(@ParametricNullness K key) {
        return Collections.unmodifiableList(Lists.newArrayList(new ValueForKeyIterator(this, key)));
    }

    @Override
    @CanIgnoreReturnValue
    public List<V> removeAll(@CheckForNull org.rascalmpl.java.lang.Object key) {
        org.rascalmpl.java.lang.Object castKey = key;
        List<V> oldValues = this.getCopy(castKey);
        this.removeAllNodes(castKey);
        return oldValues;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.keyToKeyList.clear();
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public List<V> get(@ParametricNullness K key) {
        return new AbstractSequentialList<V>((org.rascalmpl.java.lang.Object)key){
            final /* synthetic */ org.rascalmpl.java.lang.Object val$key;
            {
                this.val$key = object;
            }

            public int size() {
                KeyList keyList = (KeyList)LinkedListMultimap.this.keyToKeyList.get(this.val$key);
                return keyList == null ? 0 : keyList.count;
            }

            public ListIterator<V> listIterator(int index) {
                return new ValueForKeyIterator(LinkedListMultimap.this, this.val$key, index);
            }
        };
    }

    @Override
    Set<K> createKeySet() {
        class KeySetImpl
        extends Sets.ImprovedAbstractSet<K> {
            KeySetImpl() {
            }

            public int size() {
                return LinkedListMultimap.this.keyToKeyList.size();
            }

            public Iterator<K> iterator() {
                return new DistinctKeyIterator();
            }

            public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object key) {
                return LinkedListMultimap.this.containsKey(key);
            }

            public boolean remove(@CheckForNull org.rascalmpl.java.lang.Object o) {
                return !LinkedListMultimap.this.removeAll(o).isEmpty();
            }
        }
        return new KeySetImpl();
    }

    @Override
    Multiset<K> createKeys() {
        return new Multimaps.Keys(this);
    }

    @Override
    public List<V> values() {
        return (List)super.values();
    }

    @Override
    List<V> createValues() {
        class ValuesImpl
        extends AbstractSequentialList<V> {
            ValuesImpl() {
            }

            public int size() {
                return LinkedListMultimap.this.size;
            }

            public ListIterator<V> listIterator(int index) {
                final NodeIterator nodeItr = new NodeIterator(index);
                return new TransformedListIterator<Map.Entry<K, V>, V>(nodeItr){

                    @Override
                    @ParametricNullness
                    V transform(Map.Entry<K, V> entry) {
                        return entry.getValue();
                    }

                    @Override
                    public void set(@ParametricNullness V value) {
                        nodeItr.setValue(value);
                    }
                };
            }
        }
        return new ValuesImpl();
    }

    @Override
    public List<Map.Entry<K, V>> entries() {
        return (List)super.entries();
    }

    @Override
    List<Map.Entry<K, V>> createEntries() {
        class EntriesImpl
        extends AbstractSequentialList<Map.Entry<K, V>> {
            EntriesImpl() {
            }

            public int size() {
                return LinkedListMultimap.this.size;
            }

            public ListIterator<Map.Entry<K, V>> listIterator(int index) {
                return new NodeIterator(index);
            }

            public void forEach(Consumer<? super Map.Entry<K, V>> action) {
                Preconditions.checkNotNull(action);
                Node node = LinkedListMultimap.this.head;
                while (node != null) {
                    action.accept((org.rascalmpl.java.lang.Object)node);
                    node = node.next;
                }
            }
        }
        return new EntriesImpl();
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        throw new AssertionError((org.rascalmpl.java.lang.Object)"org.rascalmpl.should never be called");
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return new Multimaps.AsMap(this);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        for (Map.Entry entry : this.entries()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.keyToKeyList = Maps.newLinkedHashMap();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            org.rascalmpl.java.lang.Object key = stream.readObject();
            org.rascalmpl.java.lang.Object value = stream.readObject();
            this.put(key, value);
        }
    }

    private class ValueForKeyIterator
    extends org.rascalmpl.java.lang.Object
    implements ListIterator<V> {
        @ParametricNullness
        final K key;
        int nextIndex;
        @CheckForNull
        Node<K, V> next;
        @CheckForNull
        Node<K, V> current;
        @CheckForNull
        Node<K, V> previous;
        final /* synthetic */ LinkedListMultimap this$0;

        ValueForKeyIterator(K key) {
            this.this$0 = var1_1;
            this.key = key;
            KeyList keyList = (KeyList)((LinkedListMultimap)var1_1).keyToKeyList.get(key);
            this.next = keyList == null ? null : keyList.head;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public ValueForKeyIterator(K key, int index) {
            this.this$0 = (LinkedListMultimap)n;
            KeyList keyList = (KeyList)((LinkedListMultimap)n).keyToKeyList.get(key);
            int size = keyList == null ? 0 : keyList.count;
            Preconditions.checkPositionIndex(index, size);
            if (index >= size / 2) {
                this.previous = keyList == null ? null : keyList.tail;
                this.nextIndex = size;
                while (index++ < size) {
                    this.previous();
                }
            } else {
                Node node = this.next = keyList == null ? null : keyList.head;
                while (index-- > 0) {
                    this.next();
                }
            }
            this.key = key;
            this.current = null;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        @ParametricNullness
        @CanIgnoreReturnValue
        public V next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.previous = this.current;
            this.next = this.next.nextSibling;
            ++this.nextIndex;
            return this.current.value;
        }

        public boolean hasPrevious() {
            return this.previous != null;
        }

        @ParametricNullness
        @CanIgnoreReturnValue
        public V previous() {
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            this.current = this.previous;
            this.next = this.current;
            this.previous = this.previous.previousSibling;
            --this.nextIndex;
            return this.current.value;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void remove() {
            Preconditions.checkState(this.current != null, (org.rascalmpl.java.lang.Object)"org.rascalmpl.no calls to next() since the last call to remove()");
            if (this.current != this.next) {
                this.previous = this.current.previousSibling;
                --this.nextIndex;
            } else {
                this.next = this.current.nextSibling;
            }
            this.this$0.removeNode(this.current);
            this.current = null;
        }

        public void set(@ParametricNullness V value) {
            Preconditions.checkState(this.current != null);
            this.current.value = value;
        }

        public void add(@ParametricNullness V value) {
            this.previous = this.this$0.addNode(this.key, value, this.next);
            ++this.nextIndex;
            this.current = null;
        }
    }

    private class DistinctKeyIterator
    extends org.rascalmpl.java.lang.Object
    implements Iterator<K> {
        final Set<K> seenKeys;
        @CheckForNull
        Node<K, V> next;
        @CheckForNull
        Node<K, V> current;
        int expectedModCount;

        private DistinctKeyIterator() {
            this.seenKeys = Sets.newHashSetWithExpectedSize(LinkedListMultimap.this.keySet().size());
            this.next = LinkedListMultimap.this.head;
            this.expectedModCount = LinkedListMultimap.this.modCount;
        }

        private void checkForConcurrentModification() {
            if (LinkedListMultimap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            this.checkForConcurrentModification();
            return this.next != null;
        }

        @ParametricNullness
        public K next() {
            this.checkForConcurrentModification();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.seenKeys.add(this.current.key);
            do {
                this.next = this.next.next;
            } while (this.next != null && !this.seenKeys.add(this.next.key));
            return this.current.key;
        }

        public void remove() {
            this.checkForConcurrentModification();
            Preconditions.checkState(this.current != null, (org.rascalmpl.java.lang.Object)"org.rascalmpl.no calls to next() since the last call to remove()");
            LinkedListMultimap.this.removeAllNodes(this.current.key);
            this.current = null;
            this.expectedModCount = LinkedListMultimap.this.modCount;
        }
    }

    private class NodeIterator
    extends org.rascalmpl.java.lang.Object
    implements ListIterator<Map.Entry<K, V>> {
        int nextIndex;
        @CheckForNull
        Node<K, V> next;
        @CheckForNull
        Node<K, V> current;
        @CheckForNull
        Node<K, V> previous;
        int expectedModCount;

        NodeIterator(int index) {
            this.expectedModCount = LinkedListMultimap.this.modCount;
            int size = LinkedListMultimap.this.size();
            Preconditions.checkPositionIndex(index, size);
            if (index >= size / 2) {
                this.previous = LinkedListMultimap.this.tail;
                this.nextIndex = size;
                while (index++ < size) {
                    this.previous();
                }
            } else {
                this.next = LinkedListMultimap.this.head;
                while (index-- > 0) {
                    this.next();
                }
            }
            this.current = null;
        }

        private void checkForConcurrentModification() {
            if (LinkedListMultimap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            this.checkForConcurrentModification();
            return this.next != null;
        }

        @CanIgnoreReturnValue
        public Node<K, V> next() {
            this.checkForConcurrentModification();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.previous = this.current;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.current;
        }

        public void remove() {
            this.checkForConcurrentModification();
            Preconditions.checkState(this.current != null, (org.rascalmpl.java.lang.Object)"org.rascalmpl.no calls to next() since the last call to remove()");
            if (this.current != this.next) {
                this.previous = this.current.previous;
                --this.nextIndex;
            } else {
                this.next = this.current.next;
            }
            LinkedListMultimap.this.removeNode(this.current);
            this.current = null;
            this.expectedModCount = LinkedListMultimap.this.modCount;
        }

        public boolean hasPrevious() {
            this.checkForConcurrentModification();
            return this.previous != null;
        }

        @CanIgnoreReturnValue
        public Node<K, V> previous() {
            this.checkForConcurrentModification();
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            this.current = this.previous;
            this.next = this.current;
            this.previous = this.previous.previous;
            --this.nextIndex;
            return this.current;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void set(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        public void add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        void setValue(@ParametricNullness V value) {
            Preconditions.checkState(this.current != null);
            this.current.value = value;
        }
    }

    private static class KeyList<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object {
        Node<K, V> head;
        Node<K, V> tail;
        int count;

        KeyList(Node<K, V> firstNode) {
            this.head = firstNode;
            this.tail = firstNode;
            firstNode.previousSibling = null;
            firstNode.nextSibling = null;
            this.count = 1;
        }
    }

    static final class Node<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends AbstractMapEntry<K, V> {
        @ParametricNullness
        final K key;
        @ParametricNullness
        V value;
        @CheckForNull
        Node<K, V> next;
        @CheckForNull
        Node<K, V> previous;
        @CheckForNull
        Node<K, V> nextSibling;
        @CheckForNull
        Node<K, V> previousSibling;

        Node(@ParametricNullness K key, @ParametricNullness V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @ParametricNullness
        public K getKey() {
            return this.key;
        }

        @Override
        @ParametricNullness
        public V getValue() {
            return this.value;
        }

        @Override
        @ParametricNullness
        public V setValue(@ParametricNullness V newValue) {
            V result = this.value;
            this.value = newValue;
            return result;
        }
    }
}

