/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Supplier;
import org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ListMultimap;
import org.rascalmpl.com.google.common.collect.Multimap;
import org.rascalmpl.com.google.common.collect.Multimaps;
import org.rascalmpl.com.google.common.collect.Ordering;
import org.rascalmpl.com.google.common.collect.Platform;
import org.rascalmpl.com.google.common.collect.SetMultimap;
import org.rascalmpl.com.google.common.collect.SortedSetMultimap;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.EnumMap;
import org.rascalmpl.java.util.EnumSet;
import org.rascalmpl.java.util.LinkedList;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.SortedSet;
import org.rascalmpl.java.util.TreeMap;
import org.rascalmpl.java.util.TreeSet;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class MultimapBuilder<K0 extends @Nullable org.rascalmpl.java.lang.Object, V0 extends @Nullable org.rascalmpl.java.lang.Object>
extends org.rascalmpl.java.lang.Object {
    private static final int DEFAULT_EXPECTED_KEYS = 8;

    private MultimapBuilder() {
    }

    public static MultimapBuilderWithKeys<@Nullable org.rascalmpl.java.lang.Object> hashKeys() {
        return MultimapBuilder.hashKeys(8);
    }

    public static MultimapBuilderWithKeys<@Nullable org.rascalmpl.java.lang.Object> hashKeys(final int expectedKeys) {
        CollectPreconditions.checkNonnegative(expectedKeys, (String)"org.rascalmpl.expectedKeys");
        return new MultimapBuilderWithKeys<org.rascalmpl.java.lang.Object>(){

            @Override
            <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Map<K, Collection<V>> createMap() {
                return Platform.newHashMapWithExpectedSize(expectedKeys);
            }
        };
    }

    public static MultimapBuilderWithKeys<@Nullable org.rascalmpl.java.lang.Object> linkedHashKeys() {
        return MultimapBuilder.linkedHashKeys(8);
    }

    public static MultimapBuilderWithKeys<@Nullable org.rascalmpl.java.lang.Object> linkedHashKeys(final int expectedKeys) {
        CollectPreconditions.checkNonnegative(expectedKeys, (String)"org.rascalmpl.expectedKeys");
        return new MultimapBuilderWithKeys<org.rascalmpl.java.lang.Object>(){

            @Override
            <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Map<K, Collection<V>> createMap() {
                return Platform.newLinkedHashMapWithExpectedSize(expectedKeys);
            }
        };
    }

    public static MultimapBuilderWithKeys<Comparable> treeKeys() {
        return MultimapBuilder.treeKeys(Ordering.natural());
    }

    public static <K0 extends org.rascalmpl.java.lang.Object> MultimapBuilderWithKeys<K0> treeKeys(final Comparator<K0> comparator) {
        Preconditions.checkNotNull(comparator);
        return new MultimapBuilderWithKeys<K0>(){

            @Override
            <K extends K0, V extends org.rascalmpl.java.lang.Object> Map<K, Collection<V>> createMap() {
                return new TreeMap(comparator);
            }
        };
    }

    public static <K0 extends Enum<K0>> MultimapBuilderWithKeys<K0> enumKeys(final Class<K0> keyClass) {
        Preconditions.checkNotNull(keyClass);
        return new MultimapBuilderWithKeys<K0>(){

            @Override
            <K extends K0, V extends org.rascalmpl.java.lang.Object> Map<K, Collection<V>> createMap() {
                return new EnumMap(keyClass);
            }
        };
    }

    public abstract <K extends K0, V extends V0> Multimap<K, V> build();

    public <K extends K0, V extends V0> Multimap<K, V> build(Multimap<? extends K, ? extends V> multimap) {
        Multimap<? extends K, ? extends V> result = this.build();
        result.putAll(multimap);
        return result;
    }

    public static abstract class SortedSetMultimapBuilder<K0 extends @Nullable org.rascalmpl.java.lang.Object, V0 extends @Nullable org.rascalmpl.java.lang.Object>
    extends SetMultimapBuilder<K0, V0> {
        SortedSetMultimapBuilder() {
        }

        @Override
        public abstract <K extends K0, V extends V0> SortedSetMultimap<K, V> build();

        @Override
        public <K extends K0, V extends V0> SortedSetMultimap<K, V> build(Multimap<? extends K, ? extends V> multimap) {
            return (SortedSetMultimap)super.build((Multimap)multimap);
        }
    }

    public static abstract class SetMultimapBuilder<K0 extends @Nullable org.rascalmpl.java.lang.Object, V0 extends @Nullable org.rascalmpl.java.lang.Object>
    extends MultimapBuilder<K0, V0> {
        SetMultimapBuilder() {
        }

        @Override
        public abstract <K extends K0, V extends V0> SetMultimap<K, V> build();

        @Override
        public <K extends K0, V extends V0> SetMultimap<K, V> build(Multimap<? extends K, ? extends V> multimap) {
            return (SetMultimap)super.build(multimap);
        }
    }

    public static abstract class ListMultimapBuilder<K0 extends @Nullable org.rascalmpl.java.lang.Object, V0 extends @Nullable org.rascalmpl.java.lang.Object>
    extends MultimapBuilder<K0, V0> {
        ListMultimapBuilder() {
        }

        @Override
        public abstract <K extends K0, V extends V0> ListMultimap<K, V> build();

        @Override
        public <K extends K0, V extends V0> ListMultimap<K, V> build(Multimap<? extends K, ? extends V> multimap) {
            return (ListMultimap)super.build(multimap);
        }
    }

    public static abstract class MultimapBuilderWithKeys<K0 extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object {
        private static final int DEFAULT_EXPECTED_VALUES_PER_KEY = 2;

        MultimapBuilderWithKeys() {
        }

        abstract <K extends K0, V extends org.rascalmpl.java.lang.Object> Map<K, Collection<V>> createMap();

        public ListMultimapBuilder<K0, @Nullable org.rascalmpl.java.lang.Object> arrayListValues() {
            return this.arrayListValues(2);
        }

        public ListMultimapBuilder<K0, @Nullable org.rascalmpl.java.lang.Object> arrayListValues(final int expectedValuesPerKey) {
            CollectPreconditions.checkNonnegative(expectedValuesPerKey, (String)"org.rascalmpl.expectedValuesPerKey");
            return new ListMultimapBuilder<K0, org.rascalmpl.java.lang.Object>(){

                @Override
                public <K extends K0, V extends org.rascalmpl.java.lang.Object> ListMultimap<K, V> build() {
                    return Multimaps.newListMultimap(this.createMap(), new ArrayListSupplier(expectedValuesPerKey));
                }
            };
        }

        public ListMultimapBuilder<K0, @Nullable org.rascalmpl.java.lang.Object> linkedListValues() {
            return new ListMultimapBuilder<K0, org.rascalmpl.java.lang.Object>(){

                @Override
                public <K extends K0, V extends org.rascalmpl.java.lang.Object> ListMultimap<K, V> build() {
                    return Multimaps.newListMultimap(this.createMap(), LinkedListSupplier.instance());
                }
            };
        }

        public SetMultimapBuilder<K0, @Nullable org.rascalmpl.java.lang.Object> hashSetValues() {
            return this.hashSetValues(2);
        }

        public SetMultimapBuilder<K0, @Nullable org.rascalmpl.java.lang.Object> hashSetValues(final int expectedValuesPerKey) {
            CollectPreconditions.checkNonnegative(expectedValuesPerKey, (String)"org.rascalmpl.expectedValuesPerKey");
            return new SetMultimapBuilder<K0, org.rascalmpl.java.lang.Object>(){

                @Override
                public <K extends K0, V extends org.rascalmpl.java.lang.Object> SetMultimap<K, V> build() {
                    return Multimaps.newSetMultimap(this.createMap(), new HashSetSupplier(expectedValuesPerKey));
                }
            };
        }

        public SetMultimapBuilder<K0, @Nullable org.rascalmpl.java.lang.Object> linkedHashSetValues() {
            return this.linkedHashSetValues(2);
        }

        public SetMultimapBuilder<K0, @Nullable org.rascalmpl.java.lang.Object> linkedHashSetValues(final int expectedValuesPerKey) {
            CollectPreconditions.checkNonnegative(expectedValuesPerKey, (String)"org.rascalmpl.expectedValuesPerKey");
            return new SetMultimapBuilder<K0, org.rascalmpl.java.lang.Object>(){

                @Override
                public <K extends K0, V extends org.rascalmpl.java.lang.Object> SetMultimap<K, V> build() {
                    return Multimaps.newSetMultimap(this.createMap(), new LinkedHashSetSupplier(expectedValuesPerKey));
                }
            };
        }

        public SortedSetMultimapBuilder<K0, Comparable> treeSetValues() {
            return this.treeSetValues(Ordering.natural());
        }

        public <V0 extends org.rascalmpl.java.lang.Object> SortedSetMultimapBuilder<K0, V0> treeSetValues(final Comparator<V0> comparator) {
            Preconditions.checkNotNull(comparator, (org.rascalmpl.java.lang.Object)"org.rascalmpl.comparator");
            return new SortedSetMultimapBuilder<K0, V0>(){

                @Override
                public <K extends K0, V extends V0> SortedSetMultimap<K, V> build() {
                    return Multimaps.newSortedSetMultimap(this.createMap(), new TreeSetSupplier(comparator));
                }
            };
        }

        public <V0 extends Enum<V0>> SetMultimapBuilder<K0, V0> enumSetValues(final Class<V0> valueClass) {
            Preconditions.checkNotNull(valueClass, (org.rascalmpl.java.lang.Object)"org.rascalmpl.valueClass");
            return new SetMultimapBuilder<K0, V0>(){

                @Override
                public <K extends K0, V extends V0> SetMultimap<K, V> build() {
                    EnumSetSupplier factory = new EnumSetSupplier(valueClass);
                    return Multimaps.newSetMultimap(this.createMap(), factory);
                }
            };
        }
    }

    private static final class EnumSetSupplier<V extends Enum<V>>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<Set<V>>,
    Serializable {
        private final Class<V> clazz;

        EnumSetSupplier(Class<V> clazz) {
            this.clazz = Preconditions.checkNotNull(clazz);
        }

        @Override
        public Set<V> get() {
            return EnumSet.noneOf(this.clazz);
        }
    }

    private static final class TreeSetSupplier<V extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<SortedSet<V>>,
    Serializable {
        private final Comparator<? super V> comparator;

        TreeSetSupplier(Comparator<? super V> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public SortedSet<V> get() {
            return new TreeSet(this.comparator);
        }
    }

    private static final class LinkedHashSetSupplier<V extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<Set<V>>,
    Serializable {
        private final int expectedValuesPerKey;

        LinkedHashSetSupplier(int expectedValuesPerKey) {
            this.expectedValuesPerKey = CollectPreconditions.checkNonnegative(expectedValuesPerKey, (String)"org.rascalmpl.expectedValuesPerKey");
        }

        @Override
        public Set<V> get() {
            return Platform.newLinkedHashSetWithExpectedSize(this.expectedValuesPerKey);
        }
    }

    private static final class HashSetSupplier<V extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<Set<V>>,
    Serializable {
        private final int expectedValuesPerKey;

        HashSetSupplier(int expectedValuesPerKey) {
            this.expectedValuesPerKey = CollectPreconditions.checkNonnegative(expectedValuesPerKey, (String)"org.rascalmpl.expectedValuesPerKey");
        }

        @Override
        public Set<V> get() {
            return Platform.newHashSetWithExpectedSize(this.expectedValuesPerKey);
        }
    }

    private static final class LinkedListSupplier
    extends Enum<LinkedListSupplier>
    implements Supplier<List<?>> {
        public static final /* enum */ LinkedListSupplier INSTANCE = new LinkedListSupplier((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ LinkedListSupplier[] $VALUES;

        public static LinkedListSupplier[] values() {
            return (LinkedListSupplier[])$VALUES.clone();
        }

        public static LinkedListSupplier valueOf(String name) {
            return (LinkedListSupplier)Enum.valueOf(LinkedListSupplier.class, (String)name);
        }

        private LinkedListSupplier() {
            super((String)string, n);
        }

        public static <V extends org.rascalmpl.java.lang.Object> Supplier<List<V>> instance() {
            LinkedListSupplier result = INSTANCE;
            return result;
        }

        @Override
        public List<?> get() {
            return new LinkedList();
        }

        static {
            $VALUES = new LinkedListSupplier[]{INSTANCE};
        }
    }

    private static final class ArrayListSupplier<V extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Supplier<List<V>>,
    Serializable {
        private final int expectedValuesPerKey;

        ArrayListSupplier(int expectedValuesPerKey) {
            this.expectedValuesPerKey = CollectPreconditions.checkNonnegative(expectedValuesPerKey, (String)"org.rascalmpl.expectedValuesPerKey");
        }

        @Override
        public List<V> get() {
            return new ArrayList(this.expectedValuesPerKey);
        }
    }
}

