/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.AllEqualOrdering;
import org.rascalmpl.com.google.common.collect.ByFunctionOrdering;
import org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.com.google.common.collect.ComparatorOrdering;
import org.rascalmpl.com.google.common.collect.CompoundOrdering;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ExplicitOrdering;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.com.google.common.collect.LexicographicalOrdering;
import org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.com.google.common.collect.MapMaker;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.NaturalOrdering;
import org.rascalmpl.com.google.common.collect.NullsFirstOrdering;
import org.rascalmpl.com.google.common.collect.NullsLastOrdering;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.com.google.common.collect.Platform;
import org.rascalmpl.com.google.common.collect.ReverseOrdering;
import org.rascalmpl.com.google.common.collect.TopKSelector;
import org.rascalmpl.com.google.common.collect.UsingToStringOrdering;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.ClassCastException;
import org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.ConcurrentMap;
import org.rascalmpl.java.util.concurrent.atomic.AtomicInteger;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class Ordering<T extends @Nullable org.rascalmpl.java.lang.Object>
extends org.rascalmpl.java.lang.Object
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    @GwtCompatible(serializable=true)
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static <T extends org.rascalmpl.java.lang.Object> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    @Deprecated
    @GwtCompatible(serializable=true)
    public static <T extends org.rascalmpl.java.lang.Object> Ordering<T> from(Ordering<T> ordering) {
        return Preconditions.checkNotNull(ordering);
    }

    @GwtCompatible(serializable=true)
    public static <T extends org.rascalmpl.java.lang.Object> Ordering<T> explicit(List<T> valuesInOrder) {
        return new ExplicitOrdering<T>(valuesInOrder);
    }

    @GwtCompatible(serializable=true)
    public static <T extends org.rascalmpl.java.lang.Object> Ordering<T> explicit(T leastValue, T ... remainingValuesInOrder) {
        return Ordering.explicit(Lists.asList(leastValue, remainingValuesInOrder));
    }

    @GwtCompatible(serializable=true)
    public static Ordering<@Nullable org.rascalmpl.java.lang.Object> allEqual() {
        return AllEqualOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static Ordering<org.rascalmpl.java.lang.Object> usingToString() {
        return UsingToStringOrdering.INSTANCE;
    }

    @J2ktIncompatible
    public static Ordering<@Nullable org.rascalmpl.java.lang.Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    protected Ordering() {
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<@Nullable S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<@Nullable S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <F extends org.rascalmpl.java.lang.Object> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    @GwtCompatible(serializable=true)
    public <U extends T> Ordering<U> compound(Comparator<? super U> secondaryComparator) {
        return new CompoundOrdering<U>(this, Preconditions.checkNotNull(secondaryComparator));
    }

    @GwtCompatible(serializable=true)
    public static <T extends org.rascalmpl.java.lang.Object> Ordering<T> compound(Iterable<? extends Comparator<? super T>> comparators) {
        return new CompoundOrdering(comparators);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    public abstract int compare(@ParametricNullness T var1, @ParametricNullness T var2);

    @ParametricNullness
    public <E extends T> E min(Iterator<E> iterator) {
        org.rascalmpl.java.lang.Object minSoFar = iterator.next();
        while (iterator.hasNext()) {
            minSoFar = this.min(minSoFar, iterator.next());
        }
        return (E)minSoFar;
    }

    @ParametricNullness
    public <E extends T> E min(Iterable<E> iterable) {
        return this.min(iterable.iterator());
    }

    @ParametricNullness
    public <E extends T> E min(@ParametricNullness E a, @ParametricNullness E b) {
        return this.compare(a, b) <= 0 ? a : b;
    }

    @ParametricNullness
    public <E extends T> E min(@ParametricNullness E a, @ParametricNullness E b, @ParametricNullness E c, E ... rest) {
        E minSoFar = this.min(this.min(a, b), c);
        for (E r : rest) {
            minSoFar = this.min(minSoFar, r);
        }
        return minSoFar;
    }

    @ParametricNullness
    public <E extends T> E max(Iterator<E> iterator) {
        org.rascalmpl.java.lang.Object maxSoFar = iterator.next();
        while (iterator.hasNext()) {
            maxSoFar = this.max(maxSoFar, iterator.next());
        }
        return (E)maxSoFar;
    }

    @ParametricNullness
    public <E extends T> E max(Iterable<E> iterable) {
        return this.max(iterable.iterator());
    }

    @ParametricNullness
    public <E extends T> E max(@ParametricNullness E a, @ParametricNullness E b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    @ParametricNullness
    public <E extends T> E max(@ParametricNullness E a, @ParametricNullness E b, @ParametricNullness E c, E ... rest) {
        E maxSoFar = this.max(this.max(a, b), c);
        for (E r : rest) {
            maxSoFar = this.max(maxSoFar, r);
        }
        return maxSoFar;
    }

    public <E extends T> List<E> leastOf(Iterable<E> iterable, int k) {
        Collection collection;
        if (iterable instanceof Collection && (long)(collection = (Collection)iterable).size() <= 2L * (long)k) {
            org.rascalmpl.java.lang.Object[] array = collection.toArray();
            Arrays.sort((org.rascalmpl.java.lang.Object[])array, (Comparator)this);
            if (array.length > k) {
                array = Arrays.copyOf((org.rascalmpl.java.lang.Object[])array, (int)k);
            }
            return Collections.unmodifiableList((List)Arrays.asList((org.rascalmpl.java.lang.Object[])array));
        }
        return this.leastOf(iterable.iterator(), k);
    }

    public <E extends T> List<E> leastOf(Iterator<E> iterator, int k) {
        Preconditions.checkNotNull(iterator);
        CollectPreconditions.checkNonnegative(k, (String)"org.rascalmpl.k");
        if (k == 0 || !iterator.hasNext()) {
            return Collections.emptyList();
        }
        if (k >= 0x3FFFFFFF) {
            ArrayList<E> list = Lists.newArrayList(iterator);
            Collections.sort(list, (Comparator)this);
            if (list.size() > k) {
                list.subList(k, list.size()).clear();
            }
            list.trimToSize();
            return Collections.unmodifiableList(list);
        }
        TopKSelector<E> selector = TopKSelector.least(k, this);
        selector.offerAll(iterator);
        return selector.topK();
    }

    public <E extends T> List<E> greatestOf(Iterable<E> iterable, int k) {
        return this.reverse().leastOf(iterable, k);
    }

    public <E extends T> List<E> greatestOf(Iterator<E> iterator, int k) {
        return this.reverse().leastOf(iterator, k);
    }

    public <E extends T> List<E> sortedCopy(Iterable<E> elements) {
        org.rascalmpl.java.lang.Object[] array = Iterables.toArray(elements);
        Arrays.sort((org.rascalmpl.java.lang.Object[])array, (Comparator)this);
        return Lists.newArrayList(Arrays.asList((org.rascalmpl.java.lang.Object[])array));
    }

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> elements) {
        return ImmutableList.sortedCopyOf(this, elements);
    }

    public boolean isOrdered(Iterable<? extends T> iterable) {
        Iterator it = iterable.iterator();
        if (it.hasNext()) {
            org.rascalmpl.java.lang.Object prev = it.next();
            while (it.hasNext()) {
                org.rascalmpl.java.lang.Object next = it.next();
                if (this.compare(prev, next) > 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    public boolean isStrictlyOrdered(Iterable<? extends T> iterable) {
        Iterator it = iterable.iterator();
        if (it.hasNext()) {
            org.rascalmpl.java.lang.Object prev = it.next();
            while (it.hasNext()) {
                org.rascalmpl.java.lang.Object next = it.next();
                if (this.compare(prev, next) >= 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    @Deprecated
    public int binarySearch(List<? extends T> sortedList, @ParametricNullness T key) {
        return Collections.binarySearch(sortedList, key, (Comparator)this);
    }

    static class IncomparableValueException
    extends ClassCastException {
        final org.rascalmpl.java.lang.Object value;
        private static final long serialVersionUID = 0L;

        IncomparableValueException(org.rascalmpl.java.lang.Object value) {
            super(new StringBuilder().append((String)"org.rascalmpl.Cannot compare value: ").append(value).toString());
            this.value = value;
        }
    }

    @J2ktIncompatible
    @VisibleForTesting
    static class ArbitraryOrdering
    extends Ordering<org.rascalmpl.java.lang.Object> {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final ConcurrentMap<org.rascalmpl.java.lang.Object, Integer> uids = Platform.tryWeakKeys(new MapMaker()).makeMap();

        ArbitraryOrdering() {
        }

        private Integer getUid(org.rascalmpl.java.lang.Object obj) {
            Integer alreadySet;
            Integer uid = (Integer)this.uids.get(obj);
            if (uid == null && (alreadySet = (Integer)this.uids.putIfAbsent(obj, (org.rascalmpl.java.lang.Object)(uid = Integer.valueOf((int)this.counter.getAndIncrement())))) != null) {
                uid = alreadySet;
            }
            return uid;
        }

        @Override
        public int compare(@CheckForNull org.rascalmpl.java.lang.Object left, @CheckForNull org.rascalmpl.java.lang.Object right) {
            int rightCode;
            if (left == right) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            int leftCode = this.identityHashCode(left);
            if (leftCode != (rightCode = this.identityHashCode(right))) {
                return leftCode < rightCode ? -1 : 1;
            }
            int result = this.getUid(left).compareTo(this.getUid(right));
            if (result == 0) {
                throw new AssertionError();
            }
            return result;
        }

        public String toString() {
            return "org.rascalmpl.Ordering.arbitrary()";
        }

        int identityHashCode(org.rascalmpl.java.lang.Object object) {
            return System.identityHashCode((org.rascalmpl.java.lang.Object)object);
        }
    }

    @J2ktIncompatible
    private static class ArbitraryOrderingHolder
    extends org.rascalmpl.java.lang.Object {
        static final Ordering<@Nullable org.rascalmpl.java.lang.Object> ARBITRARY_ORDERING = new ArbitraryOrdering();

        private ArbitraryOrderingHolder() {
        }
    }
}

