/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.com.google.common.collect.Synchronized;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.ArrayDeque;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Deque;
import org.rascalmpl.java.util.PriorityQueue;
import org.rascalmpl.java.util.Queue;
import org.rascalmpl.java.util.concurrent.ArrayBlockingQueue;
import org.rascalmpl.java.util.concurrent.BlockingQueue;
import org.rascalmpl.java.util.concurrent.ConcurrentLinkedQueue;
import org.rascalmpl.java.util.concurrent.LinkedBlockingDeque;
import org.rascalmpl.java.util.concurrent.LinkedBlockingQueue;
import org.rascalmpl.java.util.concurrent.PriorityBlockingQueue;
import org.rascalmpl.java.util.concurrent.SynchronousQueue;
import org.rascalmpl.java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Queues
extends org.rascalmpl.java.lang.Object {
    private Queues() {
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> ArrayBlockingQueue<E> newArrayBlockingQueue(int capacity) {
        return new ArrayBlockingQueue(capacity);
    }

    public static <E extends org.rascalmpl.java.lang.Object> ArrayDeque<E> newArrayDeque() {
        return new ArrayDeque();
    }

    public static <E extends org.rascalmpl.java.lang.Object> ArrayDeque<E> newArrayDeque(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            return new ArrayDeque((Collection)elements);
        }
        ArrayDeque deque = new ArrayDeque();
        Iterables.addAll(deque, elements);
        return deque;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> ConcurrentLinkedQueue<E> newConcurrentLinkedQueue() {
        return new ConcurrentLinkedQueue();
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> ConcurrentLinkedQueue<E> newConcurrentLinkedQueue(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            return new ConcurrentLinkedQueue((Collection)elements);
        }
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        Iterables.addAll(queue, elements);
        return queue;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> LinkedBlockingDeque<E> newLinkedBlockingDeque() {
        return new LinkedBlockingDeque();
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> LinkedBlockingDeque<E> newLinkedBlockingDeque(int capacity) {
        return new LinkedBlockingDeque(capacity);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> LinkedBlockingDeque<E> newLinkedBlockingDeque(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            return new LinkedBlockingDeque((Collection)elements);
        }
        LinkedBlockingDeque deque = new LinkedBlockingDeque();
        Iterables.addAll(deque, elements);
        return deque;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> LinkedBlockingQueue<E> newLinkedBlockingQueue() {
        return new LinkedBlockingQueue();
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> LinkedBlockingQueue<E> newLinkedBlockingQueue(int capacity) {
        return new LinkedBlockingQueue(capacity);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> LinkedBlockingQueue<E> newLinkedBlockingQueue(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            return new LinkedBlockingQueue((Collection)elements);
        }
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Iterables.addAll(queue, elements);
        return queue;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends Comparable> PriorityBlockingQueue<E> newPriorityBlockingQueue() {
        return new PriorityBlockingQueue();
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends Comparable> PriorityBlockingQueue<E> newPriorityBlockingQueue(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            return new PriorityBlockingQueue((Collection)elements);
        }
        PriorityBlockingQueue queue = new PriorityBlockingQueue();
        Iterables.addAll(queue, elements);
        return queue;
    }

    public static <E extends Comparable> PriorityQueue<E> newPriorityQueue() {
        return new PriorityQueue();
    }

    public static <E extends Comparable> PriorityQueue<E> newPriorityQueue(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            return new PriorityQueue((Collection)elements);
        }
        PriorityQueue queue = new PriorityQueue();
        Iterables.addAll(queue, elements);
        return queue;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> SynchronousQueue<E> newSynchronousQueue() {
        return new SynchronousQueue();
    }

    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> int drain(BlockingQueue<E> q, Collection<? super E> buffer, int numElements, Duration timeout) throws InterruptedException {
        return Queues.drain(q, buffer, numElements, timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> int drain(BlockingQueue<E> q, Collection<? super E> buffer, int numElements, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(buffer);
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        int added = 0;
        while (added < numElements) {
            if ((added += q.drainTo(buffer, numElements - added)) >= numElements) continue;
            org.rascalmpl.java.lang.Object e = q.poll(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
            if (e == null) break;
            buffer.add(e);
            ++added;
        }
        return added;
    }

    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> int drainUninterruptibly(BlockingQueue<E> q, Collection<? super E> buffer, int numElements, Duration timeout) {
        return Queues.drainUninterruptibly(q, buffer, numElements, timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> int drainUninterruptibly(BlockingQueue<E> q, Collection<? super E> buffer, int numElements, long timeout, TimeUnit unit) {
        Preconditions.checkNotNull(buffer);
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        int added = 0;
        boolean interrupted = false;
        try {
            while (added < numElements) {
                org.rascalmpl.java.lang.Object e;
                if ((added += q.drainTo(buffer, numElements - added)) >= numElements) continue;
                while (true) {
                    try {
                        e = q.poll(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                if (e == null) {
                    break;
                }
                buffer.add(e);
                ++added;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return added;
    }

    public static <E extends org.rascalmpl.java.lang.Object> Queue<E> synchronizedQueue(Queue<E> queue) {
        return Synchronized.queue(queue, null);
    }

    public static <E extends org.rascalmpl.java.lang.Object> Deque<E> synchronizedDeque(Deque<E> deque) {
        return Synchronized.deque(deque, null);
    }
}

