/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.Hashing;
import org.rascalmpl.com.google.common.collect.ImmutableAsList;
import org.rascalmpl.com.google.common.collect.ImmutableBiMap;
import org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.com.google.common.collect.ImmutableMapEntry;
import org.rascalmpl.com.google.common.collect.ImmutableMapEntrySet;
import org.rascalmpl.com.google.common.collect.ImmutableMapKeySet;
import org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.com.google.common.collect.JdkBackedImmutableBiMap;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.RegularImmutableMap;
import org.rascalmpl.com.google.common.collect.UnmodifiableIterator;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.com.google.j2objc.annotations.RetainedWith;
import org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.function.BiConsumer;
import org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableBiMap<K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object>
extends ImmutableBiMap<K, V> {
    static final RegularImmutableBiMap<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object> EMPTY = new RegularImmutableBiMap(null, null, ImmutableMap.EMPTY_ENTRY_ARRAY, 0, 0);
    static final double MAX_LOAD_FACTOR = 1.2;
    @CheckForNull
    private final transient @Nullable ImmutableMapEntry<K, V>[] keyTable;
    @CheckForNull
    private final transient @Nullable ImmutableMapEntry<K, V>[] valueTable;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    private final transient int mask;
    private final transient int hashCode;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableBiMap<V, K> inverse;

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableBiMap<K, V> fromEntries(Map.Entry<K, V> ... entries) {
        return RegularImmutableBiMap.fromEntryArray(entries.length, entries);
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableBiMap<K, V> fromEntryArray(int n, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Map.Entry<K, V>[] entryArray) {
        Preconditions.checkPositionIndex(n, entryArray.length);
        int tableSize = Hashing.closedTableSize(n, 1.2);
        int mask = tableSize - 1;
        @Nullable ImmutableMapEntry<K, V>[] keyTable = ImmutableMapEntry.createEntryArray(tableSize);
        @Nullable ImmutableMapEntry<K, V>[] valueTable = ImmutableMapEntry.createEntryArray(tableSize);
        Map.Entry<K, V>[] entries = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
        int hashCode = 0;
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)Objects.requireNonNull(entryArray[i]);
            org.rascalmpl.java.lang.Object key = entry.getKey();
            org.rascalmpl.java.lang.Object value = entry.getValue();
            CollectPreconditions.checkEntryNotNull(key, value);
            int keyHash = key.hashCode();
            int valueHash = value.hashCode();
            int keyBucket = Hashing.smear(keyHash) & mask;
            int valueBucket = Hashing.smear(valueHash) & mask;
            ImmutableMapEntry nextInKeyBucket = keyTable[keyBucket];
            ImmutableMapEntry nextInValueBucket = valueTable[valueBucket];
            try {
                RegularImmutableMap.checkNoConflictInKeyBucket(key, value, nextInKeyBucket, true);
                RegularImmutableBiMap.checkNoConflictInValueBucket(value, entry, nextInValueBucket);
            }
            catch (RegularImmutableMap.BucketOverflowException e) {
                return JdkBackedImmutableBiMap.create(n, entryArray);
            }
            ImmutableMapEntry newEntry = nextInValueBucket == null && nextInKeyBucket == null ? RegularImmutableMap.makeImmutable(entry, key, value) : new ImmutableMapEntry.NonTerminalImmutableBiMapEntry<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object>(key, value, nextInKeyBucket, nextInValueBucket);
            keyTable[keyBucket] = newEntry;
            valueTable[valueBucket] = newEntry;
            entries[i] = newEntry;
            hashCode += keyHash ^ valueHash;
        }
        return new RegularImmutableBiMap(keyTable, valueTable, entries, mask, hashCode);
    }

    private RegularImmutableBiMap(@CheckForNull @Nullable ImmutableMapEntry<K, V>[] keyTable, @CheckForNull @Nullable ImmutableMapEntry<K, V>[] valueTable, Map.Entry<K, V>[] entries, int mask, int hashCode) {
        this.keyTable = keyTable;
        this.valueTable = valueTable;
        this.entries = entries;
        this.mask = mask;
        this.hashCode = hashCode;
    }

    private static void checkNoConflictInValueBucket(org.rascalmpl.java.lang.Object value, Map.Entry<?, ?> entry, @CheckForNull ImmutableMapEntry<?, ?> valueBucketHead) throws RegularImmutableMap.BucketOverflowException {
        int bucketSize = 0;
        while (valueBucketHead != null) {
            RegularImmutableBiMap.checkNoConflict(!value.equals(valueBucketHead.getValue()), (String)"org.rascalmpl.value", entry, valueBucketHead);
            if (++bucketSize > 8) {
                throw new RegularImmutableMap.BucketOverflowException();
            }
            valueBucketHead = valueBucketHead.getNextInValueBucket();
        }
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull org.rascalmpl.java.lang.Object key) {
        return RegularImmutableMap.get(key, this.keyTable, this.mask);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return this.isEmpty() ? ImmutableSet.of() : new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        for (Map.Entry<K, V> entry : this.entries) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    public int size() {
        return this.entries.length;
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        if (this.isEmpty()) {
            return ImmutableBiMap.of();
        }
        Inverse result = this.inverse;
        return result == null ? (this.inverse = new Inverse()) : result;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    org.rascalmpl.java.lang.Object writeReplace() {
        return super.writeReplace();
    }

    @J2ktIncompatible
    private static class InverseSerializedForm<K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Serializable {
        private final ImmutableBiMap<K, V> forward;
        private static final long serialVersionUID = 1L;

        InverseSerializedForm(ImmutableBiMap<K, V> forward) {
            this.forward = forward;
        }

        org.rascalmpl.java.lang.Object readResolve() {
            return this.forward.inverse();
        }
    }

    private final class Inverse
    extends ImmutableBiMap<V, K> {
        private Inverse() {
        }

        public int size() {
            return this.inverse().size();
        }

        @Override
        public ImmutableBiMap<K, V> inverse() {
            return RegularImmutableBiMap.this;
        }

        /*
         * Exception decompiling
         */
        public void forEach(BiConsumer<? super V, ? super K> action) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;Lorg/rascalmpl/java/lang/Object;)V
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        @CheckForNull
        public K get(@CheckForNull org.rascalmpl.java.lang.Object value) {
            if (value == null || RegularImmutableBiMap.this.valueTable == null) {
                return null;
            }
            int bucket = Hashing.smear(value.hashCode()) & RegularImmutableBiMap.this.mask;
            for (ImmutableMapEntry entry = RegularImmutableBiMap.this.valueTable[bucket]; entry != null; entry = entry.getNextInValueBucket()) {
                if (!value.equals(entry.getValue())) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        ImmutableSet<V> createKeySet() {
            return new ImmutableMapKeySet(this);
        }

        @Override
        ImmutableSet<Map.Entry<V, K>> createEntrySet() {
            return new InverseEntrySet();
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        org.rascalmpl.java.lang.Object writeReplace() {
            return new InverseSerializedForm(RegularImmutableBiMap.this);
        }

        @J2ktIncompatible
        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException((String)"org.rascalmpl.Use InverseSerializedForm");
        }

        private static /* synthetic */ void lambda$forEach$0(BiConsumer action, org.rascalmpl.java.lang.Object k, org.rascalmpl.java.lang.Object v) {
            action.accept(v, k);
        }

        final class InverseEntrySet
        extends ImmutableMapEntrySet<V, K> {
            InverseEntrySet() {
            }

            @Override
            ImmutableMap<V, K> map() {
                return Inverse.this;
            }

            @Override
            boolean isHashCodeFast() {
                return true;
            }

            @Override
            public int hashCode() {
                return RegularImmutableBiMap.this.hashCode;
            }

            @Override
            public UnmodifiableIterator<Map.Entry<V, K>> iterator() {
                return this.asList().iterator();
            }

            public void forEach(Consumer<? super Map.Entry<V, K>> action) {
                this.asList().forEach(action);
            }

            @Override
            ImmutableList<Map.Entry<V, K>> createAsList() {
                return new ImmutableAsList<Map.Entry<V, K>>(){

                    public Map.Entry<V, K> get(int index) {
                        Map.Entry entry = RegularImmutableBiMap.this.entries[index];
                        return Maps.immutableEntry(entry.getValue(), entry.getKey());
                    }

                    @Override
                    ImmutableCollection<Map.Entry<V, K>> delegateCollection() {
                        return InverseEntrySet.this;
                    }

                    @Override
                    @J2ktIncompatible
                    @GwtIncompatible
                    org.rascalmpl.java.lang.Object writeReplace() {
                        return super.writeReplace();
                    }
                };
            }

            @Override
            @J2ktIncompatible
            @GwtIncompatible
            org.rascalmpl.java.lang.Object writeReplace() {
                return super.writeReplace();
            }
        }
    }
}

