/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.Hashing;
import org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.com.google.common.collect.ImmutableMapEntry;
import org.rascalmpl.com.google.common.collect.ImmutableMapEntrySet;
import org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.com.google.common.collect.IndexedImmutableSet;
import org.rascalmpl.com.google.common.collect.JdkBackedImmutableMap;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.IdentityHashMap;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.function.BiConsumer;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object>
extends ImmutableMap<K, V> {
    static final ImmutableMap<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object> EMPTY = new RegularImmutableMap(ImmutableMap.EMPTY_ENTRY_ARRAY, null, 0);
    @VisibleForTesting
    static final double MAX_LOAD_FACTOR = 1.2;
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    static final int MAX_HASH_BUCKET_LENGTH = 8;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    @CheckForNull
    private final transient @Nullable ImmutableMapEntry<K, V>[] table;
    private final transient int mask;
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableMap<K, V> fromEntries(Map.Entry<K, V> ... entries) {
        return RegularImmutableMap.fromEntryArray(entries.length, entries, true);
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableMap<K, V> fromEntryArray(int n, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Map.Entry<K, V>[] entryArray, boolean throwIfDuplicateKeys) {
        Preconditions.checkPositionIndex(n, entryArray.length);
        if (n == 0) {
            ImmutableMap<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object> empty = EMPTY;
            return empty;
        }
        try {
            return RegularImmutableMap.fromEntryArrayCheckingBucketOverflow(n, entryArray, throwIfDuplicateKeys);
        }
        catch (BucketOverflowException e) {
            return JdkBackedImmutableMap.create(n, entryArray, throwIfDuplicateKeys);
        }
    }

    private static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableMap<K, V> fromEntryArrayCheckingBucketOverflow(int n, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Map.Entry<K, V>[] entryArray, boolean throwIfDuplicateKeys) throws BucketOverflowException {
        int newTableSize;
        Map.Entry<K, V>[] entries = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
        int tableSize = Hashing.closedTableSize(n, 1.2);
        @Nullable ImmutableMapEntry<K, V>[] table = ImmutableMapEntry.createEntryArray(tableSize);
        int mask = tableSize - 1;
        IdentityHashMap duplicates = null;
        int dupCount = 0;
        for (int entryIndex = n - 1; entryIndex >= 0; --entryIndex) {
            Map.Entry entry = (Map.Entry)Objects.requireNonNull(entryArray[entryIndex]);
            org.rascalmpl.java.lang.Object key = entry.getKey();
            org.rascalmpl.java.lang.Object value = entry.getValue();
            CollectPreconditions.checkEntryNotNull(key, value);
            int tableIndex = Hashing.smear(key.hashCode()) & mask;
            ImmutableMapEntry keyBucketHead = table[tableIndex];
            ImmutableMapEntry effectiveEntry = RegularImmutableMap.checkNoConflictInKeyBucket(key, value, keyBucketHead, throwIfDuplicateKeys);
            if (effectiveEntry == null) {
                effectiveEntry = keyBucketHead == null ? RegularImmutableMap.makeImmutable(entry, key, value) : new ImmutableMapEntry.NonTerminalImmutableMapEntry<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object>(key, value, keyBucketHead);
                table[tableIndex] = effectiveEntry;
            } else {
                if (duplicates == null) {
                    duplicates = new IdentityHashMap();
                }
                duplicates.put(effectiveEntry, (org.rascalmpl.java.lang.Object)Boolean.valueOf((boolean)true));
                ++dupCount;
                if (entries == entryArray) {
                    Map.Entry<K, V>[] originalEntries = entries;
                    entries = (Map.Entry[])originalEntries.clone();
                }
            }
            entries[entryIndex] = effectiveEntry;
        }
        if (duplicates != null && (newTableSize = Hashing.closedTableSize((entries = RegularImmutableMap.removeDuplicates(entries, n, n - dupCount, duplicates)).length, 1.2)) != tableSize) {
            return RegularImmutableMap.fromEntryArrayCheckingBucketOverflow(entries.length, entries, true);
        }
        return new RegularImmutableMap<K, V>(entries, table, mask);
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Map.Entry<K, V>[] removeDuplicates(Map.Entry<K, V>[] entries, int n, int newN, IdentityHashMap<Map.Entry<K, V>, Boolean> duplicates) {
        ImmutableMapEntry<K, V>[] newEntries = ImmutableMapEntry.createEntryArray(newN);
        int out = 0;
        for (int in = 0; in < n; ++in) {
            Map.Entry<K, V> entry = entries[in];
            Boolean status = (Boolean)duplicates.get(entry);
            if (status != null) {
                if (!status.booleanValue()) continue;
                duplicates.put(entry, (org.rascalmpl.java.lang.Object)Boolean.valueOf((boolean)false));
            }
            newEntries[out++] = entry;
        }
        return newEntries;
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry, K key, V value) {
        boolean reusable = entry instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry).isReusable();
        return reusable ? (ImmutableMapEntry)entry : new ImmutableMapEntry<K, V>(key, value);
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry) {
        return RegularImmutableMap.makeImmutable(entry, entry.getKey(), entry.getValue());
    }

    private RegularImmutableMap(Map.Entry<K, V>[] entries, @CheckForNull @Nullable ImmutableMapEntry<K, V>[] table, int mask) {
        this.entries = entries;
        this.table = table;
        this.mask = mask;
    }

    @CheckForNull
    @CanIgnoreReturnValue
    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ImmutableMapEntry<K, V> checkNoConflictInKeyBucket(org.rascalmpl.java.lang.Object key, org.rascalmpl.java.lang.Object newValue, @CheckForNull ImmutableMapEntry<K, V> keyBucketHead, boolean throwIfDuplicateKeys) throws BucketOverflowException {
        int bucketSize = 0;
        while (keyBucketHead != null) {
            if (keyBucketHead.getKey().equals(key)) {
                if (throwIfDuplicateKeys) {
                    RegularImmutableMap.checkNoConflict(false, (String)"org.rascalmpl.key", keyBucketHead, (org.rascalmpl.java.lang.Object)new StringBuilder().append(key).append((String)"org.rascalmpl.=").append(newValue).toString());
                } else {
                    return keyBucketHead;
                }
            }
            if (++bucketSize > 8) {
                throw new BucketOverflowException();
            }
            keyBucketHead = keyBucketHead.getNextInKeyBucket();
        }
        return null;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull org.rascalmpl.java.lang.Object key) {
        return RegularImmutableMap.get(key, this.table, this.mask);
    }

    @CheckForNull
    static <V extends org.rascalmpl.java.lang.Object> V get(@CheckForNull org.rascalmpl.java.lang.Object key, @CheckForNull @Nullable ImmutableMapEntry<?, V>[] keyTable, int mask) {
        if (key == null || keyTable == null) {
            return null;
        }
        int index = Hashing.smear(key.hashCode()) & mask;
        for (ImmutableMapEntry<?, V> entry = keyTable[index]; entry != null; entry = entry.getNextInKeyBucket()) {
            Object candidateKey = entry.getKey();
            if (!key.equals(candidateKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        for (Map.Entry<K, V> entry : this.entries) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new KeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    org.rascalmpl.java.lang.Object writeReplace() {
        return super.writeReplace();
    }

    @GwtCompatible(emulated=true)
    private static final class Values<K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object>
    extends ImmutableList<V> {
        final RegularImmutableMap<K, V> map;

        Values(RegularImmutableMap<K, V> map) {
            this.map = map;
        }

        public V get(int index) {
            return (V)this.map.entries[index].getValue();
        }

        public int size() {
            return this.map.size();
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        org.rascalmpl.java.lang.Object writeReplace() {
            return super.writeReplace();
        }

        @GwtIncompatible
        @J2ktIncompatible
        private static class SerializedForm<V extends org.rascalmpl.java.lang.Object>
        extends org.rascalmpl.java.lang.Object
        implements Serializable {
            final ImmutableMap<?, V> map;
            @J2ktIncompatible
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<?, V> map) {
                this.map = map;
            }

            org.rascalmpl.java.lang.Object readResolve() {
                return this.map.values();
            }
        }
    }

    @GwtCompatible(emulated=true)
    private static final class KeySet<K extends org.rascalmpl.java.lang.Object>
    extends IndexedImmutableSet<K> {
        private final RegularImmutableMap<K, ?> map;

        KeySet(RegularImmutableMap<K, ?> map) {
            this.map = map;
        }

        @Override
        K get(int index) {
            return (K)this.map.entries[index].getKey();
        }

        @Override
        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object object) {
            return this.map.containsKey(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        public int size() {
            return this.map.size();
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        org.rascalmpl.java.lang.Object writeReplace() {
            return super.writeReplace();
        }

        @GwtIncompatible
        @J2ktIncompatible
        private static class SerializedForm<K extends org.rascalmpl.java.lang.Object>
        extends org.rascalmpl.java.lang.Object
        implements Serializable {
            final ImmutableMap<K, ?> map;
            @J2ktIncompatible
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<K, ?> map) {
                this.map = map;
            }

            org.rascalmpl.java.lang.Object readResolve() {
                return this.map.keySet();
            }
        }
    }

    static class BucketOverflowException
    extends Exception {
        BucketOverflowException() {
        }
    }
}

