/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.Multimap;
import org.rascalmpl.com.google.common.collect.Multiset;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.java.io.ObjectOutputStream;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.NoSuchFieldException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.reflect.Field;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
final class Serialization
extends Object {
    private Serialization() {
    }

    static int readCount(ObjectInputStream stream) throws IOException {
        return stream.readInt();
    }

    static <K extends Object, V extends Object> void writeMap(Map<K, V> map, ObjectOutputStream stream) throws IOException {
        stream.writeInt(map.size());
        for (Map.Entry entry : map.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    static <K extends Object, V extends Object> void populateMap(Map<K, V> map, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int size = stream.readInt();
        Serialization.populateMap(map, stream, size);
    }

    static <K extends Object, V extends Object> void populateMap(Map<K, V> map, ObjectInputStream stream, int size) throws IOException, ClassNotFoundException {
        for (int i = 0; i < size; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            map.put(key, value);
        }
    }

    static <E extends Object> void writeMultiset(Multiset<E> multiset, ObjectOutputStream stream) throws IOException {
        int entryCount = multiset.entrySet().size();
        stream.writeInt(entryCount);
        for (Multiset.Entry entry : multiset.entrySet()) {
            stream.writeObject(entry.getElement());
            stream.writeInt(entry.getCount());
        }
    }

    static <E extends Object> void populateMultiset(Multiset<E> multiset, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int distinctElements = stream.readInt();
        Serialization.populateMultiset(multiset, stream, distinctElements);
    }

    static <E extends Object> void populateMultiset(Multiset<E> multiset, ObjectInputStream stream, int distinctElements) throws IOException, ClassNotFoundException {
        for (int i = 0; i < distinctElements; ++i) {
            Object element = stream.readObject();
            int count = stream.readInt();
            multiset.add(element, count);
        }
    }

    static <K extends Object, V extends Object> void writeMultimap(Multimap<K, V> multimap, ObjectOutputStream stream) throws IOException {
        stream.writeInt(multimap.asMap().size());
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeInt(((Collection)entry.getValue()).size());
            for (Object value : (Collection)entry.getValue()) {
                stream.writeObject(value);
            }
        }
    }

    static <K extends Object, V extends Object> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int distinctKeys = stream.readInt();
        Serialization.populateMultimap(multimap, stream, distinctKeys);
    }

    static <K extends Object, V extends Object> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream stream, int distinctKeys) throws IOException, ClassNotFoundException {
        for (int i = 0; i < distinctKeys; ++i) {
            Object key = stream.readObject();
            Collection<V> values = multimap.get(key);
            int valueCount = stream.readInt();
            for (int j = 0; j < valueCount; ++j) {
                Object value = stream.readObject();
                values.add(value);
            }
        }
    }

    static <T extends Object> FieldSetter<T> getFieldSetter(Class<T> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            return new FieldSetter(field);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static final class FieldSetter<T extends Object>
    extends Object {
        private final Field field;

        private FieldSetter(Field field) {
            this.field = field;
            field.setAccessible(true);
        }

        void set(T instance, Object value) {
            try {
                this.field.set(instance, value);
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        void set(T instance, int value) {
            try {
                this.field.set(instance, (Object)Integer.valueOf((int)value));
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }
    }
}

