/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Predicate;
import org.rascalmpl.com.google.common.base.Predicates;
import org.rascalmpl.com.google.common.collect.AbstractIndexedListIterator;
import org.rascalmpl.com.google.common.collect.AbstractIterator;
import org.rascalmpl.com.google.common.collect.BoundType;
import org.rascalmpl.com.google.common.collect.CartesianList;
import org.rascalmpl.com.google.common.collect.CollectCollectors;
import org.rascalmpl.com.google.common.collect.CollectPreconditions;
import org.rascalmpl.com.google.common.collect.Collections2;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ForwardingCollection;
import org.rascalmpl.com.google.common.collect.ForwardingNavigableSet;
import org.rascalmpl.com.google.common.collect.ForwardingSortedSet;
import org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.com.google.common.collect.ImmutableEnumSet;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.Multiset;
import org.rascalmpl.com.google.common.collect.Ordering;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.com.google.common.collect.Platform;
import org.rascalmpl.com.google.common.collect.Range;
import org.rascalmpl.com.google.common.collect.Synchronized;
import org.rascalmpl.com.google.common.collect.UnmodifiableIterator;
import org.rascalmpl.com.google.common.math.IntMath;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.DoNotCall;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassCastException;
import org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.NullPointerException;
import org.rascalmpl.java.lang.SafeVarargs;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.AbstractSet;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.BitSet;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.EnumSet;
import org.rascalmpl.java.util.HashSet;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.LinkedHashSet;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.NavigableSet;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.SortedSet;
import org.rascalmpl.java.util.TreeSet;
import org.rascalmpl.java.util.concurrent.CopyOnWriteArraySet;
import org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.java.util.stream.Collector;
import org.rascalmpl.java.util.stream.Stream;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.NonNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Sets
extends org.rascalmpl.java.lang.Object {
    private Sets() {
    }

    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(E anElement, E ... otherElements) {
        return ImmutableEnumSet.asImmutable(EnumSet.of(anElement, otherElements));
    }

    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(Iterable<E> elements) {
        if (elements instanceof ImmutableEnumSet) {
            return (ImmutableEnumSet)elements;
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            if (collection.isEmpty()) {
                return ImmutableSet.of();
            }
            return ImmutableEnumSet.asImmutable(EnumSet.copyOf((Collection)collection));
        }
        Iterator itr = elements.iterator();
        if (itr.hasNext()) {
            EnumSet enumSet = EnumSet.of((Enum)((Enum)itr.next()));
            Iterators.addAll(enumSet, itr);
            return ImmutableEnumSet.asImmutable(enumSet);
        }
        return ImmutableSet.of();
    }

    public static <E extends Enum<E>> Collector<E, ?, ImmutableSet<E>> toImmutableEnumSet() {
        return CollectCollectors.toImmutableEnumSet();
    }

    public static <E extends Enum<E>> EnumSet<E> newEnumSet(Iterable<E> iterable, Class<E> elementType) {
        EnumSet set = EnumSet.noneOf(elementType);
        Iterables.addAll(set, iterable);
        return set;
    }

    public static <E extends org.rascalmpl.java.lang.Object> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E extends org.rascalmpl.java.lang.Object> HashSet<E> newHashSet(E ... elements) {
        HashSet<E> set = Sets.newHashSetWithExpectedSize(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E extends org.rascalmpl.java.lang.Object> HashSet<E> newHashSet(Iterable<? extends E> elements) {
        return elements instanceof Collection ? new HashSet((Collection)elements) : Sets.newHashSet(elements.iterator());
    }

    public static <E extends org.rascalmpl.java.lang.Object> HashSet<E> newHashSet(Iterator<? extends E> elements) {
        HashSet<E> set = Sets.newHashSet();
        Iterators.addAll(set, elements);
        return set;
    }

    public static <E extends org.rascalmpl.java.lang.Object> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(Maps.capacity(expectedSize));
    }

    public static <E extends org.rascalmpl.java.lang.Object> Set<E> newConcurrentHashSet() {
        return Platform.newConcurrentHashSet();
    }

    public static <E extends org.rascalmpl.java.lang.Object> Set<E> newConcurrentHashSet(Iterable<? extends E> elements) {
        Set<E> set = Sets.newConcurrentHashSet();
        Iterables.addAll(set, elements);
        return set;
    }

    public static <E extends org.rascalmpl.java.lang.Object> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E extends org.rascalmpl.java.lang.Object> LinkedHashSet<E> newLinkedHashSet(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            return new LinkedHashSet((Collection)elements);
        }
        LinkedHashSet<E> set = Sets.newLinkedHashSet();
        Iterables.addAll(set, elements);
        return set;
    }

    public static <E extends org.rascalmpl.java.lang.Object> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(Maps.capacity(expectedSize));
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet(Iterable<? extends E> elements) {
        TreeSet<E> set = Sets.newTreeSet();
        Iterables.addAll(set, elements);
        return set;
    }

    public static <E extends org.rascalmpl.java.lang.Object> TreeSet<E> newTreeSet(Comparator<? super E> comparator) {
        return new TreeSet(Preconditions.checkNotNull(comparator));
    }

    public static <E extends org.rascalmpl.java.lang.Object> Set<E> newIdentityHashSet() {
        return Collections.newSetFromMap(Maps.newIdentityHashMap());
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> CopyOnWriteArraySet<E> newCopyOnWriteArraySet() {
        return new CopyOnWriteArraySet();
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> CopyOnWriteArraySet<E> newCopyOnWriteArraySet(Iterable<? extends E> elements) {
        ArrayList<? extends E> elementsCollection = elements instanceof Collection ? (ArrayList<? extends E>)elements : Lists.newArrayList(elements);
        return new CopyOnWriteArraySet(elementsCollection);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection) {
        if (collection instanceof EnumSet) {
            return EnumSet.complementOf((EnumSet)((EnumSet)collection));
        }
        Preconditions.checkArgument(!collection.isEmpty(), (org.rascalmpl.java.lang.Object)"org.rascalmpl.collection is empty; use the other version of this method");
        Class type = ((Enum)collection.iterator().next()).getDeclaringClass();
        return Sets.makeComplementByHand(collection, type);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection, Class<E> type) {
        Preconditions.checkNotNull(collection);
        return collection instanceof EnumSet ? EnumSet.complementOf((EnumSet)((EnumSet)collection)) : Sets.makeComplementByHand(collection, type);
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static <E extends Enum<E>> EnumSet<E> makeComplementByHand(Collection<E> collection, Class<E> type) {
        EnumSet result = EnumSet.allOf(type);
        result.removeAll(collection);
        return result;
    }

    @Deprecated
    public static <E extends org.rascalmpl.java.lang.Object> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return Collections.newSetFromMap(map);
    }

    public static <E extends org.rascalmpl.java.lang.Object> SetView<E> union(final Set<? extends E> set1, final Set<? extends E> set2) {
        Preconditions.checkNotNull(set1, (org.rascalmpl.java.lang.Object)"org.rascalmpl.set1");
        Preconditions.checkNotNull(set2, (org.rascalmpl.java.lang.Object)"org.rascalmpl.set2");
        return new SetView<E>(){

            public int size() {
                int size = set1.size();
                for (org.rascalmpl.java.lang.Object e : set2) {
                    if (set1.contains(e)) continue;
                    ++size;
                }
                return size;
            }

            public boolean isEmpty() {
                return set1.isEmpty() && set2.isEmpty();
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<? extends E> itr1;
                    final Iterator<? extends E> itr2;
                    {
                        this.itr1 = set1.iterator();
                        this.itr2 = set2.iterator();
                    }

                    @Override
                    @CheckForNull
                    protected E computeNext() {
                        if (this.itr1.hasNext()) {
                            return this.itr1.next();
                        }
                        while (this.itr2.hasNext()) {
                            org.rascalmpl.java.lang.Object e = this.itr2.next();
                            if (set1.contains(e)) continue;
                            return e;
                        }
                        return this.endOfData();
                    }
                };
            }

            /*
             * Exception decompiling
             */
            public Stream<E> stream() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Z
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
                 *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public Stream<E> parallelStream() {
                return (Stream)this.stream().parallel();
            }

            public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object object) {
                return set1.contains(object) || set2.contains(object);
            }

            @Override
            public <S extends Set<E>> S copyInto(S set) {
                set.addAll((Collection)set1);
                set.addAll((Collection)set2);
                return set;
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public ImmutableSet<@NonNull E> immutableCopy() {
                @NonNull ImmutableCollection.Builder builder = ((ImmutableSet.Builder)new ImmutableSet.Builder().addAll((Iterable)set1)).addAll((Iterable)set2);
                return ((ImmutableSet.Builder)builder).build();
            }

            private static /* synthetic */ boolean lambda$stream$0(Set set12, org.rascalmpl.java.lang.Object e) {
                return !set12.contains(e);
            }
        };
    }

    public static <E extends org.rascalmpl.java.lang.Object> SetView<E> intersection(final Set<E> set1, final Set<?> set2) {
        Preconditions.checkNotNull(set1, (org.rascalmpl.java.lang.Object)"org.rascalmpl.set1");
        Preconditions.checkNotNull(set2, (org.rascalmpl.java.lang.Object)"org.rascalmpl.set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set1.iterator();
                    }

                    @Override
                    @CheckForNull
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            org.rascalmpl.java.lang.Object e = this.itr.next();
                            if (!set2.contains(e)) continue;
                            return e;
                        }
                        return this.endOfData();
                    }
                };
            }

            /*
             * Exception decompiling
             */
            public Stream<E> stream() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Z
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
                 *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            /*
             * Exception decompiling
             */
            public Stream<E> parallelStream() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Z
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
                 *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public int size() {
                int size = 0;
                for (org.rascalmpl.java.lang.Object e : set1) {
                    if (!set2.contains(e)) continue;
                    ++size;
                }
                return size;
            }

            public boolean isEmpty() {
                return Collections.disjoint((Collection)set2, (Collection)set1);
            }

            public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object object) {
                return set1.contains(object) && set2.contains(object);
            }

            public boolean containsAll(Collection<?> collection) {
                return set1.containsAll(collection) && set2.containsAll(collection);
            }
        };
    }

    public static <E extends org.rascalmpl.java.lang.Object> SetView<E> difference(final Set<E> set1, final Set<?> set2) {
        Preconditions.checkNotNull(set1, (org.rascalmpl.java.lang.Object)"org.rascalmpl.set1");
        Preconditions.checkNotNull(set2, (org.rascalmpl.java.lang.Object)"org.rascalmpl.set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set1.iterator();
                    }

                    @Override
                    @CheckForNull
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            org.rascalmpl.java.lang.Object e = this.itr.next();
                            if (set2.contains(e)) continue;
                            return e;
                        }
                        return this.endOfData();
                    }
                };
            }

            /*
             * Exception decompiling
             */
            public Stream<E> stream() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Z
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
                 *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            /*
             * Exception decompiling
             */
            public Stream<E> parallelStream() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Z
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
                 *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public int size() {
                int size = 0;
                for (org.rascalmpl.java.lang.Object e : set1) {
                    if (set2.contains(e)) continue;
                    ++size;
                }
                return size;
            }

            public boolean isEmpty() {
                return set2.containsAll((Collection)set1);
            }

            public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object element) {
                return set1.contains(element) && !set2.contains(element);
            }

            private static /* synthetic */ boolean lambda$parallelStream$1(Set set22, org.rascalmpl.java.lang.Object e) {
                return !set22.contains(e);
            }

            private static /* synthetic */ boolean lambda$stream$0(Set set22, org.rascalmpl.java.lang.Object e) {
                return !set22.contains(e);
            }
        };
    }

    public static <E extends org.rascalmpl.java.lang.Object> SetView<E> symmetricDifference(final Set<? extends E> set1, final Set<? extends E> set2) {
        Preconditions.checkNotNull(set1, (org.rascalmpl.java.lang.Object)"org.rascalmpl.set1");
        Preconditions.checkNotNull(set2, (org.rascalmpl.java.lang.Object)"org.rascalmpl.set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                final Iterator itr1 = set1.iterator();
                final Iterator itr2 = set2.iterator();
                return new AbstractIterator<E>(){

                    @Override
                    @CheckForNull
                    public E computeNext() {
                        while (itr1.hasNext()) {
                            org.rascalmpl.java.lang.Object elem1 = itr1.next();
                            if (set2.contains(elem1)) continue;
                            return elem1;
                        }
                        while (itr2.hasNext()) {
                            org.rascalmpl.java.lang.Object elem2 = itr2.next();
                            if (set1.contains(elem2)) continue;
                            return elem2;
                        }
                        return this.endOfData();
                    }
                };
            }

            public int size() {
                int size = 0;
                for (org.rascalmpl.java.lang.Object e : set1) {
                    if (set2.contains(e)) continue;
                    ++size;
                }
                for (org.rascalmpl.java.lang.Object e : set2) {
                    if (set1.contains(e)) continue;
                    ++size;
                }
                return size;
            }

            public boolean isEmpty() {
                return set1.equals((org.rascalmpl.java.lang.Object)set2);
            }

            public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object element) {
                return set1.contains(element) ^ set2.contains(element);
            }
        };
    }

    public static <E extends org.rascalmpl.java.lang.Object> Set<E> filter(Set<E> unfiltered, Predicate<? super E> predicate) {
        if (unfiltered instanceof SortedSet) {
            return Sets.filter((SortedSet)unfiltered, predicate);
        }
        if (unfiltered instanceof FilteredSet) {
            FilteredSet filtered = (FilteredSet)unfiltered;
            Predicate<? super E> combinedPredicate = Predicates.and(filtered.predicate, predicate);
            return new FilteredSet<E>((Set)filtered.unfiltered, combinedPredicate);
        }
        return new FilteredSet<E>(Preconditions.checkNotNull(unfiltered), Preconditions.checkNotNull(predicate));
    }

    public static <E extends org.rascalmpl.java.lang.Object> SortedSet<E> filter(SortedSet<E> unfiltered, Predicate<? super E> predicate) {
        if (unfiltered instanceof FilteredSet) {
            FilteredSet filtered = (FilteredSet)unfiltered;
            Predicate<? super E> combinedPredicate = Predicates.and(filtered.predicate, predicate);
            return new FilteredSortedSet<E>((SortedSet)filtered.unfiltered, combinedPredicate);
        }
        return new FilteredSortedSet<E>(Preconditions.checkNotNull(unfiltered), Preconditions.checkNotNull(predicate));
    }

    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> NavigableSet<E> filter(NavigableSet<E> unfiltered, Predicate<? super E> predicate) {
        if (unfiltered instanceof FilteredSet) {
            FilteredSet filtered = (FilteredSet)unfiltered;
            Predicate<? super E> combinedPredicate = Predicates.and(filtered.predicate, predicate);
            return new FilteredNavigableSet<E>((NavigableSet)filtered.unfiltered, combinedPredicate);
        }
        return new FilteredNavigableSet<E>(Preconditions.checkNotNull(unfiltered), Preconditions.checkNotNull(predicate));
    }

    public static <B extends org.rascalmpl.java.lang.Object> Set<List<B>> cartesianProduct(List<? extends Set<? extends B>> sets) {
        return CartesianSet.create(sets);
    }

    @SafeVarargs
    public static <B extends org.rascalmpl.java.lang.Object> Set<List<B>> cartesianProduct(Set<? extends B> ... sets) {
        return Sets.cartesianProduct(Arrays.asList(sets));
    }

    @GwtCompatible(serializable=false)
    public static <E extends org.rascalmpl.java.lang.Object> Set<Set<E>> powerSet(Set<E> set) {
        return new PowerSet<E>(set);
    }

    public static <E extends org.rascalmpl.java.lang.Object> Set<Set<E>> combinations(Set<E> set, final int size) {
        final ImmutableMap<E, Integer> index = Maps.indexMap(set);
        CollectPreconditions.checkNonnegative(size, (String)"org.rascalmpl.size");
        Preconditions.checkArgument(size <= index.size(), (String)"org.rascalmpl.size (%s) must be <= set.size() (%s)", size, index.size());
        if (size == 0) {
            return ImmutableSet.of(ImmutableSet.of());
        }
        if (size == index.size()) {
            return ImmutableSet.of(index.keySet());
        }
        return new AbstractSet<Set<E>>(){

            public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object o) {
                if (o instanceof Set) {
                    Set s2 = (Set)o;
                    return s2.size() == size && index.keySet().containsAll((Collection)s2);
                }
                return false;
            }

            public Iterator<Set<E>> iterator() {
                return new AbstractIterator<Set<E>>(){
                    final BitSet bits;
                    {
                        this.bits = new BitSet(index.size());
                    }

                    @Override
                    @CheckForNull
                    protected Set<E> computeNext() {
                        if (this.bits.isEmpty()) {
                            this.bits.set(0, size);
                        } else {
                            int firstSetBit = this.bits.nextSetBit(0);
                            int bitToFlip = this.bits.nextClearBit(firstSetBit);
                            if (bitToFlip == index.size()) {
                                return (Set)this.endOfData();
                            }
                            this.bits.set(0, bitToFlip - firstSetBit - 1);
                            this.bits.clear(bitToFlip - firstSetBit - 1, bitToFlip);
                            this.bits.set(bitToFlip);
                        }
                        final BitSet copy = (BitSet)this.bits.clone();
                        return new AbstractSet<E>(){

                            public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object o) {
                                Integer i = (Integer)index.get(o);
                                return i != null && copy.get(i.intValue());
                            }

                            public Iterator<E> iterator() {
                                return new AbstractIterator<E>(){
                                    int i = -1;

                                    @Override
                                    @CheckForNull
                                    protected E computeNext() {
                                        this.i = copy.nextSetBit(this.i + 1);
                                        if (this.i == -1) {
                                            return this.endOfData();
                                        }
                                        return index.keySet().asList().get(this.i);
                                    }
                                };
                            }

                            public int size() {
                                return size;
                            }
                        };
                    }
                };
            }

            public int size() {
                return IntMath.binomial(index.size(), size);
            }

            public String toString() {
                return new StringBuilder().append((String)"org.rascalmpl.Sets.combinations(").append((org.rascalmpl.java.lang.Object)index.keySet()).append((String)"org.rascalmpl., ").append(size).append((String)"org.rascalmpl.)").toString();
            }
        };
    }

    static int hashCodeImpl(Set<?> s2) {
        int hashCode = 0;
        for (org.rascalmpl.java.lang.Object o : s2) {
            hashCode += o != null ? o.hashCode() : 0;
            hashCode = ~(~hashCode);
        }
        return hashCode;
    }

    static boolean equalsImpl(Set<?> s2, @CheckForNull org.rascalmpl.java.lang.Object object) {
        if (s2 == object) {
            return true;
        }
        if (object instanceof Set) {
            Set o = (Set)object;
            try {
                return s2.size() == o.size() && s2.containsAll((Collection)o);
            }
            catch (ClassCastException | NullPointerException ignored) {
                return false;
            }
        }
        return false;
    }

    public static <E extends org.rascalmpl.java.lang.Object> NavigableSet<E> unmodifiableNavigableSet(NavigableSet<E> set) {
        if (set instanceof ImmutableCollection || set instanceof UnmodifiableNavigableSet) {
            return set;
        }
        return new UnmodifiableNavigableSet<E>(set);
    }

    @GwtIncompatible
    public static <E extends org.rascalmpl.java.lang.Object> NavigableSet<E> synchronizedNavigableSet(NavigableSet<E> navigableSet) {
        return Synchronized.navigableSet(navigableSet);
    }

    static boolean removeAllImpl(Set<?> set, Iterator<?> iterator) {
        boolean changed = false;
        while (iterator.hasNext()) {
            changed |= set.remove(iterator.next());
        }
        return changed;
    }

    static boolean removeAllImpl(Set<?> set, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        if (collection instanceof Multiset) {
            collection = ((Multiset)collection).elementSet();
        }
        if (collection instanceof Set && collection.size() > set.size()) {
            return Iterators.removeAll(set.iterator(), collection);
        }
        return Sets.removeAllImpl(set, collection.iterator());
    }

    @GwtIncompatible
    public static <K extends Comparable<? super K>> NavigableSet<K> subSet(NavigableSet<K> set, Range<K> range) {
        if (set.comparator() != null && set.comparator() != Ordering.natural() && range.hasLowerBound() && range.hasUpperBound()) {
            Preconditions.checkArgument(set.comparator().compare(range.lowerEndpoint(), range.upperEndpoint()) <= 0, (org.rascalmpl.java.lang.Object)"org.rascalmpl.set is using a custom comparator which is inconsistent with the natural ordering.");
        }
        if (range.hasLowerBound() && range.hasUpperBound()) {
            return set.subSet(range.lowerEndpoint(), range.lowerBoundType() == BoundType.CLOSED, range.upperEndpoint(), range.upperBoundType() == BoundType.CLOSED);
        }
        if (range.hasLowerBound()) {
            return set.tailSet(range.lowerEndpoint(), range.lowerBoundType() == BoundType.CLOSED);
        }
        if (range.hasUpperBound()) {
            return set.headSet(range.upperEndpoint(), range.upperBoundType() == BoundType.CLOSED);
        }
        return Preconditions.checkNotNull(set);
    }

    @GwtIncompatible
    static class DescendingSet<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends ForwardingNavigableSet<E> {
        private final NavigableSet<E> forward;

        DescendingSet(NavigableSet<E> forward) {
            this.forward = forward;
        }

        @Override
        protected NavigableSet<E> delegate() {
            return this.forward;
        }

        @Override
        @CheckForNull
        public E lower(@ParametricNullness E e) {
            return (E)this.forward.higher(e);
        }

        @Override
        @CheckForNull
        public E floor(@ParametricNullness E e) {
            return (E)this.forward.ceiling(e);
        }

        @Override
        @CheckForNull
        public E ceiling(@ParametricNullness E e) {
            return (E)this.forward.floor(e);
        }

        @Override
        @CheckForNull
        public E higher(@ParametricNullness E e) {
            return (E)this.forward.lower(e);
        }

        @Override
        @CheckForNull
        public E pollFirst() {
            return (E)this.forward.pollLast();
        }

        @Override
        @CheckForNull
        public E pollLast() {
            return (E)this.forward.pollFirst();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return this.forward;
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.forward.iterator();
        }

        @Override
        public NavigableSet<E> subSet(@ParametricNullness E fromElement, boolean fromInclusive, @ParametricNullness E toElement, boolean toInclusive) {
            return this.forward.subSet(toElement, toInclusive, fromElement, fromInclusive).descendingSet();
        }

        @Override
        public SortedSet<E> subSet(@ParametricNullness E fromElement, @ParametricNullness E toElement) {
            return this.standardSubSet(fromElement, toElement);
        }

        @Override
        public NavigableSet<E> headSet(@ParametricNullness E toElement, boolean inclusive) {
            return this.forward.tailSet(toElement, inclusive).descendingSet();
        }

        @Override
        public SortedSet<E> headSet(@ParametricNullness E toElement) {
            return this.standardHeadSet(toElement);
        }

        @Override
        public NavigableSet<E> tailSet(@ParametricNullness E fromElement, boolean inclusive) {
            return this.forward.headSet(fromElement, inclusive).descendingSet();
        }

        @Override
        public SortedSet<E> tailSet(@ParametricNullness E fromElement) {
            return this.standardTailSet(fromElement);
        }

        @Override
        public Comparator<? super E> comparator() {
            Comparator forwardComparator = this.forward.comparator();
            if (forwardComparator == null) {
                return Ordering.natural().reverse();
            }
            return DescendingSet.reverse(forwardComparator);
        }

        private static <T extends org.rascalmpl.java.lang.Object> Ordering<T> reverse(Comparator<T> forward) {
            return Ordering.from(forward).reverse();
        }

        @Override
        @ParametricNullness
        public E first() {
            return (E)this.forward.last();
        }

        @Override
        @ParametricNullness
        public E last() {
            return (E)this.forward.first();
        }

        @Override
        public Iterator<E> iterator() {
            return this.forward.descendingIterator();
        }

        @Override
        public @Nullable org.rascalmpl.java.lang.Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T extends org.rascalmpl.java.lang.Object> T[] toArray(T[] array) {
            return this.standardToArray((org.rascalmpl.java.lang.Object[])array);
        }

        @Override
        public String toString() {
            return this.standardToString();
        }
    }

    static final class UnmodifiableNavigableSet<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends ForwardingSortedSet<E>
    implements NavigableSet<E>,
    Serializable {
        private final NavigableSet<E> delegate;
        private final SortedSet<E> unmodifiableDelegate;
        @LazyInit
        @CheckForNull
        private transient UnmodifiableNavigableSet<E> descendingSet;
        private static final long serialVersionUID = 0L;

        UnmodifiableNavigableSet(NavigableSet<E> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
            this.unmodifiableDelegate = Collections.unmodifiableSortedSet(delegate);
        }

        @Override
        protected SortedSet<E> delegate() {
            return this.unmodifiableDelegate;
        }

        public boolean removeIf(org.rascalmpl.java.util.function.Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        public Stream<E> stream() {
            return this.delegate.stream();
        }

        public Stream<E> parallelStream() {
            return this.delegate.parallelStream();
        }

        public void forEach(Consumer<? super E> action) {
            this.delegate.forEach(action);
        }

        @CheckForNull
        public E lower(@ParametricNullness E e) {
            return (E)this.delegate.lower(e);
        }

        @CheckForNull
        public E floor(@ParametricNullness E e) {
            return (E)this.delegate.floor(e);
        }

        @CheckForNull
        public E ceiling(@ParametricNullness E e) {
            return (E)this.delegate.ceiling(e);
        }

        @CheckForNull
        public E higher(@ParametricNullness E e) {
            return (E)this.delegate.higher(e);
        }

        @CheckForNull
        public E pollFirst() {
            throw new UnsupportedOperationException();
        }

        @CheckForNull
        public E pollLast() {
            throw new UnsupportedOperationException();
        }

        public NavigableSet<E> descendingSet() {
            UnmodifiableNavigableSet<E> result = this.descendingSet;
            if (result == null) {
                result = this.descendingSet = new UnmodifiableNavigableSet<E>(this.delegate.descendingSet());
                result.descendingSet = this;
            }
            return result;
        }

        public Iterator<E> descendingIterator() {
            return Iterators.unmodifiableIterator(this.delegate.descendingIterator());
        }

        public NavigableSet<E> subSet(@ParametricNullness E fromElement, boolean fromInclusive, @ParametricNullness E toElement, boolean toInclusive) {
            return Sets.unmodifiableNavigableSet(this.delegate.subSet(fromElement, fromInclusive, toElement, toInclusive));
        }

        public NavigableSet<E> headSet(@ParametricNullness E toElement, boolean inclusive) {
            return Sets.unmodifiableNavigableSet(this.delegate.headSet(toElement, inclusive));
        }

        public NavigableSet<E> tailSet(@ParametricNullness E fromElement, boolean inclusive) {
            return Sets.unmodifiableNavigableSet(this.delegate.tailSet(fromElement, inclusive));
        }
    }

    private static final class PowerSet<E extends org.rascalmpl.java.lang.Object>
    extends AbstractSet<Set<E>> {
        final ImmutableMap<E, Integer> inputSet;

        PowerSet(Set<E> input) {
            Preconditions.checkArgument(input.size() <= 30, (String)"org.rascalmpl.Too many elements to create power set: %s > 30", input.size());
            this.inputSet = Maps.indexMap(input);
        }

        public int size() {
            return 1 << this.inputSet.size();
        }

        public boolean isEmpty() {
            return false;
        }

        public Iterator<Set<E>> iterator() {
            return new AbstractIndexedListIterator<Set<E>>(this.size()){

                @Override
                protected Set<E> get(int setBits) {
                    return new SubSet(inputSet, setBits);
                }
            };
        }

        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof Set) {
                Set set = (Set)obj;
                return this.inputSet.keySet().containsAll((Collection)set);
            }
            return false;
        }

        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj instanceof PowerSet) {
                PowerSet that = (PowerSet)obj;
                return this.inputSet.keySet().equals((org.rascalmpl.java.lang.Object)that.inputSet.keySet());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.inputSet.keySet().hashCode() << this.inputSet.size() - 1;
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.powerSet(").append(this.inputSet).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static final class SubSet<E extends org.rascalmpl.java.lang.Object>
    extends AbstractSet<E> {
        private final ImmutableMap<E, Integer> inputSet;
        private final int mask;

        SubSet(ImmutableMap<E, Integer> inputSet, int mask) {
            this.inputSet = inputSet;
            this.mask = mask;
        }

        public Iterator<E> iterator() {
            return new UnmodifiableIterator<E>(){
                final ImmutableList<E> elements;
                int remainingSetBits;
                {
                    this.elements = inputSet.keySet().asList();
                    this.remainingSetBits = mask;
                }

                public boolean hasNext() {
                    return this.remainingSetBits != 0;
                }

                public E next() {
                    int index = Integer.numberOfTrailingZeros((int)this.remainingSetBits);
                    if (index == 32) {
                        throw new NoSuchElementException();
                    }
                    this.remainingSetBits &= ~(1 << index);
                    return this.elements.get(index);
                }
            };
        }

        public int size() {
            return Integer.bitCount((int)this.mask);
        }

        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object o) {
            Integer index = this.inputSet.get(o);
            return index != null && (this.mask & 1 << index.intValue()) != 0;
        }
    }

    private static final class CartesianSet<E extends org.rascalmpl.java.lang.Object>
    extends ForwardingCollection<List<E>>
    implements Set<List<E>> {
        private final transient ImmutableList<ImmutableSet<E>> axes;
        private final transient CartesianList<E> delegate;

        static <E extends org.rascalmpl.java.lang.Object> Set<List<E>> create(List<? extends Set<? extends E>> sets) {
            ImmutableList.Builder axesBuilder = new ImmutableList.Builder(sets.size());
            for (Set set : sets) {
                ImmutableSet copy = ImmutableSet.copyOf(set);
                if (copy.isEmpty()) {
                    return ImmutableSet.of();
                }
                axesBuilder.add((org.rascalmpl.java.lang.Object)copy);
            }
            ImmutableCollection axes = axesBuilder.build();
            ImmutableList listAxes = new ImmutableList<List<E>>((ImmutableList)axes){
                final /* synthetic */ ImmutableList val$axes;
                {
                    this.val$axes = immutableList;
                }

                public int size() {
                    return this.val$axes.size();
                }

                public List<E> get(int index) {
                    return ((ImmutableSet)this.val$axes.get(index)).asList();
                }

                @Override
                boolean isPartialView() {
                    return true;
                }

                @Override
                @J2ktIncompatible
                @GwtIncompatible
                org.rascalmpl.java.lang.Object writeReplace() {
                    return super.writeReplace();
                }
            };
            return new CartesianSet(axes, new CartesianList(listAxes));
        }

        private CartesianSet(ImmutableList<ImmutableSet<E>> axes, CartesianList<E> delegate) {
            this.axes = axes;
            this.delegate = delegate;
        }

        @Override
        protected Collection<List<E>> delegate() {
            return this.delegate;
        }

        @Override
        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object object) {
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            if (list.size() != this.axes.size()) {
                return false;
            }
            int i = 0;
            for (org.rascalmpl.java.lang.Object o : list) {
                if (!((ImmutableSet)this.axes.get(i)).contains(o)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object object) {
            if (object instanceof CartesianSet) {
                CartesianSet that = (CartesianSet)object;
                return this.axes.equals((org.rascalmpl.java.lang.Object)that.axes);
            }
            if (object instanceof Set) {
                Set that = (Set)object;
                return this.size() == that.size() && this.containsAll((Collection<?>)that);
            }
            return false;
        }

        public int hashCode() {
            int adjust = this.size() - 1;
            for (int i = 0; i < this.axes.size(); ++i) {
                adjust *= 31;
                adjust = ~(~adjust);
            }
            int hash = 1;
            Iterator iterator = this.axes.iterator();
            while (iterator.hasNext()) {
                Set axis = (Set)iterator.next();
                hash = 31 * hash + this.size() / axis.size() * axis.hashCode();
                hash = ~(~hash);
            }
            return ~(~(hash += adjust));
        }
    }

    @GwtIncompatible
    private static class FilteredNavigableSet<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends FilteredSortedSet<E>
    implements NavigableSet<E> {
        FilteredNavigableSet(NavigableSet<E> unfiltered, Predicate<? super E> predicate) {
            super(unfiltered, predicate);
        }

        NavigableSet<E> unfiltered() {
            return (NavigableSet)this.unfiltered;
        }

        @CheckForNull
        public E lower(@ParametricNullness E e) {
            return Iterators.find(this.unfiltered().headSet(e, false).descendingIterator(), this.predicate, null);
        }

        @CheckForNull
        public E floor(@ParametricNullness E e) {
            return Iterators.find(this.unfiltered().headSet(e, true).descendingIterator(), this.predicate, null);
        }

        @CheckForNull
        public E ceiling(@ParametricNullness E e) {
            return Iterables.find(this.unfiltered().tailSet(e, true), this.predicate, null);
        }

        @CheckForNull
        public E higher(@ParametricNullness E e) {
            return Iterables.find(this.unfiltered().tailSet(e, false), this.predicate, null);
        }

        @CheckForNull
        public E pollFirst() {
            return Iterables.removeFirstMatching(this.unfiltered(), this.predicate);
        }

        @CheckForNull
        public E pollLast() {
            return (E)Iterables.removeFirstMatching(this.unfiltered().descendingSet(), this.predicate);
        }

        public NavigableSet<E> descendingSet() {
            return Sets.filter(this.unfiltered().descendingSet(), this.predicate);
        }

        public Iterator<E> descendingIterator() {
            return Iterators.filter(this.unfiltered().descendingIterator(), this.predicate);
        }

        @Override
        @ParametricNullness
        public E last() {
            return (E)Iterators.find(this.unfiltered().descendingIterator(), this.predicate);
        }

        public NavigableSet<E> subSet(@ParametricNullness E fromElement, boolean fromInclusive, @ParametricNullness E toElement, boolean toInclusive) {
            return Sets.filter(this.unfiltered().subSet(fromElement, fromInclusive, toElement, toInclusive), this.predicate);
        }

        public NavigableSet<E> headSet(@ParametricNullness E toElement, boolean inclusive) {
            return Sets.filter(this.unfiltered().headSet(toElement, inclusive), this.predicate);
        }

        public NavigableSet<E> tailSet(@ParametricNullness E fromElement, boolean inclusive) {
            return Sets.filter(this.unfiltered().tailSet(fromElement, inclusive), this.predicate);
        }
    }

    private static class FilteredSortedSet<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends FilteredSet<E>
    implements SortedSet<E> {
        FilteredSortedSet(SortedSet<E> unfiltered, Predicate<? super E> predicate) {
            super(unfiltered, predicate);
        }

        @CheckForNull
        public Comparator<? super E> comparator() {
            return ((SortedSet)this.unfiltered).comparator();
        }

        public SortedSet<E> subSet(@ParametricNullness E fromElement, @ParametricNullness E toElement) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).subSet(fromElement, toElement), this.predicate);
        }

        public SortedSet<E> headSet(@ParametricNullness E toElement) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).headSet(toElement), this.predicate);
        }

        public SortedSet<E> tailSet(@ParametricNullness E fromElement) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).tailSet(fromElement), this.predicate);
        }

        @ParametricNullness
        public E first() {
            return (E)Iterators.find(this.unfiltered.iterator(), this.predicate);
        }

        @ParametricNullness
        public E last() {
            SortedSet sortedUnfiltered = (SortedSet)this.unfiltered;
            org.rascalmpl.java.lang.Object element;
            while (!this.predicate.apply(element = sortedUnfiltered.last())) {
                sortedUnfiltered = sortedUnfiltered.headSet(element);
            }
            return (E)element;
        }
    }

    private static class FilteredSet<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends Collections2.FilteredCollection<E>
    implements Set<E> {
        FilteredSet(Set<E> unfiltered, Predicate<? super E> predicate) {
            super(unfiltered, predicate);
        }

        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object object) {
            return Sets.equalsImpl(this, object);
        }

        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    public static abstract class SetView<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends AbstractSet<E> {
        private SetView() {
        }

        public ImmutableSet<@NonNull E> immutableCopy() {
            return ImmutableSet.copyOf(this);
        }

        @CanIgnoreReturnValue
        public <S extends Set<E>> S copyInto(S set) {
            set.addAll((Collection)this);
            return set;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
        public final boolean add(@ParametricNullness E e) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        @CanIgnoreReturnValue
        @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
        public final boolean remove(@CheckForNull org.rascalmpl.java.lang.Object object) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        @CanIgnoreReturnValue
        @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
        public final boolean addAll(Collection<? extends E> newElements) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        @CanIgnoreReturnValue
        @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
        public final boolean removeAll(Collection<?> oldElements) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        @CanIgnoreReturnValue
        @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
        public final boolean removeIf(org.rascalmpl.java.util.function.Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        @CanIgnoreReturnValue
        @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
        public final boolean retainAll(Collection<?> elementsToKeep) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        public abstract UnmodifiableIterator<E> iterator();
    }

    static abstract class ImprovedAbstractSet<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends AbstractSet<E> {
        ImprovedAbstractSet() {
        }

        public boolean removeAll(Collection<?> c) {
            return Sets.removeAllImpl(this, c);
        }

        public boolean retainAll(Collection<?> c) {
            return super.retainAll(Preconditions.checkNotNull(c));
        }
    }
}

