/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.collect.BoundType;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.Multiset;
import org.rascalmpl.com.google.common.collect.Multisets;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.com.google.common.collect.SortedMultiset;
import org.rascalmpl.com.google.j2objc.annotations.Weak;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.NavigableSet;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.java.util.SortedSet;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class SortedMultisets
extends Object {
    private SortedMultisets() {
    }

    private static <E extends Object> E getElementOrThrow(@CheckForNull Multiset.Entry<E> entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getElement();
    }

    @CheckForNull
    private static <E extends Object> E getElementOrNull(@CheckForNull Multiset.Entry<E> entry) {
        return entry == null ? null : (E)entry.getElement();
    }

    @GwtIncompatible
    static class NavigableElementSet<E extends @Nullable Object>
    extends ElementSet<E>
    implements NavigableSet<E> {
        NavigableElementSet(SortedMultiset<E> multiset) {
            super(multiset);
        }

        @CheckForNull
        public E lower(@ParametricNullness E e) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().headMultiset(e, BoundType.OPEN).lastEntry());
        }

        @CheckForNull
        public E floor(@ParametricNullness E e) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().headMultiset(e, BoundType.CLOSED).lastEntry());
        }

        @CheckForNull
        public E ceiling(@ParametricNullness E e) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().tailMultiset(e, BoundType.CLOSED).firstEntry());
        }

        @CheckForNull
        public E higher(@ParametricNullness E e) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().tailMultiset(e, BoundType.OPEN).firstEntry());
        }

        public NavigableSet<E> descendingSet() {
            return new NavigableElementSet(this.multiset().descendingMultiset());
        }

        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @CheckForNull
        public E pollFirst() {
            return (E)SortedMultisets.getElementOrNull(this.multiset().pollFirstEntry());
        }

        @CheckForNull
        public E pollLast() {
            return (E)SortedMultisets.getElementOrNull(this.multiset().pollLastEntry());
        }

        public NavigableSet<E> subSet(@ParametricNullness E fromElement, boolean fromInclusive, @ParametricNullness E toElement, boolean toInclusive) {
            return new NavigableElementSet<E>(this.multiset().subMultiset(fromElement, BoundType.forBoolean(fromInclusive), toElement, BoundType.forBoolean(toInclusive)));
        }

        public NavigableSet<E> headSet(@ParametricNullness E toElement, boolean inclusive) {
            return new NavigableElementSet<E>(this.multiset().headMultiset(toElement, BoundType.forBoolean(inclusive)));
        }

        public NavigableSet<E> tailSet(@ParametricNullness E fromElement, boolean inclusive) {
            return new NavigableElementSet<E>(this.multiset().tailMultiset(fromElement, BoundType.forBoolean(inclusive)));
        }
    }

    static class ElementSet<E extends @Nullable Object>
    extends Multisets.ElementSet<E>
    implements SortedSet<E> {
        @Weak
        private final SortedMultiset<E> multiset;

        ElementSet(SortedMultiset<E> multiset) {
            this.multiset = multiset;
        }

        @Override
        final SortedMultiset<E> multiset() {
            return this.multiset;
        }

        @Override
        public Iterator<E> iterator() {
            return Multisets.elementIterator(this.multiset().entrySet().iterator());
        }

        public Comparator<? super E> comparator() {
            return this.multiset().comparator();
        }

        public SortedSet<E> subSet(@ParametricNullness E fromElement, @ParametricNullness E toElement) {
            return this.multiset().subMultiset(fromElement, BoundType.CLOSED, toElement, BoundType.OPEN).elementSet();
        }

        public SortedSet<E> headSet(@ParametricNullness E toElement) {
            return this.multiset().headMultiset(toElement, BoundType.OPEN).elementSet();
        }

        public SortedSet<E> tailSet(@ParametricNullness E fromElement) {
            return this.multiset().tailMultiset(fromElement, BoundType.CLOSED).elementSet();
        }

        @ParametricNullness
        public E first() {
            return (E)SortedMultisets.getElementOrThrow(this.multiset().firstEntry());
        }

        @ParametricNullness
        public E last() {
            return (E)SortedMultisets.getElementOrThrow(this.multiset().lastEntry());
        }
    }
}

