/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.BaseImmutableMultimap;
import org.rascalmpl.com.google.common.collect.BiMap;
import org.rascalmpl.com.google.common.collect.Collections2;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ForwardingMapEntry;
import org.rascalmpl.com.google.common.collect.ImmutableBiMap;
import org.rascalmpl.com.google.common.collect.ImmutableMultiset;
import org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.com.google.common.collect.ListMultimap;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.Multimap;
import org.rascalmpl.com.google.common.collect.Multiset;
import org.rascalmpl.com.google.common.collect.ObjectArrays;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.com.google.common.collect.SetMultimap;
import org.rascalmpl.com.google.common.collect.Sets;
import org.rascalmpl.com.google.common.collect.SortedSetMultimap;
import org.rascalmpl.com.google.common.collect.Table;
import org.rascalmpl.com.google.common.collect.TransformedIterator;
import org.rascalmpl.com.google.j2objc.annotations.RetainedWith;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.ObjectOutputStream;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.Deque;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.ListIterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.NavigableMap;
import org.rascalmpl.java.util.NavigableSet;
import org.rascalmpl.java.util.Queue;
import org.rascalmpl.java.util.RandomAccess;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.SortedMap;
import org.rascalmpl.java.util.SortedSet;
import org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.java.util.function.BiConsumer;
import org.rascalmpl.java.util.function.BiFunction;
import org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.java.util.function.Function;
import org.rascalmpl.java.util.function.Predicate;
import org.rascalmpl.java.util.function.UnaryOperator;
import org.rascalmpl.java.util.stream.Stream;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.NonNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Synchronized
extends org.rascalmpl.java.lang.Object {
    private Synchronized() {
    }

    private static <E extends org.rascalmpl.java.lang.Object> Collection<E> collection(Collection<E> collection, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        return new SynchronizedCollection(collection, mutex);
    }

    @VisibleForTesting
    static <E extends org.rascalmpl.java.lang.Object> Set<E> set(Set<E> set, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        return new SynchronizedSet<E>(set, mutex);
    }

    private static <E extends org.rascalmpl.java.lang.Object> SortedSet<E> sortedSet(SortedSet<E> set, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        return new SynchronizedSortedSet<E>(set, mutex);
    }

    private static <E extends org.rascalmpl.java.lang.Object> List<E> list(List<E> list, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList<E>(list, mutex) : new SynchronizedList<E>(list, mutex);
    }

    static <E extends org.rascalmpl.java.lang.Object> Multiset<E> multiset(Multiset<E> multiset, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        if (multiset instanceof SynchronizedMultiset || multiset instanceof ImmutableMultiset) {
            return multiset;
        }
        return new SynchronizedMultiset<E>(multiset, mutex);
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Multimap<K, V> multimap(Multimap<K, V> multimap, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        if (multimap instanceof SynchronizedMultimap || multimap instanceof BaseImmutableMultimap) {
            return multimap;
        }
        return new SynchronizedMultimap<K, V>(multimap, mutex);
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> ListMultimap<K, V> listMultimap(ListMultimap<K, V> multimap, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        if (multimap instanceof SynchronizedListMultimap || multimap instanceof BaseImmutableMultimap) {
            return multimap;
        }
        return new SynchronizedListMultimap<K, V>(multimap, mutex);
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> SetMultimap<K, V> setMultimap(SetMultimap<K, V> multimap, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        if (multimap instanceof SynchronizedSetMultimap || multimap instanceof BaseImmutableMultimap) {
            return multimap;
        }
        return new SynchronizedSetMultimap<K, V>(multimap, mutex);
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> SortedSetMultimap<K, V> sortedSetMultimap(SortedSetMultimap<K, V> multimap, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        if (multimap instanceof SynchronizedSortedSetMultimap) {
            return multimap;
        }
        return new SynchronizedSortedSetMultimap<K, V>(multimap, mutex);
    }

    private static <E extends org.rascalmpl.java.lang.Object> Collection<E> typePreservingCollection(Collection<E> collection, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        if (collection instanceof SortedSet) {
            return Synchronized.sortedSet((SortedSet)collection, mutex);
        }
        if (collection instanceof Set) {
            return Synchronized.set((Set)collection, mutex);
        }
        if (collection instanceof List) {
            return Synchronized.list((List)collection, mutex);
        }
        return Synchronized.collection(collection, mutex);
    }

    private static <E extends org.rascalmpl.java.lang.Object> Set<E> typePreservingSet(Set<E> set, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        if (set instanceof SortedSet) {
            return Synchronized.sortedSet((SortedSet)set, mutex);
        }
        return Synchronized.set(set, mutex);
    }

    @VisibleForTesting
    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Map<K, V> map(Map<K, V> map, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        return new SynchronizedMap<K, V>(map, mutex);
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> SortedMap<K, V> sortedMap(SortedMap<K, V> sortedMap, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        return new SynchronizedSortedMap<K, V>(sortedMap, mutex);
    }

    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> BiMap<K, V> biMap(BiMap<K, V> bimap, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        if (bimap instanceof SynchronizedBiMap || bimap instanceof ImmutableBiMap) {
            return bimap;
        }
        return new SynchronizedBiMap(bimap, mutex, null);
    }

    @GwtIncompatible
    static <E extends org.rascalmpl.java.lang.Object> NavigableSet<E> navigableSet(NavigableSet<E> navigableSet, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        return new SynchronizedNavigableSet<E>(navigableSet, mutex);
    }

    @GwtIncompatible
    static <E extends org.rascalmpl.java.lang.Object> NavigableSet<E> navigableSet(NavigableSet<E> navigableSet) {
        return Synchronized.navigableSet(navigableSet, null);
    }

    @GwtIncompatible
    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> NavigableMap<K, V> navigableMap(NavigableMap<K, V> navigableMap) {
        return Synchronized.navigableMap(navigableMap, null);
    }

    @GwtIncompatible
    static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> NavigableMap<K, V> navigableMap(NavigableMap<K, V> navigableMap, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        return new SynchronizedNavigableMap<K, V>(navigableMap, mutex);
    }

    @CheckForNull
    @GwtIncompatible
    private static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Map.Entry<K, V> nullableSynchronizedEntry(@CheckForNull Map.Entry<K, V> entry, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        if (entry == null) {
            return null;
        }
        return new SynchronizedEntry<K, V>(entry, mutex);
    }

    static <E extends org.rascalmpl.java.lang.Object> Queue<E> queue(Queue<E> queue, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        return queue instanceof SynchronizedQueue ? queue : new SynchronizedQueue(queue, mutex);
    }

    static <E extends org.rascalmpl.java.lang.Object> Deque<E> deque(Deque<E> deque, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        return new SynchronizedDeque<E>(deque, mutex);
    }

    static <R extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Table<R, C, V> table(Table<R, C, V> table, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
        return new SynchronizedTable<R, C, V>(table, mutex);
    }

    static final class SynchronizedTable<R extends @Nullable org.rascalmpl.java.lang.Object, C extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedObject
    implements Table<R, C, V> {
        SynchronizedTable(Table<R, C, V> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        Table<R, C, V> delegate() {
            return (Table)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().contains(rowKey, columnKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsRow(@CheckForNull org.rascalmpl.java.lang.Object rowKey) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().containsRow(rowKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsColumn(@CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().containsColumn(columnKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(@CheckForNull org.rascalmpl.java.lang.Object value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CheckForNull
        public V get(@CheckForNull org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().get(rowKey, columnKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CheckForNull
        public V put(@ParametricNullness R rowKey, @ParametricNullness C columnKey, @ParametricNullness V value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().put(rowKey, columnKey, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().putAll(table);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CheckForNull
        public V remove(@CheckForNull org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().remove(rowKey, columnKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<C, V> row(@ParametricNullness R rowKey) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.map(this.delegate().row(rowKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<R, V> column(@ParametricNullness C columnKey) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.map(this.delegate().column(columnKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Table.Cell<R, C, V>> cellSet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.set(this.delegate().cellSet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<R> rowKeySet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.set(this.delegate().rowKeySet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<C> columnKeySet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.set(this.delegate().columnKeySet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.collection(this.delegate().values(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<R, Map<C, V>> rowMap() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.map(Maps.transformValues(this.delegate().rowMap(), new org.rascalmpl.com.google.common.base.Function<Map<C, V>, Map<C, V>>(){

                    @Override
                    public Map<C, V> apply(Map<C, V> t2) {
                        return Synchronized.map(t2, mutex);
                    }
                }), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<C, Map<R, V>> columnMap() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.map(Maps.transformValues(this.delegate().columnMap(), new org.rascalmpl.com.google.common.base.Function<Map<R, V>, Map<R, V>>(){

                    @Override
                    public Map<R, V> apply(Map<R, V> t2) {
                        return Synchronized.map(t2, mutex);
                    }
                }), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().equals(obj);
            }
        }
    }

    static final class SynchronizedDeque<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedQueue<E>
    implements Deque<E> {
        private static final long serialVersionUID = 0L;

        SynchronizedDeque(Deque<E> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        Deque<E> delegate() {
            return (Deque)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFirst(E e) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().addFirst(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLast(E e) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().addLast(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offerFirst(E e) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().offerFirst(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offerLast(E e) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().offerLast(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E removeFirst() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E removeLast() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E pollFirst() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().pollFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E pollLast() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().pollLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E getFirst() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().getFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E getLast() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().getLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E peekFirst() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().peekFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E peekLast() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().peekLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeFirstOccurrence(@CheckForNull org.rascalmpl.java.lang.Object o) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeFirstOccurrence(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeLastOccurrence(@CheckForNull org.rascalmpl.java.lang.Object o) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeLastOccurrence(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(E e) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().push(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E pop() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator<E> descendingIterator() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().descendingIterator();
            }
        }
    }

    static class SynchronizedQueue<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedCollection<E>
    implements Queue<E> {
        private static final long serialVersionUID = 0L;

        SynchronizedQueue(Queue<E> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super((Collection)delegate, mutex);
        }

        @Override
        Queue<E> delegate() {
            return (Queue)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E element() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().element();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offer(E e) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().offer(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E peek() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E poll() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().poll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E remove() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().remove();
            }
        }
    }

    @GwtIncompatible
    static final class SynchronizedEntry<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedObject
    implements Map.Entry<K, V> {
        private static final long serialVersionUID = 0L;

        SynchronizedEntry(Map.Entry<K, V> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super((org.rascalmpl.java.lang.Object)delegate, mutex);
        }

        Map.Entry<K, V> delegate() {
            return (Map.Entry)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().equals(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public K getKey() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (K)this.delegate().getKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V getValue() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().getValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V setValue(V value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().setValue(value);
            }
        }
    }

    @GwtIncompatible
    @VisibleForTesting
    static final class SynchronizedNavigableMap<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedSortedMap<K, V>
    implements NavigableMap<K, V> {
        @CheckForNull
        transient NavigableSet<K> descendingKeySet;
        @CheckForNull
        transient NavigableMap<K, V> descendingMap;
        @CheckForNull
        transient NavigableSet<K> navigableKeySet;
        private static final long serialVersionUID = 0L;

        SynchronizedNavigableMap(NavigableMap<K, V> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        NavigableMap<K, V> delegate() {
            return (NavigableMap)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Map.Entry<K, V> ceilingEntry(K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().ceilingEntry(key), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public K ceilingKey(K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (K)this.delegate().ceilingKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableSet<K> descendingKeySet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.descendingKeySet == null) {
                    this.descendingKeySet = Synchronized.navigableSet(this.delegate().descendingKeySet(), this.mutex);
                    return this.descendingKeySet;
                }
                return this.descendingKeySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableMap<K, V> descendingMap() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.descendingMap == null) {
                    this.descendingMap = Synchronized.navigableMap(this.delegate().descendingMap(), this.mutex);
                    return this.descendingMap;
                }
                return this.descendingMap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Map.Entry<K, V> firstEntry() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().firstEntry(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Map.Entry<K, V> floorEntry(K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().floorEntry(key), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public K floorKey(K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (K)this.delegate().floorKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.navigableMap(this.delegate().headMap(toKey, inclusive), this.mutex);
            }
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Map.Entry<K, V> higherEntry(K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().higherEntry(key), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public K higherKey(K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (K)this.delegate().higherKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Map.Entry<K, V> lastEntry() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().lastEntry(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Map.Entry<K, V> lowerEntry(K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().lowerEntry(key), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public K lowerKey(K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (K)this.delegate().lowerKey(key);
            }
        }

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableSet<K> navigableKeySet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.navigableKeySet == null) {
                    this.navigableKeySet = Synchronized.navigableSet(this.delegate().navigableKeySet(), this.mutex);
                    return this.navigableKeySet;
                }
                return this.navigableKeySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Map.Entry<K, V> pollFirstEntry() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().pollFirstEntry(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Map.Entry<K, V> pollLastEntry() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.nullableSynchronizedEntry(this.delegate().pollLastEntry(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.navigableMap(this.delegate().subMap(fromKey, fromInclusive, toKey, toInclusive), this.mutex);
            }
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.navigableMap(this.delegate().tailMap(fromKey, inclusive), this.mutex);
            }
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }
    }

    @GwtIncompatible
    @VisibleForTesting
    static final class SynchronizedNavigableSet<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedSortedSet<E>
    implements NavigableSet<E> {
        @CheckForNull
        transient NavigableSet<E> descendingSet;
        private static final long serialVersionUID = 0L;

        SynchronizedNavigableSet(NavigableSet<E> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        NavigableSet<E> delegate() {
            return (NavigableSet)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E ceiling(E e) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().ceiling(e);
            }
        }

        public Iterator<E> descendingIterator() {
            return this.delegate().descendingIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableSet<E> descendingSet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.descendingSet == null) {
                    NavigableSet dS = Synchronized.navigableSet(this.delegate().descendingSet(), this.mutex);
                    this.descendingSet = dS;
                    return dS;
                }
                return this.descendingSet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E floor(E e) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().floor(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.navigableSet(this.delegate().headSet(toElement, inclusive), this.mutex);
            }
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E higher(E e) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().higher(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E lower(E e) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().lower(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E pollFirst() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().pollFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public E pollLast() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().pollLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.navigableSet(this.delegate().subSet(fromElement, fromInclusive, toElement, toInclusive), this.mutex);
            }
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.navigableSet(this.delegate().tailSet(fromElement, inclusive), this.mutex);
            }
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }
    }

    static final class SynchronizedAsMapValues<V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedCollection<Collection<V>> {
        private static final long serialVersionUID = 0L;

        SynchronizedAsMapValues(Collection<Collection<V>> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        public Iterator<Collection<V>> iterator() {
            return new TransformedIterator<Collection<V>, Collection<V>>(super.iterator()){

                @Override
                Collection<V> transform(Collection<V> from) {
                    return Synchronized.typePreservingCollection(from, mutex);
                }
            };
        }
    }

    static final class SynchronizedAsMap<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedMap<K, Collection<V>> {
        @CheckForNull
        transient Set<Map.Entry<K, Collection<V>>> asMapEntrySet;
        @CheckForNull
        transient Collection<Collection<V>> asMapValues;
        private static final long serialVersionUID = 0L;

        SynchronizedAsMap(Map<K, Collection<V>> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CheckForNull
        public Collection<V> get(@CheckForNull org.rascalmpl.java.lang.Object key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                Collection collection = (Collection)super.get(key);
                return collection == null ? null : Synchronized.typePreservingCollection(collection, this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.asMapEntrySet == null) {
                    this.asMapEntrySet = new SynchronizedAsMapEntries(this.delegate().entrySet(), this.mutex);
                }
                return this.asMapEntrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Collection<V>> values() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.asMapValues == null) {
                    this.asMapValues = new SynchronizedAsMapValues(this.delegate().values(), this.mutex);
                }
                return this.asMapValues;
            }
        }

        @Override
        public boolean containsValue(@CheckForNull org.rascalmpl.java.lang.Object o) {
            return this.values().contains(o);
        }
    }

    static final class SynchronizedBiMap<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedMap<K, V>
    implements BiMap<K, V>,
    Serializable {
        @CheckForNull
        private transient Set<V> valueSet;
        @CheckForNull
        @RetainedWith
        private transient BiMap<V, K> inverse;
        private static final long serialVersionUID = 0L;

        private SynchronizedBiMap(BiMap<K, V> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex, @CheckForNull BiMap<V, K> inverse) {
            super(delegate, mutex);
            this.inverse = inverse;
        }

        @Override
        BiMap<K, V> delegate() {
            return (BiMap)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<V> values() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.valueSet == null) {
                    this.valueSet = Synchronized.set(this.delegate().values(), this.mutex);
                }
                return this.valueSet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CheckForNull
        public V forcePut(@ParametricNullness K key, @ParametricNullness V value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().forcePut(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BiMap<V, K> inverse() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.inverse == null) {
                    this.inverse = new SynchronizedBiMap<K, V>(this.delegate().inverse(), this.mutex, this);
                }
                return this.inverse;
            }
        }
    }

    static class SynchronizedSortedMap<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = 0L;

        SynchronizedSortedMap(SortedMap<K, V> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        SortedMap<K, V> delegate() {
            return (SortedMap)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Comparator<? super K> comparator() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public K firstKey() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (K)this.delegate().firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap<K, V> headMap(K toKey) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.sortedMap(this.delegate().headMap(toKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public K lastKey() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (K)this.delegate().lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.sortedMap(this.delegate().subMap(fromKey, toKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap<K, V> tailMap(K fromKey) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.sortedMap(this.delegate().tailMap(fromKey), this.mutex);
            }
        }
    }

    static class SynchronizedMap<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedObject
    implements Map<K, V> {
        @CheckForNull
        transient Set<K> keySet;
        @CheckForNull
        transient Collection<V> values;
        @CheckForNull
        transient Set<Map.Entry<K, V>> entrySet;
        private static final long serialVersionUID = 0L;

        SynchronizedMap(Map<K, V> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super((org.rascalmpl.java.lang.Object)delegate, mutex);
        }

        Map<K, V> delegate() {
            return (Map)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(@CheckForNull org.rascalmpl.java.lang.Object key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(@CheckForNull org.rascalmpl.java.lang.Object value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Map.Entry<K, V>> entrySet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = Synchronized.set(this.delegate().entrySet(), this.mutex);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(BiConsumer<? super K, ? super V> action) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().forEach(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public V get(@CheckForNull org.rascalmpl.java.lang.Object key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public V getOrDefault(@CheckForNull org.rascalmpl.java.lang.Object key, @CheckForNull V defaultValue) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().getOrDefault(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<K> keySet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = Synchronized.set(this.delegate().keySet(), this.mutex);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public V put(K key, V value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public V putIfAbsent(K key, V value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().putIfAbsent(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replace(K key, V oldValue, V newValue) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().replace(key, oldValue, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public V replace(K key, V value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().replace(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().computeIfAbsent(key, mappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public V computeIfPresent(K key, BiFunction<? super K, ? super @NonNull V, ? extends @Nullable V> remappingFunction) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().computeIfPresent(key, remappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public V compute(K key, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> remappingFunction) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().compute(key, remappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public V merge(K key, @NonNull V value, BiFunction<? super @NonNull V, ? super @NonNull V, ? extends @Nullable V> remappingFunction) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().merge(key, value, remappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map<? extends K, ? extends V> map) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().replaceAll(function);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public V remove(@CheckForNull org.rascalmpl.java.lang.Object key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (V)this.delegate().remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(@CheckForNull org.rascalmpl.java.lang.Object key, @CheckForNull org.rascalmpl.java.lang.Object value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().remove(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<V> values() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = Synchronized.collection(this.delegate().values(), this.mutex);
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
            if (o == this) {
                return true;
            }
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }
    }

    static final class SynchronizedAsMapEntries<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedSet<Map.Entry<K, Collection<V>>> {
        private static final long serialVersionUID = 0L;

        SynchronizedAsMapEntries(Set<Map.Entry<K, Collection<V>>> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            return new TransformedIterator<Map.Entry<K, Collection<V>>, Map.Entry<K, Collection<V>>>(super.iterator()){

                @Override
                Map.Entry<K, Collection<V>> transform(final Map.Entry<K, Collection<V>> entry) {
                    return new ForwardingMapEntry<K, Collection<V>>(){

                        @Override
                        protected Map.Entry<K, Collection<V>> delegate() {
                            return entry;
                        }

                        @Override
                        public Collection<V> getValue() {
                            return Synchronized.typePreservingCollection((Collection)entry.getValue(), mutex);
                        }
                    };
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @Nullable org.rascalmpl.java.lang.Object[] toArray() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return ObjectArrays.toArrayImpl(this.delegate());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T extends org.rascalmpl.java.lang.Object> T[] toArray(T[] array) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return ObjectArrays.toArrayImpl(this.delegate(), array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object o) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Maps.containsEntryImpl(this.delegate(), o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Collections2.containsAllImpl(this.delegate(), c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
            if (o == this) {
                return true;
            }
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Sets.equalsImpl(this.delegate(), o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(@CheckForNull org.rascalmpl.java.lang.Object o) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Maps.removeEntryImpl(this.delegate(), o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Iterators.removeAll(this.delegate().iterator(), c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Iterators.retainAll(this.delegate().iterator(), c);
            }
        }
    }

    static final class SynchronizedSortedSetMultimap<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedSetMultimap<K, V>
    implements SortedSetMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        SynchronizedSortedSetMultimap(SortedSetMultimap<K, V> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        SortedSetMultimap<K, V> delegate() {
            return (SortedSetMultimap)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<V> get(K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.sortedSet(this.delegate().get(key), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<V> removeAll(@CheckForNull org.rascalmpl.java.lang.Object key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeAll(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<V> replaceValues(K key, Iterable<? extends V> values) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().replaceValues(key, values);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CheckForNull
        public Comparator<? super V> valueComparator() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().valueComparator();
            }
        }
    }

    static class SynchronizedSetMultimap<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedMultimap<K, V>
    implements SetMultimap<K, V> {
        @CheckForNull
        transient Set<Map.Entry<K, V>> entrySet;
        private static final long serialVersionUID = 0L;

        SynchronizedSetMultimap(SetMultimap<K, V> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        SetMultimap<K, V> delegate() {
            return (SetMultimap)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<V> get(K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.set(this.delegate().get(key), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<V> removeAll(@CheckForNull org.rascalmpl.java.lang.Object key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeAll(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<V> replaceValues(K key, Iterable<? extends V> values) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().replaceValues(key, values);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entries() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = Synchronized.set(this.delegate().entries(), this.mutex);
                }
                return this.entrySet;
            }
        }
    }

    static final class SynchronizedListMultimap<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedMultimap<K, V>
    implements ListMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        SynchronizedListMultimap(ListMultimap<K, V> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        ListMultimap<K, V> delegate() {
            return (ListMultimap)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<V> get(K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.list(this.delegate().get(key), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<V> removeAll(@CheckForNull org.rascalmpl.java.lang.Object key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeAll(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<V> replaceValues(K key, Iterable<? extends V> values) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().replaceValues(key, values);
            }
        }
    }

    static class SynchronizedMultimap<K extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedObject
    implements Multimap<K, V> {
        @CheckForNull
        transient Set<K> keySet;
        @CheckForNull
        transient Collection<V> valuesCollection;
        @CheckForNull
        transient Collection<Map.Entry<K, V>> entries;
        @CheckForNull
        transient Map<K, Collection<V>> asMap;
        @CheckForNull
        transient Multiset<K> keys;
        private static final long serialVersionUID = 0L;

        @Override
        Multimap<K, V> delegate() {
            return (Multimap)super.delegate();
        }

        SynchronizedMultimap(Multimap<K, V> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(@CheckForNull org.rascalmpl.java.lang.Object key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(@CheckForNull org.rascalmpl.java.lang.Object value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsEntry(@CheckForNull org.rascalmpl.java.lang.Object key, @CheckForNull org.rascalmpl.java.lang.Object value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().containsEntry(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> get(@ParametricNullness K key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.typePreservingCollection(this.delegate().get(key), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean put(@ParametricNullness K key, @ParametricNullness V value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean putAll(@ParametricNullness K key, Iterable<? extends V> values) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().putAll(key, values);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().putAll(multimap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().replaceValues(key, values);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(@CheckForNull org.rascalmpl.java.lang.Object key, @CheckForNull org.rascalmpl.java.lang.Object value) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().remove(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> removeAll(@CheckForNull org.rascalmpl.java.lang.Object key) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeAll(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = Synchronized.typePreservingSet(this.delegate().keySet(), this.mutex);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.valuesCollection == null) {
                    this.valuesCollection = Synchronized.collection(this.delegate().values(), this.mutex);
                }
                return this.valuesCollection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Map.Entry<K, V>> entries() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.entries == null) {
                    this.entries = Synchronized.typePreservingCollection(this.delegate().entries(), this.mutex);
                }
                return this.entries;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().forEach(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<K, Collection<V>> asMap() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.asMap == null) {
                    this.asMap = new SynchronizedAsMap(this.delegate().asMap(), this.mutex);
                }
                return this.asMap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Multiset<K> keys() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.keys == null) {
                    this.keys = Synchronized.multiset(this.delegate().keys(), this.mutex);
                }
                return this.keys;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
            if (o == this) {
                return true;
            }
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }
    }

    static final class SynchronizedMultiset<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedCollection<E>
    implements Multiset<E> {
        @CheckForNull
        transient Set<E> elementSet;
        @CheckForNull
        transient Set<Multiset.Entry<E>> entrySet;
        private static final long serialVersionUID = 0L;

        SynchronizedMultiset(Multiset<E> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        Multiset<E> delegate() {
            return (Multiset)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int count(@CheckForNull org.rascalmpl.java.lang.Object o) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().count(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int add(@ParametricNullness E e, int n) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().add(e, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int remove(@CheckForNull org.rascalmpl.java.lang.Object o, int n) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().remove(o, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int setCount(@ParametricNullness E element, int count) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().setCount(element, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setCount(@ParametricNullness E element, int oldCount, int newCount) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().setCount(element, oldCount, newCount);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<E> elementSet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.elementSet == null) {
                    this.elementSet = Synchronized.typePreservingSet(this.delegate().elementSet(), this.mutex);
                }
                return this.elementSet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = Synchronized.typePreservingSet(this.delegate().entrySet(), this.mutex);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
            if (o == this) {
                return true;
            }
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }
    }

    static final class SynchronizedRandomAccessList<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 0L;

        SynchronizedRandomAccessList(List<E> list, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(list, mutex);
        }
    }

    static class SynchronizedList<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 0L;

        SynchronizedList(List<E> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super((Collection)delegate, mutex);
        }

        @Override
        List<E> delegate() {
            return (List)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, E element) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().add(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection<? extends E> c) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E get(int index) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(@CheckForNull org.rascalmpl.java.lang.Object o) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(@CheckForNull org.rascalmpl.java.lang.Object o) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().lastIndexOf(o);
            }
        }

        public ListIterator<E> listIterator() {
            return this.delegate().listIterator();
        }

        public ListIterator<E> listIterator(int index) {
            return this.delegate().listIterator(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E remove(int index) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E set(int index, E element) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().set(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceAll(UnaryOperator<E> operator) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().replaceAll(operator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sort(@Nullable Comparator<? super E> c) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().sort(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<E> subList(int fromIndex, int toIndex) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.list(this.delegate().subList(fromIndex, toIndex), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
            if (o == this) {
                return true;
            }
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }
    }

    static class SynchronizedSortedSet<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 0L;

        SynchronizedSortedSet(SortedSet<E> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super(delegate, mutex);
        }

        @Override
        SortedSet<E> delegate() {
            return (SortedSet)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Comparator<? super E> comparator() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet<E> subSet(E fromElement, E toElement) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.sortedSet(this.delegate().subSet(fromElement, toElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet<E> headSet(E toElement) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.sortedSet(this.delegate().headSet(toElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet<E> tailSet(E fromElement) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return Synchronized.sortedSet(this.delegate().tailSet(fromElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E first() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E last() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return (E)this.delegate().last();
            }
        }
    }

    static class SynchronizedSet<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 0L;

        SynchronizedSet(Set<E> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super((Collection)delegate, mutex);
        }

        @Override
        Set<E> delegate() {
            return (Set)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
            if (o == this) {
                return true;
            }
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }
    }

    @VisibleForTesting
    static class SynchronizedCollection<E extends @Nullable org.rascalmpl.java.lang.Object>
    extends SynchronizedObject
    implements Collection<E> {
        private static final long serialVersionUID = 0L;

        private SynchronizedCollection(Collection<E> delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            super((org.rascalmpl.java.lang.Object)delegate, mutex);
        }

        Collection<E> delegate() {
            return (Collection)super.delegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(E e) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection<? extends E> c) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object o) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection<?> c) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        public Iterator<E> iterator() {
            return this.delegate().iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Spliterator<E> spliterator() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().spliterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Stream<E> stream() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().stream();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Stream<E> parallelStream() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().parallelStream();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(Consumer<? super E> action) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                this.delegate().forEach(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(@CheckForNull org.rascalmpl.java.lang.Object o) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection<?> c) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection<?> c) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeIf(Predicate<? super E> filter) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeIf(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable org.rascalmpl.java.lang.Object[] toArray() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends org.rascalmpl.java.lang.Object> T[] toArray(T[] a) {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate().toArray(a);
            }
        }
    }

    static class SynchronizedObject
    extends org.rascalmpl.java.lang.Object
    implements Serializable {
        final org.rascalmpl.java.lang.Object delegate;
        final org.rascalmpl.java.lang.Object mutex;
        @GwtIncompatible
        @J2ktIncompatible
        private static final long serialVersionUID = 0L;

        SynchronizedObject(org.rascalmpl.java.lang.Object delegate, @CheckForNull org.rascalmpl.java.lang.Object mutex) {
            this.delegate = Preconditions.checkNotNull(delegate);
            this.mutex = mutex == null ? this : mutex;
        }

        org.rascalmpl.java.lang.Object delegate() {
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                return this.delegate.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GwtIncompatible
        @J2ktIncompatible
        private void writeObject(ObjectOutputStream stream) throws IOException {
            org.rascalmpl.java.lang.Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }
    }
}

