/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Supplier;
import org.rascalmpl.com.google.common.collect.AbstractTable;
import org.rascalmpl.com.google.common.collect.CollectSpliterators;
import org.rascalmpl.com.google.common.collect.Collections2;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ForwardingTable;
import org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.NullnessCasts;
import org.rascalmpl.com.google.common.collect.ParametricNullness;
import org.rascalmpl.com.google.common.collect.RowSortedTable;
import org.rascalmpl.com.google.common.collect.StandardTable;
import org.rascalmpl.com.google.common.collect.Synchronized;
import org.rascalmpl.com.google.common.collect.Table;
import org.rascalmpl.com.google.common.collect.TableCollectors;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.SortedMap;
import org.rascalmpl.java.util.SortedSet;
import org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.java.util.function.BinaryOperator;
import org.rascalmpl.java.util.function.Function;
import org.rascalmpl.java.util.stream.Collector;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Tables
extends org.rascalmpl.java.lang.Object {
    private static final org.rascalmpl.com.google.common.base.Function<? extends Map<?, ?>, ? extends Map<?, ?>> UNMODIFIABLE_WRAPPER = new org.rascalmpl.com.google.common.base.Function<Map<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object>, Map<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object>>(){

        @Override
        public Map<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object> apply(Map<org.rascalmpl.java.lang.Object, org.rascalmpl.java.lang.Object> input) {
            return Collections.unmodifiableMap(input);
        }
    };

    private Tables() {
    }

    public static <T extends org.rascalmpl.java.lang.Object, R extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object, I extends Table<R, C, V>> Collector<T, ?, I> toTable(Function<? super T, ? extends R> rowFunction, Function<? super T, ? extends C> columnFunction, Function<? super T, ? extends V> valueFunction, org.rascalmpl.java.util.function.Supplier<I> tableSupplier) {
        return TableCollectors.toTable(rowFunction, columnFunction, valueFunction, tableSupplier);
    }

    public static <T extends org.rascalmpl.java.lang.Object, R extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object, I extends Table<R, C, V>> Collector<T, ?, I> toTable(Function<? super T, ? extends R> rowFunction, Function<? super T, ? extends C> columnFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction, org.rascalmpl.java.util.function.Supplier<I> tableSupplier) {
        return TableCollectors.toTable(rowFunction, columnFunction, valueFunction, mergeFunction, tableSupplier);
    }

    public static <R extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Table.Cell<R, C, V> immutableCell(@ParametricNullness R rowKey, @ParametricNullness C columnKey, @ParametricNullness V value) {
        return new ImmutableCell<R, C, V>(rowKey, columnKey, value);
    }

    public static <R extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Table<C, R, V> transpose(Table<R, C, V> table) {
        return table instanceof TransposeTable ? ((TransposeTable)table).original : new TransposeTable<C, R, V>(table);
    }

    private static <R extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Table.Cell<C, R, V> transposeCell(Table.Cell<R, C, V> cell) {
        return Tables.immutableCell(cell.getColumnKey(), cell.getRowKey(), cell.getValue());
    }

    public static <R extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Table<R, C, V> newCustomTable(Map<R, Map<C, V>> backingMap, Supplier<? extends Map<C, V>> factory) {
        Preconditions.checkArgument(backingMap.isEmpty());
        Preconditions.checkNotNull(factory);
        return new StandardTable<R, C, V>(backingMap, factory);
    }

    public static <R extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object, V1 extends org.rascalmpl.java.lang.Object, V2 extends org.rascalmpl.java.lang.Object> Table<R, C, V2> transformValues(Table<R, C, V1> fromTable, org.rascalmpl.com.google.common.base.Function<? super V1, V2> function) {
        return new TransformedTable<R, C, V1, V2>(fromTable, function);
    }

    public static <R extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Table<R, C, V> unmodifiableTable(Table<? extends R, ? extends C, ? extends V> table) {
        return new UnmodifiableTable<R, C, V>(table);
    }

    public static <R extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> RowSortedTable<R, C, V> unmodifiableRowSortedTable(RowSortedTable<R, ? extends C, ? extends V> table) {
        return new UnmodifiableRowSortedMap<R, C, V>(table);
    }

    private static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> org.rascalmpl.com.google.common.base.Function<Map<K, V>, Map<K, V>> unmodifiableWrapper() {
        return UNMODIFIABLE_WRAPPER;
    }

    public static <R extends org.rascalmpl.java.lang.Object, C extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Table<R, C, V> synchronizedTable(Table<R, C, V> table) {
        return Synchronized.table(table, null);
    }

    static boolean equalsImpl(Table<?, ?, ?> table, @CheckForNull org.rascalmpl.java.lang.Object obj) {
        if (obj == table) {
            return true;
        }
        if (obj instanceof Table) {
            Table that = (Table)obj;
            return table.cellSet().equals(that.cellSet());
        }
        return false;
    }

    private static final class UnmodifiableRowSortedMap<R extends @Nullable org.rascalmpl.java.lang.Object, C extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends UnmodifiableTable<R, C, V>
    implements RowSortedTable<R, C, V> {
        private static final long serialVersionUID = 0L;

        public UnmodifiableRowSortedMap(RowSortedTable<R, ? extends C, ? extends V> delegate) {
            super(delegate);
        }

        @Override
        protected RowSortedTable<R, C, V> delegate() {
            return (RowSortedTable)super.delegate();
        }

        @Override
        public SortedMap<R, Map<C, V>> rowMap() {
            org.rascalmpl.com.google.common.base.Function wrapper = Tables.unmodifiableWrapper();
            return Collections.unmodifiableSortedMap(Maps.transformValues(this.delegate().rowMap(), wrapper));
        }

        @Override
        public SortedSet<R> rowKeySet() {
            return Collections.unmodifiableSortedSet(this.delegate().rowKeySet());
        }
    }

    private static class UnmodifiableTable<R extends @Nullable org.rascalmpl.java.lang.Object, C extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends ForwardingTable<R, C, V>
    implements Serializable {
        final Table<? extends R, ? extends C, ? extends V> delegate;
        private static final long serialVersionUID = 0L;

        UnmodifiableTable(Table<? extends R, ? extends C, ? extends V> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected Table<R, C, V> delegate() {
            return this.delegate;
        }

        @Override
        public Set<Table.Cell<R, C, V>> cellSet() {
            return Collections.unmodifiableSet(super.cellSet());
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<R, V> column(@ParametricNullness C columnKey) {
            return Collections.unmodifiableMap(super.column(columnKey));
        }

        @Override
        public Set<C> columnKeySet() {
            return Collections.unmodifiableSet(super.columnKeySet());
        }

        @Override
        public Map<C, Map<R, V>> columnMap() {
            org.rascalmpl.com.google.common.base.Function wrapper = Tables.unmodifiableWrapper();
            return Collections.unmodifiableMap(Maps.transformValues(super.columnMap(), wrapper));
        }

        @Override
        @CheckForNull
        public V put(@ParametricNullness R rowKey, @ParametricNullness C columnKey, @ParametricNullness V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
            throw new UnsupportedOperationException();
        }

        @Override
        @CheckForNull
        public V remove(@CheckForNull org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<C, V> row(@ParametricNullness R rowKey) {
            return Collections.unmodifiableMap(super.row(rowKey));
        }

        @Override
        public Set<R> rowKeySet() {
            return Collections.unmodifiableSet(super.rowKeySet());
        }

        @Override
        public Map<R, Map<C, V>> rowMap() {
            org.rascalmpl.com.google.common.base.Function wrapper = Tables.unmodifiableWrapper();
            return Collections.unmodifiableMap(Maps.transformValues(super.rowMap(), wrapper));
        }

        @Override
        public Collection<V> values() {
            return Collections.unmodifiableCollection(super.values());
        }
    }

    private static class TransformedTable<R extends @Nullable org.rascalmpl.java.lang.Object, C extends @Nullable org.rascalmpl.java.lang.Object, V1 extends @Nullable org.rascalmpl.java.lang.Object, V2 extends @Nullable org.rascalmpl.java.lang.Object>
    extends AbstractTable<R, C, V2> {
        final Table<R, C, V1> fromTable;
        final org.rascalmpl.com.google.common.base.Function<? super V1, V2> function;

        TransformedTable(Table<R, C, V1> fromTable, org.rascalmpl.com.google.common.base.Function<? super V1, V2> function) {
            this.fromTable = Preconditions.checkNotNull(fromTable);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            return this.fromTable.contains(rowKey, columnKey);
        }

        @Override
        @CheckForNull
        public V2 get(@CheckForNull org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            return this.contains(rowKey, columnKey) ? (V2)this.function.apply((V1)NullnessCasts.uncheckedCastNullableTToT(this.fromTable.get(rowKey, columnKey))) : null;
        }

        @Override
        public int size() {
            return this.fromTable.size();
        }

        @Override
        public void clear() {
            this.fromTable.clear();
        }

        @Override
        @CheckForNull
        public V2 put(@ParametricNullness R rowKey, @ParametricNullness C columnKey, @ParametricNullness V2 value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Table<? extends R, ? extends C, ? extends V2> table) {
            throw new UnsupportedOperationException();
        }

        @Override
        @CheckForNull
        public V2 remove(@CheckForNull org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            return this.contains(rowKey, columnKey) ? (V2)this.function.apply((V1)NullnessCasts.uncheckedCastNullableTToT(this.fromTable.remove(rowKey, columnKey))) : null;
        }

        @Override
        public Map<C, V2> row(@ParametricNullness R rowKey) {
            return Maps.transformValues(this.fromTable.row(rowKey), this.function);
        }

        @Override
        public Map<R, V2> column(@ParametricNullness C columnKey) {
            return Maps.transformValues(this.fromTable.column(columnKey), this.function);
        }

        org.rascalmpl.com.google.common.base.Function<Table.Cell<R, C, V1>, Table.Cell<R, C, V2>> cellFunction() {
            return new org.rascalmpl.com.google.common.base.Function<Table.Cell<R, C, V1>, Table.Cell<R, C, V2>>(){

                @Override
                public Table.Cell<R, C, V2> apply(Table.Cell<R, C, V1> cell) {
                    return Tables.immutableCell(cell.getRowKey(), cell.getColumnKey(), function.apply(cell.getValue()));
                }
            };
        }

        @Override
        Iterator<Table.Cell<R, C, V2>> cellIterator() {
            return Iterators.transform(this.fromTable.cellSet().iterator(), this.cellFunction());
        }

        @Override
        Spliterator<Table.Cell<R, C, V2>> cellSpliterator() {
            return CollectSpliterators.map(this.fromTable.cellSet().spliterator(), this.cellFunction());
        }

        @Override
        public Set<R> rowKeySet() {
            return this.fromTable.rowKeySet();
        }

        @Override
        public Set<C> columnKeySet() {
            return this.fromTable.columnKeySet();
        }

        @Override
        Collection<V2> createValues() {
            return Collections2.transform(this.fromTable.values(), this.function);
        }

        @Override
        public Map<R, Map<C, V2>> rowMap() {
            org.rascalmpl.com.google.common.base.Function rowFunction = new org.rascalmpl.com.google.common.base.Function<Map<C, V1>, Map<C, V2>>(){

                @Override
                public Map<C, V2> apply(Map<C, V1> row) {
                    return Maps.transformValues(row, function);
                }
            };
            return Maps.transformValues(this.fromTable.rowMap(), rowFunction);
        }

        @Override
        public Map<C, Map<R, V2>> columnMap() {
            org.rascalmpl.com.google.common.base.Function columnFunction = new org.rascalmpl.com.google.common.base.Function<Map<R, V1>, Map<R, V2>>(){

                @Override
                public Map<R, V2> apply(Map<R, V1> column) {
                    return Maps.transformValues(column, function);
                }
            };
            return Maps.transformValues(this.fromTable.columnMap(), columnFunction);
        }
    }

    private static class TransposeTable<C extends @Nullable org.rascalmpl.java.lang.Object, R extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends AbstractTable<C, R, V> {
        final Table<R, C, V> original;

        TransposeTable(Table<R, C, V> original) {
            this.original = Preconditions.checkNotNull(original);
        }

        @Override
        public void clear() {
            this.original.clear();
        }

        @Override
        public Map<C, V> column(@ParametricNullness R columnKey) {
            return this.original.row(columnKey);
        }

        @Override
        public Set<R> columnKeySet() {
            return this.original.rowKeySet();
        }

        @Override
        public Map<R, Map<C, V>> columnMap() {
            return this.original.rowMap();
        }

        @Override
        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            return this.original.contains(columnKey, rowKey);
        }

        @Override
        public boolean containsColumn(@CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            return this.original.containsRow(columnKey);
        }

        @Override
        public boolean containsRow(@CheckForNull org.rascalmpl.java.lang.Object rowKey) {
            return this.original.containsColumn(rowKey);
        }

        @Override
        public boolean containsValue(@CheckForNull org.rascalmpl.java.lang.Object value) {
            return this.original.containsValue(value);
        }

        @Override
        @CheckForNull
        public V get(@CheckForNull org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            return this.original.get(columnKey, rowKey);
        }

        @Override
        @CheckForNull
        public V put(@ParametricNullness C rowKey, @ParametricNullness R columnKey, @ParametricNullness V value) {
            return this.original.put(columnKey, rowKey, value);
        }

        @Override
        public void putAll(Table<? extends C, ? extends R, ? extends V> table) {
            this.original.putAll(Tables.transpose(table));
        }

        @Override
        @CheckForNull
        public V remove(@CheckForNull org.rascalmpl.java.lang.Object rowKey, @CheckForNull org.rascalmpl.java.lang.Object columnKey) {
            return this.original.remove(columnKey, rowKey);
        }

        @Override
        public Map<R, V> row(@ParametricNullness C rowKey) {
            return this.original.column(rowKey);
        }

        @Override
        public Set<C> rowKeySet() {
            return this.original.columnKeySet();
        }

        @Override
        public Map<C, Map<R, V>> rowMap() {
            return this.original.columnMap();
        }

        @Override
        public int size() {
            return this.original.size();
        }

        @Override
        public Collection<V> values() {
            return this.original.values();
        }

        /*
         * Exception decompiling
         */
        @Override
        Iterator<Table.Cell<C, R, V>> cellIterator() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        Spliterator<Table.Cell<C, R, V>> cellSpliterator() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ Table.Cell lambda$cellSpliterator$1(Table.Cell x$0) {
            return Tables.transposeCell(x$0);
        }

        private static /* synthetic */ Table.Cell lambda$cellIterator$0(Table.Cell x$0) {
            return Tables.transposeCell(x$0);
        }
    }

    static abstract class AbstractCell<R extends @Nullable org.rascalmpl.java.lang.Object, C extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Table.Cell<R, C, V> {
        AbstractCell() {
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Table.Cell) {
                Table.Cell other = (Table.Cell)obj;
                return Objects.equal(this.getRowKey(), other.getRowKey()) && Objects.equal(this.getColumnKey(), other.getColumnKey()) && Objects.equal(this.getValue(), other.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getRowKey(), this.getColumnKey(), this.getValue());
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.(").append(this.getRowKey()).append((String)"org.rascalmpl.,").append(this.getColumnKey()).append((String)"org.rascalmpl.)=").append(this.getValue()).toString();
        }
    }

    static final class ImmutableCell<R extends @Nullable org.rascalmpl.java.lang.Object, C extends @Nullable org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends AbstractCell<R, C, V>
    implements Serializable {
        @ParametricNullness
        private final R rowKey;
        @ParametricNullness
        private final C columnKey;
        @ParametricNullness
        private final V value;
        private static final long serialVersionUID = 0L;

        ImmutableCell(@ParametricNullness R rowKey, @ParametricNullness C columnKey, @ParametricNullness V value) {
            this.rowKey = rowKey;
            this.columnKey = columnKey;
            this.value = value;
        }

        @Override
        @ParametricNullness
        public R getRowKey() {
            return this.rowKey;
        }

        @Override
        @ParametricNullness
        public C getColumnKey() {
            return this.columnKey;
        }

        @Override
        @ParametricNullness
        public V getValue() {
            return this.value;
        }
    }
}

