/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.collect;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.base.MoreObjects;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Predicate;
import org.rascalmpl.com.google.common.base.Predicates;
import org.rascalmpl.com.google.common.collect.AbstractIterator;
import org.rascalmpl.com.google.common.collect.AbstractMapEntry;
import org.rascalmpl.com.google.common.collect.Cut;
import org.rascalmpl.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.Range;
import org.rascalmpl.com.google.common.collect.RangeMap;
import org.rascalmpl.java.lang.ClassCastException;
import org.rascalmpl.java.lang.Comparable;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.AbstractMap;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.NavigableMap;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.function.BiFunction;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class TreeRangeMap<K extends Comparable, V extends org.rascalmpl.java.lang.Object>
extends org.rascalmpl.java.lang.Object
implements RangeMap<K, V> {
    private final NavigableMap<Cut<K>, RangeMapEntry<K, V>> entriesByLowerBound = Maps.newTreeMap();
    private static final RangeMap<Comparable<?>, org.rascalmpl.java.lang.Object> EMPTY_SUB_RANGE_MAP = new RangeMap<Comparable<?>, org.rascalmpl.java.lang.Object>(){

        @Override
        @CheckForNull
        public org.rascalmpl.java.lang.Object get(Comparable<?> key) {
            return null;
        }

        @Override
        @CheckForNull
        public Map.Entry<Range<Comparable<?>>, org.rascalmpl.java.lang.Object> getEntry(Comparable<?> key) {
            return null;
        }

        @Override
        public Range<Comparable<?>> span() {
            throw new NoSuchElementException();
        }

        @Override
        public void put(Range<Comparable<?>> range, org.rascalmpl.java.lang.Object value) {
            Preconditions.checkNotNull(range);
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Cannot insert range ").append(range).append((String)"org.rascalmpl. into an empty subRangeMap").toString());
        }

        @Override
        public void putCoalescing(Range<Comparable<?>> range, org.rascalmpl.java.lang.Object value) {
            Preconditions.checkNotNull(range);
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Cannot insert range ").append(range).append((String)"org.rascalmpl. into an empty subRangeMap").toString());
        }

        @Override
        public void putAll(RangeMap<Comparable<?>, ? extends org.rascalmpl.java.lang.Object> rangeMap) {
            if (!rangeMap.asMapOfRanges().isEmpty()) {
                throw new IllegalArgumentException((String)"org.rascalmpl.Cannot putAll(nonEmptyRangeMap) into an empty subRangeMap");
            }
        }

        @Override
        public void clear() {
        }

        @Override
        public void remove(Range<Comparable<?>> range) {
            Preconditions.checkNotNull(range);
        }

        @Override
        public void merge(Range<Comparable<?>> range, @CheckForNull org.rascalmpl.java.lang.Object value, BiFunction<? super org.rascalmpl.java.lang.Object, ? super @Nullable org.rascalmpl.java.lang.Object, ? extends @Nullable org.rascalmpl.java.lang.Object> remappingFunction) {
            Preconditions.checkNotNull(range);
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Cannot merge range ").append(range).append((String)"org.rascalmpl. into an empty subRangeMap").toString());
        }

        @Override
        public Map<Range<Comparable<?>>, org.rascalmpl.java.lang.Object> asMapOfRanges() {
            return Collections.emptyMap();
        }

        @Override
        public Map<Range<Comparable<?>>, org.rascalmpl.java.lang.Object> asDescendingMapOfRanges() {
            return Collections.emptyMap();
        }

        @Override
        public RangeMap<Comparable<?>, org.rascalmpl.java.lang.Object> subRangeMap(Range<Comparable<?>> range) {
            Preconditions.checkNotNull(range);
            return this;
        }
    };

    public static <K extends Comparable, V extends org.rascalmpl.java.lang.Object> TreeRangeMap<K, V> create() {
        return new TreeRangeMap<K, V>();
    }

    private TreeRangeMap() {
    }

    @Override
    @CheckForNull
    public V get(K key) {
        Map.Entry<Range<K>, V> entry = this.getEntry(key);
        return (V)(entry == null ? null : entry.getValue());
    }

    @Override
    @CheckForNull
    public Map.Entry<Range<K>, V> getEntry(K key) {
        Map.Entry mapEntry = this.entriesByLowerBound.floorEntry(Cut.belowValue(key));
        if (mapEntry != null && ((RangeMapEntry)mapEntry.getValue()).contains(key)) {
            return (Map.Entry)mapEntry.getValue();
        }
        return null;
    }

    @Override
    public void put(Range<K> range, V value) {
        if (!range.isEmpty()) {
            Preconditions.checkNotNull(value);
            this.remove(range);
            this.entriesByLowerBound.put(range.lowerBound, new RangeMapEntry<K, V>(range, value));
        }
    }

    @Override
    public void putCoalescing(Range<K> range, V value) {
        if (this.entriesByLowerBound.isEmpty()) {
            this.put(range, value);
            return;
        }
        Range<K> coalescedRange = this.coalescedRange(range, Preconditions.checkNotNull(value));
        this.put(coalescedRange, value);
    }

    private Range<K> coalescedRange(Range<K> range, V value) {
        Range<K> coalescedRange = range;
        Map.Entry lowerEntry = this.entriesByLowerBound.lowerEntry(range.lowerBound);
        coalescedRange = TreeRangeMap.coalesce(coalescedRange, value, lowerEntry);
        Map.Entry higherEntry = this.entriesByLowerBound.floorEntry(range.upperBound);
        coalescedRange = TreeRangeMap.coalesce(coalescedRange, value, higherEntry);
        return coalescedRange;
    }

    private static <K extends Comparable, V extends org.rascalmpl.java.lang.Object> Range<K> coalesce(Range<K> range, V value, @CheckForNull Map.Entry<Cut<K>, RangeMapEntry<K, V>> entry) {
        if (entry != null && ((RangeMapEntry)entry.getValue()).getKey().isConnected(range) && ((RangeMapEntry)entry.getValue()).getValue().equals(value)) {
            return range.span((Range<K>)((RangeMapEntry)entry.getValue()).getKey());
        }
        return range;
    }

    @Override
    public void putAll(RangeMap<K, ? extends V> rangeMap) {
        for (Map.Entry entry : rangeMap.asMapOfRanges().entrySet()) {
            this.put((Range)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.entriesByLowerBound.clear();
    }

    @Override
    public Range<K> span() {
        Map.Entry firstEntry = this.entriesByLowerBound.firstEntry();
        Map.Entry lastEntry = this.entriesByLowerBound.lastEntry();
        if (firstEntry == null || lastEntry == null) {
            throw new NoSuchElementException();
        }
        return Range.create(((RangeMapEntry)firstEntry.getValue()).getKey().lowerBound, ((RangeMapEntry)lastEntry.getValue()).getKey().upperBound);
    }

    private void putRangeMapEntry(Cut<K> lowerBound, Cut<K> upperBound, V value) {
        this.entriesByLowerBound.put(lowerBound, new RangeMapEntry<K, V>(lowerBound, upperBound, value));
    }

    @Override
    public void remove(Range<K> rangeToRemove) {
        RangeMapEntry rangeMapEntry;
        Map.Entry mapEntryAboveToTruncate;
        RangeMapEntry rangeMapEntry2;
        if (rangeToRemove.isEmpty()) {
            return;
        }
        Map.Entry mapEntryBelowToTruncate = this.entriesByLowerBound.lowerEntry(rangeToRemove.lowerBound);
        if (mapEntryBelowToTruncate != null && (rangeMapEntry2 = (RangeMapEntry)mapEntryBelowToTruncate.getValue()).getUpperBound().compareTo(rangeToRemove.lowerBound) > 0) {
            if (rangeMapEntry2.getUpperBound().compareTo(rangeToRemove.upperBound) > 0) {
                this.putRangeMapEntry(rangeToRemove.upperBound, rangeMapEntry2.getUpperBound(), ((RangeMapEntry)mapEntryBelowToTruncate.getValue()).getValue());
            }
            this.putRangeMapEntry(rangeMapEntry2.getLowerBound(), rangeToRemove.lowerBound, ((RangeMapEntry)mapEntryBelowToTruncate.getValue()).getValue());
        }
        if ((mapEntryAboveToTruncate = this.entriesByLowerBound.lowerEntry(rangeToRemove.upperBound)) != null && (rangeMapEntry = (RangeMapEntry)mapEntryAboveToTruncate.getValue()).getUpperBound().compareTo(rangeToRemove.upperBound) > 0) {
            this.putRangeMapEntry(rangeToRemove.upperBound, rangeMapEntry.getUpperBound(), ((RangeMapEntry)mapEntryAboveToTruncate.getValue()).getValue());
        }
        this.entriesByLowerBound.subMap(rangeToRemove.lowerBound, rangeToRemove.upperBound).clear();
    }

    private void split(Cut<K> cut) {
        Map.Entry mapEntryToSplit = this.entriesByLowerBound.lowerEntry(cut);
        if (mapEntryToSplit == null) {
            return;
        }
        RangeMapEntry rangeMapEntry = (RangeMapEntry)mapEntryToSplit.getValue();
        if (rangeMapEntry.getUpperBound().compareTo(cut) <= 0) {
            return;
        }
        this.putRangeMapEntry(rangeMapEntry.getLowerBound(), cut, rangeMapEntry.getValue());
        this.putRangeMapEntry(cut, rangeMapEntry.getUpperBound(), rangeMapEntry.getValue());
    }

    @Override
    public void merge(Range<K> range, @CheckForNull V value, BiFunction<? super V, ? super @Nullable V, ? extends @Nullable V> remappingFunction) {
        Iterator backingItr;
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(remappingFunction);
        if (range.isEmpty()) {
            return;
        }
        this.split(range.lowerBound);
        this.split(range.upperBound);
        Set entriesInMergeRange = this.entriesByLowerBound.subMap(range.lowerBound, range.upperBound).entrySet();
        ImmutableMap.Builder gaps = ImmutableMap.builder();
        if (value != null) {
            backingItr = entriesInMergeRange.iterator();
            Cut<Object> lowerBound = range.lowerBound;
            while (backingItr.hasNext()) {
                RangeMapEntry entry = (RangeMapEntry)((Map.Entry)backingItr.next()).getValue();
                Cut upperBound = entry.getLowerBound();
                if (!lowerBound.equals(upperBound)) {
                    gaps.put(lowerBound, new RangeMapEntry(lowerBound, upperBound, value));
                }
                lowerBound = entry.getUpperBound();
            }
            if (!lowerBound.equals(range.upperBound)) {
                gaps.put(lowerBound, new RangeMapEntry(lowerBound, range.upperBound, value));
            }
        }
        backingItr = entriesInMergeRange.iterator();
        while (backingItr.hasNext()) {
            Map.Entry entry = (Map.Entry)backingItr.next();
            org.rascalmpl.java.lang.Object newValue = remappingFunction.apply(((RangeMapEntry)entry.getValue()).getValue(), value);
            if (newValue == null) {
                backingItr.remove();
                continue;
            }
            entry.setValue(new RangeMapEntry(((RangeMapEntry)entry.getValue()).getLowerBound(), ((RangeMapEntry)entry.getValue()).getUpperBound(), newValue));
        }
        this.entriesByLowerBound.putAll(gaps.build());
    }

    @Override
    public Map<Range<K>, V> asMapOfRanges() {
        return new AsMapOfRanges(this.entriesByLowerBound.values());
    }

    @Override
    public Map<Range<K>, V> asDescendingMapOfRanges() {
        return new AsMapOfRanges(this.entriesByLowerBound.descendingMap().values());
    }

    @Override
    public RangeMap<K, V> subRangeMap(Range<K> subRange) {
        if (subRange.equals(Range.all())) {
            return this;
        }
        return new SubRangeMap(subRange);
    }

    private RangeMap<K, V> emptySubRangeMap() {
        return EMPTY_SUB_RANGE_MAP;
    }

    @Override
    public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
        if (o instanceof RangeMap) {
            RangeMap rangeMap = (RangeMap)o;
            return this.asMapOfRanges().equals(rangeMap.asMapOfRanges());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.asMapOfRanges().hashCode();
    }

    @Override
    public String toString() {
        return this.entriesByLowerBound.values().toString();
    }

    private class SubRangeMap
    extends org.rascalmpl.java.lang.Object
    implements RangeMap<K, V> {
        private final Range<K> subRange;

        SubRangeMap(Range<K> subRange) {
            this.subRange = subRange;
        }

        @Override
        @CheckForNull
        public V get(K key) {
            return this.subRange.contains(key) ? (Object)TreeRangeMap.this.get(key) : null;
        }

        @Override
        @CheckForNull
        public Map.Entry<Range<K>, V> getEntry(K key) {
            Map.Entry entry;
            if (this.subRange.contains(key) && (entry = TreeRangeMap.this.getEntry(key)) != null) {
                return Maps.immutableEntry(((Range)entry.getKey()).intersection(this.subRange), entry.getValue());
            }
            return null;
        }

        @Override
        public Range<K> span() {
            Cut lowerBound;
            Map.Entry lowerEntry = TreeRangeMap.this.entriesByLowerBound.floorEntry(this.subRange.lowerBound);
            if (lowerEntry != null && ((RangeMapEntry)lowerEntry.getValue()).getUpperBound().compareTo(this.subRange.lowerBound) > 0) {
                lowerBound = this.subRange.lowerBound;
            } else {
                lowerBound = (Cut)TreeRangeMap.this.entriesByLowerBound.ceilingKey(this.subRange.lowerBound);
                if (lowerBound == null || lowerBound.compareTo(this.subRange.upperBound) >= 0) {
                    throw new NoSuchElementException();
                }
            }
            Map.Entry upperEntry = TreeRangeMap.this.entriesByLowerBound.lowerEntry(this.subRange.upperBound);
            if (upperEntry == null) {
                throw new NoSuchElementException();
            }
            Cut<Object> upperBound = ((RangeMapEntry)upperEntry.getValue()).getUpperBound().compareTo(this.subRange.upperBound) >= 0 ? this.subRange.upperBound : ((RangeMapEntry)upperEntry.getValue()).getUpperBound();
            return Range.create(lowerBound, upperBound);
        }

        @Override
        public void put(Range<K> range, V value) {
            Preconditions.checkArgument(this.subRange.encloses(range), (String)"org.rascalmpl.Cannot put range %s into a subRangeMap(%s)", range, this.subRange);
            TreeRangeMap.this.put(range, value);
        }

        @Override
        public void putCoalescing(Range<K> range, V value) {
            if (TreeRangeMap.this.entriesByLowerBound.isEmpty() || !this.subRange.encloses(range)) {
                this.put(range, value);
                return;
            }
            Range coalescedRange = TreeRangeMap.this.coalescedRange(range, Preconditions.checkNotNull(value));
            this.put(coalescedRange.intersection(this.subRange), value);
        }

        @Override
        public void putAll(RangeMap<K, ? extends V> rangeMap) {
            if (rangeMap.asMapOfRanges().isEmpty()) {
                return;
            }
            Range span = rangeMap.span();
            Preconditions.checkArgument(this.subRange.encloses(span), (String)"org.rascalmpl.Cannot putAll rangeMap with span %s into a subRangeMap(%s)", span, this.subRange);
            TreeRangeMap.this.putAll(rangeMap);
        }

        @Override
        public void clear() {
            TreeRangeMap.this.remove(this.subRange);
        }

        @Override
        public void remove(Range<K> range) {
            if (range.isConnected(this.subRange)) {
                TreeRangeMap.this.remove(range.intersection(this.subRange));
            }
        }

        @Override
        public void merge(Range<K> range, @CheckForNull V value, BiFunction<? super V, ? super @Nullable V, ? extends @Nullable V> remappingFunction) {
            Preconditions.checkArgument(this.subRange.encloses(range), (String)"org.rascalmpl.Cannot merge range %s into a subRangeMap(%s)", range, this.subRange);
            TreeRangeMap.this.merge(range, value, remappingFunction);
        }

        @Override
        public RangeMap<K, V> subRangeMap(Range<K> range) {
            if (!range.isConnected(this.subRange)) {
                return TreeRangeMap.this.emptySubRangeMap();
            }
            return TreeRangeMap.this.subRangeMap(range.intersection(this.subRange));
        }

        @Override
        public Map<Range<K>, V> asMapOfRanges() {
            return new SubRangeMapAsMap();
        }

        @Override
        public Map<Range<K>, V> asDescendingMapOfRanges() {
            return new SubRangeMapAsMap(){

                @Override
                Iterator<Map.Entry<Range<K>, V>> entryIterator() {
                    if (SubRangeMap.this.subRange.isEmpty()) {
                        return Iterators.emptyIterator();
                    }
                    final Iterator backingItr = TreeRangeMap.this.entriesByLowerBound.headMap(((SubRangeMap)SubRangeMap.this).subRange.upperBound, false).descendingMap().values().iterator();
                    return new AbstractIterator<Map.Entry<Range<K>, V>>(){

                        @Override
                        @CheckForNull
                        protected Map.Entry<Range<K>, V> computeNext() {
                            if (backingItr.hasNext()) {
                                RangeMapEntry entry = (RangeMapEntry)backingItr.next();
                                if (entry.getUpperBound().compareTo(((SubRangeMap)SubRangeMap.this).subRange.lowerBound) <= 0) {
                                    return (Map.Entry)this.endOfData();
                                }
                                return Maps.immutableEntry(entry.getKey().intersection(SubRangeMap.this.subRange), entry.getValue());
                            }
                            return (Map.Entry)this.endOfData();
                        }
                    };
                }
            };
        }

        @Override
        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
            if (o instanceof RangeMap) {
                RangeMap rangeMap = (RangeMap)o;
                return this.asMapOfRanges().equals(rangeMap.asMapOfRanges());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.asMapOfRanges().hashCode();
        }

        @Override
        public String toString() {
            return this.asMapOfRanges().toString();
        }

        class SubRangeMapAsMap
        extends AbstractMap<Range<K>, V> {
            SubRangeMapAsMap() {
            }

            public boolean containsKey(@CheckForNull org.rascalmpl.java.lang.Object key) {
                return this.get(key) != null;
            }

            @CheckForNull
            public V get(@CheckForNull org.rascalmpl.java.lang.Object key) {
                try {
                    if (key instanceof Range) {
                        Range r = (Range)key;
                        if (!SubRangeMap.this.subRange.encloses(r) || r.isEmpty()) {
                            return null;
                        }
                        RangeMapEntry candidate = null;
                        if (r.lowerBound.compareTo(((SubRangeMap)SubRangeMap.this).subRange.lowerBound) == 0) {
                            Map.Entry entry = TreeRangeMap.this.entriesByLowerBound.floorEntry(r.lowerBound);
                            if (entry != null) {
                                candidate = (RangeMapEntry)entry.getValue();
                            }
                        } else {
                            candidate = (RangeMapEntry)TreeRangeMap.this.entriesByLowerBound.get(r.lowerBound);
                        }
                        if (candidate != null && candidate.getKey().isConnected(SubRangeMap.this.subRange) && candidate.getKey().intersection(SubRangeMap.this.subRange).equals(r)) {
                            return candidate.getValue();
                        }
                    }
                }
                catch (ClassCastException e) {
                    return null;
                }
                return null;
            }

            @CheckForNull
            public V remove(@CheckForNull org.rascalmpl.java.lang.Object key) {
                Object value = this.get(key);
                if (value != null) {
                    Range range = (Range)Objects.requireNonNull((org.rascalmpl.java.lang.Object)key);
                    TreeRangeMap.this.remove(range);
                    return value;
                }
                return null;
            }

            public void clear() {
                SubRangeMap.this.clear();
            }

            private boolean removeEntryIf(Predicate<? super Map.Entry<Range<K>, V>> predicate) {
                ArrayList toRemove = Lists.newArrayList();
                for (Map.Entry entry : this.entrySet()) {
                    if (!predicate.apply(entry)) continue;
                    toRemove.add((org.rascalmpl.java.lang.Object)((Range)entry.getKey()));
                }
                for (Range range : toRemove) {
                    TreeRangeMap.this.remove(range);
                }
                return !toRemove.isEmpty();
            }

            public Set<Range<K>> keySet() {
                return new Maps.KeySet<Range<K>, V>((Map)this){

                    @Override
                    public boolean remove(@CheckForNull org.rascalmpl.java.lang.Object o) {
                        return SubRangeMapAsMap.this.remove(o) != null;
                    }

                    @Override
                    public boolean retainAll(Collection<?> c) {
                        return SubRangeMapAsMap.this.removeEntryIf(Predicates.compose(Predicates.not(Predicates.in(c)), Maps.keyFunction()));
                    }
                };
            }

            public Set<Map.Entry<Range<K>, V>> entrySet() {
                return new Maps.EntrySet<Range<K>, V>(){

                    @Override
                    Map<Range<K>, V> map() {
                        return SubRangeMapAsMap.this;
                    }

                    public Iterator<Map.Entry<Range<K>, V>> iterator() {
                        return SubRangeMapAsMap.this.entryIterator();
                    }

                    @Override
                    public boolean retainAll(Collection<?> c) {
                        return SubRangeMapAsMap.this.removeEntryIf(Predicates.not(Predicates.in(c)));
                    }

                    @Override
                    public int size() {
                        return Iterators.size(this.iterator());
                    }

                    @Override
                    public boolean isEmpty() {
                        return !this.iterator().hasNext();
                    }
                };
            }

            Iterator<Map.Entry<Range<K>, V>> entryIterator() {
                if (SubRangeMap.this.subRange.isEmpty()) {
                    return Iterators.emptyIterator();
                }
                Cut cutToStart = MoreObjects.firstNonNull((Cut)TreeRangeMap.this.entriesByLowerBound.floorKey(((SubRangeMap)SubRangeMap.this).subRange.lowerBound), ((SubRangeMap)SubRangeMap.this).subRange.lowerBound);
                final Iterator backingItr = TreeRangeMap.this.entriesByLowerBound.tailMap(cutToStart, true).values().iterator();
                return new AbstractIterator<Map.Entry<Range<K>, V>>(){

                    @Override
                    @CheckForNull
                    protected Map.Entry<Range<K>, V> computeNext() {
                        while (backingItr.hasNext()) {
                            RangeMapEntry entry = (RangeMapEntry)backingItr.next();
                            if (entry.getLowerBound().compareTo(((SubRangeMap)SubRangeMap.this).subRange.upperBound) >= 0) {
                                return (Map.Entry)this.endOfData();
                            }
                            if (entry.getUpperBound().compareTo(((SubRangeMap)SubRangeMap.this).subRange.lowerBound) <= 0) continue;
                            return Maps.immutableEntry(entry.getKey().intersection(SubRangeMap.this.subRange), entry.getValue());
                        }
                        return (Map.Entry)this.endOfData();
                    }
                };
            }

            public Collection<V> values() {
                return new Maps.Values<Range<K>, V>((Map)this){

                    @Override
                    public boolean removeAll(Collection<?> c) {
                        return SubRangeMapAsMap.this.removeEntryIf(Predicates.compose(Predicates.in(c), Maps.valueFunction()));
                    }

                    @Override
                    public boolean retainAll(Collection<?> c) {
                        return SubRangeMapAsMap.this.removeEntryIf(Predicates.compose(Predicates.not(Predicates.in(c)), Maps.valueFunction()));
                    }
                };
            }
        }
    }

    private final class AsMapOfRanges
    extends Maps.IteratorBasedAbstractMap<Range<K>, V> {
        final Iterable<Map.Entry<Range<K>, V>> entryIterable;

        AsMapOfRanges(Iterable<RangeMapEntry<K, V>> entryIterable) {
            this.entryIterable = entryIterable;
        }

        public boolean containsKey(@CheckForNull org.rascalmpl.java.lang.Object key) {
            return this.get(key) != null;
        }

        @CheckForNull
        public V get(@CheckForNull org.rascalmpl.java.lang.Object key) {
            if (key instanceof Range) {
                Range range = (Range)key;
                RangeMapEntry rangeMapEntry = (RangeMapEntry)TreeRangeMap.this.entriesByLowerBound.get(range.lowerBound);
                if (rangeMapEntry != null && rangeMapEntry.getKey().equals(range)) {
                    return rangeMapEntry.getValue();
                }
            }
            return null;
        }

        @Override
        public int size() {
            return TreeRangeMap.this.entriesByLowerBound.size();
        }

        @Override
        Iterator<Map.Entry<Range<K>, V>> entryIterator() {
            return this.entryIterable.iterator();
        }
    }

    private static final class RangeMapEntry<K extends Comparable, V extends org.rascalmpl.java.lang.Object>
    extends AbstractMapEntry<Range<K>, V> {
        private final Range<K> range;
        private final V value;

        RangeMapEntry(Cut<K> lowerBound, Cut<K> upperBound, V value) {
            this(Range.create(lowerBound, upperBound), value);
        }

        RangeMapEntry(Range<K> range, V value) {
            this.range = range;
            this.value = value;
        }

        @Override
        public Range<K> getKey() {
            return this.range;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public boolean contains(K value) {
            return this.range.contains(value);
        }

        Cut<K> getLowerBound() {
            return this.range.lowerBound;
        }

        Cut<K> getUpperBound() {
            return this.range.upperBound;
        }
    }
}

