/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.escape;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.escape.CharEscaper;
import org.rascalmpl.com.google.common.escape.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.escape.Escaper;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.Character;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class CharEscaperBuilder
extends Object {
    private final Map<Character, String> map = new HashMap();
    private int max = -1;

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscape(char c, String r) {
        this.map.put((Object)Character.valueOf((char)c), (Object)Preconditions.checkNotNull(r));
        if (c > this.max) {
            this.max = c;
        }
        return this;
    }

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscapes(char[] cs, String r) {
        Preconditions.checkNotNull(r);
        for (char c : cs) {
            this.addEscape(c, r);
        }
        return this;
    }

    public char[] @Nullable [] toArray() {
        char[][] result = new char[this.max + 1][];
        for (Map.Entry entry : this.map.entrySet()) {
            result[((Character)entry.getKey()).charValue()] = ((String)entry.getValue()).toCharArray();
        }
        return result;
    }

    public Escaper toEscaper() {
        return new CharArrayDecorator(this.toArray());
    }

    private static class CharArrayDecorator
    extends CharEscaper {
        private final char[] @Nullable [] replacements;
        private final int replaceLength;

        CharArrayDecorator(char[] @Nullable [] replacements) {
            this.replacements = replacements;
            this.replaceLength = replacements.length;
        }

        @Override
        public String escape(String s2) {
            int slen = s2.length();
            for (int index = 0; index < slen; ++index) {
                char c = s2.charAt(index);
                if (c >= this.replacements.length || this.replacements[c] == null) continue;
                return this.escapeSlow(s2, index);
            }
            return s2;
        }

        @Override
        @CheckForNull
        protected char[] escape(char c) {
            return c < this.replaceLength ? this.replacements[c] : null;
        }
    }
}

