/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.eventbus;

import org.rascalmpl.com.google.common.base.MoreObjects;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.eventbus.DeadEvent;
import org.rascalmpl.com.google.common.eventbus.Dispatcher;
import org.rascalmpl.com.google.common.eventbus.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.eventbus.Subscriber;
import org.rascalmpl.com.google.common.eventbus.SubscriberExceptionContext;
import org.rascalmpl.com.google.common.eventbus.SubscriberExceptionHandler;
import org.rascalmpl.com.google.common.eventbus.SubscriberRegistry;
import org.rascalmpl.com.google.common.util.concurrent.MoreExecutors;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Locale;
import org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
public class EventBus
extends Object {
    private static final Logger logger = Logger.getLogger((String)EventBus.class.getName());
    private final String identifier;
    private final Executor executor;
    private final SubscriberExceptionHandler exceptionHandler;
    private final SubscriberRegistry subscribers = new SubscriberRegistry(this);
    private final Dispatcher dispatcher;

    public EventBus() {
        this((String)"org.rascalmpl.default");
    }

    public EventBus(String identifier) {
        this(identifier, MoreExecutors.directExecutor(), Dispatcher.perThreadDispatchQueue(), LoggingHandler.INSTANCE);
    }

    public EventBus(SubscriberExceptionHandler exceptionHandler) {
        this((String)"org.rascalmpl.default", MoreExecutors.directExecutor(), Dispatcher.perThreadDispatchQueue(), exceptionHandler);
    }

    EventBus(String identifier, Executor executor, Dispatcher dispatcher, SubscriberExceptionHandler exceptionHandler) {
        this.identifier = Preconditions.checkNotNull(identifier);
        this.executor = Preconditions.checkNotNull(executor);
        this.dispatcher = Preconditions.checkNotNull(dispatcher);
        this.exceptionHandler = Preconditions.checkNotNull(exceptionHandler);
    }

    public final String identifier() {
        return this.identifier;
    }

    final Executor executor() {
        return this.executor;
    }

    void handleSubscriberException(Throwable e, SubscriberExceptionContext context) {
        Preconditions.checkNotNull(e);
        Preconditions.checkNotNull(context);
        try {
            this.exceptionHandler.handleException(e, context);
        }
        catch (Throwable e2) {
            logger.log(Level.SEVERE, String.format((Locale)Locale.ROOT, (String)"org.rascalmpl.Exception %s thrown while handling exception: %s", (Object[])new Object[]{e2, e}), e2);
        }
    }

    public void register(Object object) {
        this.subscribers.register(object);
    }

    public void unregister(Object object) {
        this.subscribers.unregister(object);
    }

    public void post(Object event) {
        Iterator<Subscriber> eventSubscribers = this.subscribers.getSubscribers(event);
        if (eventSubscribers.hasNext()) {
            this.dispatcher.dispatch(event, eventSubscribers);
        } else if (!(event instanceof DeadEvent)) {
            this.post(new DeadEvent(this, event));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue((Object)this.identifier).toString();
    }

    static final class LoggingHandler
    extends Object
    implements SubscriberExceptionHandler {
        static final LoggingHandler INSTANCE = new LoggingHandler();

        LoggingHandler() {
        }

        @Override
        public void handleException(Throwable exception, SubscriberExceptionContext context) {
            Logger logger = LoggingHandler.logger(context);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, LoggingHandler.message(context), exception);
            }
        }

        private static Logger logger(SubscriberExceptionContext context) {
            return Logger.getLogger((String)new StringBuilder().append(EventBus.class.getName()).append((String)"org.rascalmpl..").append(context.getEventBus().identifier()).toString());
        }

        private static String message(SubscriberExceptionContext context) {
            Method method = context.getSubscriberMethod();
            return new StringBuilder().append((String)"org.rascalmpl.Exception thrown by subscriber method ").append(method.getName()).append('(').append(method.getParameterTypes()[0].getName()).append(')').append((String)"org.rascalmpl. on subscriber ").append(context.getSubscriber()).append((String)"org.rascalmpl. when dispatching event: ").append(context.getEvent()).toString();
        }
    }
}

