/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.eventbus;

import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.MoreObjects;
import org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Throwables;
import org.rascalmpl.com.google.common.cache.CacheBuilder;
import org.rascalmpl.com.google.common.cache.CacheLoader;
import org.rascalmpl.com.google.common.cache.LoadingCache;
import org.rascalmpl.com.google.common.collect.HashMultimap;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.Multimap;
import org.rascalmpl.com.google.common.eventbus.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.eventbus.EventBus;
import org.rascalmpl.com.google.common.eventbus.Subscribe;
import org.rascalmpl.com.google.common.eventbus.Subscriber;
import org.rascalmpl.com.google.common.primitives.Primitives;
import org.rascalmpl.com.google.common.reflect.TypeToken;
import org.rascalmpl.com.google.common.util.concurrent.UncheckedExecutionException;
import org.rascalmpl.com.google.j2objc.annotations.Weak;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.util.AbstractCollection;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.concurrent.ConcurrentMap;
import org.rascalmpl.java.util.concurrent.CopyOnWriteArraySet;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
final class SubscriberRegistry
extends org.rascalmpl.java.lang.Object {
    private final ConcurrentMap<Class<?>, CopyOnWriteArraySet<Subscriber>> subscribers = Maps.newConcurrentMap();
    @Weak
    private final EventBus bus;
    private static final LoadingCache<Class<?>, ImmutableList<Method>> subscriberMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableList<Method>>(){

        @Override
        public ImmutableList<Method> load(Class<?> concreteClass) throws Exception {
            return SubscriberRegistry.getAnnotatedMethodsNotCached(concreteClass);
        }
    });
    private static final LoadingCache<Class<?>, ImmutableSet<Class<?>>> flattenHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableSet<Class<?>>>(){

        @Override
        public ImmutableSet<Class<?>> load(Class<?> concreteClass) {
            return ImmutableSet.copyOf(TypeToken.of(concreteClass).getTypes().rawTypes());
        }
    });

    SubscriberRegistry(EventBus bus) {
        this.bus = Preconditions.checkNotNull(bus);
    }

    void register(org.rascalmpl.java.lang.Object listener) {
        Multimap<Class<?>, Subscriber> listenerMethods = this.findAllSubscribers(listener);
        for (Map.Entry entry : listenerMethods.asMap().entrySet()) {
            Class eventType = (Class)entry.getKey();
            Collection eventMethodsInListener = (Collection)entry.getValue();
            CopyOnWriteArraySet eventSubscribers = (CopyOnWriteArraySet)this.subscribers.get((org.rascalmpl.java.lang.Object)eventType);
            if (eventSubscribers == null) {
                CopyOnWriteArraySet newSet = new CopyOnWriteArraySet();
                eventSubscribers = MoreObjects.firstNonNull((CopyOnWriteArraySet)this.subscribers.putIfAbsent((org.rascalmpl.java.lang.Object)eventType, (org.rascalmpl.java.lang.Object)newSet), newSet);
            }
            eventSubscribers.addAll(eventMethodsInListener);
        }
    }

    void unregister(org.rascalmpl.java.lang.Object listener) {
        Multimap<Class<?>, Subscriber> listenerMethods = this.findAllSubscribers(listener);
        for (Map.Entry entry : listenerMethods.asMap().entrySet()) {
            Class eventType = (Class)entry.getKey();
            Collection listenerMethodsForType = (Collection)entry.getValue();
            CopyOnWriteArraySet currentSubscribers = (CopyOnWriteArraySet)this.subscribers.get((org.rascalmpl.java.lang.Object)eventType);
            if (currentSubscribers != null && currentSubscribers.removeAll(listenerMethodsForType)) continue;
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.missing event subscriber for an annotated method. Is ").append(listener).append((String)"org.rascalmpl. registered?").toString());
        }
    }

    @VisibleForTesting
    Set<Subscriber> getSubscribersForTesting(Class<?> eventType) {
        return MoreObjects.firstNonNull((AbstractCollection)this.subscribers.get(eventType), ImmutableSet.of());
    }

    Iterator<Subscriber> getSubscribers(org.rascalmpl.java.lang.Object event) {
        ImmutableSet<Class<?>> eventTypes = SubscriberRegistry.flattenHierarchy(event.getClass());
        ArrayList subscriberIterators = Lists.newArrayListWithCapacity(eventTypes.size());
        Iterator iterator = eventTypes.iterator();
        while (iterator.hasNext()) {
            Class eventType = (Class)iterator.next();
            CopyOnWriteArraySet eventSubscribers = (CopyOnWriteArraySet)this.subscribers.get((org.rascalmpl.java.lang.Object)eventType);
            if (eventSubscribers == null) continue;
            subscriberIterators.add((org.rascalmpl.java.lang.Object)eventSubscribers.iterator());
        }
        return Iterators.concat(subscriberIterators.iterator());
    }

    private Multimap<Class<?>, Subscriber> findAllSubscribers(org.rascalmpl.java.lang.Object listener) {
        HashMultimap<Class<?>, Subscriber> methodsInListener = HashMultimap.create();
        Class clazz = listener.getClass();
        Iterator iterator = SubscriberRegistry.getAnnotatedMethods(clazz).iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            Class[] parameterTypes = method.getParameterTypes();
            Class eventType = parameterTypes[0];
            methodsInListener.put(eventType, Subscriber.create(this.bus, listener, method));
        }
        return methodsInListener;
    }

    private static ImmutableList<Method> getAnnotatedMethods(Class<?> clazz) {
        try {
            return subscriberMethodsCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked(e.getCause());
            throw e;
        }
    }

    private static ImmutableList<Method> getAnnotatedMethodsNotCached(Class<?> clazz) {
        Set supertypes = TypeToken.of(clazz).getTypes().rawTypes();
        HashMap identifiers = Maps.newHashMap();
        for (Class supertype : supertypes) {
            for (Method method : supertype.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Subscribe.class) || method.isSynthetic()) continue;
                Class[] parameterTypes = method.getParameterTypes();
                Preconditions.checkArgument(parameterTypes.length == 1, (String)"org.rascalmpl.Method %s has @Subscribe annotation but has %s parameters. Subscriber methods must have exactly 1 parameter.", (org.rascalmpl.java.lang.Object)method, parameterTypes.length);
                Preconditions.checkArgument(!parameterTypes[0].isPrimitive(), (String)"org.rascalmpl.@Subscribe method %s's parameter is %s. Subscriber methods cannot accept primitives. Consider changing the parameter to %s.", (org.rascalmpl.java.lang.Object)method, (org.rascalmpl.java.lang.Object)parameterTypes[0].getName(), (org.rascalmpl.java.lang.Object)Primitives.wrap(parameterTypes[0]).getSimpleName());
                MethodIdentifier ident = new MethodIdentifier(method);
                if (identifiers.containsKey((org.rascalmpl.java.lang.Object)ident)) continue;
                identifiers.put((org.rascalmpl.java.lang.Object)ident, (org.rascalmpl.java.lang.Object)method);
            }
        }
        return ImmutableList.copyOf(identifiers.values());
    }

    @VisibleForTesting
    static ImmutableSet<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        try {
            return flattenHierarchyCache.getUnchecked(concreteClass);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    private static final class MethodIdentifier
    extends org.rascalmpl.java.lang.Object {
        private final String name;
        private final List<Class<?>> parameterTypes;

        MethodIdentifier(Method method) {
            this.name = method.getName();
            this.parameterTypes = Arrays.asList((org.rascalmpl.java.lang.Object[])method.getParameterTypes());
        }

        public int hashCode() {
            return Objects.hashCode(new org.rascalmpl.java.lang.Object[]{this.name, this.parameterTypes});
        }

        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object o) {
            if (o instanceof MethodIdentifier) {
                MethodIdentifier ident = (MethodIdentifier)o;
                return this.name.equals((org.rascalmpl.java.lang.Object)ident.name) && this.parameterTypes.equals(ident.parameterTypes);
            }
            return false;
        }
    }
}

