/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.graph;

import org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.AbstractIterator;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.UnmodifiableIterator;
import org.rascalmpl.com.google.common.graph.ElementOrder;
import org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.graph.EndpointPair;
import org.rascalmpl.com.google.common.graph.GraphConnections;
import org.rascalmpl.com.google.common.graph.Graphs;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.util.AbstractSet;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.HashSet;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
final class DirectedGraphConnections<N extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object>
extends org.rascalmpl.java.lang.Object
implements GraphConnections<N, V> {
    private static final org.rascalmpl.java.lang.Object PRED = new org.rascalmpl.java.lang.Object();
    private final Map<N, org.rascalmpl.java.lang.Object> adjacentNodeValues;
    @CheckForNull
    private final List<NodeConnection<N>> orderedNodeConnections;
    private int predecessorCount;
    private int successorCount;

    private DirectedGraphConnections(Map<N, org.rascalmpl.java.lang.Object> adjacentNodeValues, @CheckForNull List<NodeConnection<N>> orderedNodeConnections, int predecessorCount, int successorCount) {
        this.adjacentNodeValues = Preconditions.checkNotNull(adjacentNodeValues);
        this.orderedNodeConnections = orderedNodeConnections;
        this.predecessorCount = Graphs.checkNonNegative(predecessorCount);
        this.successorCount = Graphs.checkNonNegative(successorCount);
        Preconditions.checkState(predecessorCount <= adjacentNodeValues.size() && successorCount <= adjacentNodeValues.size());
    }

    static <N extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> DirectedGraphConnections<N, V> of(ElementOrder<N> incidentEdgeOrder) {
        ArrayList orderedNodeConnections;
        int initialCapacity = 4;
        switch (incidentEdgeOrder.type()) {
            case UNORDERED: {
                orderedNodeConnections = null;
                break;
            }
            case STABLE: {
                orderedNodeConnections = new ArrayList();
                break;
            }
            default: {
                throw new AssertionError((org.rascalmpl.java.lang.Object)incidentEdgeOrder.type());
            }
        }
        return new DirectedGraphConnections<N, V>(new HashMap(initialCapacity, 1.0f), orderedNodeConnections, 0, 0);
    }

    static <N extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> DirectedGraphConnections<N, V> ofImmutable(N thisNode, Iterable<EndpointPair<N>> incidentEdges, Function<N, V> successorNodeToValueFn) {
        Preconditions.checkNotNull(thisNode);
        Preconditions.checkNotNull(successorNodeToValueFn);
        HashMap adjacentNodeValues = new HashMap();
        ImmutableList.Builder orderedNodeConnectionsBuilder = ImmutableList.builder();
        int predecessorCount = 0;
        int successorCount = 0;
        for (EndpointPair incidentEdge : incidentEdges) {
            if (incidentEdge.nodeU().equals(thisNode) && incidentEdge.nodeV().equals(thisNode)) {
                adjacentNodeValues.put(thisNode, (org.rascalmpl.java.lang.Object)new PredAndSucc((org.rascalmpl.java.lang.Object)successorNodeToValueFn.apply(thisNode)));
                orderedNodeConnectionsBuilder.add(new NodeConnection.Pred<N>(thisNode));
                orderedNodeConnectionsBuilder.add(new NodeConnection.Succ<N>(thisNode));
                ++predecessorCount;
                ++successorCount;
                continue;
            }
            if (incidentEdge.nodeV().equals(thisNode)) {
                Object predecessor = incidentEdge.nodeU();
                org.rascalmpl.java.lang.Object existingValue = adjacentNodeValues.put(predecessor, PRED);
                if (existingValue != null) {
                    adjacentNodeValues.put(predecessor, (org.rascalmpl.java.lang.Object)new PredAndSucc(existingValue));
                }
                orderedNodeConnectionsBuilder.add(new NodeConnection.Pred(predecessor));
                ++predecessorCount;
                continue;
            }
            Preconditions.checkArgument(incidentEdge.nodeU().equals(thisNode));
            Object successor = incidentEdge.nodeV();
            V value = successorNodeToValueFn.apply(successor);
            org.rascalmpl.java.lang.Object existingValue = adjacentNodeValues.put(successor, value);
            if (existingValue != null) {
                Preconditions.checkArgument(existingValue == PRED);
                adjacentNodeValues.put(successor, (org.rascalmpl.java.lang.Object)new PredAndSucc((org.rascalmpl.java.lang.Object)value));
            }
            orderedNodeConnectionsBuilder.add(new NodeConnection.Succ(successor));
            ++successorCount;
        }
        return new DirectedGraphConnections<N, V>(adjacentNodeValues, orderedNodeConnectionsBuilder.build(), predecessorCount, successorCount);
    }

    @Override
    public Set<N> adjacentNodes() {
        if (this.orderedNodeConnections == null) {
            return Collections.unmodifiableSet((Set)this.adjacentNodeValues.keySet());
        }
        return new AbstractSet<N>(){

            public UnmodifiableIterator<N> iterator() {
                final Iterator nodeConnections = DirectedGraphConnections.this.orderedNodeConnections.iterator();
                HashSet seenNodes = new HashSet();
                return new AbstractIterator<N>((Set)seenNodes){
                    final /* synthetic */ Set val$seenNodes;
                    {
                        this.val$seenNodes = set;
                    }

                    @Override
                    @CheckForNull
                    protected N computeNext() {
                        while (nodeConnections.hasNext()) {
                            NodeConnection nodeConnection = (NodeConnection)nodeConnections.next();
                            boolean added = this.val$seenNodes.add(nodeConnection.node);
                            if (!added) continue;
                            return nodeConnection.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            public int size() {
                return DirectedGraphConnections.this.adjacentNodeValues.size();
            }

            public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object obj) {
                return DirectedGraphConnections.this.adjacentNodeValues.containsKey(obj);
            }
        };
    }

    @Override
    public Set<N> predecessors() {
        return new AbstractSet<N>(){

            public UnmodifiableIterator<N> iterator() {
                if (DirectedGraphConnections.this.orderedNodeConnections == null) {
                    final Iterator entries = DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator();
                    return new AbstractIterator<N>(){

                        @Override
                        @CheckForNull
                        protected N computeNext() {
                            while (entries.hasNext()) {
                                Map.Entry entry = (Map.Entry)entries.next();
                                if (!DirectedGraphConnections.isPredecessor(entry.getValue())) continue;
                                return entry.getKey();
                            }
                            return this.endOfData();
                        }
                    };
                }
                final Iterator nodeConnections = DirectedGraphConnections.this.orderedNodeConnections.iterator();
                return new AbstractIterator<N>(){

                    @Override
                    @CheckForNull
                    protected N computeNext() {
                        while (nodeConnections.hasNext()) {
                            NodeConnection nodeConnection = (NodeConnection)nodeConnections.next();
                            if (!(nodeConnection instanceof NodeConnection.Pred)) continue;
                            return nodeConnection.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            public int size() {
                return DirectedGraphConnections.this.predecessorCount;
            }

            public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object obj) {
                return DirectedGraphConnections.isPredecessor(DirectedGraphConnections.this.adjacentNodeValues.get(obj));
            }
        };
    }

    @Override
    public Set<N> successors() {
        return new AbstractSet<N>(){

            public UnmodifiableIterator<N> iterator() {
                if (DirectedGraphConnections.this.orderedNodeConnections == null) {
                    final Iterator entries = DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator();
                    return new AbstractIterator<N>(){

                        @Override
                        @CheckForNull
                        protected N computeNext() {
                            while (entries.hasNext()) {
                                Map.Entry entry = (Map.Entry)entries.next();
                                if (!DirectedGraphConnections.isSuccessor(entry.getValue())) continue;
                                return entry.getKey();
                            }
                            return this.endOfData();
                        }
                    };
                }
                final Iterator nodeConnections = DirectedGraphConnections.this.orderedNodeConnections.iterator();
                return new AbstractIterator<N>(){

                    @Override
                    @CheckForNull
                    protected N computeNext() {
                        while (nodeConnections.hasNext()) {
                            NodeConnection nodeConnection = (NodeConnection)nodeConnections.next();
                            if (!(nodeConnection instanceof NodeConnection.Succ)) continue;
                            return nodeConnection.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            public int size() {
                return DirectedGraphConnections.this.successorCount;
            }

            public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object obj) {
                return DirectedGraphConnections.isSuccessor(DirectedGraphConnections.this.adjacentNodeValues.get(obj));
            }
        };
    }

    /*
     * Exception decompiling
     */
    @Override
    public Iterator<EndpointPair<N>> incidentEdgeIterator(N thisNode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @CheckForNull
    public V value(N node) {
        Preconditions.checkNotNull(node);
        org.rascalmpl.java.lang.Object value = this.adjacentNodeValues.get(node);
        if (value == PRED) {
            return null;
        }
        if (value instanceof PredAndSucc) {
            return (V)((PredAndSucc)value).successorValue;
        }
        return (V)value;
    }

    @Override
    public void removePredecessor(N node) {
        boolean removedPredecessor;
        Preconditions.checkNotNull(node);
        org.rascalmpl.java.lang.Object previousValue = this.adjacentNodeValues.get(node);
        if (previousValue == PRED) {
            this.adjacentNodeValues.remove(node);
            removedPredecessor = true;
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, ((PredAndSucc)previousValue).successorValue);
            removedPredecessor = true;
        } else {
            removedPredecessor = false;
        }
        if (removedPredecessor) {
            Graphs.checkNonNegative(--this.predecessorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.remove(new NodeConnection.Pred<N>(node));
            }
        }
    }

    @Override
    @CheckForNull
    public V removeSuccessor(org.rascalmpl.java.lang.Object node) {
        org.rascalmpl.java.lang.Object removedValue;
        Preconditions.checkNotNull(node);
        org.rascalmpl.java.lang.Object previousValue = this.adjacentNodeValues.get(node);
        if (previousValue == null || previousValue == PRED) {
            removedValue = null;
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, PRED);
            removedValue = ((PredAndSucc)previousValue).successorValue;
        } else {
            this.adjacentNodeValues.remove(node);
            removedValue = previousValue;
        }
        if (removedValue != null) {
            Graphs.checkNonNegative(--this.successorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.remove(new NodeConnection.Succ<org.rascalmpl.java.lang.Object>(node));
            }
        }
        return (V)(removedValue == null ? null : removedValue);
    }

    @Override
    public void addPredecessor(N node, V unused) {
        boolean addedPredecessor;
        org.rascalmpl.java.lang.Object previousValue = this.adjacentNodeValues.put(node, PRED);
        if (previousValue == null) {
            addedPredecessor = true;
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, previousValue);
            addedPredecessor = false;
        } else if (previousValue != PRED) {
            this.adjacentNodeValues.put(node, (org.rascalmpl.java.lang.Object)new PredAndSucc(previousValue));
            addedPredecessor = true;
        } else {
            addedPredecessor = false;
        }
        if (addedPredecessor) {
            Graphs.checkPositive(++this.predecessorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.add(new NodeConnection.Pred<N>(node));
            }
        }
    }

    @Override
    @CheckForNull
    public V addSuccessor(N node, V value) {
        org.rascalmpl.java.lang.Object previousSuccessor;
        org.rascalmpl.java.lang.Object previousValue = this.adjacentNodeValues.put(node, value);
        if (previousValue == null) {
            previousSuccessor = null;
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, (org.rascalmpl.java.lang.Object)new PredAndSucc((org.rascalmpl.java.lang.Object)value));
            previousSuccessor = ((PredAndSucc)previousValue).successorValue;
        } else if (previousValue == PRED) {
            this.adjacentNodeValues.put(node, (org.rascalmpl.java.lang.Object)new PredAndSucc((org.rascalmpl.java.lang.Object)value));
            previousSuccessor = null;
        } else {
            previousSuccessor = previousValue;
        }
        if (previousSuccessor == null) {
            Graphs.checkPositive(++this.successorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.add(new NodeConnection.Succ<N>(node));
            }
        }
        return (V)(previousSuccessor == null ? null : previousSuccessor);
    }

    private static boolean isPredecessor(@CheckForNull org.rascalmpl.java.lang.Object value) {
        return value == PRED || value instanceof PredAndSucc;
    }

    private static boolean isSuccessor(@CheckForNull org.rascalmpl.java.lang.Object value) {
        return value != PRED && value != null;
    }

    private static /* synthetic */ EndpointPair lambda$incidentEdgeIterator$2(org.rascalmpl.java.lang.Object thisNode, NodeConnection connection) {
        if (connection instanceof NodeConnection.Succ) {
            return EndpointPair.ordered(thisNode, connection.node);
        }
        return EndpointPair.ordered(connection.node, thisNode);
    }

    private static /* synthetic */ EndpointPair lambda$incidentEdgeIterator$1(org.rascalmpl.java.lang.Object thisNode, org.rascalmpl.java.lang.Object successor) {
        return EndpointPair.ordered(thisNode, successor);
    }

    private static /* synthetic */ EndpointPair lambda$incidentEdgeIterator$0(org.rascalmpl.java.lang.Object thisNode, org.rascalmpl.java.lang.Object predecessor) {
        return EndpointPair.ordered(predecessor, thisNode);
    }

    private static abstract class NodeConnection<N extends org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object {
        final N node;

        NodeConnection(N node) {
            this.node = Preconditions.checkNotNull(node);
        }

        static final class Succ<N extends org.rascalmpl.java.lang.Object>
        extends NodeConnection<N> {
            Succ(N node) {
                super(node);
            }

            public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object that) {
                if (that instanceof Succ) {
                    return this.node.equals(((Succ)that).node);
                }
                return false;
            }

            public int hashCode() {
                return Succ.class.hashCode() + this.node.hashCode();
            }
        }

        static final class Pred<N extends org.rascalmpl.java.lang.Object>
        extends NodeConnection<N> {
            Pred(N node) {
                super(node);
            }

            public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object that) {
                if (that instanceof Pred) {
                    return this.node.equals(((Pred)that).node);
                }
                return false;
            }

            public int hashCode() {
                return Pred.class.hashCode() + this.node.hashCode();
            }
        }
    }

    private static final class PredAndSucc
    extends org.rascalmpl.java.lang.Object {
        private final org.rascalmpl.java.lang.Object successorValue;

        PredAndSucc(org.rascalmpl.java.lang.Object successorValue) {
            this.successorValue = successorValue;
        }
    }
}

